/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.HoodieUnsafeRowUtils;
import org.apache.spark.sql.HoodieUnsafeRowUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;

@ThreadSafe
public abstract class BuiltinKeyGenerator
extends BaseKeyGenerator
implements SparkKeyGeneratorInterface {
    private static final Logger LOG = LogManager.getLogger(BuiltinKeyGenerator.class);
    private static final String COMPOSITE_KEY_FIELD_VALUE_INFIX = ":";
    protected static final UTF8String HUDI_DEFAULT_PARTITION_PATH_UTF8 = UTF8String.fromString((String)"__HIVE_DEFAULT_PARTITION__");
    protected static final UTF8String NULL_RECORD_KEY_PLACEHOLDER_UTF8 = UTF8String.fromString((String)"__null__");
    protected static final UTF8String EMPTY_RECORD_KEY_PLACEHOLDER_UTF8 = UTF8String.fromString((String)"__empty__");
    protected volatile transient SparkRowConverter rowConverter;
    protected volatile transient SparkRowAccessor rowAccessor;

    protected BuiltinKeyGenerator(TypedProperties config) {
        super(config);
    }

    @Override
    public String getRecordKey(Row row) {
        this.tryInitRowConverter(row.schema());
        return this.getRecordKey(this.rowConverter.convertToAvro(row));
    }

    @Override
    public UTF8String getRecordKey(InternalRow internalRow, StructType schema2) {
        this.tryInitRowConverter(schema2);
        return UTF8String.fromString((String)this.getRecordKey(this.rowConverter.convertToAvro(internalRow)));
    }

    @Override
    public String getPartitionPath(Row row) {
        this.tryInitRowConverter(row.schema());
        return this.getPartitionPath(this.rowConverter.convertToAvro(row));
    }

    @Override
    public UTF8String getPartitionPath(InternalRow internalRow, StructType schema2) {
        this.tryInitRowConverter(schema2);
        GenericRecord avroRecord = this.rowConverter.convertToAvro(internalRow);
        return UTF8String.fromString((String)this.getPartitionPath(avroRecord));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryInitRowAccessor(StructType schema2) {
        if (this.rowAccessor == null) {
            BuiltinKeyGenerator builtinKeyGenerator = this;
            synchronized (builtinKeyGenerator) {
                if (this.rowAccessor == null) {
                    this.rowAccessor = new SparkRowAccessor(schema2);
                }
            }
        }
    }

    protected final String combinePartitionPath(Object ... partitionPathParts) {
        return this.combinePartitionPathInternal(() -> new JavaStringBuilder(), BuiltinKeyGenerator::toString, this::tryEncodePartitionPath, BuiltinKeyGenerator::handleNullOrEmptyPartitionPathPart, partitionPathParts);
    }

    protected final UTF8String combinePartitionPathUnsafe(Object ... partitionPathParts) {
        return this.combinePartitionPathInternal(() -> new UTF8StringBuilder(), BuiltinKeyGenerator::toUTF8String, this::tryEncodePartitionPathUTF8, BuiltinKeyGenerator::handleNullOrEmptyPartitionPathPartUTF8, partitionPathParts);
    }

    protected final String combineRecordKey(Object ... recordKeyParts) {
        return this.combineRecordKeyInternal(() -> new JavaStringBuilder(), BuiltinKeyGenerator::toString, BuiltinKeyGenerator::handleNullRecordKey, recordKeyParts);
    }

    protected final UTF8String combineRecordKeyUnsafe(Object ... recordKeyParts) {
        return this.combineRecordKeyInternal(() -> new UTF8StringBuilder(), BuiltinKeyGenerator::toUTF8String, BuiltinKeyGenerator::handleNullRecordKey, recordKeyParts);
    }

    protected final String combineCompositeRecordKey(Object ... recordKeyParts) {
        return this.combineCompositeRecordKeyInternal(() -> new JavaStringBuilder(), BuiltinKeyGenerator::toString, BuiltinKeyGenerator::handleNullOrEmptyCompositeKeyPart, BuiltinKeyGenerator::isNullOrEmptyCompositeKeyPart, recordKeyParts);
    }

    protected final UTF8String combineCompositeRecordKeyUnsafe(Object ... recordKeyParts) {
        return this.combineCompositeRecordKeyInternal(() -> new UTF8StringBuilder(), BuiltinKeyGenerator::toUTF8String, BuiltinKeyGenerator::handleNullOrEmptyCompositeKeyPartUTF8, BuiltinKeyGenerator::isNullOrEmptyCompositeKeyPartUTF8, recordKeyParts);
    }

    private <S> S combineRecordKeyInternal(Supplier<StringBuilder<S>> builderFactory, Function<Object, S> converter, Function<S, S> emptyKeyPartHandler, Object ... recordKeyParts) {
        if (recordKeyParts.length == 1) {
            return emptyKeyPartHandler.apply(converter.apply(recordKeyParts[0]));
        }
        StringBuilder<S> sb = builderFactory.get();
        for (int i = 0; i < recordKeyParts.length; ++i) {
            sb.append(emptyKeyPartHandler.apply(converter.apply(recordKeyParts[i])));
            if (i >= recordKeyParts.length - 1) continue;
            sb.appendJava(",");
        }
        return sb.build();
    }

    private <S> S combineCompositeRecordKeyInternal(Supplier<StringBuilder<S>> builderFactory, Function<Object, S> converter, Function<S, S> emptyKeyPartHandler, Predicate<S> isNullOrEmptyKeyPartPredicate, Object ... recordKeyParts) {
        boolean hasNonNullNonEmptyPart = false;
        StringBuilder<S> sb = builderFactory.get();
        for (int i = 0; i < recordKeyParts.length; ++i) {
            S convertedKeyPart = emptyKeyPartHandler.apply(converter.apply(recordKeyParts[i]));
            sb.appendJava((String)this.recordKeyFields.get(i));
            sb.appendJava(COMPOSITE_KEY_FIELD_VALUE_INFIX);
            sb.append(convertedKeyPart);
            hasNonNullNonEmptyPart |= !isNullOrEmptyKeyPartPredicate.test(convertedKeyPart);
            if (i >= recordKeyParts.length - 1) continue;
            sb.appendJava(",");
        }
        if (hasNonNullNonEmptyPart) {
            return sb.build();
        }
        throw new HoodieKeyException(String.format("All of the values for (%s) were either null or empty", this.recordKeyFields));
    }

    private <S> S combinePartitionPathInternal(Supplier<StringBuilder<S>> builderFactory, Function<Object, S> converter, Function<S, S> encoder2, Function<S, S> emptyHandler, Object ... partitionPathParts) {
        ValidationUtils.checkState(partitionPathParts.length == this.partitionPathFields.size());
        if (!this.hiveStylePartitioning && partitionPathParts.length == 1) {
            return emptyHandler.apply(converter.apply(partitionPathParts[0]));
        }
        StringBuilder<S> sb = builderFactory.get();
        for (int i = 0; i < partitionPathParts.length; ++i) {
            S partitionPathPartStr = encoder2.apply(emptyHandler.apply(converter.apply(partitionPathParts[i])));
            if (this.hiveStylePartitioning) {
                sb.appendJava((String)this.partitionPathFields.get(i)).appendJava("=").append(partitionPathPartStr);
            } else {
                sb.append(partitionPathPartStr);
            }
            if (i >= partitionPathParts.length - 1) continue;
            sb.appendJava("/");
        }
        return sb.build();
    }

    private String tryEncodePartitionPath(String partitionPathPart) {
        return this.encodePartitionPath ? PartitionPathEncodeUtils.escapePathName(partitionPathPart) : partitionPathPart;
    }

    private UTF8String tryEncodePartitionPathUTF8(UTF8String partitionPathPart) {
        return this.encodePartitionPath ? UTF8String.fromString((String)PartitionPathEncodeUtils.escapePathName(partitionPathPart.toString())) : partitionPathPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryInitRowConverter(StructType structType) {
        if (this.rowConverter == null) {
            BuiltinKeyGenerator builtinKeyGenerator = this;
            synchronized (builtinKeyGenerator) {
                if (this.rowConverter == null) {
                    this.rowConverter = new SparkRowConverter(structType);
                }
            }
        }
    }

    protected static String requireNonNullNonEmptyKey(String key) {
        if (key != null && key.length() > 0) {
            return key;
        }
        throw new HoodieKeyException("Record key has to be non-empty string!");
    }

    protected static UTF8String requireNonNullNonEmptyKey(UTF8String key) {
        if (key != null && key.numChars() > 0) {
            return key;
        }
        throw new HoodieKeyException("Record key has to be non-empty string!");
    }

    protected static <S> S handleNullRecordKey(S s) {
        if (s == null || s.toString().isEmpty()) {
            throw new HoodieKeyException("Record key has to be non-null!");
        }
        return s;
    }

    private static UTF8String toUTF8String(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof UTF8String) {
            return (UTF8String)o;
        }
        return UTF8String.fromString((String)o.toString());
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    private static String handleNullOrEmptyCompositeKeyPart(Object keyPart) {
        if (keyPart == null) {
            return "__null__";
        }
        String keyPartStr = keyPart.toString();
        return !keyPartStr.isEmpty() ? keyPartStr : "__empty__";
    }

    private static UTF8String handleNullOrEmptyCompositeKeyPartUTF8(UTF8String keyPart) {
        if (keyPart == null) {
            return NULL_RECORD_KEY_PLACEHOLDER_UTF8;
        }
        if (keyPart.numChars() == 0) {
            return EMPTY_RECORD_KEY_PLACEHOLDER_UTF8;
        }
        return keyPart;
    }

    private static boolean isNullOrEmptyCompositeKeyPart(String keyPart) {
        return keyPart == "__null__" || keyPart == "__empty__";
    }

    private static boolean isNullOrEmptyCompositeKeyPartUTF8(UTF8String keyPart) {
        return keyPart == NULL_RECORD_KEY_PLACEHOLDER_UTF8 || keyPart == EMPTY_RECORD_KEY_PLACEHOLDER_UTF8;
    }

    private static String handleNullOrEmptyPartitionPathPart(Object partitionPathPart) {
        if (partitionPathPart == null) {
            return "__HIVE_DEFAULT_PARTITION__";
        }
        String keyPartStr = partitionPathPart.toString();
        return keyPartStr.isEmpty() ? "__HIVE_DEFAULT_PARTITION__" : keyPartStr;
    }

    private static UTF8String handleNullOrEmptyPartitionPathPartUTF8(UTF8String keyPart) {
        if (keyPart == null || keyPart.numChars() == 0) {
            return HUDI_DEFAULT_PARTITION_PATH_UTF8;
        }
        return keyPart;
    }

    private static Object convertToLogicalDataType(DataType dataType, Object value) {
        if (value == null) {
            return null;
        }
        if (dataType instanceof TimestampType) {
            return new Timestamp((Long)value / 1000L);
        }
        if (dataType instanceof DateType) {
            return LocalDate.ofEpochDay(((Integer)value).intValue());
        }
        return value;
    }

    private static class UTF8StringBuilder
    implements StringBuilder<UTF8String> {
        private final org.apache.hudi.unsafe.UTF8StringBuilder sb = new org.apache.hudi.unsafe.UTF8StringBuilder();

        private UTF8StringBuilder() {
        }

        @Override
        public StringBuilder<UTF8String> appendJava(String s) {
            this.sb.append(s);
            return this;
        }

        @Override
        public StringBuilder<UTF8String> append(UTF8String s) {
            this.sb.append(s);
            return this;
        }

        @Override
        public UTF8String build() {
            return this.sb.build();
        }
    }

    private static class JavaStringBuilder
    implements StringBuilder<String> {
        private final java.lang.StringBuilder sb = new java.lang.StringBuilder();

        private JavaStringBuilder() {
        }

        @Override
        public StringBuilder<String> appendJava(String s) {
            this.sb.append(s);
            return this;
        }

        @Override
        public String build() {
            return this.sb.toString();
        }
    }

    private static interface StringBuilder<S> {
        default public StringBuilder<S> append(S s) {
            return this.appendJava(s.toString());
        }

        public StringBuilder<S> appendJava(String var1);

        public S build();
    }

    protected class SparkRowAccessor {
        private final HoodieUnsafeRowUtils.NestedFieldPath[] recordKeyFieldsPaths;
        private final HoodieUnsafeRowUtils.NestedFieldPath[] partitionPathFieldsPaths;

        SparkRowAccessor(StructType schema2) {
            this.recordKeyFieldsPaths = this.resolveNestedFieldPaths(BuiltinKeyGenerator.this.getRecordKeyFieldNames(), schema2);
            this.partitionPathFieldsPaths = this.resolveNestedFieldPaths(BuiltinKeyGenerator.this.getPartitionPathFields(), schema2);
        }

        public Object[] getRecordKeyParts(Row row) {
            return this.getNestedFieldValues(row, this.recordKeyFieldsPaths);
        }

        public Object[] getRecordPartitionPathValues(Row row) {
            return this.getNestedFieldValues(row, this.partitionPathFieldsPaths);
        }

        public Object[] getRecordKeyParts(InternalRow row) {
            return this.getNestedFieldValues(row, this.recordKeyFieldsPaths);
        }

        public Object[] getRecordPartitionPathValues(InternalRow row) {
            return this.getNestedFieldValues(row, this.partitionPathFieldsPaths);
        }

        private Object[] getNestedFieldValues(Row row, HoodieUnsafeRowUtils.NestedFieldPath[] nestedFieldsPaths) {
            Object[] nestedFieldValues = new Object[nestedFieldsPaths.length];
            for (int i = 0; i < nestedFieldsPaths.length; ++i) {
                nestedFieldValues[i] = HoodieUnsafeRowUtils$.MODULE$.getNestedRowValue(row, nestedFieldsPaths[i]);
            }
            return nestedFieldValues;
        }

        private Object[] getNestedFieldValues(InternalRow row, HoodieUnsafeRowUtils.NestedFieldPath[] nestedFieldsPaths) {
            Object[] nestedFieldValues = new Object[nestedFieldsPaths.length];
            for (int i = 0; i < nestedFieldsPaths.length; ++i) {
                Object rawValue = HoodieUnsafeRowUtils$.MODULE$.getNestedInternalRowValue(row, nestedFieldsPaths[i]);
                DataType dataType = ((StructField)CollectionUtils.tail(nestedFieldsPaths[i].parts())._2).dataType();
                nestedFieldValues[i] = BuiltinKeyGenerator.convertToLogicalDataType(dataType, rawValue);
            }
            return nestedFieldValues;
        }

        private HoodieUnsafeRowUtils.NestedFieldPath[] resolveNestedFieldPaths(List<String> fieldPaths, StructType schema2) {
            try {
                return (HoodieUnsafeRowUtils.NestedFieldPath[])fieldPaths.stream().map(fieldPath -> HoodieUnsafeRowUtils$.MODULE$.composeNestedFieldPath(schema2, (String)fieldPath)).toArray(HoodieUnsafeRowUtils.NestedFieldPath[]::new);
            }
            catch (Exception e) {
                LOG.error((Object)String.format("Failed to resolve nested field-paths (%s) in schema (%s)", fieldPaths, schema2), (Throwable)e);
                throw new HoodieException("Failed to resolve nested field-paths", e);
            }
        }
    }

    protected static class SparkRowConverter {
        private static final String STRUCT_NAME = "hoodieRowTopLevelField";
        private static final String NAMESPACE = "hoodieRow";
        private final Function1<Row, GenericRecord> avroConverter;
        private final SparkRowSerDe rowSerDe;

        SparkRowConverter(StructType schema2) {
            this.rowSerDe = HoodieSparkUtils.getCatalystRowSerDe(schema2);
            this.avroConverter = AvroConversionUtils.createConverterToAvro(schema2, STRUCT_NAME, NAMESPACE);
        }

        GenericRecord convertToAvro(Row row) {
            return (GenericRecord)this.avroConverter.apply((Object)row);
        }

        GenericRecord convertToAvro(InternalRow row) {
            return (GenericRecord)this.avroConverter.apply((Object)this.rowSerDe.deserializeRow(row));
        }
    }
}

