/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.util.Arrays;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MutableRegionInfo
implements RegionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MutableRegionInfo.class);
    private static final int MAX_REPLICA_ID = 65535;
    private boolean offLine;
    private boolean split;
    private final long regionId;
    private final int replicaId;
    private final byte[] regionName;
    private final byte[] startKey;
    private final byte[] endKey;
    private final int hashCode;
    private final String encodedName;
    private final byte[] encodedNameAsBytes;
    private final TableName tableName;

    private static int generateHashCode(TableName tableName, byte[] startKey, byte[] endKey, long regionId, int replicaId, boolean offLine, byte[] regionName) {
        int result = Arrays.hashCode(regionName);
        result = (int)((long)result ^ regionId);
        result ^= Arrays.hashCode(MutableRegionInfo.checkStartKey(startKey));
        result ^= Arrays.hashCode(MutableRegionInfo.checkEndKey(endKey));
        result ^= Boolean.valueOf(offLine).hashCode();
        result ^= Arrays.hashCode(tableName.getName());
        return result ^= replicaId;
    }

    private static byte[] checkStartKey(byte[] startKey) {
        return startKey == null ? HConstants.EMPTY_START_ROW : startKey;
    }

    private static byte[] checkEndKey(byte[] endKey) {
        return endKey == null ? HConstants.EMPTY_END_ROW : endKey;
    }

    private static TableName checkTableName(TableName tableName) {
        if (tableName == null) {
            throw new IllegalArgumentException("TableName cannot be null");
        }
        return tableName;
    }

    private static int checkReplicaId(int regionId) {
        if (regionId > 65535) {
            throw new IllegalArgumentException("ReplicaId cannot be greater than65535");
        }
        return regionId;
    }

    MutableRegionInfo(long regionId, TableName tableName, int replicaId) {
        this(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false, regionId, replicaId, false);
    }

    MutableRegionInfo(TableName tableName, byte[] startKey, byte[] endKey, boolean split2, long regionId, int replicaId, boolean offLine) {
        this.tableName = MutableRegionInfo.checkTableName(tableName);
        this.startKey = MutableRegionInfo.checkStartKey(startKey);
        this.endKey = MutableRegionInfo.checkEndKey(endKey);
        this.split = split2;
        this.regionId = regionId;
        this.replicaId = MutableRegionInfo.checkReplicaId(replicaId);
        this.offLine = offLine;
        this.regionName = RegionInfo.createRegionName(this.tableName, this.startKey, this.regionId, this.replicaId, !this.tableName.equals(TableName.META_TABLE_NAME));
        this.encodedName = RegionInfo.encodeRegionName(this.regionName);
        this.hashCode = MutableRegionInfo.generateHashCode(this.tableName, this.startKey, this.endKey, this.regionId, this.replicaId, this.offLine, this.regionName);
        this.encodedNameAsBytes = Bytes.toBytes(this.encodedName);
    }

    @Override
    public String getShortNameToLog() {
        return RegionInfo.prettyPrint(this.getEncodedName());
    }

    @Override
    public long getRegionId() {
        return this.regionId;
    }

    @Override
    public byte[] getRegionName() {
        return this.regionName;
    }

    @Override
    public String getRegionNameAsString() {
        return RegionInfo.getRegionNameAsString(this, this.regionName);
    }

    @Override
    public String getEncodedName() {
        return this.encodedName;
    }

    @Override
    public byte[] getEncodedNameAsBytes() {
        return this.encodedNameAsBytes;
    }

    @Override
    public byte[] getStartKey() {
        return this.startKey;
    }

    @Override
    public byte[] getEndKey() {
        return this.endKey;
    }

    @Override
    public TableName getTable() {
        return this.tableName;
    }

    @Override
    public boolean containsRange(byte[] rangeStartKey, byte[] rangeEndKey) {
        CellComparator cellComparator = CellComparatorImpl.getCellComparator(this.tableName);
        if (cellComparator.compareRows(rangeStartKey, rangeEndKey) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(rangeStartKey) + " > " + Bytes.toStringBinary(rangeEndKey));
        }
        boolean firstKeyInRange = cellComparator.compareRows(rangeStartKey, this.startKey) >= 0;
        boolean lastKeyInRange = cellComparator.compareRows(rangeEndKey, this.endKey) < 0 || Bytes.equals(this.endKey, HConstants.EMPTY_BYTE_ARRAY);
        return firstKeyInRange && lastKeyInRange;
    }

    @Override
    public boolean containsRow(byte[] row) {
        CellComparator cellComparator = CellComparatorImpl.getCellComparator(this.tableName);
        return cellComparator.compareRows(row, this.startKey) >= 0 && (cellComparator.compareRows(row, this.endKey) < 0 || Bytes.equals(this.endKey, HConstants.EMPTY_BYTE_ARRAY));
    }

    @Override
    public boolean isMetaRegion() {
        return this.tableName.equals(TableName.META_TABLE_NAME);
    }

    @Override
    public boolean isSplit() {
        return this.split;
    }

    public MutableRegionInfo setSplit(boolean split2) {
        this.split = split2;
        return this;
    }

    @Override
    @Deprecated
    public boolean isOffline() {
        return this.offLine;
    }

    public MutableRegionInfo setOffline(boolean offLine) {
        this.offLine = offLine;
        return this;
    }

    @Override
    @Deprecated
    public boolean isSplitParent() {
        if (!this.isSplit()) {
            return false;
        }
        if (!this.isOffline()) {
            LOG.warn("Region is split but NOT offline: " + this.getRegionNameAsString());
        }
        return true;
    }

    @Override
    public int getReplicaId() {
        return this.replicaId;
    }

    public String toString() {
        return "{ENCODED => " + this.getEncodedName() + ", " + "NAME" + " => '" + Bytes.toStringBinary(this.regionName) + "', STARTKEY => '" + Bytes.toStringBinary(this.startKey) + "', ENDKEY => '" + Bytes.toStringBinary(this.endKey) + "'" + (this.isOffline() ? ", OFFLINE => true" : "") + (this.isSplit() ? ", SPLIT => true" : "") + (this.replicaId > 0 ? ", REPLICA_ID => " + this.replicaId : "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof RegionInfo)) {
            return false;
        }
        return this.compareTo((RegionInfo)o) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

