/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableExistsException;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.FairQueue;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MetaProcedureInterface;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MetaQueue;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.PeerQueue;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.Queue;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.SchemaLocking;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.ServerQueue;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.TableQueue;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.LockAndQueue;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.LockStatus;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.LockedResourceType;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hudi.org.apache.hadoop.hbase.util.AvlUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterProcedureScheduler
extends AbstractProcedureScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(MasterProcedureScheduler.class);
    private static final AvlUtil.AvlKeyComparator<ServerQueue> SERVER_QUEUE_KEY_COMPARATOR = (n, k) -> n.compareKey((ServerName)k);
    private static final AvlUtil.AvlKeyComparator<TableQueue> TABLE_QUEUE_KEY_COMPARATOR = (n, k) -> n.compareKey((TableName)k);
    private static final AvlUtil.AvlKeyComparator<PeerQueue> PEER_QUEUE_KEY_COMPARATOR = (n, k) -> n.compareKey((String)k);
    private static final AvlUtil.AvlKeyComparator<MetaQueue> META_QUEUE_KEY_COMPARATOR = (n, k) -> n.compareKey((TableName)k);
    private final FairQueue<ServerName> serverRunQueue = new FairQueue();
    private final FairQueue<TableName> tableRunQueue = new FairQueue();
    private final FairQueue<String> peerRunQueue = new FairQueue();
    private final FairQueue<TableName> metaRunQueue = new FairQueue();
    private final ServerQueue[] serverBuckets = new ServerQueue[128];
    private TableQueue tableMap = null;
    private PeerQueue peerMap = null;
    private MetaQueue metaMap = null;
    private final SchemaLocking locking;

    public MasterProcedureScheduler(Function<Long, Procedure<?>> procedureRetriever) {
        this.locking = new SchemaLocking(procedureRetriever);
    }

    public void yield(Procedure proc) {
        this.push(proc, false, true);
    }

    protected void enqueue(Procedure proc, boolean addFront) {
        if (MasterProcedureScheduler.isMetaProcedure(proc)) {
            this.doAdd(this.metaRunQueue, this.getMetaQueue(), proc, addFront);
        } else if (MasterProcedureScheduler.isTableProcedure(proc)) {
            this.doAdd(this.tableRunQueue, this.getTableQueue(MasterProcedureScheduler.getTableName(proc)), proc, addFront);
        } else if (MasterProcedureScheduler.isServerProcedure(proc)) {
            ServerProcedureInterface spi = (ServerProcedureInterface)proc;
            this.doAdd(this.serverRunQueue, this.getServerQueue(spi.getServerName(), spi), proc, addFront);
        } else if (MasterProcedureScheduler.isPeerProcedure(proc)) {
            this.doAdd(this.peerRunQueue, this.getPeerQueue(MasterProcedureScheduler.getPeerId(proc)), proc, addFront);
        } else {
            throw new UnsupportedOperationException("RQs for non-table/non-server procedures are not implemented yet: " + proc);
        }
    }

    private <T extends Comparable<T>> void doAdd(FairQueue<T> fairq, Queue<T> queue, Procedure<?> proc, boolean addFront) {
        queue.add(proc, addFront);
        Supplier<String> reason = null;
        if (proc.hasLock()) {
            reason = () -> proc + " has lock";
        } else if (proc.isLockedWhenLoading()) {
            reason = () -> proc + " restores lock when restarting";
        } else if (!queue.getLockStatus().hasExclusiveLock()) {
            reason = () -> "the exclusive lock is not held by anyone when adding " + proc;
        } else if (queue.getLockStatus().hasLockAccess(proc)) {
            reason = () -> proc + " has the excusive lock access";
        }
        if (reason != null) {
            MasterProcedureScheduler.addToRunQueue(fairq, queue, reason);
        }
    }

    protected boolean queueHasRunnables() {
        return this.metaRunQueue.hasRunnables() || this.tableRunQueue.hasRunnables() || this.serverRunQueue.hasRunnables() || this.peerRunQueue.hasRunnables();
    }

    protected Procedure dequeue() {
        Procedure<?> pollResult = this.doPoll(this.metaRunQueue);
        if (pollResult == null) {
            pollResult = this.doPoll(this.serverRunQueue);
        }
        if (pollResult == null) {
            pollResult = this.doPoll(this.peerRunQueue);
        }
        if (pollResult == null) {
            pollResult = this.doPoll(this.tableRunQueue);
        }
        return pollResult;
    }

    private <T extends Comparable<T>> boolean isLockReady(Procedure<?> proc, Queue<T> rq) {
        LockStatus s = rq.getLockStatus();
        if (s.hasLockAccess(proc)) {
            return true;
        }
        boolean xlockReq = rq.requireExclusiveLock(proc);
        return xlockReq ? !s.isLocked() : !s.hasExclusiveLock();
    }

    private <T extends Comparable<T>> Procedure<?> doPoll(FairQueue<T> fairq) {
        Queue<T> rq = fairq.poll();
        if (rq == null || !rq.isAvailable()) {
            return null;
        }
        int n = rq.size();
        for (int i = 0; i < n; ++i) {
            Procedure<?> proc = rq.poll();
            if (this.isLockReady(proc, rq)) {
                if (rq.isEmpty()) {
                    MasterProcedureScheduler.removeFromRunQueue(fairq, rq, () -> "queue is empty after polling out " + proc);
                }
                return proc;
            }
            rq.add(proc, false);
        }
        MasterProcedureScheduler.removeFromRunQueue(fairq, rq, () -> "no procedure can be executed");
        return null;
    }

    public List<LockedResource> getLocks() {
        this.schedLock();
        try {
            List<LockedResource> list = this.locking.getLocks();
            return list;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockedResource getLockResource(LockedResourceType resourceType, String resourceName) {
        this.schedLock();
        try {
            LockedResource lockedResource = this.locking.getLockResource(resourceType, resourceName);
            return lockedResource;
        }
        finally {
            this.schedUnlock();
        }
    }

    public void clear() {
        this.schedLock();
        try {
            this.clearQueue();
            this.locking.clear();
        }
        finally {
            this.schedUnlock();
        }
    }

    private void clearQueue() {
        for (int i = 0; i < this.serverBuckets.length; ++i) {
            this.clear(this.serverBuckets[i], this.serverRunQueue, SERVER_QUEUE_KEY_COMPARATOR);
            this.serverBuckets[i] = null;
        }
        this.clear(this.tableMap, this.tableRunQueue, TABLE_QUEUE_KEY_COMPARATOR);
        this.tableMap = null;
        this.clear(this.peerMap, this.peerRunQueue, PEER_QUEUE_KEY_COMPARATOR);
        this.peerMap = null;
        assert (this.size() == 0) : "expected queue size to be 0, got " + this.size();
    }

    private <T extends Comparable<T>, TNode extends Queue<T>> void clear(TNode treeMap, FairQueue<T> fairq, AvlUtil.AvlKeyComparator<TNode> comparator) {
        while (treeMap != null) {
            TNode node = AvlUtil.AvlTree.getFirst(treeMap);
            treeMap = AvlUtil.AvlTree.remove(treeMap, node.getKey(), comparator);
            if (fairq == null) continue;
            MasterProcedureScheduler.removeFromRunQueue(fairq, node, () -> "clear all queues");
        }
    }

    private int queueSize(Queue<?> head) {
        int count2 = 0;
        AvlUtil.AvlTreeIterator iter = new AvlUtil.AvlTreeIterator(head);
        while (iter.hasNext()) {
            count2 += ((Queue)iter.next()).size();
        }
        return count2;
    }

    protected int queueSize() {
        int count2 = 0;
        for (ServerQueue serverMap : this.serverBuckets) {
            count2 += this.queueSize(serverMap);
        }
        count2 += this.queueSize(this.tableMap);
        count2 += this.queueSize(this.peerMap);
        return count2 += this.queueSize(this.metaMap);
    }

    public void completionCleanup(Procedure proc) {
        if (proc instanceof TableProcedureInterface) {
            boolean tableDeleted;
            TableProcedureInterface iProcTable = (TableProcedureInterface)proc;
            if (proc.hasException()) {
                Exception procEx = proc.getException().unwrapRemoteException();
                tableDeleted = iProcTable.getTableOperationType() == TableProcedureInterface.TableOperationType.CREATE ? !(procEx instanceof TableExistsException) : procEx instanceof TableNotFoundException;
            } else {
                boolean bl = tableDeleted = iProcTable.getTableOperationType() == TableProcedureInterface.TableOperationType.DELETE;
            }
            if (tableDeleted) {
                this.markTableAsDeleted(iProcTable.getTableName(), proc);
                return;
            }
        } else if (proc instanceof PeerProcedureInterface) {
            this.tryCleanupPeerQueue(MasterProcedureScheduler.getPeerId(proc), proc);
        } else if (proc instanceof ServerProcedureInterface) {
            this.tryCleanupServerQueue(MasterProcedureScheduler.getServerName(proc), proc);
        } else {
            return;
        }
    }

    private static <T extends Comparable<T>> void addToRunQueue(FairQueue<T> fairq, Queue<T> queue, Supplier<String> reason) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Add {} to run queue because: {}", queue, (Object)reason.get());
        }
        if (!AvlUtil.AvlIterableList.isLinked(queue) && !queue.isEmpty()) {
            fairq.add(queue);
        }
    }

    private static <T extends Comparable<T>> void removeFromRunQueue(FairQueue<T> fairq, Queue<T> queue, Supplier<String> reason) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Remove {} from run queue because: {}", queue, (Object)reason.get());
        }
        if (AvlUtil.AvlIterableList.isLinked(queue)) {
            fairq.remove(queue);
        }
    }

    private TableQueue getTableQueue(TableName tableName) {
        TableQueue node = AvlUtil.AvlTree.get(this.tableMap, tableName, TABLE_QUEUE_KEY_COMPARATOR);
        if (node != null) {
            return node;
        }
        node = new TableQueue(tableName, MasterProcedureUtil.getTablePriority(tableName), (LockStatus)this.locking.getTableLock(tableName), (LockStatus)this.locking.getNamespaceLock(tableName.getNamespaceAsString()));
        this.tableMap = AvlUtil.AvlTree.insert(this.tableMap, node);
        return node;
    }

    private void removeTableQueue(TableName tableName) {
        this.tableMap = AvlUtil.AvlTree.remove(this.tableMap, tableName, TABLE_QUEUE_KEY_COMPARATOR);
        this.locking.removeTableLock(tableName);
    }

    private static boolean isTableProcedure(Procedure<?> proc) {
        return proc instanceof TableProcedureInterface;
    }

    private static TableName getTableName(Procedure<?> proc) {
        return ((TableProcedureInterface)proc).getTableName();
    }

    private ServerQueue getServerQueue(ServerName serverName, ServerProcedureInterface proc) {
        int index = MasterProcedureScheduler.getBucketIndex(this.serverBuckets, serverName.hashCode());
        ServerQueue node = AvlUtil.AvlTree.get(this.serverBuckets[index], serverName, SERVER_QUEUE_KEY_COMPARATOR);
        if (node != null) {
            return node;
        }
        int priority = proc != null ? MasterProcedureUtil.getServerPriority(proc) : 1;
        node = new ServerQueue(serverName, priority, (LockStatus)this.locking.getServerLock(serverName));
        this.serverBuckets[index] = AvlUtil.AvlTree.insert(this.serverBuckets[index], node);
        return node;
    }

    private void removeServerQueue(ServerName serverName) {
        int index = MasterProcedureScheduler.getBucketIndex(this.serverBuckets, serverName.hashCode());
        this.serverBuckets[index] = AvlUtil.AvlTree.remove(this.serverBuckets[index], serverName, SERVER_QUEUE_KEY_COMPARATOR);
        this.locking.removeServerLock(serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCleanupServerQueue(ServerName serverName, Procedure<?> proc) {
        this.schedLock();
        try {
            int index = MasterProcedureScheduler.getBucketIndex(this.serverBuckets, serverName.hashCode());
            ServerQueue node = AvlUtil.AvlTree.get(this.serverBuckets[index], serverName, SERVER_QUEUE_KEY_COMPARATOR);
            if (node == null) {
                return;
            }
            LockAndQueue lock = this.locking.getServerLock(serverName);
            if (node.isEmpty() && lock.tryExclusiveLock(proc)) {
                MasterProcedureScheduler.removeFromRunQueue(this.serverRunQueue, node, () -> "clean up server queue after " + proc + " completed");
                this.removeServerQueue(serverName);
            }
        }
        finally {
            this.schedUnlock();
        }
    }

    private static int getBucketIndex(Object[] buckets, int hashCode) {
        return Math.abs(hashCode) % buckets.length;
    }

    private static boolean isServerProcedure(Procedure<?> proc) {
        return proc instanceof ServerProcedureInterface;
    }

    private static ServerName getServerName(Procedure<?> proc) {
        return ((ServerProcedureInterface)proc).getServerName();
    }

    private PeerQueue getPeerQueue(String peerId) {
        PeerQueue node = AvlUtil.AvlTree.get(this.peerMap, peerId, PEER_QUEUE_KEY_COMPARATOR);
        if (node != null) {
            return node;
        }
        node = new PeerQueue(peerId, (LockStatus)this.locking.getPeerLock(peerId));
        this.peerMap = AvlUtil.AvlTree.insert(this.peerMap, node);
        return node;
    }

    private void removePeerQueue(String peerId) {
        this.peerMap = AvlUtil.AvlTree.remove(this.peerMap, peerId, PEER_QUEUE_KEY_COMPARATOR);
        this.locking.removePeerLock(peerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCleanupPeerQueue(String peerId, Procedure procedure) {
        this.schedLock();
        try {
            PeerQueue queue = AvlUtil.AvlTree.get(this.peerMap, peerId, PEER_QUEUE_KEY_COMPARATOR);
            if (queue == null) {
                return;
            }
            LockAndQueue lock = this.locking.getPeerLock(peerId);
            if (queue.isEmpty() && lock.tryExclusiveLock(procedure)) {
                MasterProcedureScheduler.removeFromRunQueue(this.peerRunQueue, queue, () -> "clean up peer queue after " + procedure + " completed");
                this.removePeerQueue(peerId);
            }
        }
        finally {
            this.schedUnlock();
        }
    }

    private static boolean isPeerProcedure(Procedure<?> proc) {
        return proc instanceof PeerProcedureInterface;
    }

    private static String getPeerId(Procedure<?> proc) {
        return ((PeerProcedureInterface)proc).getPeerId();
    }

    private MetaQueue getMetaQueue() {
        MetaQueue node = AvlUtil.AvlTree.get(this.metaMap, TableName.META_TABLE_NAME, META_QUEUE_KEY_COMPARATOR);
        if (node != null) {
            return node;
        }
        node = new MetaQueue((LockStatus)this.locking.getMetaLock());
        this.metaMap = AvlUtil.AvlTree.insert(this.metaMap, node);
        return node;
    }

    private static boolean isMetaProcedure(Procedure<?> proc) {
        return proc instanceof MetaProcedureInterface;
    }

    private void logLockedResource(LockedResourceType resourceType, String resourceName) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LockedResource lockedResource = this.getLockResource(resourceType, resourceName);
        if (lockedResource != null) {
            String msg = resourceType.toString() + " '" + resourceName + "', shared lock count=" + lockedResource.getSharedLockCount();
            Procedure proc = lockedResource.getExclusiveLockOwnerProcedure();
            if (proc != null) {
                msg = msg + ", exclusively locked by procId=" + proc.getProcId();
            }
            LOG.debug(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitTableExclusiveLock(Procedure<?> procedure, TableName table) {
        this.schedLock();
        try {
            String namespace = table.getNamespaceAsString();
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(namespace);
            LockAndQueue tableLock = this.locking.getTableLock(table);
            if (!namespaceLock.trySharedLock(procedure)) {
                this.waitProcedure(namespaceLock, procedure);
                this.logLockedResource(LockedResourceType.NAMESPACE, namespace);
                boolean bl = true;
                return bl;
            }
            if (!tableLock.tryExclusiveLock(procedure)) {
                namespaceLock.releaseSharedLock();
                this.waitProcedure(tableLock, procedure);
                this.logLockedResource(LockedResourceType.TABLE, table.getNameAsString());
                boolean bl = true;
                return bl;
            }
            MasterProcedureScheduler.removeFromRunQueue(this.tableRunQueue, this.getTableQueue(table), () -> procedure + " held the exclusive lock");
            boolean bl = false;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeTableExclusiveLock(Procedure<?> procedure, TableName table) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(table.getNamespaceAsString());
            LockAndQueue tableLock = this.locking.getTableLock(table);
            int waitingCount = 0;
            if (tableLock.releaseExclusiveLock(procedure)) {
                waitingCount += this.wakeWaitingProcedures(tableLock);
            }
            if (namespaceLock.releaseSharedLock()) {
                waitingCount += this.wakeWaitingProcedures(namespaceLock);
            }
            MasterProcedureScheduler.addToRunQueue(this.tableRunQueue, this.getTableQueue(table), () -> procedure + " released the exclusive lock");
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    public boolean waitTableSharedLock(Procedure<?> procedure, TableName table) {
        return this.waitTableQueueSharedLock(procedure, table) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableQueue waitTableQueueSharedLock(Procedure<?> procedure, TableName table) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(table.getNamespaceAsString());
            LockAndQueue tableLock = this.locking.getTableLock(table);
            if (!namespaceLock.trySharedLock(procedure)) {
                this.waitProcedure(namespaceLock, procedure);
                TableQueue tableQueue = null;
                return tableQueue;
            }
            if (!tableLock.trySharedLock(procedure)) {
                namespaceLock.releaseSharedLock();
                this.waitProcedure(tableLock, procedure);
                TableQueue tableQueue = null;
                return tableQueue;
            }
            TableQueue tableQueue = this.getTableQueue(table);
            return tableQueue;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeTableSharedLock(Procedure<?> procedure, TableName table) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(table.getNamespaceAsString());
            LockAndQueue tableLock = this.locking.getTableLock(table);
            int waitingCount = 0;
            if (tableLock.releaseSharedLock()) {
                MasterProcedureScheduler.addToRunQueue(this.tableRunQueue, this.getTableQueue(table), () -> procedure + " released the shared lock");
                waitingCount += this.wakeWaitingProcedures(tableLock);
            }
            if (namespaceLock.releaseSharedLock()) {
                waitingCount += this.wakeWaitingProcedures(namespaceLock);
            }
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean markTableAsDeleted(TableName table, Procedure<?> procedure) {
        block7: {
            this.schedLock();
            try {
                TableQueue queue = this.getTableQueue(table);
                LockAndQueue tableLock = this.locking.getTableLock(table);
                if (queue == null) {
                    boolean bl = true;
                    return bl;
                }
                if (queue.isEmpty() && tableLock.tryExclusiveLock(procedure)) {
                    if (AvlUtil.AvlIterableList.isLinked(queue)) {
                        this.tableRunQueue.remove(queue);
                    }
                    this.removeTableQueue(table);
                    break block7;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.schedUnlock();
            }
        }
        return true;
    }

    public boolean waitRegion(Procedure<?> procedure, RegionInfo regionInfo) {
        return this.waitRegions(procedure, regionInfo.getTable(), regionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitRegions(Procedure<?> procedure, TableName table, RegionInfo ... regionInfos) {
        Arrays.sort(regionInfos, RegionInfo.COMPARATOR);
        this.schedLock();
        try {
            assert (table != null);
            if (this.waitTableSharedLock(procedure, table)) {
                boolean bl = true;
                return bl;
            }
            boolean hasLock = true;
            LockAndQueue[] regionLocks = new LockAndQueue[regionInfos.length];
            for (int i = 0; i < regionInfos.length; ++i) {
                assert (regionInfos[i] != null);
                assert (regionInfos[i].getTable() != null);
                assert (regionInfos[i].getTable().equals(table)) : regionInfos[i] + " " + procedure;
                assert (i == 0 || regionInfos[i] != regionInfos[i - 1]) : "duplicate region: " + regionInfos[i];
                regionLocks[i] = this.locking.getRegionLock(regionInfos[i].getEncodedName());
                if (!regionLocks[i].tryExclusiveLock(procedure)) {
                    LOG.info("Waiting on xlock for {} held by pid={}", procedure, (Object)regionLocks[i].getExclusiveLockProcIdOwner());
                    this.waitProcedure(regionLocks[i], procedure);
                    hasLock = false;
                    while (i-- > 0) {
                        regionLocks[i].releaseExclusiveLock(procedure);
                    }
                    break;
                }
                LOG.info("Took xlock for {}", procedure);
            }
            if (!hasLock) {
                this.wakeTableSharedLock(procedure, table);
            }
            boolean bl = !hasLock;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    public void wakeRegion(Procedure<?> procedure, RegionInfo regionInfo) {
        this.wakeRegions(procedure, regionInfo.getTable(), regionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeRegions(Procedure<?> procedure, TableName table, RegionInfo ... regionInfos) {
        Arrays.sort(regionInfos, RegionInfo.COMPARATOR);
        this.schedLock();
        try {
            int i;
            int numProcs = 0;
            Procedure[] nextProcs = new Procedure[regionInfos.length];
            for (i = 0; i < regionInfos.length; ++i) {
                assert (regionInfos[i].getTable().equals(table));
                assert (i == 0 || regionInfos[i] != regionInfos[i - 1]) : "duplicate region: " + regionInfos[i];
                LockAndQueue regionLock = this.locking.getRegionLock(regionInfos[i].getEncodedName());
                if (!regionLock.releaseExclusiveLock(procedure)) continue;
                if (!regionLock.isWaitingQueueEmpty()) {
                    nextProcs[numProcs++] = regionLock.removeFirst();
                    continue;
                }
                this.locking.removeRegionLock(regionInfos[i].getEncodedName());
            }
            for (i = numProcs - 1; i >= 0; --i) {
                this.wakeProcedure(nextProcs[i]);
            }
            this.wakePollIfNeeded(numProcs);
            this.wakeTableSharedLock(procedure, table);
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitNamespaceExclusiveLock(Procedure<?> procedure, String namespace) {
        this.schedLock();
        try {
            LockAndQueue systemNamespaceTableLock = this.locking.getTableLock(TableName.NAMESPACE_TABLE_NAME);
            if (!systemNamespaceTableLock.trySharedLock(procedure)) {
                this.waitProcedure(systemNamespaceTableLock, procedure);
                this.logLockedResource(LockedResourceType.TABLE, TableName.NAMESPACE_TABLE_NAME.getNameAsString());
                boolean bl = true;
                return bl;
            }
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(namespace);
            if (!namespaceLock.tryExclusiveLock(procedure)) {
                systemNamespaceTableLock.releaseSharedLock();
                this.waitProcedure(namespaceLock, procedure);
                this.logLockedResource(LockedResourceType.NAMESPACE, namespace);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNamespaceExclusiveLock(Procedure<?> procedure, String namespace) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(namespace);
            LockAndQueue systemNamespaceTableLock = this.locking.getTableLock(TableName.NAMESPACE_TABLE_NAME);
            int waitingCount = 0;
            if (namespaceLock.releaseExclusiveLock(procedure)) {
                waitingCount += this.wakeWaitingProcedures(namespaceLock);
            }
            if (systemNamespaceTableLock.releaseSharedLock()) {
                MasterProcedureScheduler.addToRunQueue(this.tableRunQueue, this.getTableQueue(TableName.NAMESPACE_TABLE_NAME), () -> procedure + " released namespace exclusive lock");
                waitingCount += this.wakeWaitingProcedures(systemNamespaceTableLock);
            }
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitServerExclusiveLock(Procedure<?> procedure, ServerName serverName) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getServerLock(serverName);
            if (lock.tryExclusiveLock(procedure)) {
                MasterProcedureScheduler.removeFromRunQueue(this.serverRunQueue, this.getServerQueue(serverName, procedure instanceof ServerProcedureInterface ? (ServerProcedureInterface)procedure : null), () -> procedure + " held exclusive lock");
                boolean bl = false;
                return bl;
            }
            this.waitProcedure(lock, procedure);
            this.logLockedResource(LockedResourceType.SERVER, serverName.getServerName());
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeServerExclusiveLock(Procedure<?> procedure, ServerName serverName) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getServerLock(serverName);
            lock.releaseExclusiveLock(procedure);
            MasterProcedureScheduler.addToRunQueue(this.serverRunQueue, this.getServerQueue(serverName, procedure instanceof ServerProcedureInterface ? (ServerProcedureInterface)procedure : null), () -> procedure + " released exclusive lock");
            int waitingCount = this.wakeWaitingProcedures(lock);
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    private static boolean requirePeerExclusiveLock(PeerProcedureInterface proc) {
        return proc.getPeerOperationType() != PeerProcedureInterface.PeerOperationType.REFRESH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitPeerExclusiveLock(Procedure<?> procedure, String peerId) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getPeerLock(peerId);
            if (lock.tryExclusiveLock(procedure)) {
                MasterProcedureScheduler.removeFromRunQueue(this.peerRunQueue, this.getPeerQueue(peerId), () -> procedure + " held exclusive lock");
                boolean bl = false;
                return bl;
            }
            this.waitProcedure(lock, procedure);
            this.logLockedResource(LockedResourceType.PEER, peerId);
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakePeerExclusiveLock(Procedure<?> procedure, String peerId) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getPeerLock(peerId);
            if (lock.releaseExclusiveLock(procedure)) {
                MasterProcedureScheduler.addToRunQueue(this.peerRunQueue, this.getPeerQueue(peerId), () -> procedure + " released exclusive lock");
                int waitingCount = this.wakeWaitingProcedures(lock);
                this.wakePollIfNeeded(waitingCount);
            }
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean waitMetaExclusiveLock(Procedure<?> procedure) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getMetaLock();
            if (lock.tryExclusiveLock(procedure)) {
                MasterProcedureScheduler.removeFromRunQueue(this.metaRunQueue, this.getMetaQueue(), () -> procedure + " held exclusive lock");
                boolean bl = false;
                return bl;
            }
            this.waitProcedure(lock, procedure);
            this.logLockedResource(LockedResourceType.META, TableName.META_TABLE_NAME.getNameAsString());
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void wakeMetaExclusiveLock(Procedure<?> procedure) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getMetaLock();
            lock.releaseExclusiveLock(procedure);
            MasterProcedureScheduler.addToRunQueue(this.metaRunQueue, this.getMetaQueue(), () -> procedure + " released exclusive lock");
            int waitingCount = this.wakeWaitingProcedures(lock);
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    public String dumpLocks() throws IOException {
        this.schedLock();
        try {
            String string = this.locking.toString();
            return string;
        }
        finally {
            this.schedUnlock();
        }
    }
}

