/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class TimeRangeTracker {
    static final long INITIAL_MIN_TIMESTAMP = Long.MAX_VALUE;
    static final long INITIAL_MAX_TIMESTAMP = -1L;

    public static TimeRangeTracker create(Type type) {
        switch (type) {
            case NON_SYNC: {
                return new NonSyncTimeRangeTracker();
            }
            case SYNC: {
                return new SyncTimeRangeTracker();
            }
        }
        throw new UnsupportedOperationException("The type:" + (Object)((Object)type) + " is unsupported");
    }

    public static TimeRangeTracker create(Type type, TimeRangeTracker trt) {
        switch (type) {
            case NON_SYNC: {
                return new NonSyncTimeRangeTracker(trt);
            }
            case SYNC: {
                return new SyncTimeRangeTracker(trt);
            }
        }
        throw new UnsupportedOperationException("The type:" + (Object)((Object)type) + " is unsupported");
    }

    public static TimeRangeTracker create(Type type, long minimumTimestamp, long maximumTimestamp) {
        switch (type) {
            case NON_SYNC: {
                return new NonSyncTimeRangeTracker(minimumTimestamp, maximumTimestamp);
            }
            case SYNC: {
                return new SyncTimeRangeTracker(minimumTimestamp, maximumTimestamp);
            }
        }
        throw new UnsupportedOperationException("The type:" + (Object)((Object)type) + " is unsupported");
    }

    protected abstract void setMax(long var1);

    protected abstract void setMin(long var1);

    protected abstract boolean compareAndSetMin(long var1, long var3);

    protected abstract boolean compareAndSetMax(long var1, long var3);

    public void includeTimestamp(Cell cell) {
        this.includeTimestamp(cell.getTimestamp());
        if (PrivateCellUtil.isDeleteColumnOrFamily(cell)) {
            this.includeTimestamp(0L);
        }
    }

    @SuppressWarnings(value={"MT_CORRECTNESS"}, justification="Intentional")
    void includeTimestamp(long timestamp) {
        long curMaxTimestamp;
        long initialMinTimestamp = this.getMin();
        if (timestamp < initialMinTimestamp) {
            long curMinTimestamp = initialMinTimestamp;
            while (timestamp < curMinTimestamp && !this.compareAndSetMin(curMinTimestamp, timestamp)) {
                curMinTimestamp = this.getMin();
            }
            if (initialMinTimestamp != Long.MAX_VALUE) {
                return;
            }
        }
        if (timestamp > (curMaxTimestamp = this.getMax())) {
            while (timestamp > curMaxTimestamp && !this.compareAndSetMax(curMaxTimestamp, timestamp)) {
                curMaxTimestamp = this.getMax();
            }
        }
    }

    public boolean includesTimeRange(TimeRange tr) {
        return this.getMin() < tr.getMax() && this.getMax() >= tr.getMin();
    }

    public abstract long getMin();

    public abstract long getMax();

    public String toString() {
        return "[" + this.getMin() + "," + this.getMax() + "]";
    }

    public static TimeRangeTracker parseFrom(byte[] data) throws IOException {
        return TimeRangeTracker.parseFrom(data, Type.NON_SYNC);
    }

    public static TimeRangeTracker parseFrom(byte[] data, Type type) throws IOException {
        Preconditions.checkNotNull(data, "input data is null!");
        if (ProtobufUtil.isPBMagicPrefix(data)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            HBaseProtos.TimeRangeTracker.Builder builder = HBaseProtos.TimeRangeTracker.newBuilder();
            ProtobufUtil.mergeFrom(builder, data, pblen, data.length - pblen);
            return TimeRangeTracker.create(type, builder.getFrom(), builder.getTo());
        }
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));){
            TimeRangeTracker timeRangeTracker = TimeRangeTracker.create(type, in.readLong(), in.readLong());
            return timeRangeTracker;
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] toByteArray(TimeRangeTracker tracker) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    TimeRange toTimeRange() {
        long min = this.getMin();
        long max = this.getMax();
        if (min == Long.MAX_VALUE) {
            min = 0L;
        }
        if (max == -1L) {
            max = Long.MAX_VALUE;
        }
        return new TimeRange(min, max);
    }

    public static class SyncTimeRangeTracker
    extends TimeRangeTracker {
        private final AtomicLong minimumTimestamp = new AtomicLong(Long.MAX_VALUE);
        private final AtomicLong maximumTimestamp = new AtomicLong(-1L);

        private SyncTimeRangeTracker() {
        }

        SyncTimeRangeTracker(TimeRangeTracker trt) {
            this.minimumTimestamp.set(trt.getMin());
            this.maximumTimestamp.set(trt.getMax());
        }

        SyncTimeRangeTracker(long minimumTimestamp, long maximumTimestamp) {
            this.minimumTimestamp.set(minimumTimestamp);
            this.maximumTimestamp.set(maximumTimestamp);
        }

        @Override
        protected void setMax(long ts) {
            this.maximumTimestamp.set(ts);
        }

        @Override
        protected void setMin(long ts) {
            this.minimumTimestamp.set(ts);
        }

        @Override
        protected boolean compareAndSetMin(long expect, long update2) {
            return this.minimumTimestamp.compareAndSet(expect, update2);
        }

        @Override
        protected boolean compareAndSetMax(long expect, long update2) {
            return this.maximumTimestamp.compareAndSet(expect, update2);
        }

        @Override
        public long getMin() {
            return this.minimumTimestamp.get();
        }

        @Override
        public long getMax() {
            return this.maximumTimestamp.get();
        }
    }

    public static class NonSyncTimeRangeTracker
    extends TimeRangeTracker {
        private long minimumTimestamp = Long.MAX_VALUE;
        private long maximumTimestamp = -1L;

        NonSyncTimeRangeTracker() {
        }

        NonSyncTimeRangeTracker(TimeRangeTracker trt) {
            this.minimumTimestamp = trt.getMin();
            this.maximumTimestamp = trt.getMax();
        }

        NonSyncTimeRangeTracker(long minimumTimestamp, long maximumTimestamp) {
            this.minimumTimestamp = minimumTimestamp;
            this.maximumTimestamp = maximumTimestamp;
        }

        @Override
        protected void setMax(long ts) {
            this.maximumTimestamp = ts;
        }

        @Override
        protected void setMin(long ts) {
            this.minimumTimestamp = ts;
        }

        @Override
        protected boolean compareAndSetMin(long expect, long update2) {
            if (this.minimumTimestamp != expect) {
                return false;
            }
            this.minimumTimestamp = update2;
            return true;
        }

        @Override
        protected boolean compareAndSetMax(long expect, long update2) {
            if (this.maximumTimestamp != expect) {
                return false;
            }
            this.maximumTimestamp = update2;
            return true;
        }

        @Override
        public long getMin() {
            return this.minimumTimestamp;
        }

        @Override
        public long getMax() {
            return this.maximumTimestamp;
        }
    }

    public static enum Type {
        NON_SYNC,
        SYNC;

    }
}

