/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher;

import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.CompactionScanQueryMatcher;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class DropDeletesCompactionScanQueryMatcher
extends CompactionScanQueryMatcher {
    protected final long timeToPurgeDeletes;
    protected final long earliestPutTs;

    protected DropDeletesCompactionScanQueryMatcher(ScanInfo scanInfo, DeleteTracker deletes, ColumnTracker columns, long readPointToUse, long earliestPutTs, long oldestUnexpiredTS, long now) {
        super(scanInfo, deletes, columns, readPointToUse, oldestUnexpiredTS, now);
        this.timeToPurgeDeletes = scanInfo.getTimeToPurgeDeletes();
        this.earliestPutTs = earliestPutTs;
    }

    protected final ScanQueryMatcher.MatchCode tryDropDelete(Cell cell) {
        long timestamp = cell.getTimestamp();
        if (this.timeToPurgeDeletes > 0L && this.now - timestamp <= this.timeToPurgeDeletes) {
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        if (this.keepDeletedCells == KeepDeletedCells.TRUE || this.keepDeletedCells == KeepDeletedCells.TTL && timestamp >= this.oldestUnexpiredTS) {
            if (timestamp < this.earliestPutTs) {
                return this.columns.getNextRowOrNextColumn(cell);
            }
            return null;
        }
        return ScanQueryMatcher.MatchCode.SKIP;
    }
}

