/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.Admin;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hudi.org.apache.hadoop.hbase.client.Table;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hadoop.hbase.util.RecoverLeaseFSUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.GnuParser;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.OptionBuilder;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionSplitter {
    private static final Logger LOG = LoggerFactory.getLogger(RegionSplitter.class);

    public static void main(String[] args2) throws IOException, InterruptedException, ParseException {
        Configuration conf = HBaseConfiguration.create();
        Options opt = new Options();
        OptionBuilder.withArgName("property=value");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Override HBase Configuration Settings");
        opt.addOption(OptionBuilder.create("D"));
        OptionBuilder.withArgName("region count");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Create a new table with a pre-split number of regions");
        opt.addOption(OptionBuilder.create("c"));
        OptionBuilder.withArgName("family:family:...");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Column Families to create with new table.  Required with -c");
        opt.addOption(OptionBuilder.create("f"));
        opt.addOption("h", false, "Print this usage help");
        opt.addOption("r", false, "Perform a rolling split of an existing region");
        OptionBuilder.withArgName("count");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Max outstanding splits that have unfinished major compactions");
        opt.addOption(OptionBuilder.create("o"));
        opt.addOption(null, "firstrow", true, "First Row in Table for Split Algorithm");
        opt.addOption(null, "lastrow", true, "Last Row in Table for Split Algorithm");
        opt.addOption(null, "risky", false, "Skip verification steps to complete quickly. STRONGLY DISCOURAGED for production systems.  ");
        CommandLine cmd = new GnuParser().parse(opt, args2);
        if (cmd.hasOption("D")) {
            for (String confOpt : cmd.getOptionValues("D")) {
                String[] kv = confOpt.split("=", 2);
                if (kv.length != 2) {
                    throw new ParseException("-D option format invalid: " + confOpt);
                }
                conf.set(kv[0], kv[1]);
                LOG.debug("-D configuration override: " + kv[0] + "=" + kv[1]);
            }
        }
        if (cmd.hasOption("risky")) {
            conf.setBoolean("split.verify", false);
        }
        boolean createTable = cmd.hasOption("c") && cmd.hasOption("f");
        boolean rollingSplit = cmd.hasOption("r");
        boolean oneOperOnly = createTable ^ rollingSplit;
        if (2 != cmd.getArgList().size() || !oneOperOnly || cmd.hasOption("h")) {
            new HelpFormatter().printHelp("bin/hbase regionsplitter <TABLE> <SPLITALGORITHM>\nSPLITALGORITHM is the java class name of a class implementing SplitAlgorithm, or one of the special strings HexStringSplit or DecimalStringSplit or UniformSplit, which are built-in split algorithms. HexStringSplit treats keys as hexadecimal ASCII, and DecimalStringSplit treats keys as decimal ASCII, and UniformSplit treats keys as arbitrary bytes.", opt);
            return;
        }
        TableName tableName = TableName.valueOf(cmd.getArgs()[0]);
        String splitClass = cmd.getArgs()[1];
        SplitAlgorithm splitAlgo = RegionSplitter.newSplitAlgoInstance(conf, splitClass);
        if (cmd.hasOption("firstrow")) {
            splitAlgo.setFirstRow(cmd.getOptionValue("firstrow"));
        }
        if (cmd.hasOption("lastrow")) {
            splitAlgo.setLastRow(cmd.getOptionValue("lastrow"));
        }
        if (createTable) {
            conf.set("split.count", cmd.getOptionValue("c"));
            RegionSplitter.createPresplitTable(tableName, splitAlgo, cmd.getOptionValue("f").split(":"), conf);
        }
        if (rollingSplit) {
            if (cmd.hasOption("o")) {
                conf.set("split.outstanding", cmd.getOptionValue("o"));
            }
            RegionSplitter.rollingSplit(tableName, splitAlgo, conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createPresplitTable(TableName tableName, SplitAlgorithm splitAlgo, String[] columnFamilies, Configuration conf) throws IOException, InterruptedException {
        int splitCount = conf.getInt("split.count", 0);
        Preconditions.checkArgument(splitCount > 1, "Split count must be > 1");
        Preconditions.checkArgument(columnFamilies.length > 0, "Must specify at least one column family. ");
        LOG.debug("Creating table " + tableName + " with " + columnFamilies.length + " column families.  Presplitting to " + splitCount + " regions");
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder(tableName);
        for (String cf : columnFamilies) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of(cf));
        }
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            try (Admin admin = connection.getAdmin();){
                Preconditions.checkArgument(!admin.tableExists(tableName), "Table already exists: " + tableName);
                admin.createTable(builder.build(), splitAlgo.split(splitCount));
            }
            LOG.debug("Table created!  Waiting for regions to show online in META...");
            if (!conf.getBoolean("split.verify", true)) {
                int onlineRegions = 0;
                try (RegionLocator locator = connection.getRegionLocator(tableName);){
                    while (onlineRegions < splitCount) {
                        onlineRegions = locator.getAllRegionLocations().size();
                        LOG.debug(onlineRegions + " of " + splitCount + " regions online...");
                        if (onlineRegions >= splitCount) continue;
                        Thread.sleep(10000L);
                    }
                }
            }
            LOG.debug("Finished creating table with " + splitCount + " regions");
        }
    }

    private static int getRegionServerCount(Connection connection) throws IOException {
        try (Admin admin = connection.getAdmin();){
            Collection<ServerName> servers = admin.getRegionServers();
            int n = servers == null || servers.isEmpty() ? 0 : servers.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(FileSystem fs, Path path) throws IOException {
        try (FSDataInputStream tmpIn = fs.open(path);){
            byte[] rawData = new byte[tmpIn.available()];
            tmpIn.readFully(rawData);
            byte[] byArray = rawData;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rollingSplit(TableName tableName, SplitAlgorithm splitAlgo, Configuration conf) throws IOException, InterruptedException {
        int minOS = conf.getInt("split.outstanding", 2);
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            int MAX_OUTSTANDING = Math.max(RegionSplitter.getRegionServerCount(connection) / 2, minOS);
            Path hbDir = CommonFSUtils.getRootDir(conf);
            Path tableDir = CommonFSUtils.getTableDir(hbDir, tableName);
            Path splitFile = new Path(tableDir, "_balancedSplit");
            FileSystem fs = FileSystem.get((Configuration)conf);
            LinkedList<Pair<byte[], byte[]>> tmpRegionSet = null;
            try (Table table = connection.getTable(tableName);){
                tmpRegionSet = RegionSplitter.getSplits(connection, tableName, splitAlgo);
            }
            LinkedList<Pair<byte[], byte[]>> outstanding = Lists.newLinkedList();
            int splitCount = 0;
            int origCount = tmpRegionSet.size();
            LOG.debug("Bucketing regions by regionserver...");
            TreeMap daughterRegions = Maps.newTreeMap();
            try (RegionLocator regionLocator = connection.getRegionLocator(tableName);){
                for (Pair pair : tmpRegionSet) {
                    ServerName rsLocation = regionLocator.getRegionLocation((byte[])pair.getSecond()).getServerName();
                    if (!daughterRegions.containsKey(rsLocation)) {
                        LinkedList entry = Lists.newLinkedList();
                        daughterRegions.put(rsLocation, entry);
                    }
                    ((LinkedList)daughterRegions.get(rsLocation)).add(pair);
                }
                LOG.debug("Done with bucketing.  Split time!");
                long startTime = System.currentTimeMillis();
                byte[] rawData = RegionSplitter.readFile(fs, splitFile);
                FSDataOutputStream splitOut = fs.create(splitFile);
                try {
                    splitOut.write(rawData);
                    try {
                        while (!daughterRegions.isEmpty()) {
                            LOG.debug(daughterRegions.size() + " RS have regions to splt.");
                            TreeMap<ServerName, Integer> rsSizes = Maps.newTreeMap();
                            List<HRegionLocation> hrls = regionLocator.getAllRegionLocations();
                            for (HRegionLocation hRegionLocation : hrls) {
                                ServerName sn = hRegionLocation.getServerName();
                                if (rsSizes.containsKey(sn)) {
                                    rsSizes.put(sn, (Integer)rsSizes.get(sn) + 1);
                                    continue;
                                }
                                rsSizes.put(sn, 1);
                            }
                            for (Map.Entry entry : daughterRegions.entrySet()) {
                                Serializable newRs;
                                Pair dr = null;
                                ServerName rsLoc = (ServerName)entry.getKey();
                                LinkedList regionList = (LinkedList)entry.getValue();
                                LOG.debug("Finding a region on " + rsLoc);
                                while (!regionList.isEmpty()) {
                                    dr = (Pair)regionList.pop();
                                    byte[] split2 = (byte[])dr.getSecond();
                                    HRegionLocation regionLoc = regionLocator.getRegionLocation(split2);
                                    newRs = regionLoc.getServerName();
                                    if (((ServerName)newRs).compareTo(rsLoc) != 0) {
                                        LOG.debug("Region with " + splitAlgo.rowToStr(split2) + " moved to " + newRs + ". Relocating...");
                                        if (!daughterRegions.containsKey(newRs)) {
                                            LinkedList entry2 = Lists.newLinkedList();
                                            daughterRegions.put(newRs, entry2);
                                        }
                                        ((LinkedList)daughterRegions.get(newRs)).add(dr);
                                        dr = null;
                                        continue;
                                    }
                                    byte[] sk = regionLoc.getRegionInfo().getStartKey();
                                    if (sk.length == 0) break;
                                    if (Bytes.equals(split2, sk)) {
                                        LOG.debug("Region already split on " + splitAlgo.rowToStr(split2) + ".  Skipping this region...");
                                        ++splitCount;
                                        dr = null;
                                        continue;
                                    }
                                    byte[] byArray = (byte[])dr.getFirst();
                                    Preconditions.checkArgument(Bytes.equals(byArray, sk), splitAlgo.rowToStr(byArray) + " != " + splitAlgo.rowToStr(sk));
                                    break;
                                }
                                if (regionList.isEmpty()) {
                                    daughterRegions.remove(rsLoc);
                                }
                                if (dr == null) continue;
                                byte[] split2 = (byte[])dr.getSecond();
                                LOG.debug("Splitting at " + splitAlgo.rowToStr(split2));
                                Admin admin = connection.getAdmin();
                                newRs = null;
                                try {
                                    admin.split(tableName, split2);
                                }
                                catch (Throwable throwable) {
                                    newRs = throwable;
                                    throw throwable;
                                }
                                finally {
                                    if (admin != null) {
                                        if (newRs != null) {
                                            try {
                                                admin.close();
                                            }
                                            catch (Throwable throwable) {
                                                ((Throwable)newRs).addSuppressed(throwable);
                                            }
                                        } else {
                                            admin.close();
                                        }
                                    }
                                }
                                LinkedList<Object> finished = Lists.newLinkedList();
                                LinkedList<Object> local_finished = Lists.newLinkedList();
                                if (conf.getBoolean("split.verify", true)) {
                                    outstanding.addLast(dr);
                                    while (outstanding.size() >= MAX_OUTSTANDING) {
                                        LOG.debug("Wait for outstanding splits " + outstanding.size());
                                        local_finished = RegionSplitter.splitScan(outstanding, connection, tableName, splitAlgo);
                                        if (local_finished.isEmpty()) {
                                            Thread.sleep(30000L);
                                            continue;
                                        }
                                        finished.addAll(local_finished);
                                        outstanding.removeAll(local_finished);
                                        LOG.debug(local_finished.size() + " outstanding splits finished");
                                    }
                                } else {
                                    finished.add(dr);
                                }
                                for (Pair pair : finished) {
                                    splitOut.writeChars("- " + splitAlgo.rowToStr((byte[])pair.getFirst()) + " " + splitAlgo.rowToStr((byte[])pair.getSecond()) + "\n");
                                    if (++splitCount % 10 != 0) continue;
                                    long tDiff = (System.currentTimeMillis() - startTime) / (long)splitCount;
                                    LOG.debug("STATUS UPDATE: " + splitCount + " / " + origCount + ". Avg Time / Split = " + StringUtils.formatTime((long)tDiff));
                                }
                            }
                        }
                        if (conf.getBoolean("split.verify", true)) {
                            while (!outstanding.isEmpty()) {
                                LOG.debug("Finally Wait for outstanding splits " + outstanding.size());
                                LinkedList<Pair<byte[], byte[]>> finished = RegionSplitter.splitScan(outstanding, connection, tableName, splitAlgo);
                                if (finished.isEmpty()) {
                                    Thread.sleep(30000L);
                                    continue;
                                }
                                outstanding.removeAll(finished);
                                for (Pair pair : finished) {
                                    splitOut.writeChars("- " + splitAlgo.rowToStr((byte[])pair.getFirst()) + " " + splitAlgo.rowToStr((byte[])pair.getSecond()) + "\n");
                                    ++splitCount;
                                }
                                LOG.debug("Finally " + finished.size() + " outstanding splits finished");
                            }
                        }
                        LOG.debug("All regions have been successfully split!");
                    }
                    finally {
                        long tDiff = System.currentTimeMillis() - startTime;
                        LOG.debug("TOTAL TIME = " + StringUtils.formatTime((long)tDiff));
                        LOG.debug("Splits = " + splitCount);
                        if (0 < splitCount) {
                            LOG.debug("Avg Time / Split = " + StringUtils.formatTime((long)(tDiff / (long)splitCount)));
                        }
                    }
                }
                finally {
                    splitOut.close();
                    fs.delete(splitFile, false);
                }
            }
        }
    }

    public static SplitAlgorithm newSplitAlgoInstance(Configuration conf, String splitClassName) throws IOException {
        Class splitClass;
        if (splitClassName.equals(HexStringSplit.class.getSimpleName())) {
            splitClass = HexStringSplit.class;
        } else if (splitClassName.equals(DecimalStringSplit.class.getSimpleName())) {
            splitClass = DecimalStringSplit.class;
        } else if (splitClassName.equals(UniformSplit.class.getSimpleName())) {
            splitClass = UniformSplit.class;
        } else {
            try {
                splitClass = conf.getClassByName(splitClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Couldn't load split class " + splitClassName, e);
            }
            if (splitClass == null) {
                throw new IOException("Failed loading split class " + splitClassName);
            }
            if (!SplitAlgorithm.class.isAssignableFrom(splitClass)) {
                throw new IOException("Specified split class doesn't implement SplitAlgorithm");
            }
        }
        try {
            return splitClass.asSubclass(SplitAlgorithm.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("Problem loading split algorithm: ", e);
        }
    }

    static LinkedList<Pair<byte[], byte[]>> splitScan(LinkedList<Pair<byte[], byte[]>> regionList, Connection connection, TableName tableName, SplitAlgorithm splitAlgo) throws IOException, InterruptedException {
        LinkedList<Pair> finished = Lists.newLinkedList();
        LinkedList<Pair> logicalSplitting = Lists.newLinkedList();
        LinkedList<Pair> physicalSplitting = Lists.newLinkedList();
        Pair<Path, Path> tableDirAndSplitFile = RegionSplitter.getTableDirAndSplitFile(connection.getConfiguration(), tableName);
        Path tableDir = tableDirAndSplitFile.getFirst();
        FileSystem fs = tableDir.getFileSystem(connection.getConfiguration());
        ((ClusterConnection)connection).clearRegionLocationCache();
        TableDescriptor htd = null;
        try (Table table = connection.getTable(tableName);){
            htd = table.getDescriptor();
        }
        var12_12 = null;
        try (RegionLocator regionLocator = connection.getRegionLocator(tableName);){
            for (Pair pair : regionList) {
                byte[] split2;
                byte[] start2;
                block35: {
                    start2 = (byte[])pair.getFirst();
                    split2 = (byte[])pair.getSecond();
                    try {
                        HRegionInfo dri = regionLocator.getRegionLocation(split2).getRegionInfo();
                        if (dri.isOffline() || !Bytes.equals(dri.getStartKey(), split2)) {
                            logicalSplitting.add(pair);
                        }
                        break block35;
                    }
                    catch (NoServerForRegionException nsfre) {
                        LOG.info(nsfre.toString(), (Throwable)nsfre);
                        logicalSplitting.add(pair);
                    }
                    continue;
                }
                try {
                    LinkedList<HRegionInfo> check2 = Lists.newLinkedList();
                    check2.add(regionLocator.getRegionLocation(start2).getRegionInfo());
                    check2.add(regionLocator.getRegionLocation(split2).getRegionInfo());
                    for (HRegionInfo hri : check2.toArray(new HRegionInfo[check2.size()])) {
                        ColumnFamilyDescriptor c;
                        byte[] sk = hri.getStartKey();
                        if (sk.length == 0) {
                            sk = splitAlgo.firstRow();
                        }
                        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(connection.getConfiguration(), fs, tableDir, hri, true);
                        boolean refFound = false;
                        ColumnFamilyDescriptor[] columnFamilyDescriptorArray = htd.getColumnFamilies();
                        int n = columnFamilyDescriptorArray.length;
                        for (int i = 0; i < n && !(refFound = regionFs.hasReferences((c = columnFamilyDescriptorArray[i]).getNameAsString())); ++i) {
                        }
                        if (refFound) continue;
                        check2.remove(hri);
                    }
                    if (check2.isEmpty()) {
                        finished.add(pair);
                        continue;
                    }
                    physicalSplitting.add(pair);
                }
                catch (NoServerForRegionException nsfre) {
                    LOG.debug("No Server Exception thrown for: " + splitAlgo.rowToStr(start2));
                    physicalSplitting.add(pair);
                    ((ClusterConnection)connection).clearRegionLocationCache();
                }
            }
            LOG.debug("Split Scan: " + finished.size() + " finished / " + logicalSplitting.size() + " split wait / " + physicalSplitting.size() + " reference wait");
            LinkedList<Pair> linkedList = finished;
            return linkedList;
        }
        catch (Throwable throwable) {
            var12_12 = throwable;
            throw throwable;
        }
    }

    private static Pair<Path, Path> getTableDirAndSplitFile(Configuration conf, TableName tableName) throws IOException {
        Path hbDir = CommonFSUtils.getRootDir(conf);
        Path tableDir = CommonFSUtils.getTableDir(hbDir, tableName);
        Path splitFile = new Path(tableDir, "_balancedSplit");
        return new Pair<Path, Path>(tableDir, splitFile);
    }

    /*
     * WARNING - void declaration
     */
    static LinkedList<Pair<byte[], byte[]>> getSplits(Connection connection, TableName tableName, SplitAlgorithm splitAlgo) throws IOException {
        Pair<Path, Path> tableDirAndSplitFile = RegionSplitter.getTableDirAndSplitFile(connection.getConfiguration(), tableName);
        Path tableDir = tableDirAndSplitFile.getFirst();
        Path splitFile = tableDirAndSplitFile.getSecond();
        FileSystem fs = tableDir.getFileSystem(connection.getConfiguration());
        HashSet<Pair<String, String>> daughterRegions = Sets.newHashSet();
        if (!fs.exists(splitFile)) {
            void var10_12;
            LOG.debug("No " + splitFile.getName() + " file. Calculating splits ");
            HashSet<Pair<byte[], byte[]>> rows = Sets.newHashSet();
            Pair<byte[][], byte[][]> tmp = null;
            try (RegionLocator regionLocator = connection.getRegionLocator(tableName);){
                tmp = regionLocator.getStartEndKeys();
            }
            Preconditions.checkArgument(tmp.getFirst().length == tmp.getSecond().length, "Start and End rows should be equivalent");
            boolean bl = false;
            while (var10_12 < tmp.getFirst().length) {
                byte[] start2 = tmp.getFirst()[var10_12];
                byte[] end = tmp.getSecond()[var10_12];
                if (start2.length == 0) {
                    start2 = splitAlgo.firstRow();
                }
                if (end.length == 0) {
                    end = splitAlgo.lastRow();
                }
                rows.add(Pair.newPair(start2, end));
                ++var10_12;
            }
            LOG.debug("Table " + tableName + " has " + rows.size() + " regions that will be split.");
            Path path = new Path(tableDir, "_balancedSplit_prepare");
            FSDataOutputStream tmpOut = fs.create(path);
            for (Pair pair : rows) {
                byte[] splitPoint = splitAlgo.split((byte[])pair.getFirst(), (byte[])pair.getSecond());
                String startStr = splitAlgo.rowToStr((byte[])pair.getFirst());
                String splitStr = splitAlgo.rowToStr(splitPoint);
                daughterRegions.add(Pair.newPair(startStr, splitStr));
                LOG.debug("Will Split [" + startStr + " , " + splitAlgo.rowToStr((byte[])pair.getSecond()) + ") at " + splitStr);
                tmpOut.writeChars("+ " + startStr + splitAlgo.separator() + splitStr + "\n");
            }
            tmpOut.close();
            fs.rename(path, splitFile);
        } else {
            LOG.debug("_balancedSplit file found. Replay log to restore state...");
            RecoverLeaseFSUtils.recoverFileLease((FileSystem)fs, (Path)splitFile, (Configuration)connection.getConfiguration(), null);
            FSDataInputStream tmpIn = fs.open(splitFile);
            StringBuilder sb = new StringBuilder(tmpIn.available());
            while (tmpIn.available() > 0) {
                sb.append(tmpIn.readChar());
            }
            tmpIn.close();
            for (String string : sb.toString().split("\n")) {
                String[] cmd = string.split(splitAlgo.separator());
                Preconditions.checkArgument(3 == cmd.length);
                byte[] start3 = splitAlgo.strToRow(cmd[1]);
                String startStr = splitAlgo.rowToStr(start3);
                byte[] splitPoint = splitAlgo.strToRow(cmd[2]);
                String splitStr = splitAlgo.rowToStr(splitPoint);
                Pair<String, String> r = Pair.newPair(startStr, splitStr);
                if (cmd[0].equals("+")) {
                    LOG.debug("Adding: " + r);
                    daughterRegions.add(r);
                    continue;
                }
                LOG.debug("Removing: " + r);
                Preconditions.checkArgument(cmd[0].equals("-"), "Unknown option: " + cmd[0]);
                Preconditions.checkState(daughterRegions.contains(r), "Missing row: " + r);
                daughterRegions.remove(r);
            }
            LOG.debug("Done reading. " + daughterRegions.size() + " regions left.");
        }
        LinkedList<Pair<byte[], byte[]>> ret = Lists.newLinkedList();
        for (Pair pair : daughterRegions) {
            ret.add(Pair.newPair(splitAlgo.strToRow((String)pair.getFirst()), splitAlgo.strToRow((String)pair.getSecond())));
        }
        return ret;
    }

    public static class UniformSplit
    implements SplitAlgorithm {
        static final byte xFF = -1;
        byte[] firstRowBytes = ArrayUtils.EMPTY_BYTE_ARRAY;
        byte[] lastRowBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};

        @Override
        public byte[] split(byte[] start2, byte[] end) {
            return Bytes.split(start2, end, 1)[1];
        }

        @Override
        public byte[][] split(int numRegions) {
            Preconditions.checkArgument(Bytes.compareTo(this.lastRowBytes, this.firstRowBytes) > 0, "last row (%s) is configured less than first row (%s)", (Object)Bytes.toStringBinary(this.lastRowBytes), (Object)Bytes.toStringBinary(this.firstRowBytes));
            byte[][] splits = Bytes.split(this.firstRowBytes, this.lastRowBytes, true, numRegions - 1);
            Preconditions.checkState(splits != null, "Could not split region with given user input: " + this);
            return splits == null ? (byte[][])null : (byte[][])Arrays.copyOfRange(splits, 1, splits.length - 1);
        }

        @Override
        public byte[][] split(byte[] start2, byte[] end, int numSplits, boolean inclusive) {
            if (Arrays.equals(start2, HConstants.EMPTY_BYTE_ARRAY)) {
                start2 = this.firstRowBytes;
            }
            if (Arrays.equals(end, HConstants.EMPTY_BYTE_ARRAY)) {
                end = this.lastRowBytes;
            }
            Preconditions.checkArgument(Bytes.compareTo(end, start2) > 0, "last row (%s) is configured less than first row (%s)", (Object)Bytes.toStringBinary(end), (Object)Bytes.toStringBinary(start2));
            byte[][] splits = Bytes.split(start2, end, true, numSplits - 1);
            Preconditions.checkState(splits != null, "Could not calculate input splits with given user input: " + this);
            if (inclusive) {
                return splits;
            }
            return (byte[][])Arrays.copyOfRange(splits, 1, splits.length - 1);
        }

        @Override
        public byte[] firstRow() {
            return this.firstRowBytes;
        }

        @Override
        public byte[] lastRow() {
            return this.lastRowBytes;
        }

        @Override
        public void setFirstRow(String userInput) {
            this.firstRowBytes = Bytes.toBytesBinary(userInput);
        }

        @Override
        public void setLastRow(String userInput) {
            this.lastRowBytes = Bytes.toBytesBinary(userInput);
        }

        @Override
        public void setFirstRow(byte[] userInput) {
            this.firstRowBytes = userInput;
        }

        @Override
        public void setLastRow(byte[] userInput) {
            this.lastRowBytes = userInput;
        }

        @Override
        public byte[] strToRow(String input) {
            return Bytes.toBytesBinary(input);
        }

        @Override
        public String rowToStr(byte[] row) {
            return Bytes.toStringBinary(row);
        }

        @Override
        public String separator() {
            return ",";
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + this.rowToStr(this.firstRow()) + "," + this.rowToStr(this.lastRow()) + "]";
        }
    }

    public static abstract class NumberStringSplit
    implements SplitAlgorithm {
        String firstRow;
        BigInteger firstRowInt;
        String lastRow;
        BigInteger lastRowInt;
        int rowComparisonLength;
        int radix;

        NumberStringSplit(String minRow, String maxRow, int radix) {
            this.firstRow = minRow;
            this.lastRow = maxRow;
            this.radix = radix;
            this.firstRowInt = BigInteger.ZERO;
            this.lastRowInt = new BigInteger(this.lastRow, this.radix);
            this.rowComparisonLength = this.lastRow.length();
        }

        @Override
        public byte[] split(byte[] start2, byte[] end) {
            BigInteger s = this.convertToBigInteger(start2);
            BigInteger e = this.convertToBigInteger(end);
            Preconditions.checkArgument(!e.equals(BigInteger.ZERO));
            return this.convertToByte(this.split2(s, e));
        }

        @Override
        public byte[][] split(int n) {
            Preconditions.checkArgument(this.lastRowInt.compareTo(this.firstRowInt) > 0, "last row (%s) is configured less than first row (%s)", (Object)this.lastRow, (Object)this.firstRow);
            BigInteger range = this.lastRowInt.subtract(this.firstRowInt).add(BigInteger.ONE);
            Preconditions.checkState(range.compareTo(BigInteger.valueOf(n)) >= 0, "split granularity (%s) is greater than the range (%s)", n, (Object)range);
            BigInteger[] splits = new BigInteger[n - 1];
            BigInteger sizeOfEachSplit = range.divide(BigInteger.valueOf(n));
            for (int i = 1; i < n; ++i) {
                splits[i - 1] = this.firstRowInt.add(sizeOfEachSplit.multiply(BigInteger.valueOf(i)));
            }
            return this.convertToBytes(splits);
        }

        @Override
        public byte[][] split(byte[] start2, byte[] end, int numSplits, boolean inclusive) {
            BigInteger s = this.convertToBigInteger(start2);
            BigInteger e = this.convertToBigInteger(end);
            Preconditions.checkArgument(e.compareTo(s) > 0, "last row (%s) is configured less than first row (%s)", (Object)this.rowToStr(end), (Object)end);
            BigInteger range = e.subtract(s).add(BigInteger.ONE);
            Preconditions.checkState(range.compareTo(BigInteger.valueOf(numSplits)) >= 0, "split granularity (%s) is greater than the range (%s)", numSplits, (Object)range);
            BigInteger[] splits = new BigInteger[numSplits - 1];
            BigInteger sizeOfEachSplit = range.divide(BigInteger.valueOf(numSplits));
            for (int i = 1; i < numSplits; ++i) {
                splits[i - 1] = s.add(sizeOfEachSplit.multiply(BigInteger.valueOf(i)));
            }
            if (inclusive) {
                BigInteger[] inclusiveSplitPoints = new BigInteger[numSplits + 1];
                inclusiveSplitPoints[0] = this.convertToBigInteger(start2);
                inclusiveSplitPoints[numSplits] = this.convertToBigInteger(end);
                System.arraycopy(splits, 0, inclusiveSplitPoints, 1, splits.length);
                return this.convertToBytes(inclusiveSplitPoints);
            }
            return this.convertToBytes(splits);
        }

        @Override
        public byte[] firstRow() {
            return this.convertToByte(this.firstRowInt);
        }

        @Override
        public byte[] lastRow() {
            return this.convertToByte(this.lastRowInt);
        }

        @Override
        public void setFirstRow(String userInput) {
            this.firstRow = userInput;
            this.firstRowInt = new BigInteger(this.firstRow, this.radix);
        }

        @Override
        public void setLastRow(String userInput) {
            this.lastRow = userInput;
            this.lastRowInt = new BigInteger(this.lastRow, this.radix);
            this.rowComparisonLength = this.lastRow.length();
        }

        @Override
        public byte[] strToRow(String in) {
            return this.convertToByte(new BigInteger(in, this.radix));
        }

        @Override
        public String rowToStr(byte[] row) {
            return Bytes.toStringBinary(row);
        }

        @Override
        public String separator() {
            return " ";
        }

        @Override
        public void setFirstRow(byte[] userInput) {
            this.firstRow = Bytes.toString(userInput);
        }

        @Override
        public void setLastRow(byte[] userInput) {
            this.lastRow = Bytes.toString(userInput);
        }

        public BigInteger split2(BigInteger a, BigInteger b) {
            return a.add(b).divide(BigInteger.valueOf(2L)).abs();
        }

        public byte[][] convertToBytes(BigInteger[] bigIntegers) {
            byte[][] returnBytes = new byte[bigIntegers.length][];
            for (int i = 0; i < bigIntegers.length; ++i) {
                returnBytes[i] = this.convertToByte(bigIntegers[i]);
            }
            return returnBytes;
        }

        public byte[] convertToByte(BigInteger bigInteger, int pad) {
            String bigIntegerString = bigInteger.toString(this.radix);
            bigIntegerString = org.apache.commons.lang3.StringUtils.leftPad((String)bigIntegerString, (int)pad, (char)'0');
            return Bytes.toBytes(bigIntegerString);
        }

        public byte[] convertToByte(BigInteger bigInteger) {
            return this.convertToByte(bigInteger, this.rowComparisonLength);
        }

        public BigInteger convertToBigInteger(byte[] row) {
            return row.length > 0 ? new BigInteger(Bytes.toString(row), this.radix) : BigInteger.ZERO;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + this.rowToStr(this.firstRow()) + "," + this.rowToStr(this.lastRow()) + "]";
        }
    }

    public static class DecimalStringSplit
    extends NumberStringSplit {
        static final String DEFAULT_MIN_DEC = "00000000";
        static final String DEFAULT_MAX_DEC = "99999999";
        static final int RADIX_DEC = 10;

        public DecimalStringSplit() {
            super(DEFAULT_MIN_DEC, DEFAULT_MAX_DEC, 10);
        }
    }

    public static class HexStringSplit
    extends NumberStringSplit {
        static final String DEFAULT_MIN_HEX = "00000000";
        static final String DEFAULT_MAX_HEX = "FFFFFFFF";
        static final int RADIX_HEX = 16;

        public HexStringSplit() {
            super(DEFAULT_MIN_HEX, DEFAULT_MAX_HEX, 16);
        }
    }

    public static interface SplitAlgorithm {
        public byte[] split(byte[] var1, byte[] var2);

        public byte[][] split(int var1);

        public byte[][] split(byte[] var1, byte[] var2, int var3, boolean var4);

        public byte[] firstRow();

        public byte[] lastRow();

        public void setFirstRow(String var1);

        public void setLastRow(String var1);

        public byte[] strToRow(String var1);

        public String rowToStr(byte[] var1);

        public String separator();

        public void setFirstRow(byte[] var1);

        public void setLastRow(byte[] var1);
    }
}

