/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.primitives;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.annotations.Beta;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.annotations.GwtCompatible;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.primitives.Ints;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.primitives.ParseRequest;

@Beta
@GwtCompatible
public final class UnsignedInts {
    static final long INT_MASK = 0xFFFFFFFFL;

    private UnsignedInts() {
    }

    static int flip(int value) {
        return value ^ Integer.MIN_VALUE;
    }

    public static int compare(int a, int b) {
        return Ints.compare(UnsignedInts.flip(a), UnsignedInts.flip(b));
    }

    public static long toLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static int checkedCast(long value) {
        Preconditions.checkArgument(value >> 32 == 0L, "out of range: %s", value);
        return (int)value;
    }

    public static int saturatedCast(long value) {
        if (value <= 0L) {
            return 0;
        }
        if (value >= 0x100000000L) {
            return -1;
        }
        return (int)value;
    }

    public static int min(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int min = UnsignedInts.flip(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next = UnsignedInts.flip(array2[i]);
            if (next >= min) continue;
            min = next;
        }
        return UnsignedInts.flip(min);
    }

    public static int max(int ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        int max = UnsignedInts.flip(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            int next = UnsignedInts.flip(array2[i]);
            if (next <= max) continue;
            max = next;
        }
        return UnsignedInts.flip(max);
    }

    public static String join(String separator, int ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 5);
        builder.append(UnsignedInts.toString(array2[0]));
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(UnsignedInts.toString(array2[i]));
        }
        return builder.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(int[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedInts.sort(array2, 0, array2.length);
    }

    public static void sort(int[] array2, int fromIndex, int toIndex) {
        int i;
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        for (i = fromIndex; i < toIndex; ++i) {
            array2[i] = UnsignedInts.flip(array2[i]);
        }
        Arrays.sort(array2, fromIndex, toIndex);
        for (i = fromIndex; i < toIndex; ++i) {
            array2[i] = UnsignedInts.flip(array2[i]);
        }
    }

    public static void sortDescending(int[] array2) {
        Preconditions.checkNotNull(array2);
        UnsignedInts.sortDescending(array2, 0, array2.length);
    }

    public static void sortDescending(int[] array2, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array2);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array2.length);
        int i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array2[n] = array2[n] ^ Integer.MAX_VALUE;
        }
        Arrays.sort(array2, fromIndex, toIndex);
        i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array2[n] = array2[n] ^ Integer.MAX_VALUE;
        }
    }

    public static int divide(int dividend, int divisor) {
        return (int)(UnsignedInts.toLong(dividend) / UnsignedInts.toLong(divisor));
    }

    public static int remainder(int dividend, int divisor) {
        return (int)(UnsignedInts.toLong(dividend) % UnsignedInts.toLong(divisor));
    }

    @CanIgnoreReturnValue
    public static int decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedInts.parseUnsignedInt(request.rawValue, request.radix);
        }
        catch (NumberFormatException e) {
            String string = String.valueOf(stringValue);
            NumberFormatException decodeException = new NumberFormatException(string.length() != 0 ? "Error parsing value: ".concat(string) : new String("Error parsing value: "));
            decodeException.initCause(e);
            throw decodeException;
        }
    }

    @CanIgnoreReturnValue
    public static int parseUnsignedInt(String s) {
        return UnsignedInts.parseUnsignedInt(s, 10);
    }

    @CanIgnoreReturnValue
    public static int parseUnsignedInt(String string, int radix) {
        Preconditions.checkNotNull(string);
        long result = Long.parseLong(string, radix);
        if ((result & 0xFFFFFFFFL) != result) {
            throw new NumberFormatException(new StringBuilder(69 + String.valueOf(string).length()).append("Input ").append(string).append(" in base ").append(radix).append(" is not in the range of an unsigned integer").toString());
        }
        return (int)result;
    }

    public static String toString(int x) {
        return UnsignedInts.toString(x, 10);
    }

    public static String toString(int x, int radix) {
        long asLong = (long)x & 0xFFFFFFFFL;
        return Long.toString(asLong, radix);
    }

    static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] left, int[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                if (left[i] == right[i]) continue;
                return UnsignedInts.compare(left[i], right[i]);
            }
            return left.length - right.length;
        }

        public String toString() {
            return "UnsignedInts.lexicographicalComparator()";
        }
    }
}

