/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ExtensionRegistryLite;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Internal;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ManifestSchemaFactory;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.MessageSchema;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Reader;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Schema;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.SchemaFactory;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Writer;

final class Protobuf {
    private static final Protobuf INSTANCE = new Protobuf();
    private final SchemaFactory schemaFactory;
    private final ConcurrentMap<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    public static Protobuf getInstance() {
        return INSTANCE;
    }

    public <T> void writeTo(T message, Writer writer) throws IOException {
        this.schemaFor(message).writeTo(message, writer);
    }

    public <T> void mergeFrom(T message, Reader reader) throws IOException {
        this.mergeFrom(message, reader, ExtensionRegistryLite.getEmptyRegistry());
    }

    public <T> void mergeFrom(T message, Reader reader, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.schemaFor(message).mergeFrom(message, reader, extensionRegistry);
    }

    public <T> void makeImmutable(T message) {
        this.schemaFor(message).makeImmutable(message);
    }

    <T> boolean isInitialized(T message) {
        return this.schemaFor(message).isInitialized(message);
    }

    public <T> Schema<T> schemaFor(Class<T> messageType) {
        Schema<?> previous;
        Internal.checkNotNull(messageType, "messageType");
        Schema<Object> schema2 = (Schema<T>)this.schemaCache.get(messageType);
        if (schema2 == null && (previous = this.registerSchema(messageType, schema2 = this.schemaFactory.createSchema(messageType))) != null) {
            schema2 = previous;
        }
        return schema2;
    }

    public <T> Schema<T> schemaFor(T message) {
        return this.schemaFor((T)message.getClass());
    }

    public Schema<?> registerSchema(Class<?> messageType, Schema<?> schema2) {
        Internal.checkNotNull(messageType, "messageType");
        Internal.checkNotNull(schema2, "schema");
        return this.schemaCache.putIfAbsent(messageType, schema2);
    }

    public Schema<?> registerSchemaOverride(Class<?> messageType, Schema<?> schema2) {
        Internal.checkNotNull(messageType, "messageType");
        Internal.checkNotNull(schema2, "schema");
        return this.schemaCache.put(messageType, schema2);
    }

    private Protobuf() {
        this.schemaFactory = new ManifestSchemaFactory();
    }

    int getTotalSchemaSize() {
        int result = 0;
        for (Schema schema2 : this.schemaCache.values()) {
            if (!(schema2 instanceof MessageSchema)) continue;
            result += ((MessageSchema)schema2).getSchemaSize();
        }
        return result;
    }
}

