/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.metadata.HoodieTableMetadata;

public class HoodieDataTableUtils {
    static List<Path> getBaseAndLogFilePathsFromFileSystem(HoodieTableMetadata tableMetadata, String basePath) throws IOException {
        List<String> allPartitionPaths = tableMetadata.getAllPartitionPaths().stream().map(partitionPath -> FSUtils.getPartitionPath(basePath, partitionPath).toString()).collect(Collectors.toList());
        return tableMetadata.getAllFilesInPartitions(allPartitionPaths).values().stream().map(fileStatuses -> Arrays.stream(fileStatuses).map(fileStatus -> fileStatus.getPath()).collect(Collectors.toList())).flatMap(list -> list.stream()).collect(Collectors.toList());
    }
}

