/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.transform;

import java.util.UUID;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.transform.Transformer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class FlatteningTransformer
implements Transformer {
    private static final String TMP_TABLE = "HUDI_SRC_TMP_TABLE_";
    private static final Logger LOG = LogManager.getLogger(FlatteningTransformer.class);

    @Override
    public Dataset<Row> apply(JavaSparkContext jsc, SparkSession sparkSession, Dataset<Row> rowDataset, TypedProperties properties) {
        String tmpTable = TMP_TABLE.concat(UUID.randomUUID().toString().replace("-", "_"));
        LOG.info((Object)("Registering tmp table : " + tmpTable));
        rowDataset.createOrReplaceTempView(tmpTable);
        Dataset transformed = sparkSession.sql("select " + this.flattenSchema(rowDataset.schema(), null) + " from " + tmpTable);
        sparkSession.catalog().dropTempView(tmpTable);
        return transformed;
    }

    public String flattenSchema(StructType schema2, String prefix) {
        StringBuilder selectSQLQuery = new StringBuilder();
        for (StructField field : schema2.fields()) {
            String colName;
            String fieldName = field.name();
            String string = colName = prefix == null ? fieldName : prefix + "." + fieldName;
            if (field.dataType().getClass().equals(StructType.class)) {
                selectSQLQuery.append(this.flattenSchema((StructType)field.dataType(), colName));
            } else {
                selectSQLQuery.append(colName);
                selectSQLQuery.append(" as ");
                selectSQLQuery.append(colName.replace(".", "_"));
            }
            selectSQLQuery.append(",");
        }
        if (selectSQLQuery.length() > 0) {
            selectSQLQuery.deleteCharAt(selectSQLQuery.length() - 1);
        }
        return selectSQLQuery.toString();
    }
}

