/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.hudi.DeDupeType$;
import org.apache.spark.sql.hudi.DedupeSparkJob$;
import org.apache.spark.sql.hudi.SparkHelper;
import org.apache.spark.sql.hudi.SparkHelpers$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u00015\u0011a\u0002R3ekB,7\u000b]1sW*{'M\u0003\u0002\u0004\t\u0005!\u0001.\u001e3j\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005A!-Y:f!\u0006$\b\u000e\u0005\u0002\u001859\u0011q\u0002G\u0005\u00033A\ta\u0001\u0015:fI\u00164\u0017BA\u000e\u001d\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0004\u0005\u0005\t=\u0001\u0011\t\u0011)A\u0005-\u00059B-\u001e9mS\u000e\fG/\u001a3QCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b\u0005\tA\u0001\u0011\t\u0011)A\u0005-\u0005\u0001\"/\u001a9bSJ|U\u000f\u001e9viB\u000bG\u000f\u001b\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005Q1/\u001d7D_:$X\r\u001f;\u0011\u0005\u0011*S\"\u0001\u0003\n\u0005\u0019\"!AC*R\u0019\u000e{g\u000e^3yi\"A\u0001\u0006\u0001B\u0001B\u0003%\u0011&\u0001\u0002ggB\u0011!FL\u0007\u0002W)\u0011\u0001\u0006\f\u0006\u0003[!\ta\u0001[1e_>\u0004\u0018BA\u0018,\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005QA-\u001a3va\u0016$\u0016\u0010]3\u0011\u0005M:dB\u0001\u001b6\u001b\u0005\u0011\u0011B\u0001\u001c\u0003\u0003)!U\rR;qKRK\b/Z\u0005\u0003qe\u0012QAV1mk\u0016L!A\u000f\t\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0005\u0006y\u0001!\t!P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fyz\u0004)\u0011\"D\tB\u0011A\u0007\u0001\u0005\u0006+m\u0002\rA\u0006\u0005\u0006=m\u0002\rA\u0006\u0005\u0006Am\u0002\rA\u0006\u0005\u0006Em\u0002\ra\t\u0005\u0006Qm\u0002\r!\u000b\u0005\u0006cm\u0002\rA\r\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0003-\u0019\b/\u0019:l\u0011\u0016d\u0007/\u001a:\u0016\u0003!\u0003\"\u0001N%\n\u0005)\u0013!aC*qCJ\\\u0007*\u001a7qKJDa\u0001\u0014\u0001!\u0002\u0013A\u0015\u0001D:qCJ\\\u0007*\u001a7qKJ\u0004\u0003b\u0002(\u0001\u0005\u0004%\taT\u0001\u0004\u0019>;U#\u0001)\u0011\u0005E#V\"\u0001*\u000b\u0005MC\u0011!\u00027pORR\u0017BA+S\u0005\u0019aunZ4fe\"1q\u000b\u0001Q\u0001\nA\u000bA\u0001T(HA!)\u0011\f\u0001C\u00015\u0006aq-\u001a;EkB,7*Z=E\rR\u00111,\u001c\t\u00039*t!!\u00185\u000f\u0005y;gBA0g\u001d\t\u0001WM\u0004\u0002bI6\t!M\u0003\u0002d\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA5\u0005\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001b7\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA5\u0005\u0011\u0015q\u0007\f1\u0001\u0017\u0003\u001d!(\r\u001c(b[\u0016DQ\u0001\u001d\u0001\u0005\nE\f\u0001\u0003\u001d7b]\u0012+\b\u000f\\5dCR,g)\u001b=\u0015\u0003I\u0004Ba\u001d=\u0017u6\tAO\u0003\u0002vm\u00069Q.\u001e;bE2,'BA<\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003sR\u0014q\u0001S1tQ6\u000b\u0007\u000fE\u0002twZI!\u0001 ;\u0003\u000f!\u000b7\u000f[*fi\")a\u0010\u0001C\u0005\u007f\u0006iq-\u001a;EK\u0012,\b/\u001a)mC:$2A]A\u0001\u0011\u001d\t\u0019! a\u0001\u0003\u000b\tq\u0001Z;qK6\u000b\u0007\u000f\u0005\u0004\u0018\u0003\u000f1\u00121B\u0005\u0004\u0003\u0013a\"aA'baB)1/!\u0004\u0002\u0012%\u0019\u0011q\u0002;\u0003\r\t+hMZ3s!\r!\u00131C\u0005\u0004\u0003+!!a\u0001*po\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0011!\u00044jq\u0012+\b\u000f\\5dCR,7\u000f\u0006\u0003\u0002\u001e\u0005\r\u0002cA\b\u0002 %\u0019\u0011\u0011\u0005\t\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003K\t9\u0002%AA\u0002\u0005\u001d\u0012A\u00023ssJ+h\u000eE\u0002\u0010\u0003SI1!a\u000b\u0011\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\f\u0001#\u0003%\t!!\r\u0002/\u0019L\u0007\u0010R;qY&\u001c\u0017\r^3tI\u0011,g-Y;mi\u0012\nTCAA\u001aU\u0011\t9#!\u000e,\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0011\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\nYDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DedupeSparkJob {
    public final String org$apache$spark$sql$hudi$DedupeSparkJob$$basePath;
    public final String org$apache$spark$sql$hudi$DedupeSparkJob$$duplicatedPartitionPath;
    public final String org$apache$spark$sql$hudi$DedupeSparkJob$$repairOutputPath;
    private final SQLContext sqlContext;
    public final FileSystem org$apache$spark$sql$hudi$DedupeSparkJob$$fs;
    public final Enumeration.Value org$apache$spark$sql$hudi$DedupeSparkJob$$dedupeType;
    private final SparkHelper sparkHelper;
    private final Logger LOG;

    public SparkHelper sparkHelper() {
        return this.sparkHelper;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public Dataset<Row> getDupeKeyDF(String tblName) {
        String dupeSql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      select  `", "` as dupe_key,\n      count(*) as dupe_cnt\n      from ", "\n      group by `", "`\n      having dupe_cnt > 1\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"_hoodie_record_key", tblName, "_hoodie_record_key"}));
        return this.sqlContext.sql(dupeSql);
    }

    private HashMap<String, HashSet<String>> planDuplicateFix() {
        String tmpTableName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"htbl_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.currentTimeMillis())}));
        String dedupeTblName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_dupeKeys"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpTableName}));
        HoodieTableMetaClient metadata = HoodieTableMetaClient.builder().setConf(this.org$apache$spark$sql$hudi$DedupeSparkJob$$fs.getConf()).setBasePath(this.org$apache$spark$sql$hudi$DedupeSparkJob$$basePath).build();
        FileStatus[] allFiles2 = this.org$apache$spark$sql$hudi$DedupeSparkJob$$fs.listStatus(new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$hudi$DedupeSparkJob$$basePath, this.org$apache$spark$sql$hudi$DedupeSparkJob$$duplicatedPartitionPath}))));
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metadata, metadata.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), allFiles2);
        java.util.List latestFiles = fsView.getLatestBaseFiles().collect(Collectors.toList());
        Buffer filteredStatuses = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(latestFiles).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(HoodieBaseFile f) {
                return f.getPath();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        this.LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" List of files under partition: ", " =>  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxedUnit.UNIT, filteredStatuses.mkString(" ")})));
        Dataset df = this.sqlContext.parquetFile((Seq)filteredStatuses);
        df.registerTempTable(tmpTableName);
        Dataset<Row> dupeKeyDF = this.getDupeKeyDF(tmpTableName);
        dupeKeyDF.registerTempTable(dedupeTblName);
        String dupeDataSql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        SELECT `_hoodie_record_key`, `_hoodie_partition_path`, `_hoodie_file_name`, `_hoodie_commit_time`\n        FROM ", " h\n        JOIN ", " d\n        ON h.`_hoodie_record_key` = d.dupe_key\n                      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpTableName, dedupeTblName}));
        Map dupeMap = JavaConversions$.MODULE$.asScalaBuffer(this.sqlContext.sql(dupeDataSql).collectAsList()).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row r) {
                return r.getString(0);
            }
        });
        return this.getDedupePlan((Map<String, Buffer<Row>>)dupeMap);
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, HashSet<String>> getDedupePlan(Map<String, Buffer<Row>> dupeMap) {
        void var2_2;
        HashMap fileToDeleteKeyMap = new HashMap();
        dupeMap.foreach((Function1)new Serializable(this, fileToDeleteKeyMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DedupeSparkJob $outer;
            public final HashMap fileToDeleteKeyMap$1;

            public final void apply(Tuple2<String, Buffer<Row>> rt) {
                Tuple2<String, Buffer<Row>> tuple2;
                block2: {
                    block6: {
                        block4: {
                            Enumeration.Value value;
                            Buffer rows;
                            String key;
                            block5: {
                                block3: {
                                    Tuple2 tuple22;
                                    tuple2 = rt;
                                    if (tuple2 == null) break block2;
                                    String key2 = (String)tuple2._1();
                                    Buffer rows2 = (Buffer)tuple2._2();
                                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)key2, (Object)rows2);
                                    key = (String)tuple23._1();
                                    rows = (Buffer)tuple23._2();
                                    value = this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$dedupeType;
                                    Enumeration.Value value2 = DeDupeType$.MODULE$.UPDATE_TYPE();
                                    Enumeration.Value value3 = value;
                                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block3;
                                    ((IterableLike)rows.init()).foreach((Function1)new Serializable(this, key){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$getDedupePlan$1 $outer;
                                        private final String key$1;

                                        public final boolean apply(Row r) {
                                            String f = ((String)r.apply(2)).split("_")[0];
                                            if (!this.$outer.fileToDeleteKeyMap$1.contains((Object)f)) {
                                                this.$outer.fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                                            }
                                            return ((HashSet)this.$outer.fileToDeleteKeyMap$1.apply((Object)f)).add((Object)this.key$1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.key$1 = key$1;
                                        }
                                    });
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                Enumeration.Value value4 = DeDupeType$.MODULE$.INSERT_TYPE();
                                Enumeration.Value value5 = value;
                                if (value4 != null ? !value4.equals(value5) : value5 != null) break block5;
                                LongRef maxCommit = LongRef.create((long)-1L);
                                rows.foreach((Function1)new Serializable(this, maxCommit){
                                    public static final long serialVersionUID = 0L;
                                    private final LongRef maxCommit$1;

                                    public final void apply(Row r) {
                                        long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
                                        if (c > this.maxCommit$1.elem) {
                                            this.maxCommit$1.elem = c;
                                        }
                                    }
                                    {
                                        this.maxCommit$1 = maxCommit$1;
                                    }
                                });
                                rows.foreach((Function1)new Serializable(this, key, maxCommit){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$getDedupePlan$1 $outer;
                                    private final String key$1;
                                    private final LongRef maxCommit$1;

                                    public final Object apply(Row r) {
                                        Object object;
                                        long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
                                        if (c != this.maxCommit$1.elem) {
                                            String f = ((String)r.apply(2)).split("_")[0];
                                            if (!this.$outer.fileToDeleteKeyMap$1.contains((Object)f)) {
                                                this.$outer.fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                                            }
                                            object = BoxesRunTime.boxToBoolean((boolean)((HashSet)this.$outer.fileToDeleteKeyMap$1.apply((Object)f)).add((Object)this.key$1));
                                        } else {
                                            object = BoxedUnit.UNIT;
                                        }
                                        return object;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.key$1 = key$1;
                                        this.maxCommit$1 = maxCommit$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            Enumeration.Value value6 = DeDupeType$.MODULE$.UPSERT_TYPE();
                            Enumeration.Value value7 = value;
                            if (value6 != null ? !value6.equals(value7) : value7 != null) break block6;
                            LongRef maxCommit = LongRef.create((long)-1L);
                            rows.foreach((Function1)new Serializable(this, maxCommit){
                                public static final long serialVersionUID = 0L;
                                private final LongRef maxCommit$2;

                                public final void apply(Row r) {
                                    long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
                                    if (c > this.maxCommit$2.elem) {
                                        this.maxCommit$2.elem = c;
                                    }
                                }
                                {
                                    this.maxCommit$2 = maxCommit$2;
                                }
                            });
                            ListBuffer rowsWithMaxCommit = new ListBuffer();
                            rows.foreach((Function1)new Serializable(this, key, maxCommit, rowsWithMaxCommit){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$getDedupePlan$1 $outer;
                                private final String key$1;
                                private final LongRef maxCommit$2;
                                private final ListBuffer rowsWithMaxCommit$1;

                                public final Object apply(Row r) {
                                    Object object;
                                    long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
                                    if (c != this.maxCommit$2.elem) {
                                        String f = ((String)r.apply(2)).split("_")[0];
                                        if (!this.$outer.fileToDeleteKeyMap$1.contains((Object)f)) {
                                            this.$outer.fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                                        }
                                        object = BoxesRunTime.boxToBoolean((boolean)((HashSet)this.$outer.fileToDeleteKeyMap$1.apply((Object)f)).add((Object)this.key$1));
                                    } else {
                                        object = this.rowsWithMaxCommit$1.$plus$eq((Object)r);
                                    }
                                    return object;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.key$1 = key$1;
                                    this.maxCommit$2 = maxCommit$2;
                                    this.rowsWithMaxCommit$1 = rowsWithMaxCommit$1;
                                }
                            });
                            ((List)rowsWithMaxCommit.toList().init()).foreach((Function1)new Serializable(this, key){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$getDedupePlan$1 $outer;
                                private final String key$1;

                                public final boolean apply(Row r) {
                                    String f = ((String)r.apply(2)).split("_")[0];
                                    if (!this.$outer.fileToDeleteKeyMap$1.contains((Object)f)) {
                                        this.$outer.fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                                    }
                                    return ((HashSet)this.$outer.fileToDeleteKeyMap$1.apply((Object)f)).add((Object)this.key$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.key$1 = key$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new IllegalArgumentException("Please provide valid type for deduping!");
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fileToDeleteKeyMap$1 = fileToDeleteKeyMap$1;
            }
        });
        this.LOG().debug((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fileToDeleteKeyMap size: ", ", map: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fileToDeleteKeyMap.size()), fileToDeleteKeyMap})));
        return var2_2;
    }

    public void fixDuplicates(boolean dryRun) {
        Dataset<Row> fixedDF;
        HoodieTableMetaClient metadata = HoodieTableMetaClient.builder().setConf(this.org$apache$spark$sql$hudi$DedupeSparkJob$$fs.getConf()).setBasePath(this.org$apache$spark$sql$hudi$DedupeSparkJob$$basePath).build();
        FileStatus[] allFiles2 = this.org$apache$spark$sql$hudi$DedupeSparkJob$$fs.listStatus(new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$hudi$DedupeSparkJob$$basePath, this.org$apache$spark$sql$hudi$DedupeSparkJob$$duplicatedPartitionPath}))));
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metadata, metadata.getActiveTimeline().getCommitTimeline().filterCompletedInstants(), allFiles2);
        java.util.List latestFiles = fsView.getLatestBaseFiles().collect(Collectors.toList());
        Map fileNameToPathMap = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(latestFiles).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Path> apply(HoodieBaseFile f) {
                return new Tuple2((Object)f.getFileId(), (Object)new Path(f.getPath()));
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        HashMap<String, HashSet<String>> dupeFixPlan = this.planDuplicateFix();
        fileNameToPathMap.foreach((Function1)new Serializable(this, dupeFixPlan){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DedupeSparkJob $outer;
            private final HashMap dupeFixPlan$1;

            public final boolean apply(Tuple2<String, Path> x0$1) {
                Tuple2<String, Path> tuple2 = x0$1;
                if (tuple2 != null) {
                    String fileName = (String)tuple2._1();
                    Path filePath = (Path)tuple2._2();
                    String badSuffix = this.dupeFixPlan$1.contains((Object)fileName) ? ".bad" : "";
                    Path dstPath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$repairOutputPath, filePath.getName(), badSuffix})));
                    this.$outer.LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copying from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath, dstPath})));
                    boolean bl = FileUtil.copy((FileSystem)this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$fs, (Path)filePath, (FileSystem)this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$fs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$fs.getConf());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dupeFixPlan$1 = dupeFixPlan$1;
            }
        });
        dupeFixPlan.foreach((Function1)new Serializable(this, fileNameToPathMap, dupeFixPlan){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DedupeSparkJob $outer;
            private final Map fileNameToPathMap$1;
            private final HashMap dupeFixPlan$1;

            public final boolean apply(Tuple2<String, HashSet<String>> x0$2) {
                Tuple2<String, HashSet<String>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String fileName = (String)tuple2._1();
                    String instantTime = FSUtils.getCommitTime(((Path)this.fileNameToPathMap$1.apply((Object)fileName)).getName());
                    Path badFilePath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".bad"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$repairOutputPath, ((Path)this.fileNameToPathMap$1.apply((Object)fileName)).getName()})));
                    Path newFilePath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$repairOutputPath, ((Path)this.fileNameToPathMap$1.apply((Object)fileName)).getName()})));
                    this.$outer.LOG().info((Object)new StringBuilder().append((Object)" Skipping and writing new file for : ").append((Object)fileName).toString());
                    SparkHelpers$.MODULE$.skipKeysAndWriteNewFile(instantTime, this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$fs, badFilePath, newFilePath, (Set<String>)((Set)this.dupeFixPlan$1.apply((Object)fileName)));
                    boolean bl = this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$fs.delete(badFilePath, true);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fileNameToPathMap$1 = fileNameToPathMap$1;
                this.dupeFixPlan$1 = dupeFixPlan$1;
            }
        });
        Dataset df = this.sqlContext.read().parquet(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/*.parquet"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$sql$hudi$DedupeSparkJob$$repairOutputPath})));
        df.registerTempTable("fixedTbl");
        Dataset<Row> dupeKeyDF = this.getDupeKeyDF("fixedTbl");
        long dupeCnt = dupeKeyDF.count();
        if (dupeCnt != 0L) {
            dupeKeyDF.show();
            throw new HoodieException("Still found some duplicates!!.. Inspect output");
        }
        Dataset<Row> sourceDF2 = this.sparkHelper().getDistinctKeyDF((List<String>)((TraversableOnce)fileNameToPathMap.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Path> t) {
                return ((Path)t._2()).toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList());
        Dataset missedRecordKeysDF = sourceDF2.except(fixedDF = this.sparkHelper().getDistinctKeyDF((List<String>)((TraversableOnce)fileNameToPathMap.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DedupeSparkJob $outer;

            public final String apply(Tuple2<String, Path> t) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$repairOutputPath, ((Path)t._2()).getName()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList()));
        long missedCnt = missedRecordKeysDF.count();
        if (missedCnt != 0L) {
            missedRecordKeysDF.show();
            throw new HoodieException("Some records in source are not found in fixed files. Inspect output!!");
        }
        Predef$.MODULE$.println((Object)"No duplicates found & counts are in check!!!! ");
        fileNameToPathMap.foreach((Function1)new Serializable(this, dryRun){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DedupeSparkJob $outer;
            private final boolean dryRun$1;

            public final Object apply(Tuple2<String, Path> x0$3) {
                Tuple2<String, Path> tuple2 = x0$3;
                if (tuple2 != null) {
                    Object object;
                    Path filePath = (Path)tuple2._2();
                    Path srcPath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$repairOutputPath, filePath.getName()})));
                    Path dstPath = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$basePath, this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$duplicatedPartitionPath, filePath.getName()})));
                    if (this.dryRun$1) {
                        this.$outer.LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[JUST KIDDING!!!] Copying from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath, dstPath})));
                        object = BoxedUnit.UNIT;
                    } else {
                        this.$outer.LOG().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[FOR REAL!!!] Copying from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath, dstPath})));
                        object = BoxesRunTime.boxToBoolean((boolean)FileUtil.copy((FileSystem)this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$fs, (Path)srcPath, (FileSystem)this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$fs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)this.$outer.org$apache$spark$sql$hudi$DedupeSparkJob$$fs.getConf()));
                    }
                    BoxedUnit boxedUnit = object;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dryRun$1 = dryRun$1;
            }
        });
    }

    public boolean fixDuplicates$default$1() {
        return true;
    }

    public DedupeSparkJob(String basePath, String duplicatedPartitionPath, String repairOutputPath, SQLContext sqlContext, FileSystem fs, Enumeration.Value dedupeType) {
        this.org$apache$spark$sql$hudi$DedupeSparkJob$$basePath = basePath;
        this.org$apache$spark$sql$hudi$DedupeSparkJob$$duplicatedPartitionPath = duplicatedPartitionPath;
        this.org$apache$spark$sql$hudi$DedupeSparkJob$$repairOutputPath = repairOutputPath;
        this.sqlContext = sqlContext;
        this.org$apache$spark$sql$hudi$DedupeSparkJob$$fs = fs;
        this.org$apache$spark$sql$hudi$DedupeSparkJob$$dedupeType = dedupeType;
        this.sparkHelper = new SparkHelper(sqlContext, fs);
        this.LOG = Logger.getLogger(this.getClass());
    }
}

