/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowRollbacksProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001E\u0011ac\u00155poJ{G\u000e\u001c2bG.\u001c\bK]8dK\u0012,(/\u001a\u0006\u0003\u0007\u0011\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t)a!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u001dA\u0011\u0001\u00025vI&T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003']I!\u0001\u0007\u0002\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\b\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u0017MDwn\u001e#fi\u0006LGn\u001d\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011A%\n\t\u0003'\u0001AQAG\u0011A\u0002mAqa\n\u0001C\u0002\u0013%\u0001&\u0001\u000bS\u001f2c%)Q\"L'~\u0003\u0016IU!N\u000bR+%kU\u000b\u0002SA\u0019AD\u000b\u0017\n\u0005-j\"!B!se\u0006L\bCA\n.\u0013\tq#A\u0001\nQe>\u001cW\rZ;sKB\u000b'/Y7fi\u0016\u0014\bB\u0002\u0019\u0001A\u0003%\u0011&A\u000bS\u001f2c%)Q\"L'~\u0003\u0016IU!N\u000bR+%k\u0015\u0011\t\u000fI\u0002!\u0019!C\u0005Q\u0005\u0019\"k\u0014'M\u0005\u0006\u001b5j\u0018)B%\u0006kU\tV#S'\"1A\u0007\u0001Q\u0001\n%\nACU(M\u0019\n\u000b5iS0Q\u0003J\u000bU*\u0012+F%N\u0003\u0003b\u0002\u001c\u0001\u0005\u0004%IaN\u0001\u0016%>cEJQ!D\u0017N{v*\u0016+Q+R{F+\u0017)F+\u0005A\u0004CA\u001d=\u001b\u0005Q$BA\u001e\t\u0003\u0015!\u0018\u0010]3t\u0013\ti$H\u0001\u0006TiJ,8\r\u001e+za\u0016Daa\u0010\u0001!\u0002\u0013A\u0014A\u0006*P\u00192\u0013\u0015iQ&T?>+F\u000bU+U?RK\u0006+\u0012\u0011\t\u000f\u0005\u0003!\u0019!C\u0005o\u0005!\"k\u0014'M\u0005\u0006\u001b5jX(V)B+Fk\u0018+Z!\u0016Caa\u0011\u0001!\u0002\u0013A\u0014!\u0006*P\u00192\u0013\u0015iQ&`\u001fV#\u0006+\u0016+`)f\u0003V\t\t\u0005\u0006\u000b\u0002!\t\u0001K\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\"B$\u0001\t\u00039\u0014AC8viB,H\u000fV=qK\")\u0011\n\u0001C!\u0015\u0006!1-\u00197m)\tY5\fE\u0002M)^s!!\u0014*\u000f\u00059\u000bV\"A(\u000b\u0005A\u0003\u0012A\u0002\u001fs_>$h(C\u0001\u001f\u0013\t\u0019V$A\u0004qC\u000e\\\u0017mZ3\n\u0005U3&aA*fc*\u00111+\b\t\u00031fk\u0011\u0001C\u0005\u00035\"\u00111AU8x\u0011\u0015a\u0006\n1\u0001^\u0003\u0011\t'oZ:\u0011\u0005Mq\u0016BA0\u0003\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\")\u0011\r\u0001C!E\u0006)!-^5mIV\t1\r\u0005\u0002\u0014I&\u0011QM\u0001\u0002\n!J|7-\u001a3ve\u00164Aa\u001a\u0001\u0001Q\n\u0001\"k\u001c7mE\u0006\u001c7\u000eV5nK2Lg.Z\n\u0003M&\u0004\"A\u001b:\u000e\u0003-T!\u0001\\7\u0002\u0011QLW.\u001a7j]\u0016T!A\\8\u0002\u000bQ\f'\r\\3\u000b\u0005A\f\u0018AB2p[6|gN\u0003\u0002\b\u0019%\u00111o\u001b\u0002\u0015\u0011>|G-[3BGRLg/\u001a+j[\u0016d\u0017N\\3\t\u0011U4'\u0011!Q\u0001\nY\f!\"\\3uC\u000ec\u0017.\u001a8u!\t9\b0D\u0001n\u0013\tIXNA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;\t\u000b\t2G\u0011A>\u0015\u0005qt\bCA?g\u001b\u0005\u0001\u0001\"B;{\u0001\u00041\bbBA\u0001\u0001\u0011\u0005\u00111A\u0001\u0012O\u0016$(k\u001c7mE\u0006\u001c7\u000eR3uC&dGcB&\u0002\u0006\u0005%\u00111\u0004\u0005\u0007\u0003\u000fy\b\u0019\u0001?\u0002\u001d\u0005\u001cG/\u001b<f)&lW\r\\5oK\"9\u00111B@A\u0002\u00055\u0011aC5ogR\fg\u000e\u001e+j[\u0016\u0004B!a\u0004\u0002\u00169\u0019A$!\u0005\n\u0007\u0005MQ$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\tIB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'i\u0002bBA\u000f\u007f\u0002\u0007\u0011qD\u0001\u0006Y&l\u0017\u000e\u001e\t\u00049\u0005\u0005\u0012bAA\u0012;\t\u0019\u0011J\u001c;\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005aq-\u001a;S_2d'-Y2lgR)1*a\u000b\u0002.!9\u0011qAA\u0013\u0001\u0004a\b\u0002CA\u000f\u0003K\u0001\r!a\b\b\u000f\u0005E\"\u0001#\u0001\u00024\u000512\u000b[8x%>dGNY1dWN\u0004&o\\2fIV\u0014X\rE\u0002\u0014\u0003k1a!\u0001\u0002\t\u0002\u0005]2\u0003BA\u001b\u0003s\u00012\u0001HA\u001e\u0013\r\ti$\b\u0002\u0007\u0003:L(+\u001a4\t\u000f\t\n)\u0004\"\u0001\u0002BQ\u0011\u00111\u0007\u0005\u000b\u0003\u000b\n)D1A\u0005\u0002\u0005\u001d\u0013\u0001\u0002(B\u001b\u0016+\"!!\u0013\u0011\t\u0005-\u0013QK\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005!A.\u00198h\u0015\t\t\u0019&\u0001\u0003kCZ\f\u0017\u0002BA\f\u0003\u001bB\u0011\"!\u0017\u00026\u0001\u0006I!!\u0013\u0002\u000b9\u000bU*\u0012\u0011\t\u0011\u0005u\u0013Q\u0007C\u0001\u0003?\nqAY;jY\u0012,'/\u0006\u0002\u0002bA)\u00111MA7-5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'\u0001\u0005gk:\u001cG/[8o\u0015\u0011\tY'!\u0015\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003_\n)G\u0001\u0005TkB\u0004H.[3s\u0001")
public class ShowRollbacksProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final boolean showDetails;
    private final ProcedureParameter[] ROLLBACKS_PARAMETERS;
    private final ProcedureParameter[] ROLLBACK_PARAMETERS;
    private final StructType ROLLBACKS_OUTPUT_TYPE;
    private final StructType ROLLBACK_OUTPUT_TYPE;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowRollbacksProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowRollbacksProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] ROLLBACKS_PARAMETERS() {
        return this.ROLLBACKS_PARAMETERS;
    }

    private ProcedureParameter[] ROLLBACK_PARAMETERS() {
        return this.ROLLBACK_PARAMETERS;
    }

    private StructType ROLLBACKS_OUTPUT_TYPE() {
        return this.ROLLBACKS_OUTPUT_TYPE;
    }

    private StructType ROLLBACK_OUTPUT_TYPE() {
        return this.ROLLBACK_OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.showDetails ? this.ROLLBACK_PARAMETERS() : this.ROLLBACKS_PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.showDetails ? this.ROLLBACK_OUTPUT_TYPE() : this.ROLLBACKS_OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        Seq<Row> seq;
        super.checkArgs(this.parameters(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.parameters()[0]);
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args2, this.parameters()[1]).get());
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        RollbackTimeline activeTimeline = new RollbackTimeline(metaClient);
        if (this.showDetails) {
            String instantTime = (String)this.getArgValueOrDefault(args2, this.parameters()[2]).get();
            seq = this.getRollbackDetail(activeTimeline, instantTime, limit);
        } else {
            seq = this.getRollbacks(activeTimeline, limit);
        }
        return seq;
    }

    @Override
    public Procedure build() {
        return new ShowRollbacksProcedure(this.showDetails);
    }

    public Seq<Row> getRollbackDetail(RollbackTimeline activeTimeline, String instantTime, int limit) {
        ArrayList rows = new ArrayList();
        HoodieRollbackMetadata metadata = TimelineMetadataUtils.deserializeAvroMetadata(activeTimeline.getInstantDetails(new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", instantTime)).get(), HoodieRollbackMetadata.class);
        ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getPartitionMetadata()).asScala()).toMap(Predef$.MODULE$.$conforms()).iterator().foreach((Function1)new Serializable(this, rows, metadata){
            public static final long serialVersionUID = 0L;
            public final ArrayList rows$1;
            public final HoodieRollbackMetadata metadata$1;

            public final void apply(Tuple2<String, HoodieRollbackPartitionMetadata> entry) {
                ((Stream)package$.MODULE$.Stream().concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Traversable[]{(Traversable)JavaConversions$.MODULE$.asScalaBuffer(((HoodieRollbackPartitionMetadata)((Object)entry._2())).getSuccessDeleteFiles()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Object> apply(String f) {
                        return new Tuple2((Object)f, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                }, Buffer$.MODULE$.canBuildFrom()), (Traversable)JavaConversions$.MODULE$.asScalaBuffer(((HoodieRollbackPartitionMetadata)((Object)entry._2())).getFailedDeleteFiles()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Object> apply(String f) {
                        return new Tuple2((Object)f, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    }
                }, Buffer$.MODULE$.canBuildFrom())}))).iterator().foreach((Function1)new Serializable(this, entry){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getRollbackDetail$1 $outer;
                    private final Tuple2 entry$1;

                    public final boolean apply(Tuple2<String, Object> fileWithDeleteStatus) {
                        return this.$outer.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.metadata$1.getStartRollbackTime(), this.$outer.metadata$1.getCommitsRollback().toString(), this.entry$1._1(), fileWithDeleteStatus._1(), BoxesRunTime.boxToBoolean((boolean)fileWithDeleteStatus._2$mcZ$sp())})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.entry$1 = entry$1;
                    }
                });
            }
            {
                this.rows$1 = rows$1;
                this.metadata$1 = metadata$1;
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Object r) {
                return (Row)r;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
    }

    public Seq<Row> getRollbacks(RollbackTimeline activeTimeline, int limit) {
        ArrayList rows = new ArrayList();
        HoodieTimeline rollback = activeTimeline.getRollbackTimeline().filterCompletedInstants();
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(rollback.getInstants().iterator()).asScala()).foreach((Function1)new Serializable(this, activeTimeline, rows){
            public static final long serialVersionUID = 0L;
            private final RollbackTimeline activeTimeline$1;
            public final ArrayList rows$2;

            public final void apply(HoodieInstant instant) {
                try {
                    HoodieRollbackMetadata metadata = TimelineMetadataUtils.deserializeAvroMetadata(this.activeTimeline$1.getInstantDetails(instant).get(), HoodieRollbackMetadata.class);
                    ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metadata.getCommitsRollback().iterator()).asScala()).foreach((Function1)new Serializable(this, metadata){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$getRollbacks$1 $outer;
                        private final HoodieRollbackMetadata metadata$2;

                        public final boolean apply(String c) {
                            return this.$outer.rows$2.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.metadata$2.getStartRollbackTime(), c, this.metadata$2.getTotalFilesDeleted(), this.metadata$2.getTimeTakenInMillis(), this.metadata$2.getPartitionMetadata() == null ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)this.metadata$2.getPartitionMetadata().size())})));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.metadata$2 = metadata$2;
                        }
                    });
                    return;
                }
                catch (IOException iOException) {
                    throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get rollback's info from instant ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instant.getTimestamp()})));
                }
            }
            {
                this.activeTimeline$1 = activeTimeline$1;
                this.rows$2 = rows$2;
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Object r) {
                return (Row)r;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
    }

    public ShowRollbacksProcedure(boolean showDetails) {
        this.showDetails = showDetails;
        this.ROLLBACKS_PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
        this.ROLLBACK_PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.required(2, "instant_time", DataTypes.StringType, None$.MODULE$)});
        this.ROLLBACKS_OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("rollback_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_files_deleted", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("time_taken_in_millis", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_partitions", DataTypes.IntegerType, true, Metadata$.MODULE$.empty())}));
        this.ROLLBACK_OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("rollback_instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("deleted_file", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("succeeded", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }

    public class RollbackTimeline
    extends HoodieActiveTimeline {
        public /* synthetic */ ShowRollbacksProcedure org$apache$spark$sql$hudi$command$procedures$ShowRollbacksProcedure$RollbackTimeline$$$outer() {
            return ShowRollbacksProcedure.this;
        }

        public RollbackTimeline(HoodieTableMetaClient metaClient) {
            if (ShowRollbacksProcedure.this == null) {
                throw null;
            }
            super(metaClient, CollectionUtils.createImmutableSet((Object[])new String[]{".rollback"}));
        }
    }
}

