/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowSavepointsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001#\t92\u000b[8x'\u00064X\r]8j]R\u001c\bK]8dK\u0012,(/\u001a\u0006\u0003\u0007\u0011\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t)a!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u001dA\u0011\u0001\u00025vI&T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003']I!\u0001\u0007\u0002\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\b\"\u0002\u000e\u0001\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u001d!\t\u0019\u0002\u0001C\u0004\u001f\u0001\t\u0007I\u0011B\u0010\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u0001!!\r\tCEJ\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t)\u0011I\u001d:bsB\u00111cJ\u0005\u0003Q\t\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\"1!\u0006\u0001Q\u0001\n\u0001\n1\u0002U!S\u00036+E+\u0012*TA!9A\u0006\u0001b\u0001\n\u0013i\u0013aC(V)B+Fk\u0018+Z!\u0016+\u0012A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0003c!\tQ\u0001^=qKNL!a\r\u0019\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u00046\u0001\u0001\u0006IAL\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\t\t\u0005\u0006o\u0001!\taH\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\"B\u001d\u0001\t\u0003i\u0013AC8viB,H\u000fV=qK\")1\b\u0001C!y\u0005!1-\u00197m)\tiT\nE\u0002?\r&s!a\u0010#\u000f\u0005\u0001\u001bU\"A!\u000b\u0005\t\u0003\u0012A\u0002\u001fs_>$h(C\u0001$\u0013\t)%%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dC%aA*fc*\u0011QI\t\t\u0003\u0015.k\u0011\u0001C\u0005\u0003\u0019\"\u00111AU8x\u0011\u0015q%\b1\u0001P\u0003\u0011\t'oZ:\u0011\u0005M\u0001\u0016BA)\u0003\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\")1\u000b\u0001C!)\u0006)!-^5mIV\tQ\u000b\u0005\u0002\u0014-&\u0011qK\u0001\u0002\n!J|7-\u001a3ve\u0016<Q!\u0017\u0002\t\u0002i\u000bqc\u00155poN\u000bg/\u001a9pS:$8\u000f\u0015:pG\u0016$WO]3\u0011\u0005MYf!B\u0001\u0003\u0011\u0003a6CA.^!\t\tc,\u0003\u0002`E\t1\u0011I\\=SK\u001aDQAG.\u0005\u0002\u0005$\u0012A\u0017\u0005\bGn\u0013\r\u0011\"\u0001e\u0003\u0011q\u0015)T#\u0016\u0003\u0015\u0004\"AZ5\u000f\u0005\u0005:\u0017B\u00015#\u0003\u0019\u0001&/\u001a3fM&\u0011!n\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!\u0014\u0003BB7\\A\u0003%Q-A\u0003O\u00036+\u0005\u0005C\u0003p7\u0012\u0005\u0001/A\u0004ck&dG-\u001a:\u0016\u0003E\u00042A]=\u0017\u001b\u0005\u0019(B\u0001;v\u0003!1WO\\2uS>t'B\u0001<x\u0003\u0011)H/\u001b7\u000b\u0003a\fAA[1wC&\u0011!p\u001d\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class ShowSavepointsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("savepoint_time", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowSavepointsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowSavepointsProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getSavePointTimeline().filterCompletedInstants();
        List commits = timeline.getReverseOrderedInstants().collect(Collectors.toList());
        return commits.isEmpty() ? (Seq)Seq$.MODULE$.empty() : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(commits.toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object instant) {
                return ((HoodieInstant)instant).getTimestamp();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(String p) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toSeq();
    }

    @Override
    public Procedure build() {
        return new ShowSavepointsProcedure();
    }
}

