/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class UrlList {
    private final AtomicInteger index;
    private final List<String> urls;

    public UrlList(List<String> urls) {
        if (urls == null || urls.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one URL to be passed in constructor");
        }
        this.urls = new ArrayList<String>(urls);
        this.index = new AtomicInteger(new Random().nextInt(urls.size()));
    }

    public UrlList(String url2) {
        this(Arrays.asList(url2));
    }

    public String current() {
        return this.urls.get(this.index.get());
    }

    public void fail(String url2) {
        int currentIndex = this.index.get();
        if (this.urls.get(currentIndex).equals(url2)) {
            this.index.compareAndSet(currentIndex, (currentIndex + 1) % this.urls.size());
        }
    }

    public int size() {
        return this.urls.size();
    }

    public String toString() {
        return this.urls.toString();
    }
}

