/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.avro.AvroRuntimeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroDeserializer;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroSchemaConverters;
import org.apache.hudi.org.apache.spark.sql.avro.HoodieAvroSerializer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AvroConversionUtils$ {
    public static final AvroConversionUtils$ MODULE$;

    static {
        new AvroConversionUtils$();
    }

    public Tuple2<Object, Schema> resolveAvroTypeNullability(Schema avroType) {
        Tuple2 tuple2;
        Schema.Type type = avroType.getType();
        Schema.Type type2 = Schema.Type.UNION;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala();
            Buffer actualType = (Buffer)fields.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Schema x$1) {
                    Schema.Type type = x$1.getType();
                    Schema.Type type2 = Schema.Type.NULL;
                    return type != null ? !type.equals(type2) : type2 != null;
                }
            });
            if (fields.length() != 2 || actualType.length() != 1) {
                throw new AvroRuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported Avro UNION type ", ": Only UNION of a null type and a non-null "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{avroType}))).append((Object)"type is supported").toString());
            }
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), actualType.head());
        } else {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)avroType);
        }
        return tuple2;
    }

    public Function1<GenericRecord, Option<InternalRow>> createAvroToInternalRowConverter(Schema rootAvroType, StructType rootCatalystType) {
        HoodieAvroDeserializer deserializer = HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroDeserializer(rootAvroType, (DataType)rootCatalystType);
        return new Serializable(deserializer){
            public static final long serialVersionUID = 0L;
            private final HoodieAvroDeserializer deserializer$1;

            public final Option<InternalRow> apply(GenericRecord record) {
                return this.deserializer$1.deserialize(record).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InternalRow apply(Object x$2) {
                        return (InternalRow)x$2;
                    }
                });
            }
            {
                this.deserializer$1 = deserializer$1;
            }
        };
    }

    public Function1<InternalRow, GenericRecord> createInternalRowToAvroConverter(StructType rootCatalystType, Schema rootAvroType, boolean nullable) {
        HoodieAvroSerializer serializer = HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroSerializer((DataType)rootCatalystType, rootAvroType, nullable);
        return new Serializable(serializer){
            public static final long serialVersionUID = 0L;
            private final HoodieAvroSerializer serializer$1;

            public final GenericRecord apply(InternalRow row2) {
                return (GenericRecord)this.serializer$1.serialize(row2);
            }
            {
                this.serializer$1 = serializer$1;
            }
        };
    }

    @Deprecated
    public Function1<GenericRecord, Row> createConverterToRow(Schema sourceAvroSchema, StructType targetSqlType) {
        SparkRowSerDe serde = HoodieSparkUtils$.MODULE$.sparkAdapter().createSparkRowSerDe(targetSqlType);
        Function1<GenericRecord, Option<InternalRow>> converter = this.createAvroToInternalRowConverter(sourceAvroSchema, targetSqlType);
        return new Serializable(serde, converter){
            public static final long serialVersionUID = 0L;
            public final SparkRowSerDe serde$1;
            private final Function1 converter$1;

            public final Row apply(GenericRecord avro2) {
                return (Row)((Option)this.converter$1.apply((Object)avro2)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createConverterToRow.1 $outer;

                    public final Row apply(InternalRow internalRow) {
                        return this.$outer.serde$1.deserializeRow(internalRow);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).get();
            }
            {
                this.serde$1 = serde$1;
                this.converter$1 = converter$1;
            }
        };
    }

    @Deprecated
    public Function1<Row, GenericRecord> createConverterToAvro(StructType sourceSqlType, String structName, String recordNamespace) {
        SparkRowSerDe serde = HoodieSparkUtils$.MODULE$.sparkAdapter().createSparkRowSerDe(sourceSqlType);
        Schema avroSchema = this.convertStructTypeToAvroSchema((DataType)sourceSqlType, structName, recordNamespace);
        Tuple2<Object, Schema> tuple2 = this.resolveAvroTypeNullability(avroSchema);
        if (tuple2 != null) {
            boolean nullable;
            boolean bl;
            boolean nullable2 = bl = (nullable = tuple2._1$mcZ$sp());
            Function1<InternalRow, GenericRecord> converter = this.createInternalRowToAvroConverter(sourceSqlType, avroSchema, nullable2);
            return new Serializable(serde, converter){
                public static final long serialVersionUID = 0L;
                private final SparkRowSerDe serde$2;
                private final Function1 converter$2;

                public final GenericRecord apply(Row row2) {
                    return (GenericRecord)this.converter$2.apply((Object)this.serde$2.serializeRow(row2));
                }
                {
                    this.serde$2 = serde$2;
                    this.converter$2 = converter$2;
                }
            };
        }
        throw new MatchError(tuple2);
    }

    public Dataset<Row> createDataFrame(RDD<GenericRecord> rdd, String schemaStr, SparkSession ss) {
        return rdd.isEmpty() ? ss.emptyDataFrame() : ss.createDataFrame(rdd.mapPartitions((Function1)new Serializable(schemaStr){
            public static final long serialVersionUID = 0L;
            private final String schemaStr$1;

            public final Iterator<Row> apply(Iterator<GenericRecord> records) {
                Iterator iterator2;
                if (records.isEmpty()) {
                    iterator2 = package$.MODULE$.Iterator().empty();
                } else {
                    Schema schema2 = new Schema.Parser().parse(this.schemaStr$1);
                    StructType dataType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema2);
                    Function1<GenericRecord, Row> converter = AvroConversionUtils$.MODULE$.createConverterToRow(schema2, dataType);
                    iterator2 = records.map((Function1)new Serializable(this, converter){
                        public static final long serialVersionUID = 0L;
                        private final Function1 converter$3;

                        public final Row apply(GenericRecord r) {
                            return (Row)this.converter$3.apply((Object)r);
                        }
                        {
                            this.converter$3 = converter$3;
                        }
                    });
                }
                return iterator2;
            }
            {
                this.schemaStr$1 = schemaStr$1;
            }
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), this.convertAvroSchemaToStructType(new Schema.Parser().parse(schemaStr)));
    }

    public Schema convertStructTypeToAvroSchema(DataType structType, String qualifiedName) {
        String[] parts = new StringOps(Predef$.MODULE$.augmentString(qualifiedName)).split('.');
        Tuple2 tuple2 = new Tuple2((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])parts).init()).mkString("."), Predef$.MODULE$.refArrayOps((Object[])parts).last());
        if (tuple2 != null) {
            Tuple2 tuple22;
            String namespace = (String)tuple2._1();
            String name = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)namespace, (Object)name);
            String namespace2 = (String)tuple23._1();
            String name2 = (String)tuple23._2();
            return this.convertStructTypeToAvroSchema(structType, name2, namespace2);
        }
        throw new MatchError((Object)tuple2);
    }

    public Schema convertStructTypeToAvroSchema(DataType structType, String structName, String recordNamespace) {
        HoodieAvroSchemaConverters schemaConverters = HoodieSparkUtils$.MODULE$.sparkAdapter().getAvroSchemaConverters();
        Schema avroSchema = schemaConverters.toAvroType(structType, false, structName, recordNamespace);
        return this.getAvroSchemaWithDefaults(avroSchema, structType);
    }

    public StructType convertAvroSchemaToStructType(Schema avroSchema) {
        HoodieAvroSchemaConverters schemaConverters = HoodieSparkUtils$.MODULE$.sparkAdapter().getAvroSchemaConverters();
        Tuple2<DataType, Object> tuple2 = schemaConverters.toSqlType(avroSchema);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            StructType structType = (StructType)dataType;
            return structType;
        }
        throw new MatchError(tuple2);
    }

    public Schema getAvroSchemaWithDefaults(Schema schema2, DataType dataType) {
        Schema schema3;
        Schema.Type type = schema2.getType();
        if (Schema.Type.RECORD.equals(type)) {
            StructType structType = (StructType)dataType;
            StructField[] structFields = structType.fields();
            List modifiedFields = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(schema2.getFields()).map((Function1)new Serializable(structType, structFields){
                public static final long serialVersionUID = 0L;
                private final StructType structType$1;
                private final StructField[] structFields$1;

                public final Schema.Field apply(Schema.Field field) {
                    Schema.Field field2;
                    int i = this.structType$1.fieldIndex(field.name());
                    String comment = this.structFields$1[i].metadata().contains("comment") ? this.structFields$1[i].metadata().getString("comment") : field.doc();
                    Schema newSchema = AvroConversionUtils$.MODULE$.getAvroSchemaWithDefaults(field.schema(), this.structFields$1[i].dataType());
                    Schema.Type type = field.schema().getType();
                    if (Schema.Type.UNION.equals(type)) {
                        Schema.Field field3;
                        java.util.List innerFields = newSchema.getTypes();
                        boolean containsNullSchema = BoxesRunTime.unboxToBoolean((Object)JavaConversions$.MODULE$.asScalaBuffer(innerFields).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(boolean nullFieldEncountered, Schema schema2) {
                                Schema.Type type = schema2.getType();
                                Schema.Type type2 = Schema.Type.NULL;
                                return nullFieldEncountered | !(type != null ? !type.equals(type2) : type2 != null);
                            }
                        }));
                        if (containsNullSchema) {
                            Schema restructuredNewSchema = Schema.createUnion((java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL)})).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(innerFields).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Schema innerSchema) {
                                    Schema.Type type = innerSchema.getType();
                                    Schema.Type type2 = Schema.Type.NULL;
                                    return type != null ? !type.equals(type2) : type2 != null;
                                }
                            }), List$.MODULE$.canBuildFrom())));
                            field3 = new Schema.Field(field.name(), restructuredNewSchema, comment, (Object)JsonProperties.NULL_VALUE);
                        } else {
                            field3 = new Schema.Field(field.name(), newSchema, comment, field.defaultVal());
                        }
                        field2 = field3;
                    } else {
                        field2 = new Schema.Field(field.name(), newSchema, comment, field.defaultVal());
                    }
                    return field2;
                }
                {
                    this.structType$1 = structType$1;
                    this.structFields$1 = structFields$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).toList();
            schema3 = Schema.createRecord((String)schema2.getName(), (String)schema2.getDoc(), (String)schema2.getNamespace(), (boolean)schema2.isError(), (java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)modifiedFields));
        } else {
            schema3 = Schema.Type.UNION.equals(type) ? Schema.createUnion((java.util.List)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(schema2.getTypes()).map((Function1)new Serializable(dataType){
                public static final long serialVersionUID = 0L;
                private final DataType dataType$1;

                public final Schema apply(Schema innerSchema) {
                    return AvroConversionUtils$.MODULE$.getAvroSchemaWithDefaults(innerSchema, this.dataType$1);
                }
                {
                    this.dataType$1 = dataType$1;
                }
            }, Buffer$.MODULE$.canBuildFrom()))) : (Schema.Type.MAP.equals(type) ? Schema.createMap((Schema)this.getAvroSchemaWithDefaults(schema2.getValueType(), ((MapType)dataType).valueType())) : (Schema.Type.ARRAY.equals(type) ? Schema.createArray((Schema)this.getAvroSchemaWithDefaults(schema2.getElementType(), ((ArrayType)dataType).elementType())) : schema2));
        }
        return schema3;
    }

    @Deprecated
    public Tuple2<String, String> getAvroRecordNameAndNamespace(String tableName) {
        String qualifiedName = AvroSchemaUtils.getAvroRecordQualifiedName(tableName);
        String[] nameParts = new StringOps(Predef$.MODULE$.augmentString(qualifiedName)).split('.');
        return new Tuple2(Predef$.MODULE$.refArrayOps((Object[])nameParts).last(), (Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])nameParts).init()).mkString("."));
    }

    private AvroConversionUtils$() {
        MODULE$ = this;
    }
}

