/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieDatasetBulkInsertHelper$;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.SparkConfigs$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieInternalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.execution.bulkinsert.BulkInsertInternalPartitionerWithRowsFactory;
import org.apache.hudi.execution.bulkinsert.NonSortPartitionerWithRows;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.util.SyncUtilHelpers;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.util.SparkKeyGenUtils$;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieInternalRowUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

public final class HoodieSparkSqlWriter$ {
    public static final HoodieSparkSqlWriter$ MODULE$;
    private final ConfigProperty<Object> CANONICALIZE_NULLABLE;
    private final ConfigProperty<Object> SQL_MERGE_INTO_WRITES;
    private final Logger org$apache$hudi$HoodieSparkSqlWriter$$log;
    private boolean tableExists;
    private boolean asyncCompactionTriggerFnDefined;
    private boolean asyncClusteringTriggerFnDefined;

    static {
        new HoodieSparkSqlWriter$();
    }

    public ConfigProperty<Object> CANONICALIZE_NULLABLE() {
        return this.CANONICALIZE_NULLABLE;
    }

    public ConfigProperty<Object> SQL_MERGE_INTO_WRITES() {
        return this.SQL_MERGE_INTO_WRITES;
    }

    public Logger org$apache$hudi$HoodieSparkSqlWriter$$log() {
        return this.org$apache$hudi$HoodieSparkSqlWriter$$log;
    }

    private boolean tableExists() {
        return this.tableExists;
    }

    private void tableExists_$eq(boolean x$1) {
        this.tableExists = x$1;
    }

    private boolean asyncCompactionTriggerFnDefined() {
        return this.asyncCompactionTriggerFnDefined;
    }

    private void asyncCompactionTriggerFnDefined_$eq(boolean x$1) {
        this.asyncCompactionTriggerFnDefined = x$1;
    }

    private boolean asyncClusteringTriggerFnDefined() {
        return this.asyncClusteringTriggerFnDefined;
    }

    private void asyncClusteringTriggerFnDefined_$eq(boolean x$1) {
        this.asyncClusteringTriggerFnDefined = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple6<Object, Option<String>, Option<String>, Option<String>, SparkRDDWriteClient<?>, HoodieTableConfig> write(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> optParams, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<?>> hoodieWriteClient, scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>> asyncCompactionTriggerFn, scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>> asyncClusteringTriggerFn, scala.Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFn) {
        SparkRDDWriteClient writeClient;
        Tuple6 tuple6;
        Some some;
        String ser;
        Tuple2 tuple2;
        Predef$.MODULE$.assert(optParams.get((Object)"path").exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return !StringUtils.isNullOrEmpty(x$1);
            }
        }), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "'path' must be set";
            }
        });
        String path = (String)optParams.apply((Object)"path");
        Path basePath = new Path(path);
        SparkSession spark = sqlContext.sparkSession();
        SparkContext sparkContext = sqlContext.sparkContext();
        FileSystem fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
        this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
        HoodieTableConfig tableConfig = this.getHoodieTableConfig(sparkContext, path, hoodieTableConfigOpt);
        Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> tuple22 = this.mergeParamsAndGetHoodieConfig(optParams, tableConfig, mode);
        if (tuple22 == null) throw new MatchError(tuple22);
        scala.collection.immutable.Map parameters = (scala.collection.immutable.Map)tuple22._1();
        HoodieConfig hoodieConfig = (HoodieConfig)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)parameters, (Object)hoodieConfig);
        scala.collection.immutable.Map parameters2 = (scala.collection.immutable.Map)tuple23._1();
        HoodieConfig hoodieConfig2 = (HoodieConfig)tuple23._2();
        String originKeyGeneratorClassName = HoodieWriterUtils$.MODULE$.getOriginKeyGenerator((scala.collection.immutable.Map<String, String>)parameters2);
        scala.collection.immutable.Map<String, String> timestampKeyGeneratorConfigs = this.extractConfigsRelatedToTimestampBasedKeyGenerator(originKeyGeneratorClassName, (scala.collection.immutable.Map<String, String>)parameters2);
        HoodieWriterUtils$.MODULE$.validateKeyGeneratorConfig(originKeyGeneratorClassName, tableConfig);
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Overwrite;
        HoodieWriterUtils$.MODULE$.validateTableConfig(sqlContext.sparkSession(), optParams, tableConfig, !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null));
        String databaseName = hoodieConfig2.getStringOrDefault(HoodieTableConfig.DATABASE_NAME, "");
        String tblName = hoodieConfig2.getStringOrThrow(HoodieWriteConfig.TBL_NAME, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieWriteConfig.TBL_NAME.key()}))).trim();
        TableIdentifier tableIdentifier = new TableIdentifier(tblName, (scala.Option)(databaseName.isEmpty() ? None$.MODULE$ : new Some((Object)databaseName)));
        Predef$.MODULE$.assert(!StringUtils.isNullOrEmpty(hoodieConfig2.getString(HoodieWriteConfig.TBL_NAME)), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieWriteConfig.TBL_NAME.key()}));
            }
        });
        this.asyncCompactionTriggerFnDefined_$eq(asyncCompactionTriggerFn.isDefined());
        this.asyncClusteringTriggerFnDefined_$eq(asyncClusteringTriggerFn.isDefined());
        scala.Option option2 = sparkContext.getConf().getOption("spark.serializer");
        if (!(option2 instanceof Some) || !(ser = (String)(some = (Some)option2).x()).equals("org.apache.spark.serializer.KryoSerializer")) throw new HoodieException("hoodie only support org.apache.spark.serializer.KryoSerializer as spark.serializer");
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        HoodieTableType tableType = HoodieTableType.valueOf(hoodieConfig2.getString(DataSourceWriteOptions$.MODULE$.TABLE_TYPE()));
        WriteOperationType operation = WriteOperationType.fromValue(hoodieConfig2.getString(DataSourceWriteOptions$.MODULE$.OPERATION()));
        if (Predef$.MODULE$.Boolean2boolean(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()))) {
            WriteOperationType writeOperationType = operation;
            WriteOperationType writeOperationType2 = WriteOperationType.UPSERT;
            if (!(writeOperationType != null ? !((Object)((Object)writeOperationType)).equals((Object)writeOperationType2) : writeOperationType2 != null)) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not applicable "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"when ", " is set to be true, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"overriding the ", " to be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.OPERATION(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()}))).toString());
                operation = WriteOperationType.INSERT;
            }
        }
        JavaSparkContext jsc = new JavaSparkContext(sparkContext);
        if (asyncCompactionTriggerFn.isDefined() && jsc.getConf().getOption(SparkConfigs$.MODULE$.SPARK_SCHEDULER_ALLOCATION_FILE_KEY()).isDefined()) {
            jsc.setLocalProperty("spark.scheduler.pool", SparkConfigs$.MODULE$.SPARK_DATASOURCE_WRITER_POOL_NAME());
        }
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        KeyGenerator keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator(new TypedProperties(hoodieConfig2.getProps()));
        SaveMode saveMode3 = mode;
        SaveMode saveMode4 = SaveMode.Ignore;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && this.tableExists()) {
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists. Ignoring & not performing actual writes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
            tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)false), Option.empty(), Option.empty(), Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
            return tuple6;
        } else {
            Tuple3 tuple3;
            Tuple2 tuple24;
            Tuple2 tuple25;
            Tuple2 tuple26;
            HoodieTableMetaClient hoodieTableMetaClient;
            this.handleSaveModes(sqlContext.sparkSession(), mode, basePath, tableConfig, tblName, operation, fs);
            String partitionColumns = SparkKeyGenUtils$.MODULE$.getPartitionColumns(keyGenerator, HoodieConversionUtils$.MODULE$.toProperties((scala.collection.immutable.Map<String, String>)parameters2));
            if (this.tableExists()) {
                hoodieTableMetaClient = HoodieTableMetaClient.builder().setConf(sparkContext.hadoopConfiguration()).setBasePath(path).build();
            } else {
                String baseFileFormat = hoodieConfig2.getStringOrDefault(HoodieTableConfig.BASE_FILE_FORMAT);
                String archiveLogFolder = hoodieConfig2.getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER);
                boolean populateMetaFields = hoodieConfig2.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS);
                boolean useBaseFormatMetaFile = hoodieConfig2.getBooleanOrDefault(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT);
                hoodieTableMetaClient = HoodieTableMetaClient.withPropertyBuilder().setTableType(tableType).setDatabaseName(databaseName).setTableName(tblName).setBaseFileFormat(baseFileFormat).setArchiveLogFolder(archiveLogFolder).setPayloadClassName(hoodieConfig2.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME())).setPreCombineField((String)optParams.getOrElse((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                })).setPartitionFields(partitionColumns).setPopulateMetaFields(populateMetaFields).setRecordKeyFields(hoodieConfig2.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD())).setCDCEnabled(hoodieConfig2.getBooleanOrDefault(HoodieTableConfig.CDC_ENABLED)).setCDCSupplementalLoggingMode(hoodieConfig2.getStringOrDefault(HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE)).setKeyGeneratorClassProp(originKeyGeneratorClassName).set(JavaConversions$.MODULE$.mapAsJavaMap(timestampKeyGeneratorConfigs)).setHiveStylePartitioningEnable(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING())).setUrlEncodePartitioning(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING())).setPartitionMetafileUseBaseFormat(Predef$.MODULE$.boolean2Boolean(useBaseFormatMetaFile)).setShouldDropPartitionColumns(Predef$.MODULE$.boolean2Boolean(hoodieConfig2.getBooleanOrDefault(HoodieTableConfig.DROP_PARTITION_COLUMNS))).setCommitTimezone(HoodieTimelineTimeZone.valueOf(hoodieConfig2.getStringOrDefault(HoodieTableConfig.TIMELINE_TIMEZONE))).initTable(sparkContext.hadoopConfiguration(), path);
            }
            HoodieTableMetaClient tableMetaClient = hoodieTableMetaClient;
            tableConfig = tableMetaClient.getTableConfig();
            String commitActionType = CommitUtils.getCommitActionType(operation, tableConfig.getTableType());
            sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
            boolean shouldReconcileSchema = new StringOps(Predef$.MODULE$.augmentString((String)parameters2.apply((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key()))).toBoolean();
            scala.Option<Schema> latestTableSchemaOpt = this.getLatestTableSchema(spark, tableIdentifier, tableMetaClient);
            Tuple2 tuple27 = (Tuple2)latestTableSchemaOpt.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Schema s) {
                    return new Tuple2((Object)s.getName(), (Object)s.getNamespace());
                }
            }).getOrElse((Function0)new Serializable(tblName){
                public static final long serialVersionUID = 0L;
                private final String tblName$1;

                public final Tuple2<String, String> apply() {
                    return AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.tblName$1);
                }
                {
                    this.tblName$1 = tblName$1;
                }
            });
            if (tuple27 == null) throw new MatchError((Object)tuple27);
            String avroRecordName = (String)tuple27._1();
            String avroRecordNamespace = (String)tuple27._2();
            Tuple2 tuple28 = tuple26 = new Tuple2((Object)avroRecordName, (Object)avroRecordNamespace);
            String avroRecordName2 = (String)tuple28._1();
            String avroRecordNamespace2 = (String)tuple28._2();
            Schema sourceSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df.schema(), avroRecordName2, avroRecordNamespace2);
            scala.Option internalSchemaOpt = this.getLatestTableInternalSchema(hoodieConfig2, tableMetaClient).orElse((Function0)new Serializable(parameters2, hoodieConfig2, shouldReconcileSchema, latestTableSchemaOpt, sourceSchema){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map parameters$1;
                private final HoodieConfig hoodieConfig$1;
                private final boolean shouldReconcileSchema$1;
                private final scala.Option latestTableSchemaOpt$1;
                public final Schema sourceSchema$1;

                public final scala.Option<InternalSchema> apply() {
                    None$ none$;
                    if (this.shouldReconcileSchema$1 && this.hoodieConfig$1.getBooleanOrDefault(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED())) {
                        boolean allowOperationMetaDataField = new StringOps(Predef$.MODULE$.augmentString((String)this.parameters$1.getOrElse((Object)HoodieWriteConfig.ALLOW_OPERATION_METADATA_FIELD.key(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "false";
                            }
                        }))).toBoolean();
                        none$ = new Some((Object)AvroInternalSchemaConverter.convert(HoodieAvroUtils.addMetadataFields((Schema)this.latestTableSchemaOpt$1.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.4 $outer;

                            public final Schema apply() {
                                return this.$outer.sourceSchema$1;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }), allowOperationMetaDataField)));
                    } else {
                        none$ = None$.MODULE$;
                    }
                    return none$;
                }
                {
                    this.parameters$1 = parameters$1;
                    this.hoodieConfig$1 = hoodieConfig$1;
                    this.shouldReconcileSchema$1 = shouldReconcileSchema$1;
                    this.latestTableSchemaOpt$1 = latestTableSchemaOpt$1;
                    this.sourceSchema$1 = sourceSchema$1;
                }
            });
            WriteOperationType writeOperationType = operation;
            if (((Object)((Object)WriteOperationType.DELETE)).equals((Object)writeOperationType)) {
                RDD<GenericRecord> genericRecords = HoodieSparkUtils$.MODULE$.createRdd(df, avroRecordName2, avroRecordNamespace2);
                JavaRDD hoodieKeysToDelete = genericRecords.map((Function1)new Serializable(keyGenerator){
                    public static final long serialVersionUID = 0L;
                    private final KeyGenerator keyGenerator$1;

                    public final HoodieKey apply(GenericRecord gr) {
                        return this.keyGenerator$1.getKey(gr);
                    }
                    {
                        this.keyGenerator$1 = keyGenerator$1;
                    }
                }, ClassTag$.MODULE$.apply(HoodieKey.class)).toJavaRDD();
                if (!this.tableExists()) throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
                scala.Option<InternalSchema> internalSchemaOpt2 = this.getLatestTableInternalSchema(hoodieConfig2, tableMetaClient);
                SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0)new Serializable(path, parameters2, tblName, jsc, internalSchemaOpt2){
                    public static final long serialVersionUID = 0L;
                    private final String path$1;
                    private final scala.collection.immutable.Map parameters$1;
                    private final String tblName$1;
                    private final JavaSparkContext jsc$1;
                    private final scala.Option internalSchemaOpt$2;

                    public final SparkRDDWriteClient<Object> apply() {
                        return DataSourceUtils.createHoodieClient(this.jsc$1, null, this.path$1, this.tblName$1, JavaConversions$.MODULE$.mapAsJavaMap(HoodieSparkSqlWriter$.MODULE$.addSchemaEvolutionParameters((scala.collection.immutable.Map<String, String>)this.parameters$1, (scala.Option<InternalSchema>)this.internalSchemaOpt$2, HoodieSparkSqlWriter$.MODULE$.addSchemaEvolutionParameters$default$3()).$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key())));
                    }
                    {
                        this.path$1 = path$1;
                        this.parameters$1 = parameters$1;
                        this.tblName$1 = tblName$1;
                        this.jsc$1 = jsc$1;
                        this.internalSchemaOpt$2 = internalSchemaOpt$2;
                    }
                });
                Object object2 = this.isAsyncCompactionEnabled(client, tableConfig, (scala.collection.immutable.Map<String, String>)parameters2, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                object2 = this.isAsyncClusteringEnabled(client, (scala.collection.immutable.Map<String, String>)parameters2) ? ((Function1)asyncClusteringTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                client.startCommitWithTime(instantTime, commitActionType);
                HoodieWriteResult writeStatuses = DataSourceUtils.doDeleteOperation(client, (JavaRDD<HoodieKey>)hoodieKeysToDelete, instantTime);
                tuple25 = new Tuple2((Object)writeStatuses, (Object)client);
            } else if (((Object)((Object)WriteOperationType.DELETE_PARTITION)).equals((Object)writeOperationType)) {
                java.util.List<Object> list;
                if (!this.tableExists()) throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
                if (JavaConversions$.MODULE$.mapAsJavaMap((Map)parameters2).containsKey(DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key())) {
                    String[] partitionColsToDelete = ((String)parameters2.apply((Object)DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key())).split(",");
                    list = Arrays.asList((Object[])this.resolvePartitionWildcards((List<String>)JavaConversions$.MODULE$.asScalaBuffer(Arrays.asList((Object[])partitionColsToDelete)).toList(), jsc, hoodieConfig2, basePath.toString()).toArray(ClassTag$.MODULE$.apply(String.class)));
                } else {
                    RDD<GenericRecord> genericRecords = HoodieSparkUtils$.MODULE$.createRdd(df, avroRecordName2, avroRecordNamespace2);
                    list = genericRecords.map((Function1)new Serializable(keyGenerator){
                        public static final long serialVersionUID = 0L;
                        private final KeyGenerator keyGenerator$1;

                        public final String apply(GenericRecord gr) {
                            return this.keyGenerator$1.getKey(gr).getPartitionPath();
                        }
                        {
                            this.keyGenerator$1 = keyGenerator$1;
                        }
                    }, ClassTag$.MODULE$.apply(String.class)).toJavaRDD().distinct().collect();
                }
                java.util.List<Object> partitionsToDelete = list;
                HoodieTableMetaClient tableMetaClient2 = HoodieTableMetaClient.builder().setConf(sparkContext.hadoopConfiguration()).setBasePath(basePath.toString()).build();
                String schemaStr = new TableSchemaResolver(tableMetaClient2).getTableAvroSchema().toString();
                SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0)new Serializable(path, parameters2, tblName, jsc, schemaStr){
                    public static final long serialVersionUID = 0L;
                    private final String path$1;
                    private final scala.collection.immutable.Map parameters$1;
                    private final String tblName$1;
                    private final JavaSparkContext jsc$1;
                    private final String schemaStr$1;

                    public final SparkRDDWriteClient<Object> apply() {
                        return DataSourceUtils.createHoodieClient(this.jsc$1, this.schemaStr$1, this.path$1, this.tblName$1, JavaConversions$.MODULE$.mapAsJavaMap(this.parameters$1.$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key())));
                    }
                    {
                        this.path$1 = path$1;
                        this.parameters$1 = parameters$1;
                        this.tblName$1 = tblName$1;
                        this.jsc$1 = jsc$1;
                        this.schemaStr$1 = schemaStr$1;
                    }
                });
                client.startCommitWithTime(instantTime, commitActionType);
                HoodieWriteResult writeStatuses = DataSourceUtils.doDeletePartitionsOperation(client, partitionsToDelete, instantTime);
                tuple25 = new Tuple2((Object)writeStatuses, (Object)client);
            } else {
                Schema schema2;
                Boolean shouldDropPartitionColumns;
                Schema writerSchema = this.deduceWriterSchema(sourceSchema, latestTableSchemaOpt, (scala.Option<InternalSchema>)internalSchemaOpt, (scala.collection.immutable.Map<String, String>)parameters2);
                this.validateSchemaForHoodieIsDeleted(writerSchema);
                if (Predef$.MODULE$.Boolean2boolean(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER()))) {
                    WriteOperationType writeOperationType3 = operation;
                    WriteOperationType writeOperationType4 = WriteOperationType.BULK_INSERT;
                    if (!(writeOperationType3 != null ? !((Object)((Object)writeOperationType3)).equals((Object)writeOperationType4) : writeOperationType4 != null)) {
                        Tuple2 tuple29;
                        Tuple2<Object, Option<String>> tuple210 = this.bulkInsertAsRow(sqlContext, hoodieConfig2, df, tblName, basePath, path, instantTime, writerSchema, tableConfig.isTablePartitioned());
                        if (tuple210 == null) throw new MatchError(tuple210);
                        boolean success = tuple210._1$mcZ$sp();
                        Option commitTime = (Option)tuple210._2();
                        if (commitTime == null) throw new MatchError(tuple210);
                        Option option3 = commitTime;
                        Tuple2 tuple211 = tuple29 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)option3);
                        boolean success2 = tuple211._1$mcZ$sp();
                        Option commitTime2 = (Option)tuple211._2();
                        return new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)success2), (Object)commitTime2, Option.empty(), Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
                    }
                }
                if (Predef$.MODULE$.Boolean2boolean(shouldDropPartitionColumns = hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS()))) {
                    Schema truncatedSchema = this.generateSchemaWithoutPartitionColumns(partitionColumns, writerSchema);
                    this.registerAvroSchemasWithKryo(sparkContext, (Seq<Schema>)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{truncatedSchema}));
                    schema2 = truncatedSchema;
                } else {
                    schema2 = writerSchema;
                }
                Schema dataFileSchema = schema2;
                SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0)new Serializable(path, parameters2, tblName, jsc, internalSchemaOpt, writerSchema, dataFileSchema){
                    public static final long serialVersionUID = 0L;
                    private final String path$1;
                    private final scala.collection.immutable.Map parameters$1;
                    private final String tblName$1;
                    private final JavaSparkContext jsc$1;
                    private final scala.Option internalSchemaOpt$1;
                    private final Schema writerSchema$1;
                    private final Schema dataFileSchema$1;

                    public final SparkRDDWriteClient<Object> apply() {
                        scala.collection.immutable.Map finalOpts = (scala.collection.immutable.Map)HoodieSparkSqlWriter$.MODULE$.addSchemaEvolutionParameters((scala.collection.immutable.Map<String, String>)this.parameters$1, (scala.Option<InternalSchema>)this.internalSchemaOpt$1, (scala.Option<Schema>)new Some((Object)this.writerSchema$1)).$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key());
                        return DataSourceUtils.createHoodieClient(this.jsc$1, this.dataFileSchema$1.toString(), this.path$1, this.tblName$1, JavaConversions$.MODULE$.mapAsJavaMap((Map)finalOpts));
                    }
                    {
                        this.path$1 = path$1;
                        this.parameters$1 = parameters$1;
                        this.tblName$1 = tblName$1;
                        this.jsc$1 = jsc$1;
                        this.internalSchemaOpt$1 = internalSchemaOpt$1;
                        this.writerSchema$1 = writerSchema$1;
                        this.dataFileSchema$1 = dataFileSchema$1;
                    }
                });
                HoodieWriteConfig writeConfig = client.getConfig();
                HoodieRecord.HoodieRecordType hoodieRecordType = writeConfig.getRecordMerger().getRecordType();
                HoodieRecord.HoodieRecordType hoodieRecordType2 = HoodieRecord.HoodieRecordType.SPARK;
                if (!(hoodieRecordType != null ? !((Object)((Object)hoodieRecordType)).equals((Object)hoodieRecordType2) : hoodieRecordType2 != null)) {
                    HoodieTableType hoodieTableType = tableType;
                    HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
                    if (!(hoodieTableType != null ? !((Object)((Object)hoodieTableType)).equals((Object)hoodieTableType2) : hoodieTableType2 != null)) {
                        HoodieLogBlock.HoodieLogBlockType hoodieLogBlockType = writeConfig.getLogDataBlockFormat().orElse(HoodieLogBlock.HoodieLogBlockType.AVRO_DATA_BLOCK);
                        HoodieLogBlock.HoodieLogBlockType hoodieLogBlockType2 = HoodieLogBlock.HoodieLogBlockType.PARQUET_DATA_BLOCK;
                        if (hoodieLogBlockType == null ? hoodieLogBlockType2 != null : !((Object)((Object)hoodieLogBlockType)).equals((Object)hoodieLogBlockType2)) {
                            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " only support parquet log."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{writeConfig.getRecordMerger().getClass().getName()})));
                        }
                    }
                }
                JavaRDD<HoodieRecord<?>> hoodieRecords = this.createHoodieRecordRdd(df, writeConfig, (scala.collection.immutable.Map<String, String>)parameters2, avroRecordName2, avroRecordNamespace2, writerSchema, dataFileSchema, operation);
                Object object3 = this.isAsyncCompactionEnabled(client, tableConfig, (scala.collection.immutable.Map<String, String>)parameters2, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                object3 = this.isAsyncClusteringEnabled(client, (scala.collection.immutable.Map<String, String>)parameters2) ? ((Function1)asyncClusteringTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                JavaRDD<HoodieRecord<?>> dedupedHoodieRecords = Predef$.MODULE$.Boolean2boolean(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS())) ? DataSourceUtils.dropDuplicates(jsc, hoodieRecords, JavaConversions$.MODULE$.mapAsJavaMap((Map)parameters2)) : hoodieRecords;
                client.startCommitWithTime(instantTime, commitActionType);
                HoodieWriteResult writeResult = DataSourceUtils.doWriteOperation(client, dedupedHoodieRecords, instantTime, operation);
                tuple25 = new Tuple2((Object)writeResult, (Object)client);
            }
            Tuple2 tuple212 = tuple25;
            if (tuple212 == null) throw new MatchError((Object)tuple212);
            HoodieWriteResult writeResult = (HoodieWriteResult)tuple212._1();
            SparkRDDWriteClient writeClient2 = (SparkRDDWriteClient)tuple212._2();
            if (writeClient2 == null) throw new MatchError((Object)tuple212);
            SparkRDDWriteClient sparkRDDWriteClient = writeClient2;
            Tuple2 tuple213 = tuple24 = new Tuple2((Object)writeResult, (Object)sparkRDDWriteClient);
            HoodieWriteResult writeResult2 = (HoodieWriteResult)tuple213._1();
            writeClient = (SparkRDDWriteClient)tuple213._2();
            Tuple3<Object, Option<String>, Option<String>> tuple32 = this.commitAndPerformPostOperations(sqlContext.sparkSession(), df.schema(), writeResult2, (scala.collection.immutable.Map<String, String>)parameters2, writeClient, tableConfig, jsc, new HoodieSparkSqlWriter.TableInstantInfo(basePath, instantTime, commitActionType, operation), extraPreCommitFn);
            if (tuple32 == null) throw new MatchError(tuple32);
            boolean writeSuccessful = BoxesRunTime.unboxToBoolean((Object)tuple32._1());
            Option compactionInstant = (Option)tuple32._2();
            Option clusteringInstant = (Option)tuple32._3();
            Tuple3 tuple33 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful), (Object)compactionInstant, (Object)clusteringInstant);
            boolean writeSuccessful2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
            Option compactionInstant2 = (Option)tuple33._2();
            Option clusteringInstant2 = (Option)tuple33._3();
            tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful2), Option.ofNullable(instantTime), (Object)compactionInstant2, (Object)clusteringInstant2, (Object)writeClient, (Object)tableConfig);
        }
        return tuple6;
        finally {
            boolean asyncCompactionEnabled = this.isAsyncCompactionEnabled(writeClient, tableConfig, (scala.collection.immutable.Map<String, String>)parameters2, jsc.hadoopConfiguration());
            boolean asyncClusteringEnabled = this.isAsyncClusteringEnabled(writeClient, (scala.collection.immutable.Map<String, String>)parameters2);
            if (!asyncCompactionEnabled && !asyncClusteringEnabled) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)"Closing write client");
                writeClient.close();
            }
        }
    }

    public scala.Option<HoodieTableConfig> write$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<?>> write$default$6() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>> write$default$7() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<Function1<SparkRDDWriteClient<?>, BoxedUnit>> write$default$8() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> write$default$9() {
        return Option$.MODULE$.empty();
    }

    public Schema deduceWriterSchema(Schema sourceSchema, scala.Option<Schema> latestTableSchemaOpt, scala.Option<InternalSchema> internalSchemaOpt, scala.collection.immutable.Map<String, String> opts) {
        scala.Option<Schema> option2;
        block6: {
            Schema canonicalizedSourceSchema;
            Schema latestTableSchema;
            block16: {
                Schema schema2;
                block5: {
                    Schema schema3;
                    block12: {
                        boolean allowAutoEvolutionColumnDrop;
                        block14: {
                            block15: {
                                boolean shouldValidateSchemasCompatibility;
                                block13: {
                                    boolean mergeIntoWrites;
                                    block7: {
                                        scala.Option<InternalSchema> option3;
                                        block10: {
                                            Tuple2<Schema, Object> tuple2;
                                            block11: {
                                                Schema schema4;
                                                block9: {
                                                    Tuple2 tuple22;
                                                    block8: {
                                                        boolean shouldReconcileSchema;
                                                        block4: {
                                                            shouldReconcileSchema = new StringOps(Predef$.MODULE$.augmentString((String)opts.apply((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key()))).toBoolean();
                                                            shouldValidateSchemasCompatibility = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.mapAsJavaMap(opts).getOrDefault(HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.key(), HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.defaultValue()))).toBoolean();
                                                            option2 = latestTableSchemaOpt;
                                                            if (!None$.MODULE$.equals(option2)) break block4;
                                                            schema2 = sourceSchema;
                                                            break block5;
                                                        }
                                                        if (!(option2 instanceof Some)) break block6;
                                                        Some some = (Some)option2;
                                                        Schema latestTableSchemaWithMetaFields = (Schema)some.x();
                                                        latestTableSchema = HoodieAvroUtils.removeMetadataFields(latestTableSchemaWithMetaFields);
                                                        boolean shouldCanonicalizeNullable = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.mapAsJavaMap(opts).getOrDefault(this.CANONICALIZE_NULLABLE().key(), this.CANONICALIZE_NULLABLE().defaultValue().toString()))).toBoolean();
                                                        mergeIntoWrites = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.mapAsJavaMap(opts).getOrDefault(this.SQL_MERGE_INTO_WRITES().key(), this.SQL_MERGE_INTO_WRITES().defaultValue().toString()))).toBoolean();
                                                        canonicalizedSourceSchema = shouldCanonicalizeNullable ? AvroSchemaEvolutionUtils.canonicalizeColumnNullability(sourceSchema, latestTableSchema) : sourceSchema;
                                                        allowAutoEvolutionColumnDrop = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.mapAsJavaMap(opts).getOrDefault(HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.key(), HoodieWriteConfig.SCHEMA_ALLOW_AUTO_EVOLUTION_COLUMN_DROP.defaultValue()))).toBoolean();
                                                        if (!shouldReconcileSchema) break block7;
                                                        option3 = internalSchemaOpt;
                                                        if (!(option3 instanceof Some)) break block8;
                                                        Some some2 = (Some)option3;
                                                        InternalSchema internalSchema = (InternalSchema)some2.x();
                                                        InternalSchema mergedInternalSchema = AvroSchemaEvolutionUtils.reconcileSchema(canonicalizedSourceSchema, internalSchema);
                                                        Schema evolvedSchema = AvroInternalSchemaConverter.convert(mergedInternalSchema, latestTableSchema.getFullName());
                                                        boolean shouldRemoveMetaDataFromInternalSchema = ((SeqLike)JavaConversions$.MODULE$.asScalaBuffer(sourceSchema.getFields()).filter((Function1)new Serializable(){
                                                            public static final long serialVersionUID = 0L;

                                                            public final boolean apply(Schema.Field f) {
                                                                return f.name().equalsIgnoreCase(HoodieRecord.RECORD_KEY_METADATA_FIELD);
                                                            }
                                                        })).isEmpty();
                                                        schema4 = shouldRemoveMetaDataFromInternalSchema ? HoodieAvroUtils.removeMetadataFields(evolvedSchema) : evolvedSchema;
                                                        break block9;
                                                    }
                                                    if (!None$.MODULE$.equals(option3)) break block10;
                                                    tuple2 = this.reconcileSchemasLegacy(latestTableSchema, canonicalizedSourceSchema);
                                                    if (tuple2 == null) break block11;
                                                    Schema reconciledSchema = (Schema)tuple2._1();
                                                    boolean isCompatible = tuple2._2$mcZ$sp();
                                                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)reconciledSchema, (Object)BoxesRunTime.boxToBoolean((boolean)isCompatible));
                                                    Schema reconciledSchema2 = (Schema)tuple23._1();
                                                    boolean isCompatible2 = tuple23._2$mcZ$sp();
                                                    if (shouldValidateSchemasCompatibility && !isCompatible2) {
                                                        this.org$apache$hudi$HoodieSparkSqlWriter$$log().error((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to reconcile incoming batch schema with the table's one.\n                     |Incoming schema ", "\n                     |Incoming schema (canonicalized) ", "\n                     |Table's schema ", "\n                     |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceSchema.toString(true), canonicalizedSourceSchema.toString(true), latestTableSchema.toString(true)})))).stripMargin());
                                                        throw new SchemaCompatibilityException("Failed to reconcile incoming schema with the table's one");
                                                    }
                                                    schema4 = reconciledSchema2;
                                                }
                                                schema3 = schema4;
                                                break block12;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        throw new MatchError(option3);
                                    }
                                    if (!mergeIntoWrites) break block13;
                                    schema3 = canonicalizedSourceSchema;
                                    break block12;
                                }
                                if (!shouldValidateSchemasCompatibility) break block14;
                                if (!AvroSchemaUtils.isSchemaCompatible(latestTableSchema, canonicalizedSourceSchema, allowAutoEvolutionColumnDrop)) break block15;
                                schema3 = canonicalizedSourceSchema;
                                break block12;
                            }
                            this.org$apache$hudi$HoodieSparkSqlWriter$$log().error((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incoming batch schema is not compatible with the table's one.\n                   |Incoming schema ", "\n                   |Incoming schema (canonicalized) ", "\n                   |Table's schema ", "\n                   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceSchema.toString(true), canonicalizedSourceSchema.toString(true), latestTableSchema.toString(true)})))).stripMargin());
                            throw new SchemaCompatibilityException("Incoming batch schema is not compatible with the table's one");
                        }
                        if (!allowAutoEvolutionColumnDrop && !AvroSchemaUtils.canProject(latestTableSchema, canonicalizedSourceSchema)) break block16;
                        schema3 = canonicalizedSourceSchema;
                    }
                    schema2 = schema3;
                }
                return schema2;
            }
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().error((Object)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incoming batch schema is not compatible with the table's one.\n                   |Incoming schema ", "\n                   |Incoming schema (canonicalized) ", "\n                   |Table's schema ", "\n                   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceSchema.toString(true), canonicalizedSourceSchema.toString(true), latestTableSchema.toString(true)})))).stripMargin());
            throw new SchemaCompatibilityException("Incoming batch schema is not compatible with the table's one");
        }
        throw new MatchError(option2);
    }

    private List<String> resolvePartitionWildcards(List<String> partitions, JavaSparkContext jsc, HoodieConfig cfg, String basePath) {
        Tuple2 tuple2 = partitions.partition((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String partition) {
                return partition.contains("*");
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            List wildcardPartitions = (List)tuple2._1();
            List fullPartitions = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)wildcardPartitions, (Object)fullPartitions);
            List wildcardPartitions2 = (List)tuple23._1();
            ObjectRef fullPartitions2 = ObjectRef.create((Object)((List)tuple23._2()));
            if (wildcardPartitions2.nonEmpty()) {
                java.util.List<String> allPartitions = FSUtils.getAllPartitionPaths(new HoodieSparkEngineContext(jsc), HoodieMetadataConfig.newBuilder().fromProperties(cfg.getProps()).build(), basePath);
                wildcardPartitions2.foreach((Function1)new Serializable(fullPartitions2, allPartitions){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef fullPartitions$1;
                    private final java.util.List allPartitions$1;

                    public final void apply(String partition) {
                        String regexPartition = new StringBuilder().append((Object)"^\\Q").append((Object)partition.replace("*", "\\E.*\\Q")).append((Object)"\\E$").toString();
                        this.fullPartitions$1.elem = (List)List$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Traversable[]{(List)this.fullPartitions$1.elem, (Traversable)JavaConversions$.MODULE$.asScalaBuffer(this.allPartitions$1).filter((Function1)new Serializable(this, regexPartition){
                            public static final long serialVersionUID = 0L;
                            private final String regexPartition$1;

                            public final boolean apply(String x$9) {
                                return x$9.matches(this.regexPartition$1);
                            }
                            {
                                this.regexPartition$1 = regexPartition$1;
                            }
                        })}));
                    }
                    {
                        this.fullPartitions$1 = fullPartitions$1;
                        this.allPartitions$1 = allPartitions$1;
                    }
                });
            }
            return (List)((List)fullPartitions2.elem).distinct();
        }
        throw new MatchError((Object)tuple2);
    }

    public Seq<String> getPartitionColumns(String partitionParam) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitionParam.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String partitionField) {
                return partitionField.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$10) {
                return new StringOps(Predef$.MODULE$.augmentString(x$10)).nonEmpty();
            }
        })).toSeq();
    }

    public Schema generateSchemaWithoutPartitionColumns(String partitionParam, Schema schema2) {
        Seq<String> partitionColumns = this.getPartitionColumns(partitionParam);
        return HoodieAvroUtils.removeFields(schema2, (java.util.Set<String>)((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)partitionColumns.toSet()).asJava()));
    }

    public scala.collection.immutable.Map<String, String> addSchemaEvolutionParameters(scala.collection.immutable.Map<String, String> parameters, scala.Option<InternalSchema> internalSchemaOpt, scala.Option<Schema> writeSchemaOpt) {
        String schemaEvolutionEnabled = internalSchemaOpt.isDefined() ? "true" : "false";
        boolean schemaReconciliationEnabled = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.mapAsJavaMap(parameters).getOrDefault(DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key(), DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().defaultValue().toString()))).toBoolean();
        None$ schemaValidationEnabledOpt = new StringOps(Predef$.MODULE$.augmentString(schemaEvolutionEnabled)).toBoolean() && schemaReconciliationEnabled ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)) : None$.MODULE$;
        scala.Option correctInternalSchema = internalSchemaOpt.map((Function1)new Serializable(parameters, writeSchemaOpt){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map parameters$2;
            private final scala.Option writeSchemaOpt$1;

            public final InternalSchema apply(InternalSchema internalSchema) {
                InternalSchema internalSchema2;
                if (internalSchema.findField(HoodieRecord.RECORD_KEY_METADATA_FIELD) == null && this.writeSchemaOpt$1.isDefined()) {
                    boolean allowOperationMetaDataField = new StringOps(Predef$.MODULE$.augmentString((String)this.parameters$2.getOrElse((Object)HoodieWriteConfig.ALLOW_OPERATION_METADATA_FIELD.key(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "false";
                        }
                    }))).toBoolean();
                    internalSchema2 = AvroInternalSchemaConverter.convert(HoodieAvroUtils.addMetadataFields((Schema)this.writeSchemaOpt$1.get(), allowOperationMetaDataField));
                } else {
                    internalSchema2 = internalSchema;
                }
                return internalSchema2;
            }
            {
                this.parameters$2 = parameters$2;
                this.writeSchemaOpt$1 = writeSchemaOpt$1;
            }
        });
        return parameters.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.INTERNAL_SCHEMA_STRING.key()), (Object)SerDeHelper.toJson((InternalSchema)correctInternalSchema.orNull(Predef$.MODULE$.$conforms()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key()), (Object)schemaEvolutionEnabled)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(schemaValidationEnabledOpt.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(boolean x$11) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.AVRO_SCHEMA_VALIDATE_ENABLE.key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)x$11)).toString());
            }
        })).toSeq());
    }

    public scala.Option<Schema> addSchemaEvolutionParameters$default$3() {
        return None$.MODULE$;
    }

    private Tuple2<Schema, Object> reconcileSchemasLegacy(Schema tableSchema, Schema newSchema) {
        return AvroSchemaUtils.isCompatibleProjectionOf(tableSchema, newSchema) ? new Tuple2((Object)tableSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible(newSchema, tableSchema, true))) : new Tuple2((Object)newSchema, (Object)BoxesRunTime.boxToBoolean((boolean)AvroSchemaUtils.isSchemaCompatible(tableSchema, newSchema, true)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public scala.Option<InternalSchema> getLatestTableInternalSchema(HoodieConfig config, HoodieTableMetaClient tableMetaClient) {
        scala.Option option2;
        if (!config.getBooleanOrDefault(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED())) {
            option2 = Option$.MODULE$.empty();
            return option2;
        }
        try {
            TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
            Option<InternalSchema> internalSchemaOpt = tableSchemaResolver.getTableInternalSchemaFromCommitMetadata();
            if (internalSchemaOpt.isPresent()) {
                option2 = new Some((Object)internalSchemaOpt.get());
                return option2;
            }
            option2 = None$.MODULE$;
            return option2;
        }
        catch (Exception exception) {
            option2 = None$.MODULE$;
        }
        return option2;
    }

    private void registerAvroSchemasWithKryo(SparkContext sparkContext, Seq<Schema> targetAvroSchemas) {
        sparkContext.getConf().registerAvroSchemas(targetAvroSchemas);
    }

    private scala.Option<Schema> getLatestTableSchema(SparkSession spark, TableIdentifier tableId, HoodieTableMetaClient tableMetaClient) {
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
        scala.Option<Schema> latestTableSchemaFromCommitMetadata = HoodieConversionUtils$.MODULE$.toScalaOption(tableSchemaResolver.getTableAvroSchemaFromLatestCommit(false));
        return latestTableSchemaFromCommitMetadata.orElse((Function0)new Serializable(spark, tableId){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            public final TableIdentifier tableId$1;

            public final scala.Option<Schema> apply() {
                return HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$getCatalogTable(this.spark$1, this.tableId$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getLatestTableSchema.1 $outer;

                    public final Schema apply(CatalogTable catalogTable) {
                        Tuple2<String, String> tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.$outer.tableId$1.table());
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            String structName = (String)tuple2._1();
                            String namespace = (String)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)structName, (Object)namespace);
                            String structName2 = (String)tuple23._1();
                            String namespace2 = (String)tuple23._2();
                            return AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)catalogTable.schema(), structName2, namespace2);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.spark$1 = spark$1;
                this.tableId$1 = tableId$1;
            }
        });
    }

    public scala.Option<CatalogTable> org$apache$hudi$HoodieSparkSqlWriter$$getCatalogTable(SparkSession spark, TableIdentifier tableId) {
        return spark.sessionState().catalog().tableExists(tableId) ? new Some((Object)spark.sessionState().catalog().getTableMetadata(tableId)) : None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean bootstrap(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> optParams, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<?>> hoodieWriteClient) {
        boolean metaSyncSuccess;
        Object object;
        Tuple2 tuple2;
        Predef$.MODULE$.assert(optParams.get((Object)"path").exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$13) {
                return !StringUtils.isNullOrEmpty(x$13);
            }
        }), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "'path' must be set";
            }
        });
        String path = (String)optParams.apply((Object)"path");
        Path basePath = new Path(path);
        SparkContext sparkContext = sqlContext.sparkContext();
        FileSystem fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
        this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
        HoodieTableConfig tableConfig = this.getHoodieTableConfig(sparkContext, path, hoodieTableConfigOpt);
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Overwrite;
        HoodieWriterUtils$.MODULE$.validateTableConfig(sqlContext.sparkSession(), optParams, tableConfig, !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null));
        Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> tuple22 = this.mergeParamsAndGetHoodieConfig(optParams, tableConfig, mode);
        if (tuple22 == null) throw new MatchError(tuple22);
        scala.collection.immutable.Map parameters = (scala.collection.immutable.Map)tuple22._1();
        HoodieConfig hoodieConfig = (HoodieConfig)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)parameters, (Object)hoodieConfig);
        scala.collection.immutable.Map parameters2 = (scala.collection.immutable.Map)tuple23._1();
        HoodieConfig hoodieConfig2 = (HoodieConfig)tuple23._2();
        String tableName = hoodieConfig2.getStringOrThrow(HoodieWriteConfig.TBL_NAME, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' must be set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieWriteConfig.TBL_NAME.key()})));
        String tableType = hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.TABLE_TYPE());
        String bootstrapBasePath = hoodieConfig2.getStringOrThrow(HoodieBootstrapConfig.BASE_PATH, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is required for '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HoodieBootstrapConfig.BASE_PATH.key(), DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()}))).append((Object)" operation'").toString());
        String bootstrapIndexClass = hoodieConfig2.getStringOrDefault(HoodieBootstrapConfig.INDEX_CLASS_NAME);
        ObjectRef schema2 = ObjectRef.create(null);
        if (df.schema().nonEmpty()) {
            Tuple2 tuple24;
            Tuple2<String, String> tuple25 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tableName);
            if (tuple25 == null) throw new MatchError(tuple25);
            String structName = (String)tuple25._1();
            String namespace = (String)tuple25._2();
            Tuple2 tuple26 = tuple24 = new Tuple2((Object)structName, (Object)namespace);
            String structName2 = (String)tuple26._1();
            String namespace2 = (String)tuple26._2();
            schema2.elem = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df.schema(), structName2, namespace2).toString();
        } else {
            schema2.elem = HoodieAvroUtils.getNullSchema().toString();
        }
        SaveMode saveMode3 = mode;
        SaveMode saveMode4 = SaveMode.Ignore;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && this.tableExists()) {
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists. Ignoring & not performing actual writes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
            if (hoodieWriteClient.isEmpty()) return false;
            ((BaseHoodieWriteClient)hoodieWriteClient.get()).close();
            return false;
        }
        this.handleSaveModes(sqlContext.sparkSession(), mode, basePath, tableConfig, tableName, WriteOperationType.BOOTSTRAP, fs);
        if (this.tableExists()) {
            object = BoxedUnit.UNIT;
        } else {
            String archiveLogFolder = hoodieConfig2.getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER);
            String partitionColumns = HoodieWriterUtils$.MODULE$.getPartitionColumns((scala.collection.immutable.Map<String, String>)parameters2);
            String recordKeyFields = hoodieConfig2.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD());
            String keyGenProp = StringUtils.nonEmpty(hoodieConfig2.getString(HoodieBootstrapConfig.KEYGEN_CLASS_NAME)) ? hoodieConfig2.getString(HoodieBootstrapConfig.KEYGEN_CLASS_NAME) : hoodieConfig2.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME);
            scala.collection.immutable.Map<String, String> timestampKeyGeneratorConfigs = this.extractConfigsRelatedToTimestampBasedKeyGenerator(keyGenProp, (scala.collection.immutable.Map<String, String>)parameters2);
            boolean populateMetaFields = Boolean.parseBoolean((String)parameters2.getOrElse((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return String.valueOf(HoodieTableConfig.POPULATE_META_FIELDS.defaultValue());
                }
            }));
            String baseFileFormat = hoodieConfig2.getStringOrDefault(HoodieTableConfig.BASE_FILE_FORMAT);
            boolean useBaseFormatMetaFile = Boolean.parseBoolean((String)parameters2.getOrElse((Object)HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.key(), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return String.valueOf(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.defaultValue());
                }
            }));
            object = HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.valueOf(tableType)).setTableName(tableName).setRecordKeyFields(recordKeyFields).setArchiveLogFolder(archiveLogFolder).setPayloadClassName(hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME())).setPreCombineField(hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD(), null)).setBootstrapIndexClass(bootstrapIndexClass).setBaseFileFormat(baseFileFormat).setBootstrapBasePath(bootstrapBasePath).setPartitionFields(partitionColumns).setCDCEnabled(hoodieConfig2.getBooleanOrDefault(HoodieTableConfig.CDC_ENABLED)).setCDCSupplementalLoggingMode(hoodieConfig2.getStringOrDefault(HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE)).setPopulateMetaFields(populateMetaFields).setKeyGeneratorClassProp(keyGenProp).set(JavaConversions$.MODULE$.mapAsJavaMap(timestampKeyGeneratorConfigs)).setHiveStylePartitioningEnable(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING())).setUrlEncodePartitioning(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING())).setCommitTimezone(HoodieTimelineTimeZone.valueOf(hoodieConfig2.getStringOrDefault(HoodieTableConfig.TIMELINE_TIMEZONE))).setPartitionMetafileUseBaseFormat(Predef$.MODULE$.boolean2Boolean(useBaseFormatMetaFile)).initTable(sparkContext.hadoopConfiguration(), path);
        }
        JavaSparkContext jsc = new JavaSparkContext(sqlContext.sparkContext());
        SparkRDDWriteClient writeClient = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0)new Serializable(path, parameters2, tableName, schema2, jsc){
            public static final long serialVersionUID = 0L;
            private final String path$2;
            private final scala.collection.immutable.Map parameters$5;
            private final String tableName$1;
            private final ObjectRef schema$1;
            private final JavaSparkContext jsc$2;

            public final SparkRDDWriteClient<Object> apply() {
                return DataSourceUtils.createHoodieClient(this.jsc$2, (String)this.schema$1.elem, this.path$2, this.tableName$1, JavaConversions$.MODULE$.mapAsJavaMap((Map)this.parameters$5));
            }
            {
                this.path$2 = path$2;
                this.parameters$5 = parameters$5;
                this.tableName$1 = tableName$1;
                this.schema$1 = schema$1;
                this.jsc$2 = jsc$2;
            }
        });
        try {
            writeClient.bootstrap(Option.empty());
        }
        catch (Throwable throwable) {
            void var42_42;
            var42_42.close();
            throw throwable;
        }
        writeClient.close();
        boolean bl = metaSyncSuccess = this.metaSync(sqlContext.sparkSession(), hoodieConfig2, basePath, df.schema());
        return bl;
    }

    public scala.Option<HoodieTableConfig> bootstrap$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<?>> bootstrap$default$6() {
        return Option$.MODULE$.empty();
    }

    public void validateSchemaForHoodieIsDeleted(Schema schema2) {
        block3: {
            block2: {
                if (schema2.getField("_hoodie_is_deleted") == null) break block2;
                Schema.Type type = ((Schema)AvroConversionUtils$.MODULE$.resolveAvroTypeNullability(schema2.getField("_hoodie_is_deleted").schema())._2()).getType();
                Schema.Type type2 = Schema.Type.BOOLEAN;
                if (type != null ? !type.equals(type2) : type2 != null) break block3;
            }
            return;
        }
        throw new HoodieException(new StringBuilder().append((Object)"_hoodie_is_deleted has to be BOOLEAN type. Passed in dataframe's schema has type ").append((Object)schema2.getField("_hoodie_is_deleted").schema().getType()).toString());
    }

    public Tuple2<Object, Option<String>> bulkInsertAsRow(SQLContext sqlContext, HoodieConfig hoodieConfig, Dataset<Row> df, String tblName, Path basePath, String path, String instantTime, Schema writerSchema, boolean isTablePartitioned) {
        block7: {
            Tuple2 tuple2;
            scala.collection.immutable.Map optsOverrides;
            Dataset<Row> hoodieDF;
            HoodieWriteConfig writeConfig;
            scala.collection.immutable.Map opts;
            block6: {
                Tuple2 tuple22;
                block5: {
                    Option<BulkInsertPartitioner<Dataset<Row>>> userDefinedBulkInsertPartitionerOpt;
                    if (Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()))) {
                        throw new HoodieException("Dropping duplicates with bulk_insert in row writer path is not supported yet");
                    }
                    String writerSchemaStr = writerSchema.toString();
                    opts = JavaConversions$.MODULE$.propertiesAsScalaMap((Properties)hoodieConfig.getProps()).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.AVRO_SCHEMA_STRING.key()), (Object)writerSchemaStr)})));
                    writeConfig = DataSourceUtils.createHoodieConfig(writerSchemaStr, path, tblName, JavaConversions$.MODULE$.mapAsJavaMap((Map)opts));
                    Boolean populateMetaFields = hoodieConfig.getBoolean(HoodieTableConfig.POPULATE_META_FIELDS);
                    NonSortPartitionerWithRows bulkInsertPartitionerRows = Predef$.MODULE$.Boolean2boolean(populateMetaFields) ? ((userDefinedBulkInsertPartitionerOpt = DataSourceUtils.createUserDefinedBulkInsertPartitionerWithRows(writeConfig)).isPresent() ? userDefinedBulkInsertPartitionerOpt.get() : BulkInsertInternalPartitionerWithRowsFactory.get(writeConfig, isTablePartitioned)) : new NonSortPartitionerWithRows();
                    Boolean shouldDropPartitionColumns = hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS());
                    hoodieDF = HoodieDatasetBulkInsertHelper$.MODULE$.prepareForBulkInsert(df, writeConfig, bulkInsertPartitionerRows, Predef$.MODULE$.Boolean2boolean(shouldDropPartitionColumns));
                    optsOverrides = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.bulkinsert.are.partitioner.records.sorted"), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)bulkInsertPartitionerRows.arePartitionRecordsSorted())).toString())}));
                    if (!HoodieSparkUtils$.MODULE$.isSpark2()) break block5;
                    tuple22 = new Tuple2((Object)"org.apache.hudi.internal", (Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                    break block6;
                }
                if (!HoodieSparkUtils$.MODULE$.isSpark3()) break block7;
                tuple22 = tuple2 = new Tuple2((Object)"org.apache.hudi.spark3.internal", (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieInternalConfig.BULKINSERT_INPUT_DATA_SCHEMA_DDL.key()), (Object)hoodieDF.schema().json())})));
            }
            if (tuple2 != null) {
                Tuple2 tuple23;
                String targetFormat = (String)tuple2._1();
                scala.collection.immutable.Map customOpts = (scala.collection.immutable.Map)tuple2._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)targetFormat, (Object)customOpts);
                String targetFormat2 = (String)tuple24._1();
                scala.collection.immutable.Map customOpts2 = (scala.collection.immutable.Map)tuple24._2();
                hoodieDF.write().format(targetFormat2).option("hoodie.instant.time", instantTime).options((Map)opts.$plus$plus((GenTraversableOnce)customOpts2).$plus$plus((GenTraversableOnce)optsOverrides)).mode(SaveMode.Append).save();
                boolean syncHiveSuccess = this.metaSync(sqlContext.sparkSession(), writeConfig, basePath, df.schema());
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)syncHiveSuccess), Option.ofNullable(instantTime));
            }
            throw new MatchError((Object)tuple2);
        }
        throw new HoodieException("Bulk insert using row writer is not supported with current Spark version. To use row writer please switch to spark 2 or spark 3");
    }

    public void cleanup() {
        Metrics.shutdown();
    }

    private void handleSaveModes(SparkSession spark, SaveMode mode, Path tablePath, HoodieTableConfig tableConfig, String tableName, WriteOperationType operation, FileSystem fs) {
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Append;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && this.tableExists()) {
            String existingTableName = tableConfig.getTableName();
            Function2 resolver2 = spark.sessionState().conf().resolver();
            if (!BoxesRunTime.unboxToBoolean((Object)resolver2.apply((Object)existingTableName, (Object)tableName))) {
                throw new HoodieException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table with name ", " already exists at ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{existingTableName, tablePath}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" can not append data to the table with another name ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).toString());
            }
        }
        WriteOperationType writeOperationType = operation;
        WriteOperationType writeOperationType2 = WriteOperationType.DELETE;
        if (!(writeOperationType != null ? !((Object)((Object)writeOperationType)).equals((Object)writeOperationType2) : writeOperationType2 != null)) {
            SaveMode saveMode3 = mode;
            SaveMode saveMode4 = SaveMode.Append;
            if (saveMode3 == null ? saveMode4 != null : !saveMode3.equals(saveMode4)) {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Append is the only save mode applicable for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation.toString()})));
            }
        } else {
            SaveMode saveMode5 = mode;
            SaveMode saveMode6 = SaveMode.ErrorIfExists;
            if (!(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null) && this.tableExists()) {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tablePath})));
            }
            SaveMode saveMode7 = mode;
            SaveMode saveMode8 = SaveMode.Overwrite;
            if (!(saveMode7 != null ? !saveMode7.equals(saveMode8) : saveMode8 != null) && this.tableExists()) {
                WriteOperationType writeOperationType3 = operation;
                WriteOperationType writeOperationType4 = WriteOperationType.INSERT_OVERWRITE_TABLE;
                if (writeOperationType3 == null ? writeOperationType4 != null : !((Object)((Object)writeOperationType3)).equals((Object)writeOperationType4)) {
                    this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists. Deleting existing data & overwriting with new data."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tablePath})));
                    fs.delete(tablePath, true);
                    this.tableExists_$eq(false);
                }
            }
        }
    }

    private boolean metaSync(SparkSession spark, HoodieConfig hoodieConfig, Path basePath, StructType schema2) {
        BoxedUnit boxedUnit;
        boolean hiveSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(HiveSyncConfigHolder.HIVE_SYNC_ENABLED))).toBoolean();
        boolean metaSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(HoodieSyncConfig.META_SYNC_ENABLED))).toBoolean();
        ObjectRef syncClientToolClassSet = ObjectRef.create((Object)((scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Predef$.MODULE$.refArrayOps((Object[])hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.META_SYNC_CLIENT_TOOL_CLASS_NAME()).split(",")).foreach((Function1)new Serializable(syncClientToolClassSet){
            public static final long serialVersionUID = 0L;
            private final ObjectRef syncClientToolClassSet$1;

            public final scala.collection.mutable.Set<String> apply(String syncClass) {
                return (scala.collection.mutable.Set)((scala.collection.mutable.Set)this.syncClientToolClassSet$1.elem).$plus$eq((Object)syncClass);
            }
            {
                this.syncClientToolClassSet$1 = syncClientToolClassSet$1;
            }
        });
        if (hiveSyncEnabled) {
            metaSyncEnabled = true;
            boxedUnit = ((scala.collection.mutable.Set)syncClientToolClassSet.elem).$plus$eq((Object)HiveSyncTool.class.getName());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (metaSyncEnabled) {
            FileSystem fs = basePath.getFileSystem(spark.sessionState().newHadoopConf());
            String baseFileFormat = hoodieConfig.getStringOrDefault(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT);
            TypedProperties properties = new TypedProperties();
            properties.putAll((java.util.Map<?, ?>)hoodieConfig.getProps());
            properties.put(HiveSyncConfigHolder.HIVE_SYNC_SCHEMA_STRING_LENGTH_THRESHOLD.key(), spark.sessionState().conf().getConf(StaticSQLConf$.MODULE$.SCHEMA_STRING_LENGTH_THRESHOLD()).toString());
            properties.put(HoodieSyncConfig.META_SYNC_SPARK_VERSION.key(), package$.MODULE$.SPARK_VERSION());
            properties.put(HoodieSyncConfig.META_SYNC_USE_FILE_LISTING_FROM_METADATA.key(), hoodieConfig.getBoolean(HoodieMetadataConfig.ENABLE));
            ListBuffer metaSyncExceptions = new ListBuffer();
            ((scala.collection.mutable.Set)syncClientToolClassSet.elem).foreach((Function1)new Serializable(basePath, fs, baseFileFormat, properties, metaSyncExceptions){
                public static final long serialVersionUID = 0L;
                private final Path basePath$1;
                private final FileSystem fs$1;
                private final String baseFileFormat$1;
                private final TypedProperties properties$1;
                private final ListBuffer metaSyncExceptions$1;

                public final Object apply(String impl) {
                    Object object;
                    try {
                        SyncUtilHelpers.runHoodieMetaSync(impl.trim(), this.properties$1, this.fs$1.getConf(), this.fs$1, this.basePath$1.toString(), this.baseFileFormat$1);
                        object = BoxedUnit.UNIT;
                    }
                    catch (HoodieException hoodieException) {
                        HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"SyncTool class ").append((Object)impl.trim()).append((Object)" failed with exception").toString(), (Throwable)hoodieException);
                        object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.metaSyncExceptions$1).add(hoodieException));
                    }
                    return object;
                }
                {
                    this.basePath$1 = basePath$1;
                    this.fs$1 = fs$1;
                    this.baseFileFormat$1 = baseFileFormat$1;
                    this.properties$1 = properties$1;
                    this.metaSyncExceptions$1 = metaSyncExceptions$1;
                }
            });
            if (metaSyncExceptions.nonEmpty()) {
                throw SyncUtilHelpers.getExceptionFromList(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)metaSyncExceptions));
            }
        }
        if (metaSyncEnabled) {
            this.getHiveTableNames(hoodieConfig).foreach((Function1)new Serializable(spark, hoodieConfig){
                public static final long serialVersionUID = 0L;
                private final SparkSession spark$2;
                private final HoodieConfig hoodieConfig$2;

                public final void apply(String name) {
                    String qualifiedTableName = String.join((CharSequence)".", this.hoodieConfig$2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_DATABASE()), name);
                    if (this.spark$2.catalog().tableExists(qualifiedTableName)) {
                        this.spark$2.catalog().refreshTable(qualifiedTableName);
                    }
                }
                {
                    this.spark$2 = spark$2;
                    this.hoodieConfig$2 = hoodieConfig$2;
                }
            });
        }
        return true;
    }

    private List<String> getHiveTableNames(HoodieConfig hoodieConfig) {
        List list;
        String tableName = hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_TABLE());
        String tableType = hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.TABLE_TYPE());
        if (tableType.equals(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL())) {
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}));
        } else {
            String roSuffix = hoodieConfig.getBooleanOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE()) ? "" : "_ro";
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)tableName).append((Object)roSuffix).toString(), new StringBuilder().append((Object)tableName).append((Object)"_rt").toString()}));
        }
        return list;
    }

    private Tuple3<Object, Option<String>, Option<String>> commitAndPerformPostOperations(SparkSession spark, StructType schema2, HoodieWriteResult writeResult, scala.collection.immutable.Map<String, String> parameters, SparkRDDWriteClient<?> client, HoodieTableConfig tableConfig, JavaSparkContext jsc, HoodieSparkSqlWriter.TableInstantInfo tableInstantInfo, scala.Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFn) {
        Tuple3 tuple3;
        if (writeResult.getWriteStatuses().rdd().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(WriteStatus ws) {
                return ws.hasErrors();
            }
        }).count() == 0L) {
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)"Proceeding to commit the write.");
            scala.collection.immutable.Map metaMap = (scala.collection.immutable.Map)parameters.filter((Function1)new Serializable(parameters){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map parameters$4;

                public final boolean apply(Tuple2<String, String> kv) {
                    return ((String)kv._1()).startsWith((String)this.parameters$4.apply((Object)DataSourceWriteOptions$.MODULE$.COMMIT_METADATA_KEYPREFIX().key()));
                }
                {
                    this.parameters$4 = parameters$4;
                }
            });
            boolean commitSuccess = client.commit(tableInstantInfo.instantTime(), writeResult.getWriteStatuses(), Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap))), tableInstantInfo.commitActionType(), writeResult.getPartitionToReplaceFileIds(), Option.ofNullable(extraPreCommitFn.orNull(Predef$.MODULE$.$conforms())));
            if (commitSuccess) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"Commit ").append((Object)tableInstantInfo.instantTime()).append((Object)" successful!").toString());
            } else {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"Commit ").append((Object)tableInstantInfo.instantTime()).append((Object)" failed!").toString());
            }
            boolean asyncCompactionEnabled = this.isAsyncCompactionEnabled(client, tableConfig, parameters, jsc.hadoopConfiguration());
            Option compactionInstant = asyncCompactionEnabled ? client.scheduleCompaction(Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap)))) : Option.empty();
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction Scheduled is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{compactionInstant})));
            boolean asyncClusteringEnabled = this.isAsyncClusteringEnabled(client, parameters);
            Option clusteringInstant = asyncClusteringEnabled ? client.scheduleClustering(Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap)))) : Option.empty();
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Clustering Scheduled is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clusteringInstant})));
            boolean metaSyncSuccess = this.metaSync(spark, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig(parameters), tableInstantInfo.basePath(), schema2);
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Is Async Compaction Enabled ? ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)asyncCompactionEnabled)})));
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((commitSuccess && metaSyncSuccess ? 1 : 0) != 0), compactionInstant, clusteringInstant);
        } else {
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().error((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed with errors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableInstantInfo.operation()})));
            if (this.org$apache$hudi$HoodieSparkSqlWriter$$log().isTraceEnabled()) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)"Printing out the top 100 errors");
                Predef$.MODULE$.refArrayOps((Object[])writeResult.getWriteStatuses().rdd().filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(WriteStatus ws) {
                        return ws.hasErrors();
                    }
                }).take(100)).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(WriteStatus ws) {
                        HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)"Global error :", ws.getGlobalError());
                        if (ws.getErrors().size() > 0) {
                            JavaConversions$.MODULE$.mapAsScalaMap(ws.getErrors()).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Tuple2<HoodieKey, Throwable> kt) {
                                    HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error for key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kt._1()})), (Throwable)kt._2());
                                }
                            });
                        }
                    }
                });
            }
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), Option.empty(), Option.empty());
        }
        return tuple3;
    }

    private boolean isAsyncCompactionEnabled(SparkRDDWriteClient<?> client, HoodieTableConfig tableConfig, scala.collection.immutable.Map<String, String> parameters, Configuration configuration) {
        boolean bl;
        this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config.inlineCompactionEnabled ? ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)client.getConfig().inlineCompactionEnabled())})));
        if (this.asyncCompactionTriggerFnDefined() && !client.getConfig().inlineCompactionEnabled() && parameters.get((Object)DataSourceWriteOptions$.MODULE$.ASYNC_COMPACT_ENABLE().key()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String r) {
                return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
            }
        })) {
            HoodieTableType hoodieTableType = tableConfig.getTableType();
            HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
            bl = !(hoodieTableType != null ? !((Object)((Object)hoodieTableType)).equals((Object)hoodieTableType2) : hoodieTableType2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isAsyncClusteringEnabled(SparkRDDWriteClient<?> client, scala.collection.immutable.Map<String, String> parameters) {
        this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config.asyncClusteringEnabled ? ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)client.getConfig().isAsyncClusteringEnabled())})));
        return this.asyncClusteringTriggerFnDefined() && client.getConfig().isAsyncClusteringEnabled();
    }

    private HoodieTableConfig getHoodieTableConfig(SparkContext sparkContext, String tablePath, scala.Option<HoodieTableConfig> hoodieTableConfigOpt) {
        return this.tableExists() ? (HoodieTableConfig)hoodieTableConfigOpt.getOrElse((Function0)new Serializable(sparkContext, tablePath){
            public static final long serialVersionUID = 0L;
            private final SparkContext sparkContext$1;
            private final String tablePath$1;

            public final HoodieTableConfig apply() {
                return HoodieTableMetaClient.builder().setConf(this.sparkContext$1.hadoopConfiguration()).setBasePath(this.tablePath$1).build().getTableConfig();
            }
            {
                this.sparkContext$1 = sparkContext$1;
                this.tablePath$1 = tablePath$1;
            }
        }) : null;
    }

    private Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> mergeParamsAndGetHoodieConfig(scala.collection.immutable.Map<String, String> optParams, HoodieTableConfig tableConfig, SaveMode mode) {
        scala.collection.immutable.Map<String, String> translatedOptions = DataSourceWriteOptions$.MODULE$.translateSqlOptions(optParams);
        scala.collection.mutable.Map mergedParams = Map$.MODULE$.empty().$plus$plus(HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(translatedOptions));
        if (!mergedParams.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key()) && mergedParams.contains((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key())) {
            mergedParams.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), mergedParams.apply((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()));
        }
        if (tableConfig != null) {
            SaveMode saveMode = mode;
            SaveMode saveMode2 = SaveMode.Overwrite;
            if (saveMode == null ? saveMode2 != null : !saveMode.equals(saveMode2)) {
                JavaConversions$.MODULE$.propertiesAsScalaMap((Properties)tableConfig.getProps()).foreach((Function1)new Serializable(mergedParams){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Map mergedParams$1;

                    public final void apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String key = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            this.mergedParams$1.update((Object)key, (Object)value);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.mergedParams$1 = mergedParams$1;
                    }
                });
            }
        }
        Object object = mergedParams.contains((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()) ? mergedParams.put((Object)"hoodie.payload.ordering.field", mergedParams.apply((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key())) : BoxedUnit.UNIT;
        scala.collection.immutable.Map params = mergedParams.toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)params, (Object)HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)params));
    }

    private scala.collection.immutable.Map<String, String> extractConfigsRelatedToTimestampBasedKeyGenerator(String keyGenerator, scala.collection.immutable.Map<String, String> params) {
        return TimestampBasedKeyGenerator.class.getCanonicalName().equals(keyGenerator) || TimestampBasedAvroKeyGenerator.class.getCanonicalName().equals(keyGenerator) ? params.filterKeys((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x$1) {
                return HoodieTableConfig.PERSISTED_CONFIG_LIST.contains(x$1);
            }
        }) : Predef$.MODULE$.Map().empty();
    }

    private JavaRDD<HoodieRecord<?>> createHoodieRecordRdd(Dataset<Row> df, HoodieWriteConfig config, scala.collection.immutable.Map<String, String> parameters, String recordName, String recordNameSpace, Schema writerSchema, Schema dataFileSchema, WriteOperationType operation) {
        HoodieRecord.HoodieRecordType hoodieRecordType;
        block4: {
            JavaRDD javaRDD;
            block3: {
                String dataFileSchemaStr;
                KeyGenerator keyGenerator;
                Boolean shouldDropPartitionColumns;
                block2: {
                    shouldDropPartitionColumns = config.getBoolean(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS());
                    keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator(new TypedProperties(config.getProps()));
                    HoodieRecord.HoodieRecordType recordType = config.getRecordMerger().getRecordType();
                    boolean shouldCombine = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key()))).toBoolean() || operation.equals((Object)WriteOperationType.UPSERT) || new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieWriteConfig.COMBINE_BEFORE_INSERT.key(), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return HoodieWriteConfig.COMBINE_BEFORE_INSERT.defaultValue();
                        }
                    }))).toBoolean();
                    dataFileSchemaStr = dataFileSchema.toString();
                    this.org$apache$hudi$HoodieSparkSqlWriter$$log().debug((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating HoodieRecords (as ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{recordType})));
                    hoodieRecordType = recordType;
                    if (!((Object)((Object)HoodieRecord.HoodieRecordType.AVRO)).equals((Object)hoodieRecordType)) break block2;
                    RDD<GenericRecord> avroRecords = HoodieSparkUtils$.MODULE$.createRdd(df, recordName, recordNameSpace, (scala.Option<Schema>)new Some((Object)writerSchema));
                    javaRDD = avroRecords.mapPartitions((Function1)new Serializable(config, parameters, shouldDropPartitionColumns, keyGenerator, shouldCombine, dataFileSchemaStr){
                        public static final long serialVersionUID = 0L;
                        public final HoodieWriteConfig config$1;
                        private final scala.collection.immutable.Map parameters$3;
                        public final Boolean shouldDropPartitionColumns$1;
                        public final KeyGenerator keyGenerator$2;
                        public final boolean shouldCombine$1;
                        private final String dataFileSchemaStr$1;

                        public final Iterator<HoodieRecord<?>> apply(Iterator<GenericRecord> it) {
                            Schema dataFileSchema = new Schema.Parser().parse(this.dataFileSchemaStr$1);
                            boolean consistentLogicalTimestampEnabled = new StringOps(Predef$.MODULE$.augmentString((String)this.parameters$3.getOrElse((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED().key(), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED().defaultValue();
                                }
                            }))).toBoolean();
                            return it.map((Function1)new Serializable(this, dataFileSchema, consistentLogicalTimestampEnabled){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.createHoodieRecordRdd.1 $outer;
                                private final Schema dataFileSchema$2;
                                private final boolean consistentLogicalTimestampEnabled$1;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final HoodieRecord<?> apply(GenericRecord avroRecord) {
                                    void var3_4;
                                    HoodieRecord hoodieRecord;
                                    GenericRecord processedRecord;
                                    GenericRecord genericRecord = processedRecord = Predef$.MODULE$.Boolean2boolean(this.$outer.shouldDropPartitionColumns$1) ? HoodieAvroUtils.rewriteRecord(avroRecord, this.dataFileSchema$2) : avroRecord;
                                    if (this.$outer.shouldCombine$1) {
                                        Comparable orderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal(avroRecord, this.$outer.config$1.getString(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD()), false, this.consistentLogicalTimestampEnabled$1);
                                        hoodieRecord = DataSourceUtils.createHoodieRecord(processedRecord, orderingVal, this.$outer.keyGenerator$2.getKey(avroRecord), this.$outer.config$1.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME()));
                                    } else {
                                        hoodieRecord = DataSourceUtils.createHoodieRecord(processedRecord, this.$outer.keyGenerator$2.getKey(avroRecord), this.$outer.config$1.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME()));
                                    }
                                    HoodieRecord hoodieRecord2 = hoodieRecord;
                                    return var3_4;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.dataFileSchema$2 = dataFileSchema$2;
                                    this.consistentLogicalTimestampEnabled$1 = consistentLogicalTimestampEnabled$1;
                                }
                            });
                        }
                        {
                            this.config$1 = config$1;
                            this.parameters$3 = parameters$3;
                            this.shouldDropPartitionColumns$1 = shouldDropPartitionColumns$1;
                            this.keyGenerator$2 = keyGenerator$2;
                            this.shouldCombine$1 = shouldCombine$1;
                            this.dataFileSchemaStr$1 = dataFileSchemaStr$1;
                        }
                    }, avroRecords.mapPartitions$default$2(), ClassTag$.MODULE$.apply(HoodieRecord.class)).toJavaRDD();
                    break block3;
                }
                if (!((Object)((Object)HoodieRecord.HoodieRecordType.SPARK)).equals((Object)hoodieRecordType)) break block4;
                SparkKeyGeneratorInterface sparkKeyGenerator = (SparkKeyGeneratorInterface)((Object)keyGenerator);
                Schema dataFileSchema2 = new Schema.Parser().parse(dataFileSchemaStr);
                StructType dataFileStructType = HoodieInternalRowUtils$.MODULE$.getCachedSchema(dataFileSchema2);
                StructType writerStructType = HoodieInternalRowUtils$.MODULE$.getCachedSchema(writerSchema);
                StructType sourceStructType = df.schema();
                javaRDD = df.queryExecution().toRdd().mapPartitions((Function1)new Serializable(shouldDropPartitionColumns, sparkKeyGenerator, dataFileStructType, writerStructType, sourceStructType){
                    public static final long serialVersionUID = 0L;
                    private final Boolean shouldDropPartitionColumns$1;
                    public final SparkKeyGeneratorInterface sparkKeyGenerator$1;
                    public final StructType dataFileStructType$1;
                    private final StructType writerStructType$1;
                    public final StructType sourceStructType$1;

                    public final Iterator<HoodieSparkRecord> apply(Iterator<InternalRow> it) {
                        StructType targetStructType = Predef$.MODULE$.Boolean2boolean(this.shouldDropPartitionColumns$1) ? this.dataFileStructType$1 : this.writerStructType$1;
                        Function1<InternalRow, UnsafeRow> targetStructTypeRowWriter = HoodieInternalRowUtils$.MODULE$.getCachedUnsafeRowWriter(this.sourceStructType$1, targetStructType, HoodieInternalRowUtils$.MODULE$.getCachedUnsafeRowWriter$default$3());
                        return it.map((Function1)new Serializable(this, targetStructTypeRowWriter){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.createHoodieRecordRdd.2 $outer;
                            private final Function1 targetStructTypeRowWriter$1;

                            public final HoodieSparkRecord apply(InternalRow sourceRow) {
                                UTF8String recordKey = this.$outer.sparkKeyGenerator$1.getRecordKey(sourceRow, this.$outer.sourceStructType$1);
                                UTF8String partitionPath = this.$outer.sparkKeyGenerator$1.getPartitionPath(sourceRow, this.$outer.sourceStructType$1);
                                HoodieKey key = new HoodieKey(recordKey.toString(), partitionPath.toString());
                                UnsafeRow targetRow = (UnsafeRow)this.targetStructTypeRowWriter$1.apply((Object)sourceRow);
                                return new HoodieSparkRecord(key, (InternalRow)targetRow, this.$outer.dataFileStructType$1, false);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.targetStructTypeRowWriter$1 = targetStructTypeRowWriter$1;
                            }
                        });
                    }
                    {
                        this.shouldDropPartitionColumns$1 = shouldDropPartitionColumns$1;
                        this.sparkKeyGenerator$1 = sparkKeyGenerator$1;
                        this.dataFileStructType$1 = dataFileStructType$1;
                        this.writerStructType$1 = writerStructType$1;
                        this.sourceStructType$1 = sourceStructType$1;
                    }
                }, df.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(HoodieSparkRecord.class)).toJavaRDD();
            }
            return javaRDD;
        }
        throw new MatchError((Object)hoodieRecordType);
    }

    private HoodieSparkSqlWriter$() {
        MODULE$ = this;
        this.CANONICALIZE_NULLABLE = ConfigProperty.key("hoodie.internal.write.schema.canonicalize.nullable").defaultValue(BoxesRunTime.boxToBoolean((boolean)true));
        this.SQL_MERGE_INTO_WRITES = ConfigProperty.key("hoodie.internal.sql.merge.into.writes").defaultValue(BoxesRunTime.boxToBoolean((boolean)false));
        this.org$apache$hudi$HoodieSparkSqlWriter$$log = LogManager.getLogger(this.getClass());
        this.tableExists = false;
        this.asyncCompactionTriggerFnDefined = false;
        this.asyncClusteringTriggerFnDefined = false;
    }
}

