/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Properties;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.BaseHoodieTableFileIndex;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieTableQueryType;
import org.apache.hudi.common.util.Option;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.NoopCache$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SparkHoodieTableFileIndex$ {
    public static final SparkHoodieTableFileIndex$ MODULE$;

    static {
        new SparkHoodieTableFileIndex$();
    }

    public boolean org$apache$hudi$SparkHoodieTableFileIndex$$haveProperPartitionValues(Seq<BaseHoodieTableFileIndex.PartitionPath> partitionPaths) {
        return partitionPaths.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BaseHoodieTableFileIndex.PartitionPath x$9) {
                return x$9.values.length > 0;
            }
        });
    }

    public Map<String, scala.Option<Object>> org$apache$hudi$SparkHoodieTableFileIndex$$extractEqualityPredicatesLiteralValues(Seq<Expression> predicates) {
        return ((TraversableOnce)predicates.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Seq<Tuple2<String, Some<Object>>> apply(Expression x0$3) {
                boolean bl = false;
                EqualTo equalTo = null;
                Expression expression = x0$3;
                if (expression instanceof EqualTo) {
                    bl = true;
                    equalTo = (EqualTo)expression;
                    Expression attr = equalTo.left();
                    Expression e = equalTo.right();
                    if (attr instanceof AttributeReference) {
                        Expression expression2;
                        AttributeReference attributeReference = (AttributeReference)attr;
                        if (e != null && (expression2 = e).foldable()) {
                            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)attributeReference.name(), (Object)new Some(expression2.eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow())))}));
                        }
                    }
                }
                if (!bl) return (Seq)Seq$.MODULE$.empty();
                Expression e = equalTo.left();
                Expression attr = equalTo.right();
                if (e == null) return (Seq)Seq$.MODULE$.empty();
                Expression expression3 = e;
                if (!(attr instanceof AttributeReference)) return (Seq)Seq$.MODULE$.empty();
                AttributeReference attributeReference = (AttributeReference)attr;
                if (!expression3.foldable()) return (Seq)Seq$.MODULE$.empty();
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)attributeReference.name(), (Object)new Some(expression3.eval(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.EmptyRow())))}));
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, StructField> org$apache$hudi$SparkHoodieTableFileIndex$$generateFieldMap(StructType structType) {
        return this.org$apache$hudi$SparkHoodieTableFileIndex$$traverse$1((Either)package$.MODULE$.Right().apply((Object)structType));
    }

    public HoodieTableQueryType org$apache$hudi$SparkHoodieTableFileIndex$$deduceQueryType(TypedProperties configProperties) {
        String string;
        block5: {
            HoodieTableQueryType hoodieTableQueryType;
            block3: {
                block4: {
                    block2: {
                        string = (String)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)configProperties).asScala()).getOrElse((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), (Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return DataSourceReadOptions$.MODULE$.QUERY_TYPE().defaultValue();
                            }
                        });
                        String string2 = DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL();
                        String string3 = string;
                        if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                        hoodieTableQueryType = HoodieTableQueryType.SNAPSHOT;
                        break block3;
                    }
                    String string4 = DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL();
                    String string5 = string;
                    if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                    hoodieTableQueryType = HoodieTableQueryType.INCREMENTAL;
                    break block3;
                }
                String string6 = DataSourceReadOptions$.MODULE$.QUERY_TYPE_READ_OPTIMIZED_OPT_VAL();
                String string7 = string;
                if (string6 != null ? !string6.equals(string7) : string7 != null) break block5;
                hoodieTableQueryType = HoodieTableQueryType.READ_OPTIMIZED;
            }
            return hoodieTableQueryType;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"query-type (", ") not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public BaseHoodieTableFileIndex.FileStatusCache org$apache$hudi$SparkHoodieTableFileIndex$$adapt(FileStatusCache cache) {
        return new BaseHoodieTableFileIndex.FileStatusCache(cache){
            private final FileStatusCache cache$1;

            public Option<FileStatus[]> get(Path path) {
                return HoodieConversionUtils$.MODULE$.toJavaOption(this.cache$1.getLeafFiles(path));
            }

            public void put(Path path, FileStatus[] leafFiles) {
                this.cache$1.putLeafFiles(path, leafFiles);
            }

            public void invalidate() {
                this.cache$1.invalidateAll();
            }
            {
                this.cache$1 = cache$1;
            }
        };
    }

    public boolean org$apache$hudi$SparkHoodieTableFileIndex$$shouldValidatePartitionColumns(SparkSession spark) {
        return new StringOps(Predef$.MODULE$.augmentString(spark.sessionState().conf().getConfString("spark.sql.sources.validatePartitionColumns", "true"))).toBoolean();
    }

    public boolean org$apache$hudi$SparkHoodieTableFileIndex$$shouldListLazily(TypedProperties props) {
        String string = props.getString(DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_OVERRIDE().key(), DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_OVERRIDE().defaultValue());
        String string2 = DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_MODE_LAZY();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean org$apache$hudi$SparkHoodieTableFileIndex$$shouldUsePartitionPathPrefixAnalysis(TypedProperties props) {
        return props.getBoolean(DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_PARTITION_PATH_PREFIX_ANALYSIS_ENABLED().key(), BoxesRunTime.unboxToBoolean((Object)DataSourceReadOptions$.MODULE$.FILE_INDEX_LISTING_PARTITION_PATH_PREFIX_ANALYSIS_ENABLED().defaultValue()));
    }

    public scala.Option<String> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public FileStatusCache $lessinit$greater$default$7() {
        return NoopCache$.MODULE$;
    }

    public final Map org$apache$hudi$SparkHoodieTableFileIndex$$traverse$1(Either structField) {
        Either either2;
        block7: {
            Map map;
            block6: {
                Map map2;
                block5: {
                    either2 = structField;
                    if (!(either2 instanceof Right)) break block5;
                    Right right = (Right)either2;
                    StructType struct = (StructType)right.b();
                    map = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])struct.fields()).flatMap((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Map<String, StructField> apply(StructField f) {
                            return SparkHoodieTableFileIndex$.MODULE$.org$apache$hudi$SparkHoodieTableFileIndex$$traverse$1((Either)package$.MODULE$.Left().apply((Object)f));
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
                    break block6;
                }
                if (!(either2 instanceof Left)) break block7;
                Left left = (Left)either2;
                StructField field = (StructField)left.a();
                DataType dataType = field.dataType();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    map2 = (Map)this.org$apache$hudi$SparkHoodieTableFileIndex$$traverse$1((Either)package$.MODULE$.Right().apply((Object)structType)).map((Function1)new Serializable(field){
                        public static final long serialVersionUID = 0L;
                        private final StructField field$1;

                        public final Tuple2<String, StructField> apply(Tuple2<String, StructField> x0$4) {
                            Tuple2<String, StructField> tuple2 = x0$4;
                            if (tuple2 != null) {
                                String key = (String)tuple2._1();
                                StructField structField = (StructField)tuple2._2();
                                Tuple2 tuple22 = new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.field$1.name(), key})), (Object)structField);
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.field$1 = field$1;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                } else {
                    map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)field)}));
                }
                map = map2;
            }
            return map;
        }
        throw new MatchError((Object)either2);
    }

    private SparkHoodieTableFileIndex$() {
        MODULE$ = this;
    }
}

