/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.hudi.avro.AvroSchemaCompatibility;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.util.ValidationUtils;

public class AvroSchemaUtils {
    private AvroSchemaUtils() {
    }

    public static boolean isSchemaCompatible(Schema prevSchema, Schema newSchema, boolean allowProjection) {
        return AvroSchemaUtils.isSchemaCompatible(prevSchema, newSchema, true, allowProjection);
    }

    public static boolean isSchemaCompatible(Schema prevSchema, Schema newSchema, boolean checkNaming, boolean allowProjection) {
        if (!allowProjection && !AvroSchemaUtils.canProject(prevSchema, newSchema)) {
            return false;
        }
        AvroSchemaCompatibility.SchemaPairCompatibility result = AvroSchemaCompatibility.checkReaderWriterCompatibility(newSchema, prevSchema, checkNaming);
        return result.getType() == AvroSchemaCompatibility.SchemaCompatibilityType.COMPATIBLE;
    }

    public static boolean canProject(Schema prevSchema, Schema newSchema) {
        return prevSchema.getFields().stream().map(oldSchemaField -> SchemaCompatibility.lookupWriterField((Schema)newSchema, (Schema.Field)oldSchemaField)).noneMatch(Objects::isNull);
    }

    public static String getAvroRecordQualifiedName(String tableName) {
        String sanitizedTableName = HoodieAvroUtils.sanitizeName(tableName);
        return "hoodie." + sanitizedTableName + "." + sanitizedTableName + "_record";
    }

    public static boolean isCompatibleProjectionOf(Schema sourceSchema, Schema targetSchema) {
        return AvroSchemaUtils.isProjectionOfInternal(sourceSchema, targetSchema, AvroSchemaUtils::isAtomicSchemasCompatible);
    }

    private static boolean isAtomicSchemasCompatible(Schema oneAtomicType, Schema anotherAtomicType) {
        return AvroSchemaUtils.isSchemaCompatible(oneAtomicType, anotherAtomicType, false, true);
    }

    public static boolean isStrictProjectionOf(Schema sourceSchema, Schema targetSchema) {
        return AvroSchemaUtils.isProjectionOfInternal(sourceSchema, targetSchema, Objects::equals);
    }

    private static boolean isProjectionOfInternal(Schema sourceSchema, Schema targetSchema, BiFunction<Schema, Schema, Boolean> atomicTypeEqualityPredicate) {
        if (sourceSchema.getType() == targetSchema.getType()) {
            if (sourceSchema.getType() == Schema.Type.RECORD) {
                for (Schema.Field targetField : targetSchema.getFields()) {
                    Schema.Field sourceField = sourceSchema.getField(targetField.name());
                    if (sourceField != null && AvroSchemaUtils.isProjectionOfInternal(sourceField.schema(), targetField.schema(), atomicTypeEqualityPredicate)) continue;
                    return false;
                }
                return true;
            }
            if (sourceSchema.getType() == Schema.Type.ARRAY) {
                return AvroSchemaUtils.isProjectionOfInternal(sourceSchema.getElementType(), targetSchema.getElementType(), atomicTypeEqualityPredicate);
            }
            if (sourceSchema.getType() == Schema.Type.MAP) {
                return AvroSchemaUtils.isProjectionOfInternal(sourceSchema.getValueType(), targetSchema.getValueType(), atomicTypeEqualityPredicate);
            }
            if (sourceSchema.getType() == Schema.Type.UNION) {
                List sourceNestedSchemas = sourceSchema.getTypes();
                List targetNestedSchemas = targetSchema.getTypes();
                if (sourceNestedSchemas.size() != targetNestedSchemas.size()) {
                    return false;
                }
                for (int i = 0; i < sourceNestedSchemas.size(); ++i) {
                    if (AvroSchemaUtils.isProjectionOfInternal((Schema)sourceNestedSchemas.get(i), (Schema)targetNestedSchemas.get(i), atomicTypeEqualityPredicate)) continue;
                    return false;
                }
                return true;
            }
        }
        return atomicTypeEqualityPredicate.apply(sourceSchema, targetSchema);
    }

    public static Schema appendFieldsToSchema(Schema schema2, List<Schema.Field> newFields) {
        List fields = schema2.getFields().stream().map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal())).collect(Collectors.toList());
        fields.addAll(newFields);
        Schema newSchema = Schema.createRecord((String)schema2.getName(), (String)schema2.getDoc(), (String)schema2.getNamespace(), (boolean)schema2.isError());
        newSchema.setFields(fields);
        return newSchema;
    }

    public static Schema resolveUnionSchema(Schema schema2, String fieldSchemaFullName) {
        if (schema2.getType() != Schema.Type.UNION) {
            return schema2;
        }
        List innerTypes = schema2.getTypes();
        Schema nonNullType = innerTypes.stream().filter(it -> it.getType() != Schema.Type.NULL && Objects.equals(it.getFullName(), fieldSchemaFullName)).findFirst().orElse(null);
        if (nonNullType == null) {
            throw new AvroRuntimeException(String.format("Unsupported Avro UNION type %s: Only UNION of a null type and a non-null type is supported", schema2));
        }
        return nonNullType;
    }

    public static boolean isNullable(Schema schema2) {
        if (schema2.getType() != Schema.Type.UNION) {
            return false;
        }
        List innerTypes = schema2.getTypes();
        return innerTypes.size() > 1 && innerTypes.stream().anyMatch(it -> it.getType() == Schema.Type.NULL);
    }

    public static Schema resolveNullableSchema(Schema schema2) {
        if (schema2.getType() != Schema.Type.UNION) {
            return schema2;
        }
        List innerTypes = schema2.getTypes();
        Schema nonNullType = innerTypes.stream().filter(it -> it.getType() != Schema.Type.NULL).findFirst().orElse(null);
        if (innerTypes.size() != 2 || nonNullType == null) {
            throw new AvroRuntimeException(String.format("Unsupported Avro UNION type %s: Only UNION of a null type and a non-null type is supported", schema2));
        }
        return nonNullType;
    }

    public static Schema createNullableSchema(Schema.Type avroType) {
        return AvroSchemaUtils.createNullableSchema(Schema.create((Schema.Type)avroType));
    }

    public static Schema createNullableSchema(Schema schema2) {
        ValidationUtils.checkState(schema2.getType() != Schema.Type.NULL);
        return Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), schema2});
    }

    public static boolean containsFieldInSchema(Schema schema2, String fieldName) {
        try {
            Schema.Field field = schema2.getField(fieldName);
            return field != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

