/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.avro.ConvertingGenericData;
import org.apache.hudi.avro.HoodieBloomFilterWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.parquet.avro.AvroWriteSupport;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.schema.MessageType;

public class HoodieAvroWriteSupport
extends AvroWriteSupport {
    private final Option<HoodieBloomFilterWriteSupport<String>> bloomFilterWriteSupportOpt;
    private final Map<String, String> footerMetadata = new HashMap<String, String>();
    public static final String OLD_HOODIE_AVRO_BLOOM_FILTER_METADATA_KEY = "com.uber.hoodie.bloomfilter";
    public static final String HOODIE_AVRO_BLOOM_FILTER_METADATA_KEY = "org.apache.hudi.bloomfilter";

    public HoodieAvroWriteSupport(MessageType schema2, Schema avroSchema, Option<BloomFilter> bloomFilterOpt) {
        super(schema2, avroSchema, ConvertingGenericData.INSTANCE);
        this.bloomFilterWriteSupportOpt = bloomFilterOpt.map(HoodieBloomFilterAvroWriteSupport::new);
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        HashMap<String, String> extraMetadata = CollectionUtils.combine(this.footerMetadata, this.bloomFilterWriteSupportOpt.map(HoodieBloomFilterWriteSupport::finalizeMetadata).orElse(Collections.emptyMap()));
        return new WriteSupport.FinalizedWriteContext(extraMetadata);
    }

    public void add(String recordKey) {
        this.bloomFilterWriteSupportOpt.ifPresent(bloomFilterWriteSupport -> bloomFilterWriteSupport.addKey(recordKey));
    }

    public void addFooterMetadata(String key, String value) {
        this.footerMetadata.put(key, value);
    }

    private static class HoodieBloomFilterAvroWriteSupport
    extends HoodieBloomFilterWriteSupport<String> {
        public HoodieBloomFilterAvroWriteSupport(BloomFilter bloomFilter) {
            super(bloomFilter);
        }

        @Override
        protected byte[] getUTF8Bytes(String key) {
            return key.getBytes(StandardCharsets.UTF_8);
        }
    }
}

