/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.validator;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.validator.SqlQueryPreCommitValidator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.config.HoodiePreCommitValidatorConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;

public class SqlQueryInequalityPreCommitValidator<T, I, K, O extends HoodieData<WriteStatus>>
extends SqlQueryPreCommitValidator<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(SqlQueryInequalityPreCommitValidator.class);

    public SqlQueryInequalityPreCommitValidator(HoodieSparkTable<T> table, HoodieEngineContext engineContext, HoodieWriteConfig config) {
        super(table, engineContext, config);
    }

    @Override
    protected String getQueryConfigName() {
        return HoodiePreCommitValidatorConfig.INEQUALITY_SQL_QUERIES.key();
    }

    @Override
    protected void validateUsingQuery(String query, String prevTableSnapshot, String newTableSnapshot, SQLContext sqlContext) {
        String queryWithPrevSnapshot = query.replaceAll("<TABLE_NAME>", prevTableSnapshot);
        String queryWithNewSnapshot = query.replaceAll("<TABLE_NAME>", newTableSnapshot);
        LOG.info((Object)("Running query on previous state: " + queryWithPrevSnapshot));
        Dataset prevRows = sqlContext.sql(queryWithPrevSnapshot);
        LOG.info((Object)("Running query on new state: " + queryWithNewSnapshot));
        Dataset newRows = sqlContext.sql(queryWithNewSnapshot);
        this.printAllRowsIfDebugEnabled((Dataset<Row>)prevRows);
        this.printAllRowsIfDebugEnabled((Dataset<Row>)newRows);
        boolean areDatasetsEqual = prevRows.intersect(newRows).count() == prevRows.count();
        LOG.info((Object)("Completed Inequality Validation, datasets equal? " + areDatasetsEqual));
        if (areDatasetsEqual) {
            LOG.error((Object)("query validation failed. See stdout for sample query results. Query: " + query));
            System.out.println("Expected query results to be different, but they are same. Result (sample records only):");
            prevRows.show();
            throw new HoodieValidationException("Query validation failed for '" + query + "'. Expected " + prevRows.count() + " rows, Found " + newRows.count());
        }
    }
}

