/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormatReader;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.ClosableIteratorWithSchema;
import org.apache.hudi.common.util.InternalSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.InternalSchemaMerger;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractHoodieLogRecordReader {
    private static final Logger LOG = LogManager.getLogger(AbstractHoodieLogRecordReader.class);
    protected final Schema readerSchema;
    private final String latestInstantTime;
    protected final HoodieTableMetaClient hoodieTableMetaClient;
    private final String payloadClassFQN;
    private final String recordKeyField;
    private final Option<String> partitionPathFieldOpt;
    private final Option<String> partitionNameOverrideOpt;
    protected final String preCombineField;
    protected final HoodieRecordMerger recordMerger;
    private final TypedProperties payloadProps;
    protected final List<String> logFilePaths;
    private final boolean readBlocksLazily;
    private final boolean reverseReader;
    private final int bufferSize;
    private final Option<InstantRange> instantRange;
    private final boolean withOperationField;
    private final FileSystem fs;
    private AtomicLong totalLogFiles = new AtomicLong(0L);
    private final InternalSchema internalSchema;
    private AtomicLong totalLogBlocks = new AtomicLong(0L);
    private AtomicLong totalLogRecords = new AtomicLong(0L);
    private AtomicLong totalRollbacks = new AtomicLong(0L);
    private AtomicLong totalCorruptBlocks = new AtomicLong(0L);
    private Deque<HoodieLogBlock> currentInstantLogBlocks = new ArrayDeque<HoodieLogBlock>();
    protected final boolean forceFullScan;
    private float progress = 0.0f;
    private final boolean populateMetaFields;
    protected final HoodieRecord.HoodieRecordType recordType;
    private final List<String> validBlockInstants = new ArrayList<String>();
    private final boolean enableOptimizedLogBlocksScan;

    protected AbstractHoodieLogRecordReader(FileSystem fs, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, boolean readBlocksLazily, boolean reverseReader, int bufferSize, Option<InstantRange> instantRange, boolean withOperationField, boolean forceFullScan, Option<String> partitionNameOverride, InternalSchema internalSchema, Option<String> keyFieldOverride, boolean enableOptimizedLogBlocksScan, HoodieRecordMerger recordMerger) {
        this.readerSchema = readerSchema;
        this.latestInstantTime = latestInstantTime;
        this.hoodieTableMetaClient = HoodieTableMetaClient.builder().setConf(fs.getConf()).setBasePath(basePath).build();
        HoodieTableConfig tableConfig = this.hoodieTableMetaClient.getTableConfig();
        this.payloadClassFQN = tableConfig.getPayloadClass();
        this.preCombineField = tableConfig.getPreCombineField();
        TypedProperties props = HoodieAvroRecordMerger.Config.withLegacyOperatingModePreCombining(new Properties());
        if (this.preCombineField != null) {
            props.setProperty("hoodie.payload.ordering.field", this.preCombineField);
        }
        this.payloadProps = props;
        this.recordMerger = recordMerger;
        this.totalLogFiles.addAndGet(logFilePaths.size());
        this.logFilePaths = logFilePaths;
        this.reverseReader = reverseReader;
        this.readBlocksLazily = readBlocksLazily;
        this.fs = fs;
        this.bufferSize = bufferSize;
        this.instantRange = instantRange;
        this.withOperationField = withOperationField;
        this.forceFullScan = forceFullScan;
        this.internalSchema = internalSchema == null ? InternalSchema.getEmptyInternalSchema() : internalSchema;
        this.enableOptimizedLogBlocksScan = enableOptimizedLogBlocksScan;
        if (keyFieldOverride.isPresent()) {
            ValidationUtils.checkState(partitionNameOverride.isPresent());
            this.populateMetaFields = false;
            this.recordKeyField = keyFieldOverride.get();
            this.partitionPathFieldOpt = Option.empty();
        } else if (tableConfig.populateMetaFields()) {
            this.populateMetaFields = true;
            this.recordKeyField = HoodieRecord.RECORD_KEY_METADATA_FIELD;
            this.partitionPathFieldOpt = Option.of(HoodieRecord.PARTITION_PATH_METADATA_FIELD);
        } else {
            this.populateMetaFields = false;
            this.recordKeyField = tableConfig.getRecordKeyFieldProp();
            this.partitionPathFieldOpt = Option.of(tableConfig.getPartitionFieldProp());
        }
        this.partitionNameOverrideOpt = partitionNameOverride;
        this.recordType = recordMerger.getRecordType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scanInternal(Option<KeySpec> keySpecOpt, boolean skipProcessingBlocks) {
        AbstractHoodieLogRecordReader abstractHoodieLogRecordReader = this;
        synchronized (abstractHoodieLogRecordReader) {
            if (this.enableOptimizedLogBlocksScan) {
                this.scanInternalV2(keySpecOpt, skipProcessingBlocks);
            } else {
                this.scanInternalV1(keySpecOpt);
            }
        }
    }

    private void scanInternalV1(Option<KeySpec> keySpecOpt) {
        this.currentInstantLogBlocks = new ArrayDeque<HoodieLogBlock>();
        this.progress = 0.0f;
        this.totalLogFiles = new AtomicLong(0L);
        this.totalRollbacks = new AtomicLong(0L);
        this.totalCorruptBlocks = new AtomicLong(0L);
        this.totalLogBlocks = new AtomicLong(0L);
        this.totalLogRecords = new AtomicLong(0L);
        HoodieLogFormatReader logFormatReaderWrapper = null;
        HoodieTimeline commitsTimeline = this.hoodieTableMetaClient.getCommitsTimeline();
        HoodieTimeline completedInstantsTimeline = commitsTimeline.filterCompletedInstants();
        HoodieTimeline inflightInstantsTimeline = commitsTimeline.filterInflights();
        try {
            logFormatReaderWrapper = new HoodieLogFormatReader(this.fs, this.logFilePaths.stream().map(logFile -> new HoodieLogFile(new Path(logFile))).collect(Collectors.toList()), this.readerSchema, this.readBlocksLazily, this.reverseReader, this.bufferSize, this.shouldLookupRecords(), this.recordKeyField, this.internalSchema);
            HashSet<HoodieLogFile> scannedLogFiles = new HashSet<HoodieLogFile>();
            block19: while (logFormatReaderWrapper.hasNext()) {
                HoodieLogFile logFile2 = logFormatReaderWrapper.getLogFile();
                LOG.info((Object)("Scanning log file " + logFile2));
                scannedLogFiles.add(logFile2);
                this.totalLogFiles.set(scannedLogFiles.size());
                HoodieLogBlock logBlock = logFormatReaderWrapper.next();
                String instantTime = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                this.totalLogBlocks.incrementAndGet();
                if (logBlock.getBlockType() != HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK && !HoodieTimeline.compareTimestamps(logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME), HoodieTimeline.LESSER_THAN_OR_EQUALS, this.latestInstantTime)) break;
                if (logBlock.getBlockType() != HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK && logBlock.getBlockType() != HoodieLogBlock.HoodieLogBlockType.COMMAND_BLOCK && (!completedInstantsTimeline.containsOrBeforeTimelineStarts(instantTime) || inflightInstantsTimeline.containsInstant(instantTime) || this.instantRange.isPresent() && !this.instantRange.get().isInRange(instantTime))) continue;
                switch (logBlock.getBlockType()) {
                    case HFILE_DATA_BLOCK: 
                    case AVRO_DATA_BLOCK: 
                    case PARQUET_DATA_BLOCK: {
                        LOG.info((Object)("Reading a data block from file " + logFile2.getPath() + " at instant " + logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME)));
                        if (this.isNewInstantBlock(logBlock) && !this.readBlocksLazily) {
                            this.processQueuedBlocksForInstant(this.currentInstantLogBlocks, scannedLogFiles.size(), keySpecOpt);
                        }
                        this.currentInstantLogBlocks.push(logBlock);
                        continue block19;
                    }
                    case DELETE_BLOCK: {
                        LOG.info((Object)("Reading a delete block from file " + logFile2.getPath()));
                        if (this.isNewInstantBlock(logBlock) && !this.readBlocksLazily) {
                            this.processQueuedBlocksForInstant(this.currentInstantLogBlocks, scannedLogFiles.size(), keySpecOpt);
                        }
                        this.currentInstantLogBlocks.push(logBlock);
                        continue block19;
                    }
                    case COMMAND_BLOCK: {
                        LOG.info((Object)("Reading a command block from file " + logFile2.getPath()));
                        HoodieCommandBlock commandBlock = (HoodieCommandBlock)logBlock;
                        String targetInstantForCommandBlock = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME);
                        switch (commandBlock.getType()) {
                            case ROLLBACK_BLOCK: {
                                int numBlocksRolledBack = 0;
                                this.totalRollbacks.incrementAndGet();
                                while (!this.currentInstantLogBlocks.isEmpty()) {
                                    HoodieLogBlock lastBlock = this.currentInstantLogBlocks.peek();
                                    if (lastBlock.getBlockType() == HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK) {
                                        LOG.info((Object)("Rolling back the last corrupted log block read in " + logFile2.getPath()));
                                        this.currentInstantLogBlocks.pop();
                                        ++numBlocksRolledBack;
                                        continue;
                                    }
                                    if (targetInstantForCommandBlock.contentEquals(lastBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME))) {
                                        LOG.info((Object)("Rolling back the last log block read in " + logFile2.getPath()));
                                        this.currentInstantLogBlocks.pop();
                                        ++numBlocksRolledBack;
                                        continue;
                                    }
                                    if (!targetInstantForCommandBlock.contentEquals(this.currentInstantLogBlocks.peek().getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME))) {
                                        LOG.warn((Object)("TargetInstantTime " + targetInstantForCommandBlock + " invalid or extra rollback command block in " + logFile2.getPath()));
                                        break;
                                    }
                                    LOG.warn((Object)("Unable to apply rollback command block in " + logFile2.getPath()));
                                }
                                LOG.info((Object)("Number of applied rollback blocks " + numBlocksRolledBack));
                                continue block19;
                            }
                        }
                        throw new UnsupportedOperationException("Command type not yet supported.");
                    }
                    case CORRUPT_BLOCK: {
                        LOG.info((Object)("Found a corrupt block in " + logFile2.getPath()));
                        this.totalCorruptBlocks.incrementAndGet();
                        this.currentInstantLogBlocks.push(logBlock);
                        continue block19;
                    }
                }
                throw new UnsupportedOperationException("Block type not supported yet");
            }
            if (!this.currentInstantLogBlocks.isEmpty()) {
                LOG.info((Object)"Merging the final data blocks");
                this.processQueuedBlocksForInstant(this.currentInstantLogBlocks, scannedLogFiles.size(), keySpecOpt);
            }
            this.progress = 1.0f;
        }
        catch (IOException e) {
            LOG.error((Object)"Got IOException when reading log file", (Throwable)e);
            throw new HoodieIOException("IOException when reading log file ", e);
        }
        catch (Exception e) {
            LOG.error((Object)"Got exception when reading log file", (Throwable)e);
            throw new HoodieException("Exception when reading log file ", e);
        }
        finally {
            try {
                if (null != logFormatReaderWrapper) {
                    logFormatReaderWrapper.close();
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)"Unable to close log format reader", (Throwable)ioe);
            }
        }
    }

    private void scanInternalV2(Option<KeySpec> keySpecOption, boolean skipProcessingBlocks) {
        this.currentInstantLogBlocks = new ArrayDeque<HoodieLogBlock>();
        this.progress = 0.0f;
        this.totalLogFiles = new AtomicLong(0L);
        this.totalRollbacks = new AtomicLong(0L);
        this.totalCorruptBlocks = new AtomicLong(0L);
        this.totalLogBlocks = new AtomicLong(0L);
        this.totalLogRecords = new AtomicLong(0L);
        HoodieLogFormatReader logFormatReaderWrapper = null;
        HoodieTimeline commitsTimeline = this.hoodieTableMetaClient.getCommitsTimeline();
        HoodieTimeline completedInstantsTimeline = commitsTimeline.filterCompletedInstants();
        HoodieTimeline inflightInstantsTimeline = commitsTimeline.filterInflights();
        try {
            logFormatReaderWrapper = new HoodieLogFormatReader(this.fs, this.logFilePaths.stream().map(logFile -> new HoodieLogFile(new Path(logFile))).collect(Collectors.toList()), this.readerSchema, this.readBlocksLazily, this.reverseReader, this.bufferSize, this.shouldLookupRecords(), this.recordKeyField, this.internalSchema);
            HashSet<String> targetRollbackInstants = new HashSet<String>();
            HashMap<String, List> instantToBlocksMap = new HashMap<String, List>();
            ArrayList<String> orderedInstantsList = new ArrayList<String>();
            HashSet<HoodieLogFile> scannedLogFiles = new HashSet<HoodieLogFile>();
            block14: while (logFormatReaderWrapper.hasNext()) {
                HoodieLogFile logFile2 = logFormatReaderWrapper.getLogFile();
                LOG.info((Object)("Scanning log file " + logFile2));
                scannedLogFiles.add(logFile2);
                this.totalLogFiles.set(scannedLogFiles.size());
                HoodieLogBlock logBlock = logFormatReaderWrapper.next();
                String instantTime = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                this.totalLogBlocks.incrementAndGet();
                if (logBlock.getBlockType().equals((Object)HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK)) {
                    LOG.info((Object)("Found a corrupt block in " + logFile2.getPath()));
                    this.totalCorruptBlocks.incrementAndGet();
                    continue;
                }
                if (!HoodieTimeline.compareTimestamps(logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME), HoodieTimeline.LESSER_THAN_OR_EQUALS, this.latestInstantTime)) break;
                if (logBlock.getBlockType() != HoodieLogBlock.HoodieLogBlockType.COMMAND_BLOCK && (!completedInstantsTimeline.containsOrBeforeTimelineStarts(instantTime) || inflightInstantsTimeline.containsInstant(instantTime) || this.instantRange.isPresent() && !this.instantRange.get().isInRange(instantTime))) continue;
                switch (logBlock.getBlockType()) {
                    case HFILE_DATA_BLOCK: 
                    case AVRO_DATA_BLOCK: 
                    case DELETE_BLOCK: {
                        List logBlocksList = instantToBlocksMap.getOrDefault(instantTime, new ArrayList());
                        if (logBlocksList.size() == 0) {
                            orderedInstantsList.add(instantTime);
                        }
                        logBlocksList.add(logBlock);
                        instantToBlocksMap.put(instantTime, logBlocksList);
                        continue block14;
                    }
                    case COMMAND_BLOCK: {
                        LOG.info((Object)("Reading a command block from file " + logFile2.getPath()));
                        HoodieCommandBlock commandBlock = (HoodieCommandBlock)logBlock;
                        if (commandBlock.getType().equals((Object)HoodieCommandBlock.HoodieCommandBlockTypeEnum.ROLLBACK_BLOCK)) {
                            this.totalRollbacks.incrementAndGet();
                            String targetInstantForCommandBlock = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME);
                            targetRollbackInstants.add(targetInstantForCommandBlock);
                            continue block14;
                        }
                        throw new UnsupportedOperationException("Command type not yet supported.");
                    }
                }
                throw new UnsupportedOperationException("Block type not yet supported.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ordered instant times seen " + orderedInstantsList));
            }
            int numBlocksRolledBack = 0;
            HashSet<String> instantTimesIncluded = new HashSet<String>();
            HashMap blockTimeToCompactionBlockTimeMap = new HashMap();
            for (int i = orderedInstantsList.size() - 1; i >= 0; --i) {
                List logBlocks;
                String instantTime = (String)orderedInstantsList.get(i);
                if (targetRollbackInstants.contains(instantTime)) {
                    numBlocksRolledBack += ((List)instantToBlocksMap.get(instantTime)).size();
                    continue;
                }
                List instantsBlocks = (List)instantToBlocksMap.get(instantTime);
                if (instantsBlocks.size() == 0) {
                    throw new HoodieException("Data corrupted while writing. Found zero blocks for an instant " + instantTime);
                }
                HoodieLogBlock firstBlock = (HoodieLogBlock)instantsBlocks.get(0);
                if (firstBlock.getLogBlockHeader().containsKey((Object)HoodieLogBlock.HeaderMetadataType.COMPACTED_BLOCK_TIMES)) {
                    Arrays.stream(firstBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.COMPACTED_BLOCK_TIMES).split(",")).forEach(originalInstant -> {
                        String finalInstant = blockTimeToCompactionBlockTimeMap.getOrDefault(instantTime, instantTime);
                        blockTimeToCompactionBlockTimeMap.put(originalInstant, finalInstant);
                    });
                    continue;
                }
                String compactedFinalInstantTime = (String)blockTimeToCompactionBlockTimeMap.get(instantTime);
                if (compactedFinalInstantTime == null) {
                    logBlocks = (List)instantToBlocksMap.get(instantTime);
                    Collections.reverse(logBlocks);
                    logBlocks.forEach(block -> this.currentInstantLogBlocks.addLast((HoodieLogBlock)block));
                    instantTimesIncluded.add(instantTime);
                    this.validBlockInstants.add(instantTime);
                    continue;
                }
                if (instantTimesIncluded.contains(compactedFinalInstantTime)) continue;
                logBlocks = (List)instantToBlocksMap.get(compactedFinalInstantTime);
                Collections.reverse(logBlocks);
                logBlocks.forEach(block -> this.currentInstantLogBlocks.addLast((HoodieLogBlock)block));
                instantTimesIncluded.add(compactedFinalInstantTime);
                this.validBlockInstants.add(compactedFinalInstantTime);
            }
            LOG.info((Object)("Number of applied rollback blocks " + numBlocksRolledBack));
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Final view of the Block time to compactionBlockMap " + blockTimeToCompactionBlockTimeMap));
            }
            if (!this.currentInstantLogBlocks.isEmpty() && !skipProcessingBlocks) {
                LOG.info((Object)"Merging the final data blocks");
                this.processQueuedBlocksForInstant(this.currentInstantLogBlocks, scannedLogFiles.size(), keySpecOption);
            }
            this.progress = 1.0f;
        }
        catch (IOException e) {
            LOG.error((Object)"Got IOException when reading log file", (Throwable)e);
            throw new HoodieIOException("IOException when reading log file ", e);
        }
        catch (Exception e) {
            LOG.error((Object)"Got exception when reading log file", (Throwable)e);
            throw new HoodieException("Exception when reading log file ", e);
        }
        finally {
            try {
                if (null != logFormatReaderWrapper) {
                    logFormatReaderWrapper.close();
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)"Unable to close log format reader", (Throwable)ioe);
            }
        }
    }

    private boolean isNewInstantBlock(HoodieLogBlock logBlock) {
        return this.currentInstantLogBlocks.size() > 0 && this.currentInstantLogBlocks.peek().getBlockType() != HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK && !logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME).contentEquals(this.currentInstantLogBlocks.peek().getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME));
    }

    private void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws Exception {
        ValidationUtils.checkState(this.partitionNameOverrideOpt.isPresent() || this.partitionPathFieldOpt.isPresent(), "Either partition-name override or partition-path field had to be present");
        Option<Pair<String, String>> recordKeyPartitionPathFieldPair = this.populateMetaFields ? Option.empty() : Option.of(Pair.of(this.recordKeyField, this.partitionPathFieldOpt.orElse(null)));
        try (ClosableIteratorWithSchema<HoodieRecord> recordIterator = this.getRecordsIterator(dataBlock, keySpecOpt);){
            while (recordIterator.hasNext()) {
                HoodieRecord completedRecord = recordIterator.next().wrapIntoHoodieRecordPayloadWithParams(recordIterator.getSchema(), this.hoodieTableMetaClient.getTableConfig().getProps(), recordKeyPartitionPathFieldPair, this.withOperationField, this.partitionNameOverrideOpt, this.populateMetaFields);
                this.processNextRecord(completedRecord);
                this.totalLogRecords.incrementAndGet();
            }
        }
    }

    protected abstract <T> void processNextRecord(HoodieRecord<T> var1) throws Exception;

    protected abstract void processNextDeletedRecord(DeleteRecord var1);

    private void processQueuedBlocksForInstant(Deque<HoodieLogBlock> logBlocks, int numLogFilesSeen, Option<KeySpec> keySpecOpt) throws Exception {
        while (!logBlocks.isEmpty()) {
            LOG.info((Object)("Number of remaining logblocks to merge " + logBlocks.size()));
            HoodieLogBlock lastBlock = logBlocks.pollLast();
            switch (lastBlock.getBlockType()) {
                case HFILE_DATA_BLOCK: 
                case AVRO_DATA_BLOCK: 
                case PARQUET_DATA_BLOCK: {
                    this.processDataBlock((HoodieDataBlock)lastBlock, keySpecOpt);
                    break;
                }
                case DELETE_BLOCK: {
                    Arrays.stream(((HoodieDeleteBlock)lastBlock).getRecordsToDelete()).forEach(this::processNextDeletedRecord);
                    break;
                }
                case CORRUPT_BLOCK: {
                    LOG.warn((Object)"Found a corrupt block which was not rolled back");
                    break;
                }
            }
        }
        this.progress = (numLogFilesSeen - 1) / this.logFilePaths.size();
    }

    private boolean shouldLookupRecords() {
        return !this.forceFullScan;
    }

    public float getProgress() {
        return this.progress;
    }

    public long getTotalLogFiles() {
        return this.totalLogFiles.get();
    }

    public long getTotalLogRecords() {
        return this.totalLogRecords.get();
    }

    public long getTotalLogBlocks() {
        return this.totalLogBlocks.get();
    }

    protected String getPayloadClassFQN() {
        return this.payloadClassFQN;
    }

    public Option<String> getPartitionNameOverride() {
        return this.partitionNameOverrideOpt;
    }

    public long getTotalRollbacks() {
        return this.totalRollbacks.get();
    }

    public long getTotalCorruptBlocks() {
        return this.totalCorruptBlocks.get();
    }

    public boolean isWithOperationField() {
        return this.withOperationField;
    }

    protected TypedProperties getPayloadProps() {
        return this.payloadProps;
    }

    public Deque<HoodieLogBlock> getCurrentInstantLogBlocks() {
        return this.currentInstantLogBlocks;
    }

    public List<String> getValidBlockInstants() {
        return this.validBlockInstants;
    }

    private ClosableIteratorWithSchema<HoodieRecord> getRecordsIterator(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        ClosableIterator blockRecordsIterator;
        if (keySpecOpt.isPresent()) {
            KeySpec keySpec = keySpecOpt.get();
            blockRecordsIterator = dataBlock.getRecordIterator(keySpec.getKeys(), keySpec.isFullKey(), this.recordType);
        } else {
            blockRecordsIterator = dataBlock.getRecordIterator(this.recordType);
        }
        Option<Pair<Function<HoodieRecord, HoodieRecord>, Schema>> schemaEvolutionTransformerOpt = this.composeEvolvedSchemaTransformer(dataBlock);
        if (schemaEvolutionTransformerOpt.isPresent()) {
            return ClosableIteratorWithSchema.newInstance(new CloseableMappingIterator<HoodieRecord, HoodieRecord>(blockRecordsIterator, schemaEvolutionTransformerOpt.get().getLeft()), schemaEvolutionTransformerOpt.get().getRight());
        }
        return ClosableIteratorWithSchema.newInstance(blockRecordsIterator, dataBlock.getSchema());
    }

    private Option<Pair<Function<HoodieRecord, HoodieRecord>, Schema>> composeEvolvedSchemaTransformer(HoodieDataBlock dataBlock) {
        if (this.internalSchema.isEmptySchema()) {
            return Option.empty();
        }
        long currentInstantTime = Long.parseLong(dataBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME));
        InternalSchema fileSchema = InternalSchemaCache.searchSchemaAndCache(currentInstantTime, this.hoodieTableMetaClient, false);
        InternalSchema mergedInternalSchema = new InternalSchemaMerger(fileSchema, this.internalSchema, true, false).mergeSchema();
        Schema mergedAvroSchema = AvroInternalSchemaConverter.convert(mergedInternalSchema, this.readerSchema.getFullName());
        return Option.of(Pair.of(record -> record.rewriteRecordWithNewSchema(dataBlock.getSchema(), this.hoodieTableMetaClient.getTableConfig().getProps(), mergedAvroSchema, Collections.emptyMap()), mergedAvroSchema));
    }

    public static abstract class Builder {
        public abstract Builder withFileSystem(FileSystem var1);

        public abstract Builder withBasePath(String var1);

        public abstract Builder withLogFilePaths(List<String> var1);

        public abstract Builder withReaderSchema(Schema var1);

        public abstract Builder withInternalSchema(InternalSchema var1);

        public abstract Builder withLatestInstantTime(String var1);

        public abstract Builder withReadBlocksLazily(boolean var1);

        public abstract Builder withReverseReader(boolean var1);

        public abstract Builder withBufferSize(int var1);

        public Builder withPartition(String partitionName) {
            throw new UnsupportedOperationException();
        }

        public Builder withInstantRange(Option<InstantRange> instantRange) {
            throw new UnsupportedOperationException();
        }

        public Builder withOperationField(boolean withOperationField) {
            throw new UnsupportedOperationException();
        }

        public Builder withRecordMerger(HoodieRecordMerger recordMerger) {
            throw new UnsupportedOperationException();
        }

        public Builder withOptimizedLogBlocksScan(boolean enableOptimizedLogBlocksScan) {
            throw new UnsupportedOperationException();
        }

        public abstract AbstractHoodieLogRecordReader build();
    }

    private static class PrefixKeySpec
    implements KeySpec {
        private final List<String> keysPrefixes;

        private PrefixKeySpec(List<String> keysPrefixes) {
            this.keysPrefixes = keysPrefixes;
        }

        @Override
        public List<String> getKeys() {
            return this.keysPrefixes;
        }

        @Override
        public boolean isFullKey() {
            return false;
        }
    }

    private static class FullKeySpec
    implements KeySpec {
        private final List<String> keys;

        private FullKeySpec(List<String> keys2) {
            this.keys = keys2;
        }

        @Override
        public List<String> getKeys() {
            return this.keys;
        }

        @Override
        public boolean isFullKey() {
            return true;
        }
    }

    protected static interface KeySpec {
        public List<String> getKeys();

        public boolean isFullKey();

        public static KeySpec fullKeySpec(List<String> keys2) {
            return new FullKeySpec(keys2);
        }

        public static KeySpec prefixKeySpec(List<String> keyPrefixes) {
            return new PrefixKeySpec(keyPrefixes);
        }
    }
}

