/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;

public abstract class HoodieDataBlock
extends HoodieLogBlock {
    private final Option<List<HoodieRecord>> records;
    private final String keyFieldName;
    private final boolean enablePointLookups;
    protected Schema readerSchema;

    public HoodieDataBlock(List<HoodieRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer, String keyFieldName) {
        super(header, footer, Option.empty(), Option.empty(), null, false);
        this.records = Option.of(records);
        this.keyFieldName = keyFieldName;
        this.readerSchema = HoodieDataBlock.getWriterSchema(super.getLogBlockHeader());
        this.enablePointLookups = false;
    }

    protected HoodieDataBlock(Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> headers, Map<HoodieLogBlock.HeaderMetadataType, String> footer, String keyFieldName, boolean enablePointLookups) {
        super(headers, footer, blockContentLocation, content, inputStream, readBlockLazily);
        this.records = Option.empty();
        this.keyFieldName = keyFieldName;
        this.readerSchema = readerSchema.orElseGet(() -> HoodieDataBlock.getWriterSchema(super.getLogBlockHeader()));
        this.enablePointLookups = enablePointLookups;
    }

    @Override
    public byte[] getContentBytes() throws IOException {
        Option<byte[]> content = this.getContent();
        ValidationUtils.checkState(content.isPresent() || this.records.isPresent(), "Block is in invalid state");
        if (content.isPresent()) {
            return content.get();
        }
        return this.serializeRecords(this.records.get());
    }

    protected static Schema getWriterSchema(Map<HoodieLogBlock.HeaderMetadataType, String> logBlockHeader) {
        return new Schema.Parser().parse(logBlockHeader.get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
    }

    public final <T> ClosableIterator<HoodieRecord<T>> getRecordIterator(HoodieRecord.HoodieRecordType type) {
        if (this.records.isPresent()) {
            return HoodieDataBlock.list2Iterator((List)TypeUtils.unsafeCast(this.records.get()));
        }
        try {
            return this.readRecordsFromBlockPayload(type);
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to convert content bytes to records", io);
        }
    }

    public Schema getSchema() {
        return this.readerSchema;
    }

    public final <T> ClosableIterator<HoodieRecord<T>> getRecordIterator(List<String> keys2, boolean fullKey, HoodieRecord.HoodieRecordType type) throws IOException {
        boolean fullScan = keys2.isEmpty();
        if (this.enablePointLookups && !fullScan) {
            return this.lookupRecords(keys2, fullKey);
        }
        ClosableIterator<HoodieRecord<T>> allRecords = this.getRecordIterator(type);
        if (fullScan) {
            return allRecords;
        }
        HashSet<String> keySet = new HashSet<String>(keys2);
        return FilteringIterator.getInstance(allRecords, keySet, fullKey, this::getRecordKey);
    }

    protected <T> ClosableIterator<HoodieRecord<T>> readRecordsFromBlockPayload(HoodieRecord.HoodieRecordType type) throws IOException {
        if (this.readBlockLazily && !this.getContent().isPresent()) {
            this.inflate();
        }
        try {
            ClosableIterator<HoodieRecord<T>> closableIterator = this.deserializeRecords(this.getContent().get(), type);
            return closableIterator;
        }
        finally {
            this.deflate();
        }
    }

    protected <T> ClosableIterator<HoodieRecord<T>> lookupRecords(List<String> keys2, boolean fullKey) throws IOException {
        throw new UnsupportedOperationException(String.format("Point lookups are not supported by this Data block type (%s)", new Object[]{this.getBlockType()}));
    }

    protected abstract byte[] serializeRecords(List<HoodieRecord> var1) throws IOException;

    protected abstract <T> ClosableIterator<HoodieRecord<T>> deserializeRecords(byte[] var1, HoodieRecord.HoodieRecordType var2) throws IOException;

    @Override
    public abstract HoodieLogBlock.HoodieLogBlockType getBlockType();

    protected Option<Schema.Field> getKeyField(Schema schema2) {
        return Option.ofNullable(schema2.getField(this.keyFieldName));
    }

    protected Option<String> getRecordKey(HoodieRecord record) {
        return Option.ofNullable(record.getRecordKey(this.readerSchema, this.keyFieldName));
    }

    static <T> ClosableIterator<T> list2Iterator(List<T> list) {
        final Iterator<T> iterator2 = list.iterator();
        return new ClosableIterator<T>(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public T next() {
                return iterator2.next();
            }
        };
    }

    private static class FilteringIterator<T>
    implements ClosableIterator<HoodieRecord<T>> {
        private final ClosableIterator<HoodieRecord<T>> nested;
        private final Set<String> keys;
        private final boolean fullKey;
        private final Function<HoodieRecord<T>, Option<String>> keyExtract;
        private HoodieRecord<T> next;

        private FilteringIterator(ClosableIterator<HoodieRecord<T>> nested, Set<String> keys2, boolean fullKey, Function<HoodieRecord<T>, Option<String>> keyExtract) {
            this.nested = nested;
            this.keys = keys2;
            this.fullKey = fullKey;
            this.keyExtract = keyExtract;
        }

        public static <T> FilteringIterator<T> getInstance(ClosableIterator<HoodieRecord<T>> nested, Set<String> keys2, boolean fullKey, Function<HoodieRecord<T>, Option<String>> keyExtract) {
            return new FilteringIterator<T>(nested, keys2, fullKey, keyExtract);
        }

        @Override
        public void close() {
            this.nested.close();
        }

        @Override
        public boolean hasNext() {
            while (this.nested.hasNext()) {
                this.next = (HoodieRecord)this.nested.next();
                String key = this.keyExtract.apply(this.next).orElseGet(() -> {
                    throw new IllegalStateException(String.format("Record without a key (%s)", this.next));
                });
                if (!this.fullKey || !this.keys.contains(key)) {
                    if (this.fullKey) continue;
                    if (!this.keys.stream().anyMatch(key::startsWith)) continue;
                }
                return true;
            }
            return false;
        }

        @Override
        public HoodieRecord<T> next() {
            return this.next;
        }
    }
}

