/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieActiveTimeline
extends HoodieDefaultTimeline {
    public static final Set<String> VALID_EXTENSIONS_IN_ACTIVE_TIMELINE = new HashSet<String>(Arrays.asList(".commit", ".inflight", ".commit.requested", ".deltacommit", ".deltacommit.inflight", ".deltacommit.requested", ".savepoint", ".savepoint.inflight", ".clean", ".clean.requested", ".clean.inflight", INFLIGHT_COMPACTION_EXTENSION, REQUESTED_COMPACTION_EXTENSION, ".restore.requested", ".restore.inflight", ".restore", INFLIGHT_LOG_COMPACTION_EXTENSION, REQUESTED_LOG_COMPACTION_EXTENSION, ".rollback", ".rollback.requested", ".rollback.inflight", ".replacecommit.requested", ".replacecommit.inflight", ".replacecommit", ".indexing.requested", ".indexing.inflight", ".indexing", ".schemacommit.requested", ".schemacommit.inflight", ".schemacommit"));
    private static final Set<String> NOT_PARSABLE_TIMESTAMPS = new HashSet<String>(3){
        {
            this.add("00000000000000");
            this.add("00000000000001");
            this.add("00000000000002");
        }
    };
    private static final Logger LOG = LogManager.getLogger(HoodieActiveTimeline.class);
    protected HoodieTableMetaClient metaClient;

    public static Date parseDateFromInstantTime(String timestamp) throws ParseException {
        return HoodieInstantTimeGenerator.parseDateFromInstantTime(timestamp);
    }

    public static Option<Date> parseDateFromInstantTimeSafely(String timestamp) {
        Option<Date> parsedDate;
        try {
            parsedDate = Option.of(HoodieInstantTimeGenerator.parseDateFromInstantTime(timestamp));
        }
        catch (ParseException e) {
            if (NOT_PARSABLE_TIMESTAMPS.contains(timestamp)) {
                parsedDate = Option.of(new Date(Integer.parseInt(timestamp)));
            }
            LOG.warn((Object)("Failed to parse timestamp " + timestamp + ": " + e.getMessage()));
            parsedDate = Option.empty();
        }
        return parsedDate;
    }

    public static String formatDate(Date timestamp) {
        return HoodieInstantTimeGenerator.formatDate(timestamp);
    }

    public static String createNewInstantTime() {
        return HoodieInstantTimeGenerator.createNewInstantTime(0L);
    }

    public static String createNewInstantTime(long milliseconds) {
        return HoodieInstantTimeGenerator.createNewInstantTime(milliseconds);
    }

    protected HoodieActiveTimeline(HoodieTableMetaClient metaClient, Set<String> includedExtensions) {
        this(metaClient, includedExtensions, true);
    }

    protected HoodieActiveTimeline(HoodieTableMetaClient metaClient, Set<String> includedExtensions, boolean applyLayoutFilters) {
        try {
            this.setInstants(metaClient.scanHoodieInstantsFromFileSystem(includedExtensions, applyLayoutFilters));
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to scan metadata", e);
        }
        this.metaClient = metaClient;
        this.details = this::getInstantDetails;
        LOG.info((Object)("Loaded instants upto : " + this.lastInstant()));
    }

    public HoodieActiveTimeline(HoodieTableMetaClient metaClient) {
        this(metaClient, Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE));
    }

    public HoodieActiveTimeline(HoodieTableMetaClient metaClient, boolean applyLayoutFilter) {
        this(metaClient, Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE), applyLayoutFilter);
    }

    @Deprecated
    public HoodieActiveTimeline() {
    }

    @Deprecated
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void createNewInstant(HoodieInstant instant) {
        LOG.info((Object)("Creating a new instant " + instant));
        this.createFileInMetaPath(instant.getFileName(), Option.empty(), false);
    }

    public void createRequestedReplaceCommit(String instantTime, String actionType) {
        try {
            HoodieInstant instant = new HoodieInstant(HoodieInstant.State.REQUESTED, actionType, instantTime);
            LOG.info((Object)("Creating a new instant " + instant));
            this.createFileInMetaPath(instant.getFileName(), TimelineMetadataUtils.serializeRequestedReplaceMetadata(new HoodieRequestedReplaceMetadata()), false);
        }
        catch (IOException e) {
            throw new HoodieIOException("Error create requested replace commit ", e);
        }
    }

    public void saveAsComplete(HoodieInstant instant, Option<byte[]> data) {
        LOG.info((Object)("Marking instant complete " + instant));
        ValidationUtils.checkArgument(instant.isInflight(), "Could not mark an already completed instant as complete again " + instant);
        this.transitionState(instant, HoodieTimeline.getCompletedInstant(instant), data);
        LOG.info((Object)("Completed " + instant));
    }

    public HoodieInstant revertToInflight(HoodieInstant instant) {
        LOG.info((Object)("Reverting instant to inflight " + instant));
        HoodieInstant inflight = HoodieTimeline.getInflightInstant(instant, this.metaClient);
        this.revertCompleteToInflight(instant, inflight);
        LOG.info((Object)("Reverted " + instant + " to inflight " + inflight));
        return inflight;
    }

    public void deleteInflight(HoodieInstant instant) {
        ValidationUtils.checkArgument(instant.isInflight());
        this.deleteInstantFile(instant);
    }

    public void deletePending(HoodieInstant instant) {
        ValidationUtils.checkArgument(!instant.isCompleted());
        this.deleteInstantFile(instant);
    }

    public void deleteCompletedRollback(HoodieInstant instant) {
        ValidationUtils.checkArgument(instant.isCompleted());
        this.deleteInstantFile(instant);
    }

    public static void deleteInstantFile(FileSystem fs, String metaPath, HoodieInstant instant) {
        try {
            fs.delete(new Path(metaPath, instant.getFileName()), false);
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not delete instant file" + instant.getFileName(), e);
        }
    }

    public void deleteEmptyInstantIfExists(HoodieInstant instant) {
        ValidationUtils.checkArgument(this.isEmpty(instant));
        this.deleteInstantFileIfExists(instant);
    }

    public void deleteCompactionRequested(HoodieInstant instant) {
        ValidationUtils.checkArgument(instant.isRequested());
        ValidationUtils.checkArgument(Objects.equals(instant.getAction(), "compaction"));
        this.deleteInstantFile(instant);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteInstantFileIfExists(HoodieInstant instant) {
        LOG.info((Object)("Deleting instant " + instant));
        Path commitFilePath = this.getInstantFileNamePath(instant.getFileName());
        try {
            if (this.metaClient.getFs().exists(commitFilePath)) {
                boolean result = this.metaClient.getFs().delete(commitFilePath, false);
                if (!result) throw new HoodieIOException("Could not delete instant " + instant);
                LOG.info((Object)("Removed instant " + instant));
                return;
            } else {
                LOG.warn((Object)("The commit " + commitFilePath + " to remove does not exist"));
            }
            return;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not remove commit " + commitFilePath, e);
        }
    }

    protected void deleteInstantFile(HoodieInstant instant) {
        LOG.info((Object)("Deleting instant " + instant));
        Path inFlightCommitFilePath = this.getInstantFileNamePath(instant.getFileName());
        try {
            boolean result = this.metaClient.getFs().delete(inFlightCommitFilePath, false);
            if (!result) {
                throw new HoodieIOException("Could not delete instant " + instant);
            }
            LOG.info((Object)("Removed instant " + instant));
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not remove inflight commit " + inFlightCommitFilePath, e);
        }
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        Path detailPath = this.getInstantFileNamePath(instant.getFileName());
        return this.readDataFromPath(detailPath);
    }

    public Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLastCommitMetadataWithValidSchema() {
        return Option.fromJavaOptional(this.getCommitMetadataStream().filter((? super T instantCommitMetadataPair) -> !StringUtils.isNullOrEmpty(((HoodieCommitMetadata)instantCommitMetadataPair.getValue()).getMetadata("schema"))).findFirst());
    }

    public Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLastCommitMetadataWithValidData() {
        return Option.fromJavaOptional(this.getCommitMetadataStream().filter((? super T instantCommitMetadataPair) -> !((HoodieCommitMetadata)instantCommitMetadataPair.getValue()).getFileIdAndRelativePaths().isEmpty()).findFirst());
    }

    private Stream<Pair<HoodieInstant, HoodieCommitMetadata>> getCommitMetadataStream() {
        return this.getCommitsTimeline().filterCompletedInstants().getInstantsAsStream().sorted(Comparator.comparing(HoodieInstant::getTimestamp).reversed()).map(instant -> {
            try {
                HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(this.getInstantDetails((HoodieInstant)instant).get(), HoodieCommitMetadata.class);
                return Pair.of(instant, commitMetadata);
            }
            catch (IOException e) {
                throw new HoodieIOException(String.format("Failed to fetch HoodieCommitMetadata for instant (%s)", instant), e);
            }
        });
    }

    public Option<byte[]> readCleanerInfoAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(this.getInstantFileNamePath(instant.getFileName()));
    }

    public Option<byte[]> readRollbackInfoAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(this.getInstantFileNamePath(instant.getFileName()));
    }

    public Option<byte[]> readRestoreInfoAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(new Path(this.metaClient.getMetaPath(), instant.getFileName()));
    }

    public Option<byte[]> readCompactionPlanAsBytes(HoodieInstant instant) {
        try {
            return this.readDataFromPath(new Path(this.metaClient.getMetaAuxiliaryPath(), instant.getFileName()));
        }
        catch (HoodieIOException e) {
            if (e.getIOException() instanceof FileNotFoundException) {
                return this.readDataFromPath(new Path(this.metaClient.getMetaPath(), instant.getFileName()));
            }
            throw e;
        }
    }

    public Option<byte[]> readIndexPlanAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(new Path(this.metaClient.getMetaPath(), instant.getFileName()));
    }

    public HoodieInstant revertInstantFromInflightToRequested(HoodieInstant inflightInstant) {
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant requestedInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, inflightInstant.getAction(), inflightInstant.getTimestamp());
        if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            this.transitionState(inflightInstant, requestedInstant, Option.empty());
        } else {
            this.deleteInflight(inflightInstant);
        }
        return requestedInstant;
    }

    public HoodieInstant revertLogCompactionInflightToRequested(HoodieInstant inflightInstant) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant requestedInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "logcompaction", inflightInstant.getTimestamp());
        if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            this.transitionState(inflightInstant, requestedInstant, Option.empty());
        } else {
            this.deleteInflight(inflightInstant);
        }
        return requestedInstant;
    }

    public HoodieInstant transitionCompactionRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("compaction"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "compaction", requestedInstant.getTimestamp());
        this.transitionState(requestedInstant, inflightInstant, Option.empty());
        return inflightInstant;
    }

    public HoodieInstant transitionLogCompactionRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "logcompaction", requestedInstant.getTimestamp());
        this.transitionState(requestedInstant, inflightInstant, Option.empty());
        return inflightInstant;
    }

    public HoodieInstant transitionCompactionInflightToComplete(HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("compaction"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", inflightInstant.getTimestamp());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    public HoodieInstant transitionLogCompactionInflightToComplete(HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "deltacommit", inflightInstant.getTimestamp());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    private void createFileInAuxiliaryFolder(HoodieInstant instant, Option<byte[]> data) {
        Path fullPath = new Path(this.metaClient.getMetaAuxiliaryPath(), instant.getFileName());
        FileIOUtils.createFileInPath(this.metaClient.getFs(), fullPath, data);
    }

    public HoodieInstant transitionCleanInflightToComplete(HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("clean"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", inflightInstant.getTimestamp());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    public HoodieInstant transitionCleanRequestedToInflight(HoodieInstant requestedInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("clean"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflight = new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", requestedInstant.getTimestamp());
        this.transitionState(requestedInstant, inflight, data);
        return inflight;
    }

    public HoodieInstant transitionRollbackInflightToComplete(HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("rollback"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "rollback", inflightInstant.getTimestamp());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    public HoodieInstant transitionRollbackRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("rollback"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflight = new HoodieInstant(HoodieInstant.State.INFLIGHT, "rollback", requestedInstant.getTimestamp());
        this.transitionState(requestedInstant, inflight, Option.empty());
        return inflight;
    }

    public HoodieInstant transitionRestoreRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("restore"), "Transition to inflight requested for a restore instant with diff action " + requestedInstant.toString());
        ValidationUtils.checkArgument(requestedInstant.isRequested(), "Transition to inflight requested for an instant not in requested state " + requestedInstant.toString());
        HoodieInstant inflight = new HoodieInstant(HoodieInstant.State.INFLIGHT, "restore", requestedInstant.getTimestamp());
        this.transitionState(requestedInstant, inflight, Option.empty());
        return inflight;
    }

    public HoodieInstant transitionReplaceRequestedToInflight(HoodieInstant requestedInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("replacecommit"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "replacecommit", requestedInstant.getTimestamp());
        this.transitionState(requestedInstant, inflightInstant, data);
        return inflightInstant;
    }

    public HoodieInstant transitionReplaceInflightToComplete(HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("replacecommit"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "replacecommit", inflightInstant.getTimestamp());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    private void transitionState(HoodieInstant fromInstant, HoodieInstant toInstant, Option<byte[]> data) {
        this.transitionState(fromInstant, toInstant, data, false);
    }

    protected void transitionState(HoodieInstant fromInstant, HoodieInstant toInstant, Option<byte[]> data, boolean allowRedundantTransitions) {
        ValidationUtils.checkArgument(fromInstant.getTimestamp().equals(toInstant.getTimestamp()));
        try {
            if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
                this.createFileInMetaPath(fromInstant.getFileName(), data, allowRedundantTransitions);
                Path fromInstantPath = this.getInstantFileNamePath(fromInstant.getFileName());
                Path toInstantPath = this.getInstantFileNamePath(toInstant.getFileName());
                boolean success = this.metaClient.getFs().rename(fromInstantPath, toInstantPath);
                if (!success) {
                    throw new HoodieIOException("Could not rename " + fromInstantPath + " to " + toInstantPath);
                }
            } else {
                LOG.info((Object)("Checking for file exists ?" + this.getInstantFileNamePath(fromInstant.getFileName())));
                ValidationUtils.checkArgument(this.metaClient.getFs().exists(this.getInstantFileNamePath(fromInstant.getFileName())));
                if (allowRedundantTransitions) {
                    FileIOUtils.createFileInPath(this.metaClient.getFs(), this.getInstantFileNamePath(toInstant.getFileName()), data);
                } else {
                    this.metaClient.getFs().createImmutableFileInPath(this.getInstantFileNamePath(toInstant.getFileName()), data);
                }
                LOG.info((Object)("Create new file for toInstant ?" + this.getInstantFileNamePath(toInstant.getFileName())));
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not complete " + fromInstant, e);
        }
    }

    protected void revertCompleteToInflight(HoodieInstant completed, HoodieInstant inflight) {
        ValidationUtils.checkArgument(completed.getTimestamp().equals(inflight.getTimestamp()));
        Path inFlightCommitFilePath = this.getInstantFileNamePath(inflight.getFileName());
        Path commitFilePath = this.getInstantFileNamePath(completed.getFileName());
        try {
            if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
                boolean success;
                if (!this.metaClient.getFs().exists(inFlightCommitFilePath) && !(success = this.metaClient.getFs().rename(commitFilePath, inFlightCommitFilePath))) {
                    throw new HoodieIOException("Could not rename " + commitFilePath + " to " + inFlightCommitFilePath);
                }
            } else {
                Path requestedInstantFilePath = this.getInstantFileNamePath(new HoodieInstant(HoodieInstant.State.REQUESTED, inflight.getAction(), inflight.getTimestamp()).getFileName());
                if (!this.metaClient.getFs().exists(requestedInstantFilePath)) {
                    this.metaClient.getFs().create(requestedInstantFilePath, false).close();
                }
                if (!this.metaClient.getFs().exists(inFlightCommitFilePath)) {
                    this.metaClient.getFs().create(inFlightCommitFilePath, false).close();
                }
                boolean success = this.metaClient.getFs().delete(commitFilePath, false);
                ValidationUtils.checkArgument(success, "State Reverting failed");
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not complete revert " + completed, e);
        }
    }

    private Path getInstantFileNamePath(String fileName) {
        return new Path(fileName.contains("schemacommit") ? this.metaClient.getSchemaFolderName() : this.metaClient.getMetaPath(), fileName);
    }

    public void transitionRequestedToInflight(String commitType, String inFlightInstant) {
        HoodieInstant requested = new HoodieInstant(HoodieInstant.State.REQUESTED, commitType, inFlightInstant);
        this.transitionRequestedToInflight(requested, Option.empty(), false);
    }

    public void transitionRequestedToInflight(HoodieInstant requested, Option<byte[]> content) {
        this.transitionRequestedToInflight(requested, content, false);
    }

    public void transitionRequestedToInflight(HoodieInstant requested, Option<byte[]> content, boolean allowRedundantTransitions) {
        HoodieInstant inflight = new HoodieInstant(HoodieInstant.State.INFLIGHT, requested.getAction(), requested.getTimestamp());
        ValidationUtils.checkArgument(requested.isRequested(), "Instant " + requested + " in wrong state");
        this.transitionState(requested, inflight, content, allowRedundantTransitions);
    }

    public void saveToCompactionRequested(HoodieInstant instant, Option<byte[]> content) {
        this.saveToCompactionRequested(instant, content, false);
    }

    public void saveToCompactionRequested(HoodieInstant instant, Option<byte[]> content, boolean overwrite) {
        ValidationUtils.checkArgument(instant.getAction().equals("compaction"));
        this.createFileInAuxiliaryFolder(instant, content);
        this.createFileInMetaPath(instant.getFileName(), content, overwrite);
    }

    public void saveToLogCompactionRequested(HoodieInstant instant, Option<byte[]> content) {
        this.saveToLogCompactionRequested(instant, content, false);
    }

    public void saveToLogCompactionRequested(HoodieInstant instant, Option<byte[]> content, boolean overwrite) {
        ValidationUtils.checkArgument(instant.getAction().equals("logcompaction"));
        this.createFileInAuxiliaryFolder(instant, content);
        this.createFileInMetaPath(instant.getFileName(), content, overwrite);
    }

    public void saveToPendingReplaceCommit(HoodieInstant instant, Option<byte[]> content) {
        ValidationUtils.checkArgument(instant.getAction().equals("replacecommit"));
        this.createFileInMetaPath(instant.getFileName(), content, false);
    }

    public void saveToCleanRequested(HoodieInstant instant, Option<byte[]> content) {
        ValidationUtils.checkArgument(instant.getAction().equals("clean"));
        ValidationUtils.checkArgument(instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(instant.getFileName(), content, false);
    }

    public void saveToRollbackRequested(HoodieInstant instant, Option<byte[]> content) {
        ValidationUtils.checkArgument(instant.getAction().equals("rollback"));
        ValidationUtils.checkArgument(instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(instant.getFileName(), content, false);
    }

    public void saveToRestoreRequested(HoodieInstant instant, Option<byte[]> content) {
        ValidationUtils.checkArgument(instant.getAction().equals("restore"));
        ValidationUtils.checkArgument(instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(instant.getFileName(), content, false);
    }

    public HoodieInstant transitionIndexRequestedToInflight(HoodieInstant requestedInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("indexing"), String.format("%s is not equal to %s action", requestedInstant.getAction(), "indexing"));
        ValidationUtils.checkArgument(requestedInstant.isRequested(), String.format("Instant %s not in requested state", requestedInstant.getTimestamp()));
        HoodieInstant inflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "indexing", requestedInstant.getTimestamp());
        this.transitionState(requestedInstant, inflightInstant, data);
        return inflightInstant;
    }

    public HoodieInstant transitionIndexInflightToComplete(HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("indexing"), String.format("%s is not equal to %s action", inflightInstant.getAction(), "indexing"));
        ValidationUtils.checkArgument(inflightInstant.isInflight(), String.format("Instant %s not inflight", inflightInstant.getTimestamp()));
        HoodieInstant commitInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "indexing", inflightInstant.getTimestamp());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    public HoodieInstant revertIndexInflightToRequested(HoodieInstant inflightInstant) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("indexing"), String.format("%s is not equal to %s action", inflightInstant.getAction(), "indexing"));
        ValidationUtils.checkArgument(inflightInstant.isInflight(), String.format("Instant %s not inflight", inflightInstant.getTimestamp()));
        HoodieInstant requestedInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "indexing", inflightInstant.getTimestamp());
        if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            this.transitionState(inflightInstant, requestedInstant, Option.empty());
        } else {
            this.deleteInflight(inflightInstant);
        }
        return requestedInstant;
    }

    public void saveToPendingIndexAction(HoodieInstant instant, Option<byte[]> content) {
        ValidationUtils.checkArgument(instant.getAction().equals("indexing"), String.format("%s is not equal to %s action", instant.getAction(), "indexing"));
        this.createFileInMetaPath(instant.getFileName(), content, false);
    }

    protected void createFileInMetaPath(String filename, Option<byte[]> content, boolean allowOverwrite) {
        Path fullPath = this.getInstantFileNamePath(filename);
        if (allowOverwrite || this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            FileIOUtils.createFileInPath(this.metaClient.getFs(), fullPath, content);
        } else {
            this.metaClient.getFs().createImmutableFileInPath(fullPath, content);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Option<byte[]> readDataFromPath(Path detailPath) {
        try (FSDataInputStream is = this.metaClient.getFs().open(detailPath);){
            Option<byte[]> option2 = Option.of(FileIOUtils.readAsByteArray((InputStream)is));
            return option2;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not read commit details from " + detailPath, e);
        }
    }

    public HoodieActiveTimeline reload() {
        return new HoodieActiveTimeline(this.metaClient);
    }
}

