/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import org.apache.avro.Schema;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ObjectSizeCalculator;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieRecordSizeEstimator<T>
implements SizeEstimator<HoodieRecord<T>> {
    private static final Logger LOG = LogManager.getLogger(HoodieRecordSizeEstimator.class);
    private final long sizeOfSchema;

    public HoodieRecordSizeEstimator(Schema schema2) {
        this.sizeOfSchema = ObjectSizeCalculator.getObjectSize(schema2);
    }

    @Override
    public long sizeEstimate(HoodieRecord<T> hoodieRecord) {
        long sizeOfRecord = ObjectSizeCalculator.getObjectSize(hoodieRecord);
        LOG.debug((Object)("SizeOfRecord => " + sizeOfRecord + " SizeOfSchema => " + this.sizeOfSchema));
        return sizeOfRecord;
    }
}

