/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@ThreadSafe
public class RateLimiter {
    private final Semaphore semaphore;
    private final int maxPermits;
    private final TimeUnit timePeriod;
    private ScheduledExecutorService scheduler;
    private static final long RELEASE_PERMITS_PERIOD_IN_SECONDS = 1L;
    private static final long WAIT_BEFORE_NEXT_ACQUIRE_PERMIT_IN_MS = 5L;
    private static final int SCHEDULER_CORE_THREAD_POOL_SIZE = 1;
    private static final Logger LOG = LogManager.getLogger(RateLimiter.class);

    public static RateLimiter create(int permits, TimeUnit timePeriod) {
        RateLimiter limiter = new RateLimiter(permits, timePeriod);
        limiter.releasePermitsPeriodically();
        return limiter;
    }

    private RateLimiter(int permits, TimeUnit timePeriod) {
        this.semaphore = new Semaphore(permits);
        this.maxPermits = permits;
        this.timePeriod = timePeriod;
    }

    public boolean tryAcquire(int numPermits) {
        for (int remainingPermits = numPermits; remainingPermits > 0; remainingPermits -= this.maxPermits) {
            if (remainingPermits > this.maxPermits) {
                this.acquire(this.maxPermits);
                continue;
            }
            return this.acquire(remainingPermits);
        }
        return true;
    }

    public boolean acquire(int numOps) {
        try {
            while (!this.semaphore.tryAcquire(numOps)) {
                Thread.sleep(5L);
            }
            LOG.debug((Object)String.format("acquire permits: %s, maxPremits: %s", numOps, this.maxPermits));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to acquire permits", e);
        }
        return true;
    }

    public void stop() {
        this.scheduler.shutdownNow();
    }

    public void releasePermitsPeriodically() {
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(() -> {
            LOG.debug((Object)String.format("Release permits: maxPremits: %s, available: %s", this.maxPermits, this.semaphore.availablePermits()));
            this.semaphore.release(this.maxPermits - this.semaphore.availablePermits());
        }, 1L, 1L, this.timePeriod);
    }
}

