/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.avro.util.Utf8;
import org.apache.hudi.common.util.HoodieCommonKryoRegistrar;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class SerializationUtils {
    private static final ThreadLocal<KryoSerializerInstance> SERIALIZER_REF = ThreadLocal.withInitial(KryoSerializerInstance::new);

    public static byte[] serialize(Object obj) throws IOException {
        return SERIALIZER_REF.get().serialize(obj);
    }

    public static <T> T deserialize(byte[] objectData) {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        return (T)SERIALIZER_REF.get().deserialize(objectData);
    }

    public static class AvroUtf8Serializer
    extends Serializer<Utf8> {
        public void write(Kryo kryo, Output output, Utf8 utf8String) {
            Serializer bytesSerializer = kryo.getDefaultSerializer(byte[].class);
            bytesSerializer.write(kryo, output, (Object)utf8String.getBytes());
        }

        public Utf8 read(Kryo kryo, Input input, Class<Utf8> type) {
            Serializer bytesSerializer = kryo.getDefaultSerializer(byte[].class);
            byte[] bytes = (byte[])bytesSerializer.read(kryo, input, byte[].class);
            return new Utf8(bytes);
        }
    }

    private static class KryoInstantiator
    implements Serializable {
        private KryoInstantiator() {
        }

        public Kryo newKryo() {
            Kryo kryo = new Kryo();
            kryo.setRegistrationRequired(false);
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
            kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
            new HoodieCommonKryoRegistrar().registerClasses(kryo);
            kryo.register(Utf8.class, (Serializer)new AvroUtf8Serializer());
            return kryo;
        }
    }

    private static class KryoSerializerInstance
    implements Serializable {
        public static final int KRYO_SERIALIZER_INITIAL_BUFFER_SIZE = 0x100000;
        private final Kryo kryo;
        private final ByteArrayOutputStream baos;

        KryoSerializerInstance() {
            KryoInstantiator kryoInstantiator = new KryoInstantiator();
            this.kryo = kryoInstantiator.newKryo();
            this.baos = new ByteArrayOutputStream(0x100000);
            this.kryo.setRegistrationRequired(false);
        }

        byte[] serialize(Object obj) {
            this.kryo.reset();
            this.baos.reset();
            Output output = new Output((OutputStream)this.baos);
            this.kryo.writeClassAndObject(output, obj);
            output.close();
            return this.baos.toByteArray();
        }

        Object deserialize(byte[] objectData) {
            return this.kryo.readClassAndObject(new Input(objectData));
        }
    }
}

