/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class ByteBufferBackedInputStream
extends InputStream {
    private final ByteBuffer buffer;
    private final int bufferOffset;

    public ByteBufferBackedInputStream(ByteBuffer buf) {
        this.buffer = buf.duplicate();
        this.buffer.mark();
        this.bufferOffset = this.buffer.position();
    }

    public ByteBufferBackedInputStream(byte[] array2) {
        this(array2, 0, array2.length);
    }

    public ByteBufferBackedInputStream(byte[] array2, int offset, int length) {
        this(ByteBuffer.wrap(array2, offset, length));
    }

    @Override
    public int read() {
        if (!this.buffer.hasRemaining()) {
            throw new IllegalArgumentException("Reading past backed buffer boundary");
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(@Nonnull byte[] bytes, int offset, int length) {
        if (!this.buffer.hasRemaining()) {
            throw new IllegalArgumentException("Reading past backed buffer boundary");
        }
        int available = Math.min(length, this.buffer.remaining());
        this.buffer.get(bytes, offset, available);
        return available;
    }

    public int getPosition() {
        return this.buffer.position() - this.bufferOffset;
    }

    public void seek(long pos) {
        this.buffer.reset();
        int offset = this.buffer.position();
        int newPos = offset + (int)pos;
        if (newPos > this.buffer.limit() || newPos < offset) {
            throw new IllegalArgumentException(String.format("Can't seek past the backing buffer (limit %d, offset %d, new %d)", this.buffer.limit(), offset, newPos));
        }
        this.buffer.position(newPos);
    }

    public int copyFrom(long pos, byte[] targetBuffer, int offset, int length) {
        int bufferPos = this.bufferOffset + (int)pos;
        if (bufferPos > this.buffer.limit()) {
            throw new IllegalArgumentException(String.format("Can't read past the backing buffer boundary (offset %d, length %d)", pos, this.buffer.limit() - this.bufferOffset));
        }
        if (length > targetBuffer.length) {
            throw new IllegalArgumentException(String.format("Target buffer is too small (length %d, buffer size %d)", length, targetBuffer.length));
        }
        int available = Math.min(length, this.buffer.limit() - bufferPos);
        System.arraycopy(this.buffer.array(), bufferPos, targetBuffer, offset, available);
        return available;
    }
}

