/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.queue;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.hudi.common.util.queue.HoodieConsumer;
import org.apache.hudi.common.util.queue.HoodieExecutor;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SimpleExecutor<I, O, E>
implements HoodieExecutor<E> {
    private static final Logger LOG = LogManager.getLogger(SimpleExecutor.class);
    private final Iterator<I> itr;
    private final HoodieConsumer<O, E> consumer;
    private final Function<I, O> transformFunction;

    public SimpleExecutor(Iterator<I> inputItr, HoodieConsumer<O, E> consumer2, Function<I, O> transformFunction) {
        this.itr = inputItr;
        this.consumer = consumer2;
        this.transformFunction = transformFunction;
    }

    @Override
    public E execute() {
        try {
            LOG.info((Object)"Starting consumer, consuming records from the records iterator directly");
            while (this.itr.hasNext()) {
                O payload = this.transformFunction.apply(this.itr.next());
                this.consumer.consume(payload);
            }
            return this.consumer.finish();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed consuming records", (Throwable)e);
            throw new HoodieException(e);
        }
    }

    @Override
    public void shutdownNow() {
    }

    @Override
    public boolean awaitTermination() {
        return true;
    }
}

