/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.util.Arrays;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class RowCustomColumnsSortPartitioner
implements BulkInsertPartitioner<Dataset<Row>> {
    private final String[] sortColumnNames;

    public RowCustomColumnsSortPartitioner(HoodieWriteConfig config) {
        this.sortColumnNames = this.getSortColumnName(config);
    }

    public RowCustomColumnsSortPartitioner(String[] columnNames) {
        this.sortColumnNames = columnNames;
    }

    @Override
    public Dataset<Row> repartitionRecords(Dataset<Row> records, int outputSparkPartitions) {
        String[] sortColumns = this.sortColumnNames;
        return records.sort(HoodieRecord.PARTITION_PATH_METADATA_FIELD, sortColumns).coalesce(outputSparkPartitions);
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return true;
    }

    private String[] getSortColumnName(HoodieWriteConfig config) {
        return (String[])Arrays.stream(config.getUserDefinedBulkInsertPartitionerSortColumns().split(",")).map(String::trim).toArray(String[]::new);
    }
}

