/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.replication;

import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.com.beust.jcommander.Parameter;
import org.apache.hudi.com.beust.jcommander.ParametersDelegate;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.hive.HiveSyncConfig;

@ConfigClassProperty(name="Global Hive Sync Configs", groupName=ConfigGroups.Names.META_SYNC, description="Global replication configurations used by the Hudi to sync metadata to Hive Metastore.")
@Immutable
public class GlobalHiveSyncConfig
extends HiveSyncConfig {
    public static final ConfigProperty<String> META_SYNC_GLOBAL_REPLICATE_TIMESTAMP = ConfigProperty.key("hoodie.meta_sync.global.replicate.timestamp").noDefaultValue().withDocumentation("");

    public GlobalHiveSyncConfig(Properties props, Configuration hadoopConf) {
        super(props, hadoopConf);
    }

    public static class GlobalHiveSyncConfigParams {
        @ParametersDelegate
        public final HiveSyncConfig.HiveSyncConfigParams hiveSyncConfigParams = new HiveSyncConfig.HiveSyncConfigParams();
        @Parameter(names={"--replicated-timestamp"}, description="Add globally replicated timestamp to enable consistent reads across clusters")
        public String globallyReplicatedTimeStamp;

        public boolean isHelp() {
            return this.hiveSyncConfigParams.isHelp();
        }

        public TypedProperties toProps() {
            TypedProperties props = this.hiveSyncConfigParams.toProps();
            props.setPropertyIfNonNull(META_SYNC_GLOBAL_REPLICATE_TIMESTAMP.key(), this.globallyReplicatedTimeStamp);
            return props;
        }
    }
}

