/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.utils;

import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;

public class AvroSchemaEvolutionUtils {
    public static InternalSchema reconcileSchema(Schema incomingSchema, InternalSchema oldTableSchema) {
        InternalSchema inComingInternalSchema = AvroInternalSchemaConverter.convert(incomingSchema);
        List<String> colNamesFromIncoming = inComingInternalSchema.getAllColsFullName();
        List<String> colNamesFromOldSchema = oldTableSchema.getAllColsFullName();
        List diffFromOldSchema = colNamesFromOldSchema.stream().filter(f -> !colNamesFromIncoming.contains(f)).collect(Collectors.toList());
        List diffFromEvolutionColumns = colNamesFromIncoming.stream().filter(f -> !colNamesFromOldSchema.contains(f)).collect(Collectors.toList());
        List typeChangeColumns = colNamesFromIncoming.stream().filter(f -> colNamesFromOldSchema.contains(f) && !inComingInternalSchema.findType((String)f).equals(oldTableSchema.findType((String)f))).collect(Collectors.toList());
        if (colNamesFromIncoming.size() == colNamesFromOldSchema.size() && diffFromOldSchema.size() == 0 && typeChangeColumns.isEmpty()) {
            return oldTableSchema;
        }
        TreeMap<Integer, String> finalAddAction = new TreeMap<Integer, String>();
        for (int i = 0; i < diffFromEvolutionColumns.size(); ++i) {
            String parentName;
            String name = (String)diffFromEvolutionColumns.get(i);
            int splitPoint = name.lastIndexOf(".");
            String string = parentName = splitPoint > 0 ? name.substring(0, splitPoint) : "";
            if (!parentName.isEmpty() && diffFromEvolutionColumns.contains(parentName)) continue;
            finalAddAction.put(inComingInternalSchema.findIdByName(name), name);
        }
        TableChanges.ColumnAddChange addChange = TableChanges.ColumnAddChange.get(oldTableSchema);
        finalAddAction.entrySet().stream().forEach(f -> {
            String name = (String)f.getValue();
            int splitPoint = name.lastIndexOf(".");
            String parentName = splitPoint > 0 ? name.substring(0, splitPoint) : "";
            String rawName = splitPoint > 0 ? name.substring(splitPoint + 1) : name;
            Optional<String> inferPosition = colNamesFromIncoming.stream().filter(c -> c.lastIndexOf(".") == splitPoint && c.startsWith(parentName) && inComingInternalSchema.findIdByName((String)c) > inComingInternalSchema.findIdByName(name) && oldTableSchema.findIdByName((String)c) > 0).sorted((s1, s2) -> oldTableSchema.findIdByName((String)s1) - oldTableSchema.findIdByName((String)s2)).findFirst();
            addChange.addColumns(parentName, rawName, inComingInternalSchema.findType(name), null);
            inferPosition.map(i -> addChange.addPositionChange(name, (String)i, "before"));
        });
        InternalSchema internalSchemaAfterAddColumns = SchemaChangeUtils.applyTableChanges2Schema(oldTableSchema, addChange);
        TableChanges.ColumnUpdateChange typeChange = TableChanges.ColumnUpdateChange.get(internalSchemaAfterAddColumns);
        typeChangeColumns.stream().filter(f -> !inComingInternalSchema.findType((String)f).isNestedType()).forEach(col -> typeChange.updateColumnType((String)col, inComingInternalSchema.findType((String)col)));
        return SchemaChangeUtils.applyTableChanges2Schema(internalSchemaAfterAddColumns, typeChange);
    }

    public static Schema canonicalizeColumnNullability(Schema writeSchema, Schema readSchema) {
        if (writeSchema.getFields().isEmpty() || readSchema.getFields().isEmpty()) {
            return writeSchema;
        }
        InternalSchema writeInternalSchema = AvroInternalSchemaConverter.convert(writeSchema);
        InternalSchema readInternalSchema = AvroInternalSchemaConverter.convert(readSchema);
        List<String> colNamesWriteSchema = writeInternalSchema.getAllColsFullName();
        List<String> colNamesFromReadSchema = readInternalSchema.getAllColsFullName();
        List candidateUpdateCols = colNamesWriteSchema.stream().filter(f -> {
            boolean exist = colNamesFromReadSchema.contains(f);
            return exist && writeInternalSchema.findField((String)f).isOptional() != readInternalSchema.findField((String)f).isOptional();
        }).collect(Collectors.toList());
        if (candidateUpdateCols.isEmpty()) {
            return writeSchema;
        }
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get(writeInternalSchema);
        candidateUpdateCols.stream().forEach(f -> updateChange.updateColumnNullability((String)f, true));
        InternalSchema updatedSchema = SchemaChangeUtils.applyTableChanges2Schema(writeInternalSchema, updateChange);
        return AvroInternalSchemaConverter.convert(updatedSchema, writeSchema.getFullName());
    }
}

