/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.utils;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;

public class InternalSchemaUtils {
    private InternalSchemaUtils() {
    }

    public static InternalSchema pruneInternalSchema(InternalSchema schema2, List<String> names) {
        List<Integer> prunedIds = names.stream().map(name -> {
            int id = schema2.findIdByName((String)name);
            if (id == -1) {
                throw new IllegalArgumentException(String.format("cannot prune col: %s which does not exist in hudi table", name));
            }
            return id;
        }).collect(Collectors.toList());
        ArrayList<Integer> topParentFieldIds = new ArrayList<Integer>();
        names.stream().forEach(f -> {
            int id = schema2.findIdByName(f.split("\\.")[0]);
            if (!topParentFieldIds.contains(id)) {
                topParentFieldIds.add(id);
            }
        });
        return InternalSchemaUtils.pruneInternalSchemaByID(schema2, prunedIds, topParentFieldIds);
    }

    public static InternalSchema pruneInternalSchemaByID(InternalSchema schema2, List<Integer> fieldIds, List<Integer> topParentFieldIds) {
        Types.RecordType recordType = (Types.RecordType)InternalSchemaUtils.pruneType(schema2.getRecord(), fieldIds);
        ArrayList<Types.Field> newFields = new ArrayList<Types.Field>();
        if (topParentFieldIds != null && !topParentFieldIds.isEmpty()) {
            for (int id : topParentFieldIds) {
                Types.Field f = recordType.field(id);
                if (f != null) {
                    newFields.add(f);
                    continue;
                }
                throw new HoodieSchemaException(String.format("cannot find pruned id %s in currentSchema %s", id, schema2.toString()));
            }
        }
        return new InternalSchema(newFields.isEmpty() ? recordType : Types.RecordType.get(newFields));
    }

    private static Type pruneType(Type type, List<Integer> fieldIds) {
        switch (type.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type;
                List<Types.Field> fields = record.fields();
                ArrayList<Type> newTypes = new ArrayList<Type>();
                for (Types.Field f : fields) {
                    Type newType = InternalSchemaUtils.pruneType(f.type(), fieldIds);
                    if (fieldIds.contains(f.fieldId())) {
                        newTypes.add(f.type());
                        continue;
                    }
                    if (newType != null) {
                        newTypes.add(newType);
                        continue;
                    }
                    newTypes.add(null);
                }
                boolean changed = false;
                ArrayList<Types.Field> newFields = new ArrayList<Types.Field>();
                for (int i = 0; i < fields.size(); ++i) {
                    Types.Field oldField = fields.get(i);
                    Type newType = (Type)newTypes.get(i);
                    if (oldField.type() == newType) {
                        newFields.add(oldField);
                        continue;
                    }
                    if (newType == null) continue;
                    changed = true;
                    newFields.add(Types.Field.get(oldField.fieldId(), oldField.isOptional(), oldField.name(), newType, oldField.doc()));
                }
                if (newFields.isEmpty()) {
                    return null;
                }
                if (newFields.size() == fields.size() && !changed) {
                    return record;
                }
                return Types.RecordType.get(newFields);
            }
            case ARRAY: {
                Types.ArrayType array2 = (Types.ArrayType)type;
                Type newElementType = InternalSchemaUtils.pruneType(array2.elementType(), fieldIds);
                if (fieldIds.contains(array2.elementId())) {
                    return array2;
                }
                if (newElementType != null) {
                    if (array2.elementType() == newElementType) {
                        return array2;
                    }
                    return Types.ArrayType.get(array2.elementId(), array2.isElementOptional(), newElementType);
                }
                return null;
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                Type newValueType = InternalSchemaUtils.pruneType(map.valueType(), fieldIds);
                if (fieldIds.contains(map.valueId())) {
                    return map;
                }
                if (newValueType != null) {
                    if (map.valueType() == newValueType) {
                        return map;
                    }
                    return Types.MapType.get(map.keyId(), map.valueId(), map.keyType(), newValueType, map.isValueOptional());
                }
                return null;
            }
        }
        return null;
    }

    public static String reBuildFilterName(String name, InternalSchema fileSchema, InternalSchema querySchema) {
        int nameId = querySchema.findIdByName(name);
        if (nameId == -1) {
            throw new IllegalArgumentException(String.format("cannot find filter col name\uff1a%s from querySchema: %s", name, querySchema));
        }
        if (fileSchema.findField(nameId) == null) {
            return "";
        }
        if (name.equals(fileSchema.findfullName(nameId))) {
            return name;
        }
        return fileSchema.findfullName(nameId);
    }

    public static Map<Integer, Pair<Type, Type>> collectTypeChangedCols(InternalSchema schema2, InternalSchema oldSchema) {
        Set<Integer> ids = schema2.getAllIds();
        Set<Integer> otherIds = oldSchema.getAllIds();
        HashMap<Integer, Pair<Type, Type>> result = new HashMap<Integer, Pair<Type, Type>>();
        ids.stream().filter(f -> otherIds.contains(f)).forEach(f -> {
            if (!schema2.findType((int)f).equals(oldSchema.findType((int)f))) {
                String[] fieldNameParts = schema2.findfullName((int)f).split("\\.");
                String[] otherFieldNameParts = oldSchema.findfullName((int)f).split("\\.");
                String parentName = fieldNameParts[0];
                String otherParentName = otherFieldNameParts[0];
                if (fieldNameParts.length == otherFieldNameParts.length && schema2.findIdByName(parentName) == oldSchema.findIdByName(otherParentName)) {
                    int index = schema2.findIdByName(parentName);
                    int position = schema2.getRecord().fields().stream().map(s -> s.fieldId()).collect(Collectors.toList()).indexOf(index);
                    if (!result.containsKey(position)) {
                        result.put(position, Pair.of(schema2.findType(parentName), oldSchema.findType(otherParentName)));
                    }
                }
            }
        });
        return result;
    }

    public static InternalSchema searchSchema(long versionId, List<InternalSchema> internalSchemas) {
        TreeMap<Long, InternalSchema> treeMap = new TreeMap<Long, InternalSchema>();
        internalSchemas.forEach(s -> treeMap.put(s.schemaId(), (InternalSchema)s));
        return InternalSchemaUtils.searchSchema(versionId, treeMap);
    }

    public static InternalSchema searchSchema(long versionId, TreeMap<Long, InternalSchema> treeMap) {
        if (treeMap.containsKey(versionId)) {
            return treeMap.get(versionId);
        }
        SortedMap<Long, InternalSchema> headMap = treeMap.headMap(versionId);
        if (!headMap.isEmpty()) {
            return (InternalSchema)headMap.get(headMap.lastKey());
        }
        return InternalSchema.getEmptyInternalSchema();
    }

    public static String createFullName(String name, Deque<String> fieldNames) {
        String result = name;
        if (!fieldNames.isEmpty()) {
            ArrayList parentNames = new ArrayList();
            fieldNames.descendingIterator().forEachRemaining(parentNames::add);
            result = parentNames.stream().collect(Collectors.joining(".")) + "." + result;
        }
        return result;
    }

    public static Map<String, String> collectRenameCols(InternalSchema oldSchema, InternalSchema newSchema) {
        List<String> colNamesFromWriteSchema = oldSchema.getAllColsFullName();
        return colNamesFromWriteSchema.stream().filter(f -> {
            int fieldIdFromWriteSchema = oldSchema.findIdByName((String)f);
            return newSchema.getAllIds().contains(fieldIdFromWriteSchema) && !newSchema.findfullName(fieldIdFromWriteSchema).equalsIgnoreCase((String)f);
        }).collect(Collectors.toMap(e -> newSchema.findfullName(oldSchema.findIdByName((String)e)), e -> {
            int lastDotIndex = e.lastIndexOf(".");
            return e.substring(lastDotIndex == -1 ? 0 : lastDotIndex + 1);
        }));
    }
}

