/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.action.TableChangesHelper;

public class SchemaChangeUtils {
    private SchemaChangeUtils() {
    }

    public static boolean isTypeUpdateAllow(Type src, Type dsr) {
        if (src.isNestedType() || dsr.isNestedType()) {
            throw new IllegalArgumentException("only support update primitive type");
        }
        if (src.equals(dsr)) {
            return true;
        }
        switch (src.typeId()) {
            case INT: {
                return dsr == Types.LongType.get() || dsr == Types.FloatType.get() || dsr == Types.DoubleType.get() || dsr == Types.StringType.get() || dsr.typeId() == Type.TypeID.DECIMAL;
            }
            case LONG: {
                return dsr == Types.FloatType.get() || dsr == Types.DoubleType.get() || dsr == Types.StringType.get() || dsr.typeId() == Type.TypeID.DECIMAL;
            }
            case FLOAT: {
                return dsr == Types.DoubleType.get() || dsr == Types.StringType.get() || dsr.typeId() == Type.TypeID.DECIMAL;
            }
            case DOUBLE: {
                return dsr == Types.StringType.get() || dsr.typeId() == Type.TypeID.DECIMAL;
            }
            case DATE: {
                return dsr == Types.StringType.get();
            }
            case DECIMAL: {
                Types.DecimalType decimalSrc;
                Types.DecimalType decimalDsr;
                return dsr.typeId() == Type.TypeID.DECIMAL ? (decimalDsr = (Types.DecimalType)dsr).isWiderThan(decimalSrc = (Types.DecimalType)src) : dsr.typeId() == Type.TypeID.STRING;
            }
            case STRING: {
                return dsr == Types.DateType.get() || dsr.typeId() == Type.TypeID.DECIMAL;
            }
            default: {
                return false;
            }
        }
    }

    public static InternalSchema applyTableChanges2Schema(InternalSchema internalSchema, TableChanges.ColumnAddChange adds) {
        Types.RecordType newType = (Types.RecordType)SchemaChangeUtils.applyTableChange2Type((Type)internalSchema.getRecord(), adds);
        List<Types.Field> newFields = TableChangesHelper.applyAddChange2Fields(newType.fields(), adds.getParentId2AddCols().get(-1), adds.getPositionChangeMap().get(-1));
        return new InternalSchema(Types.RecordType.get(newFields, newType.name()));
    }

    public static Type applyTableChange2Type(Type type, TableChanges.ColumnAddChange adds) {
        switch (type.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type;
                ArrayList<Type> newTypes = new ArrayList<Type>();
                for (Types.Field f : record.fields()) {
                    Type newType = SchemaChangeUtils.applyTableChange2Type(f.type(), adds);
                    newTypes.add(newType.isNestedType() ? adds.applyAdd(f, newType) : newType);
                }
                ArrayList<Types.Field> newFields = new ArrayList<Types.Field>();
                boolean hasChanged = false;
                for (int i = 0; i < newTypes.size(); ++i) {
                    Type newType = (Type)newTypes.get(i);
                    Types.Field oldfield = record.fields().get(i);
                    if (oldfield.type() == newType) {
                        newFields.add(oldfield);
                        continue;
                    }
                    hasChanged = true;
                    newFields.add(Types.Field.get(oldfield.fieldId(), oldfield.isOptional(), oldfield.name(), newType, oldfield.doc()));
                }
                return hasChanged ? Types.RecordType.get(newFields, record.name()) : record;
            }
            case ARRAY: {
                Types.ArrayType array2 = (Types.ArrayType)type;
                Types.Field elementField = array2.field(array2.elementId());
                Type newElementType = SchemaChangeUtils.applyTableChange2Type(array2.elementType(), adds);
                newElementType = adds.applyAdd(elementField, newElementType);
                if (newElementType == array2.elementType()) {
                    return array2;
                }
                return Types.ArrayType.get(array2.elementId(), array2.isElementOptional(), newElementType);
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                Types.Field valueField = map.field(map.valueId());
                if (adds.getParentId2AddCols().containsKey(map.keyId())) {
                    throw new IllegalArgumentException("Cannot add fields to map keys: " + map);
                }
                Type newValueType = SchemaChangeUtils.applyTableChange2Type(map.valueType(), adds);
                if ((newValueType = adds.applyAdd(valueField, newValueType)) == map.valueType()) {
                    return map;
                }
                return Types.MapType.get(map.keyId(), map.valueId(), map.keyType(), newValueType, map.isValueOptional());
            }
        }
        return type;
    }

    public static InternalSchema applyTableChanges2Schema(InternalSchema internalSchema, TableChanges.ColumnDeleteChange deletes) {
        return new InternalSchema((Types.RecordType)SchemaChangeUtils.applyTableChange2Type((Type)internalSchema.getRecord(), deletes));
    }

    private static Type applyTableChange2Type(Type type, TableChanges.ColumnDeleteChange deletes) {
        switch (type.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type;
                ArrayList<Types.Field> fields = new ArrayList<Types.Field>();
                for (Types.Field f : record.fields()) {
                    Type newType = SchemaChangeUtils.applyTableChange2Type(f.type(), deletes);
                    newType = deletes.applyDelete(f.fieldId(), newType);
                    if (newType == null) continue;
                    fields.add(Types.Field.get(f.fieldId(), f.isOptional(), f.name(), newType, f.doc()));
                }
                if (fields.isEmpty()) {
                    throw new UnsupportedOperationException("cannot support delete all columns from Struct");
                }
                return Types.RecordType.get(fields, record.name());
            }
            case ARRAY: {
                Types.ArrayType array2 = (Types.ArrayType)type;
                Type newElementType = SchemaChangeUtils.applyTableChange2Type(array2.elementType(), deletes);
                newElementType = deletes.applyDelete(array2.elementId(), newElementType);
                if (newElementType == null) {
                    throw new IllegalArgumentException(String.format("cannot delete element from arrayType: %s", array2));
                }
                return Types.ArrayType.get(array2.elementId(), array2.isElementOptional(), newElementType);
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                int keyId = map.fields().get(0).fieldId();
                if (deletes.getDeletes().contains(keyId)) {
                    throw new IllegalArgumentException(String.format("cannot delete key from mapType: %s", map));
                }
                Type newValueType = SchemaChangeUtils.applyTableChange2Type(map.valueType(), deletes);
                newValueType = deletes.applyDelete(map.valueId(), newValueType);
                if (newValueType == null) {
                    throw new IllegalArgumentException(String.format("cannot delete value from mapType: %s", map));
                }
                return Types.MapType.get(map.keyId(), map.valueId(), map.keyType(), newValueType, map.isValueOptional());
            }
        }
        return type;
    }

    public static InternalSchema applyTableChanges2Schema(InternalSchema internalSchema, TableChanges.ColumnUpdateChange updates) {
        Types.RecordType newType = (Types.RecordType)SchemaChangeUtils.applyTableChange2Type((Type)internalSchema.getRecord(), updates);
        List<Types.Field> newFields = TableChangesHelper.applyAddChange2Fields(newType.fields(), new ArrayList<Types.Field>(), updates.getPositionChangeMap().get(-1));
        return new InternalSchema(Types.RecordType.get(newFields, newType.name()));
    }

    private static Type applyTableChange2Type(Type type, TableChanges.ColumnUpdateChange updates) {
        switch (type.typeId()) {
            case RECORD: {
                Type newType;
                Types.RecordType record = (Types.RecordType)type;
                ArrayList<Type> newTypes = new ArrayList<Type>();
                for (Types.Field f : record.fields()) {
                    newType = SchemaChangeUtils.applyTableChange2Type(f.type(), updates);
                    newTypes.add(updates.applyUpdates(f, newType));
                }
                ArrayList<Types.Field> newFields = new ArrayList<Types.Field>();
                for (int i = 0; i < newTypes.size(); ++i) {
                    newType = (Type)newTypes.get(i);
                    Types.Field oldField = record.fields().get(i);
                    Types.Field updateField = updates.getUpdates().get(oldField.fieldId());
                    if (updateField != null) {
                        newFields.add(Types.Field.get(oldField.fieldId(), updateField.isOptional(), updateField.name(), newType, updateField.doc()));
                        continue;
                    }
                    if (!oldField.type().equals(newType)) {
                        newFields.add(Types.Field.get(oldField.fieldId(), oldField.isOptional(), oldField.name(), newType, oldField.doc()));
                        continue;
                    }
                    newFields.add(oldField);
                }
                return Types.RecordType.get(newFields, record.name());
            }
            case ARRAY: {
                boolean optional;
                Types.ArrayType array2 = (Types.ArrayType)type;
                Types.Field elementField = array2.fields().get(0);
                Type newElementType = SchemaChangeUtils.applyTableChange2Type(array2.elementType(), updates);
                newElementType = updates.applyUpdates(elementField, newElementType);
                Types.Field elementUpdate = updates.getUpdates().get(elementField.fieldId());
                boolean bl = optional = elementUpdate == null ? array2.isElementOptional() : elementUpdate.isOptional();
                if (optional == elementField.isOptional() && array2.elementType() == newElementType) {
                    return array2;
                }
                return Types.ArrayType.get(array2.elementId(), optional, newElementType);
            }
            case MAP: {
                boolean valueOptional;
                Types.MapType map = (Types.MapType)type;
                Types.Field valueFiled = map.fields().get(1);
                Type newValueType = SchemaChangeUtils.applyTableChange2Type(map.valueType(), updates);
                newValueType = updates.applyUpdates(valueFiled, newValueType);
                Types.Field valueUpdate = updates.getUpdates().get(valueFiled.fieldId());
                boolean bl = valueOptional = valueUpdate == null ? map.isValueOptional() : valueUpdate.isOptional();
                if (valueOptional == map.isValueOptional() && map.valueType() == newValueType) {
                    return map;
                }
                return Types.MapType.get(map.keyId(), map.valueId(), map.keyType(), newValueType, valueOptional);
            }
        }
        return type;
    }
}

