/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.table.log.AppendResult;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieHFileDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.log.block.HoodieParquetDataBlock;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieAppendException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieAppendHandle<T, I, K, O>
extends HoodieWriteHandle<T, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(HoodieAppendHandle.class);
    private static final AtomicLong RECORD_COUNTER = new AtomicLong(1L);
    private static final int NUMBER_OF_RECORDS_TO_ESTIMATE_RECORD_SIZE = 100;
    protected final String fileId;
    private final List<HoodieRecord> recordList = new ArrayList<HoodieRecord>();
    private final List<DeleteRecord> recordsToDelete = new ArrayList<DeleteRecord>();
    protected Iterator<HoodieRecord<T>> recordItr;
    protected HoodieLogFormat.Writer writer;
    protected final List<WriteStatus> statuses;
    protected long recordsWritten = 0L;
    protected long recordsDeleted = 0L;
    protected long updatedRecordsWritten = 0L;
    protected long insertRecordsWritten = 0L;
    private long averageRecordSize = 0L;
    private boolean doInit = true;
    protected long estimatedNumberOfBytesWritten;
    private int numberOfRecords = 0;
    private final int maxBlockSize = this.config.getLogFileDataBlockMaxSize();
    protected final Map<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
    private SizeEstimator<HoodieRecord> sizeEstimator;
    private String baseInstantTime;
    private boolean isLogCompaction = false;
    private boolean useWriterSchema = false;
    private Properties recordProperties = new Properties();

    public HoodieAppendHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Iterator<HoodieRecord<T>> recordItr, TaskContextSupplier taskContextSupplier, Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, recordItr, taskContextSupplier);
        this.useWriterSchema = true;
        this.isLogCompaction = true;
        this.header.putAll(header);
    }

    public HoodieAppendHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Iterator<HoodieRecord<T>> recordItr, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, partitionPath, fileId, hoodieTable, taskContextSupplier);
        this.fileId = fileId;
        this.recordItr = recordItr;
        this.sizeEstimator = new DefaultSizeEstimator<HoodieRecord>();
        this.statuses = new ArrayList<WriteStatus>();
        this.recordProperties.putAll((Map<?, ?>)config.getProps());
    }

    public HoodieAppendHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier sparkTaskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, null, sparkTaskContextSupplier);
    }

    private void init(HoodieRecord record) {
        if (this.doInit) {
            String baseInstantTime;
            TableFileSystemView.SliceView rtView = this.hoodieTable.getSliceView();
            Option<FileSlice> fileSlice = rtView.getLatestFileSlice(this.partitionPath, this.fileId);
            String baseFile = "";
            ArrayList<String> logFiles = new ArrayList();
            if (fileSlice.isPresent()) {
                baseInstantTime = fileSlice.get().getBaseInstantTime();
                baseFile = fileSlice.get().getBaseFile().map(BaseFile::getFileName).orElse("");
                logFiles = fileSlice.get().getLogFiles().map(HoodieLogFile::getFileName).collect(Collectors.toList());
            } else {
                baseInstantTime = this.instantTime;
                if (record.getCurrentLocation() != null && HoodieInstantTimeGenerator.isValidInstantTime(record.getCurrentLocation().getInstantTime())) {
                    baseInstantTime = record.getCurrentLocation().getInstantTime();
                }
                fileSlice = Option.of(new FileSlice(this.partitionPath, baseInstantTime, this.fileId));
                LOG.info((Object)("New AppendHandle for partition :" + this.partitionPath));
            }
            this.writeStatus.setStat(new HoodieDeltaWriteStat());
            this.writeStatus.setFileId(this.fileId);
            this.writeStatus.setPartitionPath(this.partitionPath);
            this.averageRecordSize = this.sizeEstimator.sizeEstimate(record);
            HoodieDeltaWriteStat deltaWriteStat = (HoodieDeltaWriteStat)this.writeStatus.getStat();
            deltaWriteStat.setPrevCommit(baseInstantTime);
            deltaWriteStat.setPartitionPath(this.partitionPath);
            deltaWriteStat.setFileId(this.fileId);
            deltaWriteStat.setBaseFile(baseFile);
            deltaWriteStat.setLogFiles(logFiles);
            try {
                HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.fs, baseInstantTime, new Path(this.config.getBasePath()), FSUtils.getPartitionPath(this.config.getBasePath(), this.partitionPath), this.hoodieTable.getPartitionMetafileFormat());
                partitionMetadata.trySave(this.getPartitionId());
                this.createMarkerFile(this.partitionPath, FSUtils.makeBaseFileName(baseInstantTime, this.writeToken, this.fileId, this.hoodieTable.getBaseFileExtension()));
                this.writer = this.createLogWriter(fileSlice, baseInstantTime);
            }
            catch (Exception e) {
                LOG.error((Object)("Error in update task at commit " + this.instantTime), (Throwable)e);
                this.writeStatus.setGlobalError(e);
                throw new HoodieUpsertException("Failed to initialize HoodieAppendHandle for FileId: " + this.fileId + " on commit " + this.instantTime + " on HDFS path " + this.hoodieTable.getMetaClient().getBasePath() + "/" + this.partitionPath, e);
            }
            this.doInit = false;
        }
    }

    protected boolean isUpdateRecord(HoodieRecord<T> hoodieRecord) {
        return hoodieRecord.getCurrentLocation() != null;
    }

    private Option<HoodieRecord> prepareRecord(HoodieRecord<T> hoodieRecord) {
        Option<Map<String, String>> recordMetadata = hoodieRecord.getMetadata();
        Schema schema2 = this.useWriterSchema ? this.writeSchemaWithMetaFields : this.writeSchema;
        try {
            Option<Object> finalRecordOpt;
            boolean isUpdateRecord = this.isUpdateRecord(hoodieRecord);
            boolean nullifyPayload = HoodieOperation.isDelete(hoodieRecord.getOperation()) && !this.config.allowOperationMetadataField();
            this.recordProperties.put("hoodie.is.update.record.for.mor", String.valueOf(isUpdateRecord));
            Option<Object> option2 = finalRecordOpt = nullifyPayload ? Option.empty() : Option.of(hoodieRecord);
            if (finalRecordOpt.isPresent() && !((HoodieRecord)finalRecordOpt.get()).isDelete(schema2, this.recordProperties)) {
                HoodieRecord finalRecord = (HoodieRecord)finalRecordOpt.get();
                if (finalRecord.shouldIgnore(schema2, this.recordProperties)) {
                    return finalRecordOpt;
                }
                MetadataValues metadataValues = this.populateMetadataFields(finalRecord);
                HoodieRecord populatedRecord = finalRecord.prependMetaFields(schema2, this.writeSchemaWithMetaFields, metadataValues, this.recordProperties);
                finalRecordOpt = Option.of(populatedRecord.copy());
                if (isUpdateRecord || this.isLogCompaction) {
                    ++this.updatedRecordsWritten;
                } else {
                    ++this.insertRecordsWritten;
                }
                ++this.recordsWritten;
            } else {
                finalRecordOpt = Option.empty();
                ++this.recordsDeleted;
            }
            this.writeStatus.markSuccess(hoodieRecord, recordMetadata);
            hoodieRecord.deflate();
            return finalRecordOpt;
        }
        catch (Exception e) {
            LOG.error((Object)("Error writing record  " + hoodieRecord), (Throwable)e);
            this.writeStatus.markFailure(hoodieRecord, e, recordMetadata);
            return Option.empty();
        }
    }

    private MetadataValues populateMetadataFields(HoodieRecord<T> hoodieRecord) {
        MetadataValues metadataValues = new MetadataValues();
        if (this.config.populateMetaFields()) {
            String seqId = HoodieRecord.generateSequenceId(this.instantTime, this.getPartitionId(), RECORD_COUNTER.getAndIncrement());
            metadataValues.setFileName(this.fileId);
            metadataValues.setPartitionPath(this.partitionPath);
            metadataValues.setRecordKey(hoodieRecord.getRecordKey());
            if (!this.isLogCompaction) {
                metadataValues.setCommitTime(this.instantTime);
                metadataValues.setCommitSeqno(seqId);
            }
        }
        if (this.config.allowOperationMetadataField()) {
            metadataValues.setOperation(hoodieRecord.getOperation().getName());
        }
        return metadataValues;
    }

    private void initNewStatus() {
        HoodieDeltaWriteStat prevStat = (HoodieDeltaWriteStat)this.writeStatus.getStat();
        HoodieDeltaWriteStat stat = new HoodieDeltaWriteStat();
        stat.setFileId(this.fileId);
        stat.setPartitionPath(this.partitionPath);
        stat.setPrevCommit(prevStat.getPrevCommit());
        stat.setBaseFile(prevStat.getBaseFile());
        stat.setLogFiles(new ArrayList<String>(prevStat.getLogFiles()));
        this.writeStatus = (WriteStatus)ReflectionUtils.loadClass(this.config.getWriteStatusClassName(), !this.hoodieTable.getIndex().isImplicitWithStorage(), this.config.getWriteStatusFailureFraction());
        this.writeStatus.setFileId(this.fileId);
        this.writeStatus.setPartitionPath(this.partitionPath);
        this.writeStatus.setStat(stat);
    }

    private String makeFilePath(HoodieLogFile logFile) {
        return this.partitionPath.length() == 0 ? new Path(logFile.getFileName()).toString() : new Path(this.partitionPath, logFile.getFileName()).toString();
    }

    private void resetWriteCounts() {
        this.recordsWritten = 0L;
        this.updatedRecordsWritten = 0L;
        this.insertRecordsWritten = 0L;
        this.recordsDeleted = 0L;
    }

    private void updateWriteCounts(HoodieDeltaWriteStat stat, AppendResult result) {
        stat.setNumWrites(this.recordsWritten);
        stat.setNumUpdateWrites(this.updatedRecordsWritten);
        stat.setNumInserts(this.insertRecordsWritten);
        stat.setNumDeletes(this.recordsDeleted);
        stat.setTotalWriteBytes(result.size());
    }

    private void accumulateWriteCounts(HoodieDeltaWriteStat stat, AppendResult result) {
        stat.setNumWrites(stat.getNumWrites() + this.recordsWritten);
        stat.setNumUpdateWrites(stat.getNumUpdateWrites() + this.updatedRecordsWritten);
        stat.setNumInserts(stat.getNumInserts() + this.insertRecordsWritten);
        stat.setNumDeletes(stat.getNumDeletes() + this.recordsDeleted);
        stat.setTotalWriteBytes(stat.getTotalWriteBytes() + result.size());
    }

    private void updateWriteStat(HoodieDeltaWriteStat stat, AppendResult result) {
        stat.setPath(this.makeFilePath(result.logFile()));
        stat.setLogOffset(result.offset());
        stat.setLogVersion(result.logFile().getLogVersion());
        if (!stat.getLogFiles().contains(result.logFile().getFileName())) {
            stat.addLogFiles(result.logFile().getFileName());
        }
        stat.setFileSizeInBytes(result.size());
    }

    private void updateRuntimeStats(HoodieDeltaWriteStat stat) {
        HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
        runtimeStats.setTotalUpsertTime(this.timer.endTimer());
        stat.setRuntimeStats(runtimeStats);
    }

    private void accumulateRuntimeStats(HoodieDeltaWriteStat stat) {
        HoodieWriteStat.RuntimeStats runtimeStats = stat.getRuntimeStats();
        assert (runtimeStats != null);
        runtimeStats.setTotalUpsertTime(runtimeStats.getTotalUpsertTime() + this.timer.endTimer());
    }

    private void updateWriteStatus(HoodieDeltaWriteStat stat, AppendResult result) {
        this.updateWriteStat(stat, result);
        this.updateWriteCounts(stat, result);
        this.updateRuntimeStats(stat);
        this.statuses.add(this.writeStatus);
    }

    private void processAppendResult(AppendResult result, List<HoodieRecord> recordList) throws IOException {
        HoodieDeltaWriteStat stat = (HoodieDeltaWriteStat)this.writeStatus.getStat();
        if (stat.getPath() == null) {
            this.updateWriteStatus(stat, result);
        } else if (stat.getPath().endsWith(result.logFile().getFileName())) {
            stat.setLogOffset(Math.min(stat.getLogOffset(), result.offset()));
            stat.setFileSizeInBytes(stat.getFileSizeInBytes() + result.size());
            this.accumulateWriteCounts(stat, result);
            this.accumulateRuntimeStats(stat);
        } else {
            this.initNewStatus();
            stat = (HoodieDeltaWriteStat)this.writeStatus.getStat();
            this.updateWriteStatus(stat, result);
        }
        if (this.config.isMetadataColumnStatsIndexEnabled() && this.recordMerger.getRecordType() == HoodieRecord.HoodieRecordType.AVRO) {
            List<Schema.Field> fieldsToIndex;
            if (this.config.getColumnsEnabledForColumnStatsIndex().isEmpty()) {
                fieldsToIndex = this.writeSchemaWithMetaFields.getFields();
            } else {
                HashSet<String> columnsToIndexSet = new HashSet<String>(this.config.getColumnsEnabledForColumnStatsIndex());
                fieldsToIndex = this.writeSchemaWithMetaFields.getFields().stream().filter(field -> columnsToIndexSet.contains(field.name())).collect(Collectors.toList());
            }
            LinkedList<IndexedRecord> indexedRecords = new LinkedList<IndexedRecord>();
            for (HoodieRecord hoodieRecord : recordList) {
                indexedRecords.add((IndexedRecord)hoodieRecord.toIndexedRecord(this.writeSchema, this.config.getProps()).get().getData());
            }
            Map<String, HoodieColumnRangeMetadata<Comparable>> columnRangesMetadataMap = HoodieTableMetadataUtil.collectColumnRangeMetadata(indexedRecords, fieldsToIndex, stat.getPath());
            stat.putRecordsStats(columnRangesMetadataMap);
        }
        this.resetWriteCounts();
        assert (stat.getRuntimeStats() != null);
        LOG.info((Object)String.format("AppendHandle for partitionPath %s filePath %s, took %d ms.", this.partitionPath, stat.getPath(), stat.getRuntimeStats().getTotalUpsertTime()));
        this.timer.startTimer();
    }

    public void doAppend() {
        while (this.recordItr.hasNext()) {
            HoodieRecord<T> record = this.recordItr.next();
            this.init(record);
            this.flushToDiskIfRequired(record, false);
            this.writeToBuffer(record);
        }
        this.appendDataAndDeleteBlocks(this.header, true);
        this.estimatedNumberOfBytesWritten += this.averageRecordSize * (long)this.numberOfRecords;
    }

    protected void appendDataAndDeleteBlocks(Map<HoodieLogBlock.HeaderMetadataType, String> header, boolean appendDeleteBlocks) {
        try {
            header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, this.instantTime);
            header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, this.writeSchemaWithMetaFields.toString());
            ArrayList<HoodieLogBlock> blocks = new ArrayList<HoodieLogBlock>(2);
            if (this.recordList.size() > 0) {
                String keyField = this.config.populateMetaFields() ? HoodieRecord.RECORD_KEY_METADATA_FIELD : this.hoodieTable.getMetaClient().getTableConfig().getRecordKeyFieldProp();
                blocks.add(HoodieAppendHandle.getBlock(this.config, this.pickLogDataBlockFormat(), this.recordList, header, keyField));
            }
            if (appendDeleteBlocks && this.recordsToDelete.size() > 0) {
                blocks.add(new HoodieDeleteBlock(this.recordsToDelete.toArray(new DeleteRecord[0]), header));
            }
            if (blocks.size() > 0) {
                AppendResult appendResult = this.writer.appendBlocks(blocks);
                this.processAppendResult(appendResult, this.recordList);
                this.recordList.clear();
                if (appendDeleteBlocks) {
                    this.recordsToDelete.clear();
                }
            }
        }
        catch (Exception e) {
            throw new HoodieAppendException("Failed while appending records to " + this.writer.getLogFile().getPath(), e);
        }
    }

    @Override
    public boolean canWrite(HoodieRecord record) {
        return (double)this.config.getParquetMaxFileSize() >= (double)this.estimatedNumberOfBytesWritten * this.config.getLogFileToParquetCompressionRatio();
    }

    @Override
    protected void doWrite(HoodieRecord record, Schema schema2, TypedProperties props) {
        Option<Map<String, String>> recordMetadata = record.getMetadata();
        try {
            this.init(record);
            this.flushToDiskIfRequired(record, false);
            this.writeToBuffer(record);
        }
        catch (Throwable t) {
            this.writeStatus.markFailure(record, t, recordMetadata);
            LOG.error((Object)("Error writing record " + record), t);
        }
    }

    @Override
    public List<WriteStatus> close() {
        try {
            this.appendDataAndDeleteBlocks(this.header, true);
            this.recordItr = null;
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
                for (WriteStatus status : this.statuses) {
                    long logFileSize = FSUtils.getFileSize(this.fs, new Path(this.config.getBasePath(), status.getStat().getPath()));
                    status.getStat().setFileSizeInBytes(logFileSize);
                }
            }
            return this.statuses;
        }
        catch (IOException e) {
            throw new HoodieUpsertException("Failed to close UpdateHandle", e);
        }
    }

    public void write(Map<String, HoodieRecord<T>> recordMap) {
        try {
            for (Map.Entry<String, HoodieRecord<T>> entry : recordMap.entrySet()) {
                HoodieRecord<T> record = entry.getValue();
                this.init(record);
                this.flushToDiskIfRequired(record, false);
                this.writeToBuffer(record);
            }
            this.appendDataAndDeleteBlocks(this.header, true);
            this.estimatedNumberOfBytesWritten += this.averageRecordSize * (long)this.numberOfRecords;
        }
        catch (Exception e) {
            throw new HoodieUpsertException("Failed to compact blocks for fileId " + this.fileId, e);
        }
    }

    @Override
    public IOType getIOType() {
        return IOType.APPEND;
    }

    @Override
    public List<WriteStatus> writeStatuses() {
        return this.statuses;
    }

    protected boolean needsUpdateLocation() {
        return true;
    }

    private void writeToBuffer(HoodieRecord<T> record) {
        if (!this.partitionPath.equals(record.getPartitionPath())) {
            HoodieUpsertException failureEx = new HoodieUpsertException("mismatched partition path, record partition: " + record.getPartitionPath() + " but trying to insert into partition: " + this.partitionPath);
            this.writeStatus.markFailure(record, failureEx, record.getMetadata());
            return;
        }
        if (this.needsUpdateLocation()) {
            record.unseal();
            record.setNewLocation(new HoodieRecordLocation(this.instantTime, this.fileId));
            record.seal();
        }
        Comparable<?> orderingVal = record.getOrderingValue(this.writeSchema, this.recordProperties);
        Option<HoodieRecord> indexedRecord = this.prepareRecord(record);
        if (indexedRecord.isPresent()) {
            try {
                if (!indexedRecord.get().shouldIgnore(this.writeSchema, this.recordProperties)) {
                    this.recordList.add(indexedRecord.get());
                }
            }
            catch (IOException e) {
                this.writeStatus.markFailure(record, e, record.getMetadata());
                LOG.error((Object)("Error writing record  " + indexedRecord.get()), (Throwable)e);
            }
        } else {
            this.recordsToDelete.add(DeleteRecord.create(record.getKey(), orderingVal));
        }
        ++this.numberOfRecords;
    }

    private void flushToDiskIfRequired(HoodieRecord record, boolean appendDeleteBlocks) {
        if (this.numberOfRecords >= (int)((long)this.maxBlockSize / this.averageRecordSize) || this.numberOfRecords % 100 == 0) {
            this.averageRecordSize = (long)((double)this.averageRecordSize * 0.8 + (double)this.sizeEstimator.sizeEstimate(record) * 0.2);
        }
        if (this.numberOfRecords >= (int)((long)this.maxBlockSize / this.averageRecordSize)) {
            LOG.info((Object)("Flush log block to disk, the current avgRecordSize => " + this.averageRecordSize));
            this.appendDataAndDeleteBlocks(this.header, appendDeleteBlocks);
            this.estimatedNumberOfBytesWritten += this.averageRecordSize * (long)this.numberOfRecords;
            this.numberOfRecords = 0;
        }
    }

    private HoodieLogBlock.HoodieLogBlockType pickLogDataBlockFormat() {
        Option<HoodieLogBlock.HoodieLogBlockType> logBlockTypeOpt = this.config.getLogDataBlockFormat();
        if (logBlockTypeOpt.isPresent()) {
            return logBlockTypeOpt.get();
        }
        switch (this.hoodieTable.getBaseFileFormat()) {
            case PARQUET: 
            case ORC: {
                return HoodieLogBlock.HoodieLogBlockType.AVRO_DATA_BLOCK;
            }
            case HFILE: {
                return HoodieLogBlock.HoodieLogBlockType.HFILE_DATA_BLOCK;
            }
        }
        throw new HoodieException("Base file format " + (Object)((Object)this.hoodieTable.getBaseFileFormat()) + " does not have associated log block type");
    }

    private static HoodieLogBlock getBlock(HoodieWriteConfig writeConfig, HoodieLogBlock.HoodieLogBlockType logDataBlockFormat, List<HoodieRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, String keyField) {
        switch (logDataBlockFormat) {
            case AVRO_DATA_BLOCK: {
                return new HoodieAvroDataBlock(records, header, keyField);
            }
            case HFILE_DATA_BLOCK: {
                return new HoodieHFileDataBlock(records, header, writeConfig.getHFileCompressionAlgorithm(), new Path(writeConfig.getBasePath()));
            }
            case PARQUET_DATA_BLOCK: {
                return new HoodieParquetDataBlock(records, header, keyField, writeConfig.getParquetCompressionCodec(), writeConfig.getParquetCompressionRatio(), writeConfig.parquetDictionaryEnabled());
            }
        }
        throw new HoodieException("Data block format " + (Object)((Object)logDataBlockFormat) + " not implemented");
    }
}

