/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.storage.HoodieAvroHFileWriter;
import org.apache.hudi.io.storage.HoodieAvroOrcWriter;
import org.apache.hudi.io.storage.HoodieAvroParquetWriter;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.io.storage.HoodieHFileConfig;
import org.apache.hudi.io.storage.HoodieOrcConfig;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.io.storage.HoodieParquetStreamWriter;
import org.apache.hudi.org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.orc.CompressionKind;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class HoodieAvroFileWriterFactory
extends HoodieFileWriterFactory {
    @Override
    protected HoodieFileWriter newParquetFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema2, TaskContextSupplier taskContextSupplier) throws IOException {
        boolean populateMetaFields = config.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS);
        boolean enableBloomFilter = populateMetaFields;
        Option<BloomFilter> filter = enableBloomFilter ? Option.of(this.createBloomFilter(config)) : Option.empty();
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter(conf).convert(schema2), schema2, filter);
        String compressionCodecName = config.getStringOrDefault(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME);
        if (compressionCodecName.isEmpty()) {
            compressionCodecName = null;
        }
        HoodieParquetConfig<HoodieAvroWriteSupport> parquetConfig = new HoodieParquetConfig<HoodieAvroWriteSupport>(writeSupport, CompressionCodecName.fromConf((String)compressionCodecName), config.getIntOrDefault(HoodieStorageConfig.PARQUET_BLOCK_SIZE), config.getIntOrDefault(HoodieStorageConfig.PARQUET_PAGE_SIZE), config.getLongOrDefault(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE), conf, config.getDoubleOrDefault(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION), config.getBooleanOrDefault(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED));
        return new HoodieAvroParquetWriter(path, parquetConfig, instantTime, taskContextSupplier, populateMetaFields);
    }

    @Override
    protected HoodieFileWriter newParquetFileWriter(FSDataOutputStream outputStream, Configuration conf, HoodieConfig config, Schema schema2) throws IOException {
        boolean enableBloomFilter = false;
        Option<BloomFilter> filter = enableBloomFilter ? Option.of(this.createBloomFilter(config)) : Option.empty();
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter(conf).convert(schema2), schema2, filter);
        HoodieParquetConfig<HoodieAvroWriteSupport> parquetConfig = new HoodieParquetConfig<HoodieAvroWriteSupport>(writeSupport, CompressionCodecName.fromConf((String)config.getString(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME)), config.getInt(HoodieStorageConfig.PARQUET_BLOCK_SIZE), config.getInt(HoodieStorageConfig.PARQUET_PAGE_SIZE), config.getLong(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE), conf, config.getDouble(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION), config.getBoolean(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED));
        return new HoodieParquetStreamWriter(outputStream, parquetConfig);
    }

    @Override
    protected HoodieFileWriter newHFileFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema2, TaskContextSupplier taskContextSupplier) throws IOException {
        BloomFilter filter = this.createBloomFilter(config);
        HoodieHFileConfig hfileConfig = new HoodieHFileConfig(conf, Compression.Algorithm.valueOf(config.getString(HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME)), config.getInt(HoodieStorageConfig.HFILE_BLOCK_SIZE), config.getLong(HoodieStorageConfig.HFILE_MAX_FILE_SIZE), "key", false, false, true, filter, HoodieHFileConfig.HFILE_COMPARATOR);
        return new HoodieAvroHFileWriter(instantTime, path, hfileConfig, schema2, taskContextSupplier, config.getBoolean(HoodieTableConfig.POPULATE_META_FIELDS));
    }

    @Override
    protected HoodieFileWriter newOrcFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema2, TaskContextSupplier taskContextSupplier) throws IOException {
        BloomFilter filter = this.createBloomFilter(config);
        HoodieOrcConfig orcConfig = new HoodieOrcConfig(conf, CompressionKind.valueOf((String)config.getString(HoodieStorageConfig.ORC_COMPRESSION_CODEC_NAME)), config.getInt(HoodieStorageConfig.ORC_STRIPE_SIZE), config.getInt(HoodieStorageConfig.ORC_BLOCK_SIZE), config.getLong(HoodieStorageConfig.ORC_FILE_MAX_SIZE), filter);
        return new HoodieAvroOrcWriter(instantTime, path, orcConfig, schema2, taskContextSupplier);
    }
}

