/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.MappingIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.io.ByteBufferBackedInputStream;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieAvroFileReaderBase;
import org.apache.hudi.io.storage.HoodieHFileUtils;
import org.apache.hudi.io.storage.HoodieSeekingFileReader;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hudi.util.Lazy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieAvroHFileReader
extends HoodieAvroFileReaderBase
implements HoodieSeekingFileReader<IndexedRecord> {
    public static final String SCHEMA_KEY = "schema";
    public static final String KEY_BLOOM_FILTER_META_BLOCK = "bloomFilter";
    public static final String KEY_BLOOM_FILTER_TYPE_CODE = "bloomFilterTypeCode";
    public static final String KEY_FIELD_NAME = "key";
    public static final String KEY_MIN_RECORD = "minRecordKey";
    public static final String KEY_MAX_RECORD = "maxRecordKey";
    private static final Logger LOG = LogManager.getLogger(HoodieAvroHFileReader.class);
    private final Path path;
    private final Lazy<Schema> schema;
    private final HFile.Reader reader;
    private final HFileScanner sharedScanner;
    private final Object sharedScannerLock = new Object();

    public HoodieAvroHFileReader(Configuration hadoopConf, Path path, CacheConfig cacheConfig) throws IOException {
        this(path, HoodieHFileUtils.createHFileReader(FSUtils.getFs(path.toString(), hadoopConf), path, cacheConfig, hadoopConf), Option.empty());
    }

    public HoodieAvroHFileReader(Configuration hadoopConf, Path path, CacheConfig cacheConfig, FileSystem fs) throws IOException {
        this(path, HoodieHFileUtils.createHFileReader(fs, path, cacheConfig, hadoopConf), Option.empty());
    }

    public HoodieAvroHFileReader(FileSystem fs, Path dummyPath, byte[] content, Option<Schema> schemaOpt) throws IOException {
        this(null, HoodieHFileUtils.createHFileReader(fs, dummyPath, content), schemaOpt);
    }

    public HoodieAvroHFileReader(Path path, HFile.Reader reader, Option<Schema> schemaOpt) throws IOException {
        this.path = path;
        this.reader = reader;
        this.sharedScanner = HoodieAvroHFileReader.getHFileScanner(reader, true);
        this.schema = schemaOpt.map(Lazy::eagerly).orElseGet(() -> Lazy.lazily(() -> HoodieAvroHFileReader.fetchSchema(reader)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<HoodieRecord<IndexedRecord>> getRecordByKey(String key, Schema readerSchema) throws IOException {
        Object object = this.sharedScannerLock;
        synchronized (object) {
            return HoodieAvroHFileReader.fetchRecordByKeyInternal(this.sharedScanner, key, this.getSchema(), readerSchema).map(data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
        }
    }

    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordsByKeysIterator(List<String> keys2, Schema schema2) throws IOException {
        HFileScanner scanner = HoodieAvroHFileReader.getHFileScanner(this.reader, true);
        RecordByKeyIterator iterator2 = new RecordByKeyIterator(scanner, keys2, this.getSchema(), schema2);
        return new MappingIterator<IndexedRecord, HoodieRecord>(iterator2, data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
    }

    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordsByKeyPrefixIterator(List<String> keyPrefixes, Schema schema2) throws IOException {
        ClosableIterator<IndexedRecord> iterator2 = this.getIndexedRecordsByKeyPrefixIterator(keyPrefixes, schema2);
        return new MappingIterator<IndexedRecord, HoodieRecord>(iterator2, data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        HFileInfo fileInfo = this.reader.getHFileInfo();
        return new String[]{new String(fileInfo.get(KEY_MIN_RECORD.getBytes())), new String(fileInfo.get(KEY_MAX_RECORD.getBytes()))};
    }

    @Override
    public BloomFilter readBloomFilter() {
        try {
            HFileInfo fileInfo = this.reader.getHFileInfo();
            ByteBuff buf = this.reader.getMetaBlock(KEY_BLOOM_FILTER_META_BLOCK, false).getBufferWithoutHeader();
            byte[] bytes = new byte[buf.remaining()];
            buf.get(bytes);
            return BloomFilterFactory.fromString(new String(bytes), new String(fileInfo.get(KEY_BLOOM_FILTER_TYPE_CODE.getBytes())));
        }
        catch (IOException e) {
            throw new HoodieException("Could not read bloom filter from " + this.path, e);
        }
    }

    @Override
    public Schema getSchema() {
        return this.schema.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> filterRowKeys(Set<String> candidateRowKeys) {
        ValidationUtils.checkState(candidateRowKeys instanceof TreeSet, String.format("HFile reader expects a TreeSet as iterating over ordered keys is more performant, got (%s)", candidateRowKeys.getClass().getSimpleName()));
        Object object = this.sharedScannerLock;
        synchronized (object) {
            return candidateRowKeys.stream().filter(k -> {
                try {
                    return this.isKeyAvailable((String)k, this.sharedScanner);
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to check key availability: " + k));
                    return false;
                }
            }).collect(Collectors.toSet());
        }
    }

    @Override
    protected ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema readerSchema, Schema requestedSchema) {
        if (!Objects.equals(readerSchema, requestedSchema)) {
            throw new UnsupportedOperationException("Schema projections are not supported in HFile reader");
        }
        HFileScanner scanner = HoodieAvroHFileReader.getHFileScanner(this.reader, false);
        return new RecordIterator(scanner, this.getSchema(), readerSchema);
    }

    @VisibleForTesting
    protected ClosableIterator<IndexedRecord> getIndexedRecordsByKeysIterator(List<String> keys2, Schema readerSchema) throws IOException {
        HFileScanner scanner = HoodieAvroHFileReader.getHFileScanner(this.reader, true);
        return new RecordByKeyIterator(scanner, keys2, this.getSchema(), readerSchema);
    }

    @VisibleForTesting
    protected ClosableIterator<IndexedRecord> getIndexedRecordsByKeyPrefixIterator(List<String> keyPrefixes, Schema readerSchema) throws IOException {
        HFileScanner scanner = HoodieAvroHFileReader.getHFileScanner(this.reader, true);
        return new RecordByKeyPrefixIterator(scanner, keyPrefixes, this.getSchema(), readerSchema);
    }

    @Override
    public long getTotalRecords() {
        return this.reader.getEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            HoodieAvroHFileReader hoodieAvroHFileReader = this;
            synchronized (hoodieAvroHFileReader) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Error closing the hfile reader", e);
        }
    }

    private boolean isKeyAvailable(String key, HFileScanner keyScanner) throws IOException {
        KeyValue kv = new KeyValue(key.getBytes(), null, null, null);
        return keyScanner.seekTo(kv) == 0;
    }

    private static Iterator<IndexedRecord> getRecordByKeyPrefixIteratorInternal(final HFileScanner scanner, final String keyPrefix, final Schema writerSchema, final Schema readerSchema) throws IOException {
        KeyValue kv = new KeyValue(keyPrefix.getBytes(), null, null, null);
        int val = scanner.seekTo(kv);
        if (val == 1) {
            if (!scanner.next()) {
                return Collections.emptyIterator();
            }
        } else if (val == -1) {
            scanner.seekTo();
        }
        class KeyPrefixIterator
        implements Iterator<IndexedRecord> {
            private IndexedRecord next = null;
            private boolean eof = false;

            KeyPrefixIterator() {
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                if (this.eof) {
                    return false;
                }
                Cell c = Objects.requireNonNull(scanner.getCell());
                byte[] keyBytes = HoodieAvroHFileReader.copyKeyFromCell(c);
                String key = new String(keyBytes);
                if (!key.startsWith(keyPrefix)) {
                    return false;
                }
                byte[] valueBytes = HoodieAvroHFileReader.copyValueFromCell(c);
                try {
                    this.next = HoodieAvroHFileReader.deserialize(keyBytes, valueBytes, writerSchema, readerSchema);
                    this.eof = !scanner.next();
                }
                catch (IOException e) {
                    throw new HoodieIOException("Failed to deserialize payload", e);
                }
                return true;
            }

            @Override
            public IndexedRecord next() {
                IndexedRecord next = this.next;
                this.next = null;
                return next;
            }
        }
        return new KeyPrefixIterator();
    }

    private static Option<IndexedRecord> fetchRecordByKeyInternal(HFileScanner scanner, String key, Schema writerSchema, Schema readerSchema) throws IOException {
        KeyValue kv = new KeyValue(key.getBytes(), null, null, null);
        if (scanner.seekTo(kv) != 0) {
            return Option.empty();
        }
        Cell c = scanner.getCell();
        byte[] valueBytes = HoodieAvroHFileReader.copyValueFromCell(c);
        GenericRecord record = HoodieAvroHFileReader.deserialize(key.getBytes(), valueBytes, writerSchema, readerSchema);
        return Option.of(record);
    }

    private static GenericRecord getRecordFromCell(Cell cell, Schema writerSchema, Schema readerSchema) throws IOException {
        byte[] keyBytes = HoodieAvroHFileReader.copyKeyFromCell(cell);
        byte[] valueBytes = HoodieAvroHFileReader.copyValueFromCell(cell);
        return HoodieAvroHFileReader.deserialize(keyBytes, valueBytes, writerSchema, readerSchema);
    }

    private static GenericRecord deserializeUnchecked(byte[] keyBytes, byte[] valueBytes, Schema writerSchema, Schema readerSchema) {
        try {
            return HoodieAvroHFileReader.deserialize(keyBytes, valueBytes, writerSchema, readerSchema);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to deserialize payload", e);
        }
    }

    private static GenericRecord deserialize(byte[] keyBytes, byte[] valueBytes, Schema writerSchema, Schema readerSchema) throws IOException {
        GenericRecord record = HoodieAvroUtils.bytesToAvro(valueBytes, writerSchema, readerSchema);
        HoodieAvroHFileReader.getKeySchema(readerSchema).ifPresent(keyFieldSchema -> {
            Object keyObject = record.get(keyFieldSchema.pos());
            if (keyObject != null && keyObject.toString().isEmpty()) {
                record.put(keyFieldSchema.pos(), (Object)new String(keyBytes));
            }
        });
        return record;
    }

    private static Schema fetchSchema(HFile.Reader reader) {
        HFileInfo fileInfo = reader.getHFileInfo();
        return new Schema.Parser().parse(new String(fileInfo.get(SCHEMA_KEY.getBytes())));
    }

    private static byte[] copyKeyFromCell(Cell cell) {
        return Arrays.copyOfRange(cell.getRowArray(), cell.getRowOffset(), cell.getRowOffset() + cell.getRowLength());
    }

    private static byte[] copyValueFromCell(Cell c) {
        return Arrays.copyOfRange(c.getValueArray(), c.getValueOffset(), c.getValueOffset() + c.getValueLength());
    }

    public static List<IndexedRecord> readAllRecords(HoodieAvroHFileReader reader) throws IOException {
        Schema schema2 = reader.getSchema();
        return CollectionUtils.toStream(reader.getIndexedRecordIterator(schema2)).collect(Collectors.toList());
    }

    public static List<IndexedRecord> readRecords(HoodieAvroHFileReader reader, List<String> keys2) throws IOException {
        return HoodieAvroHFileReader.readRecords(reader, keys2, reader.getSchema());
    }

    public static List<IndexedRecord> readRecords(HoodieAvroHFileReader reader, List<String> keys2, Schema schema2) throws IOException {
        Collections.sort(keys2);
        return CollectionUtils.toStream(reader.getIndexedRecordsByKeysIterator(keys2, schema2)).collect(Collectors.toList());
    }

    private static HFileScanner getHFileScanner(HFile.Reader reader, boolean cacheBlocks) {
        return reader.getScanner(cacheBlocks, true);
    }

    private static Option<Schema.Field> getKeySchema(Schema schema2) {
        return Option.ofNullable(schema2.getField(KEY_FIELD_NAME));
    }

    static class SeekableByteArrayInputStream
    extends ByteBufferBackedInputStream
    implements Seekable,
    PositionedReadable {
        public SeekableByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public long getPos() throws IOException {
            return this.getPosition();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            return this.copyFrom(position, buffer, offset, length);
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            this.read(position, buffer, 0, buffer.length);
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            this.read(position, buffer, offset, length);
        }
    }

    private static class RecordIterator
    implements ClosableIterator<IndexedRecord> {
        private final HFileScanner scanner;
        private final Schema writerSchema;
        private final Schema readerSchema;
        private IndexedRecord next = null;

        RecordIterator(HFileScanner scanner, Schema writerSchema, Schema readerSchema) {
            this.scanner = scanner;
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.next != null) {
                    return true;
                }
                boolean hasRecords = !this.scanner.isSeeked() ? this.scanner.seekTo() : this.scanner.next();
                if (!hasRecords) {
                    return false;
                }
                this.next = HoodieAvroHFileReader.getRecordFromCell(this.scanner.getCell(), this.writerSchema, this.readerSchema);
                return true;
            }
            catch (IOException io) {
                throw new HoodieIOException("unable to read next record from hfile ", io);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            this.scanner.close();
        }
    }

    private static class RecordByKeyIterator
    implements ClosableIterator<IndexedRecord> {
        private final Iterator<String> keyIterator;
        private final HFileScanner scanner;
        private final Schema readerSchema;
        private final Schema writerSchema;
        private IndexedRecord next = null;

        RecordByKeyIterator(HFileScanner scanner, List<String> keys2, Schema writerSchema, Schema readerSchema) throws IOException {
            this.keyIterator = keys2.iterator();
            this.scanner = scanner;
            this.scanner.seekTo();
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.next != null) {
                    return true;
                }
                while (this.keyIterator.hasNext()) {
                    Option value = HoodieAvroHFileReader.fetchRecordByKeyInternal(this.scanner, this.keyIterator.next(), this.writerSchema, this.readerSchema);
                    if (!value.isPresent()) continue;
                    this.next = (IndexedRecord)value.get();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new HoodieIOException("unable to read next record from hfile ", e);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            this.scanner.close();
        }
    }

    private static class RecordByKeyPrefixIterator
    implements ClosableIterator<IndexedRecord> {
        private final Iterator<String> keyPrefixesIterator;
        private Iterator<IndexedRecord> recordsIterator;
        private final HFileScanner scanner;
        private final Schema writerSchema;
        private final Schema readerSchema;
        private IndexedRecord next = null;

        RecordByKeyPrefixIterator(HFileScanner scanner, List<String> keyPrefixes, Schema writerSchema, Schema readerSchema) throws IOException {
            this.keyPrefixesIterator = keyPrefixes.iterator();
            this.scanner = scanner;
            this.scanner.seekTo();
            this.writerSchema = writerSchema;
            this.readerSchema = readerSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                while (true) {
                    if (this.next != null) {
                        return true;
                    }
                    if (this.recordsIterator != null && this.recordsIterator.hasNext()) {
                        this.next = this.recordsIterator.next();
                        return true;
                    }
                    if (!this.keyPrefixesIterator.hasNext()) break;
                    String currentKeyPrefix = this.keyPrefixesIterator.next();
                    this.recordsIterator = HoodieAvroHFileReader.getRecordByKeyPrefixIteratorInternal(this.scanner, currentKeyPrefix, this.writerSchema, this.readerSchema);
                }
                return false;
            }
            catch (IOException e) {
                throw new HoodieIOException("Unable to read next record from HFile", e);
            }
        }

        @Override
        public IndexedRecord next() {
            IndexedRecord next = this.next;
            this.next = null;
            return next;
        }

        @Override
        public void close() {
            this.scanner.close();
        }
    }
}

