/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.MappingIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.io.storage.HoodieAvroFileReaderBase;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.HoodieAvroParquetReaderBuilder;
import org.apache.parquet.hadoop.ParquetReader;

public class HoodieAvroParquetReader
extends HoodieAvroFileReaderBase {
    private final Path path;
    private final Configuration conf;
    private final BaseFileUtils parquetUtils;
    private final List<ParquetReaderIterator> readerIterators = new ArrayList<ParquetReaderIterator>();

    public HoodieAvroParquetReader(Configuration configuration, Path path) {
        this.conf = HoodieAvroParquetReader.tryOverrideDefaultConfigs(new Configuration(configuration));
        this.path = path;
        this.parquetUtils = BaseFileUtils.getInstance(HoodieFileFormat.PARQUET);
    }

    @Override
    public ClosableIterator<HoodieRecord<IndexedRecord>> getRecordIterator(Schema readerSchema) throws IOException {
        ClosableIterator<IndexedRecord> iterator2 = this.getIndexedRecordIterator(readerSchema);
        return new MappingIterator<IndexedRecord, HoodieRecord>(iterator2, data -> (HoodieRecord)TypeUtils.unsafeCast(new HoodieAvroIndexedRecord((IndexedRecord)data)));
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        return this.parquetUtils.readMinMaxRecordKeys(this.conf, this.path);
    }

    @Override
    public BloomFilter readBloomFilter() {
        return this.parquetUtils.readBloomFilterFromMetadata(this.conf, this.path);
    }

    @Override
    public Set<String> filterRowKeys(Set<String> candidateRowKeys) {
        return this.parquetUtils.filterRowKeys(this.conf, this.path, candidateRowKeys);
    }

    @Override
    protected ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema schema2) throws IOException {
        return this.getIndexedRecordIteratorInternal(schema2, Option.empty());
    }

    @Override
    protected ClosableIterator<IndexedRecord> getIndexedRecordIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        return this.getIndexedRecordIteratorInternal(readerSchema, Option.of(requestedSchema));
    }

    @Override
    public Schema getSchema() {
        return this.parquetUtils.readAvroSchema(this.conf, this.path);
    }

    @Override
    public void close() {
        this.readerIterators.forEach(ParquetReaderIterator::close);
    }

    @Override
    public long getTotalRecords() {
        return this.parquetUtils.getRowCount(this.conf, this.path);
    }

    private static Configuration tryOverrideDefaultConfigs(Configuration conf) {
        if (conf.get("parquet.avro.add-list-element-records") == null) {
            conf.set("parquet.avro.add-list-element-records", "false", "Overriding default treatment of repeated groups in Parquet");
        }
        if (conf.get("parquet.strict.typing") == null) {
            conf.set("parquet.strict.typing", "false", "Overriding default setting of whether type-checking is strict in Parquet reader, to enable type promotions (in schema evolution)");
        }
        return conf;
    }

    private ClosableIterator<IndexedRecord> getIndexedRecordIteratorInternal(Schema schema2, Option<Schema> requestedSchema) throws IOException {
        if (!requestedSchema.isPresent()) {
            AvroReadSupport.setAvroReadSchema(this.conf, schema2);
            AvroReadSupport.setRequestedProjection(this.conf, schema2);
        } else {
            AvroReadSupport.setAvroReadSchema(this.conf, requestedSchema.get());
            AvroReadSupport.setRequestedProjection(this.conf, requestedSchema.get());
        }
        ParquetReader reader = new HoodieAvroParquetReaderBuilder(this.path).withConf(this.conf).build();
        ParquetReaderIterator<IndexedRecord> parquetReaderIterator = new ParquetReaderIterator<IndexedRecord>(reader);
        this.readerIterators.add(parquetReaderIterator);
        return parquetReaderIterator;
    }
}

