/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.MappingIterator;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.io.storage.HoodieSparkFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class HoodieSparkParquetReader
implements HoodieSparkFileReader {
    private final Path path;
    private final Configuration conf;
    private final BaseFileUtils parquetUtils;
    private List<ParquetReaderIterator> readerIterators = new ArrayList<ParquetReaderIterator>();

    public HoodieSparkParquetReader(Configuration conf, Path path) {
        this.path = path;
        this.conf = new Configuration(conf);
        conf.set("parquet.avro.add-list-element-records", "false");
        this.parquetUtils = BaseFileUtils.getInstance(HoodieFileFormat.PARQUET);
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        return this.parquetUtils.readMinMaxRecordKeys(this.conf, this.path);
    }

    @Override
    public BloomFilter readBloomFilter() {
        return this.parquetUtils.readBloomFilterFromMetadata(this.conf, this.path);
    }

    @Override
    public Set<String> filterRowKeys(Set<String> candidateRowKeys) {
        return this.parquetUtils.filterRowKeys(this.conf, this.path, candidateRowKeys);
    }

    @Override
    public ClosableIterator<HoodieRecord<InternalRow>> getRecordIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        ClosableIterator<InternalRow> iterator2 = this.getInternalRowIterator(readerSchema, requestedSchema);
        StructType structType = HoodieInternalRowUtils.getCachedSchema(requestedSchema);
        UnsafeProjection projection = HoodieInternalRowUtils.getCachedUnsafeProjection(structType, structType);
        return new MappingIterator<InternalRow, HoodieRecord>(iterator2, data -> {
            UnsafeRow unsafeRow = projection.apply(data);
            return (HoodieRecord)TypeUtils.unsafeCast(new HoodieSparkRecord(unsafeRow));
        });
    }

    private ClosableIterator<InternalRow> getInternalRowIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        if (requestedSchema == null) {
            requestedSchema = readerSchema;
        }
        StructType readerStructType = HoodieInternalRowUtils.getCachedSchema(readerSchema);
        StructType requestedStructType = HoodieInternalRowUtils.getCachedSchema(requestedSchema);
        this.conf.set("parquet.read.schema", readerStructType.json());
        this.conf.set(ParquetReadSupport.SPARK_ROW_REQUESTED_SCHEMA(), requestedStructType.json());
        this.conf.setBoolean(SQLConf.PARQUET_BINARY_AS_STRING().key(), ((Boolean)SQLConf.get().getConf(SQLConf.PARQUET_BINARY_AS_STRING())).booleanValue());
        this.conf.setBoolean(SQLConf.PARQUET_INT96_AS_TIMESTAMP().key(), ((Boolean)SQLConf.get().getConf(SQLConf.PARQUET_INT96_AS_TIMESTAMP())).booleanValue());
        ParquetReader reader = ParquetReader.builder((ReadSupport)new ParquetReadSupport(), (Path)this.path).withConf(this.conf).build();
        ParquetReaderIterator<InternalRow> parquetReaderIterator = new ParquetReaderIterator<InternalRow>(reader);
        this.readerIterators.add(parquetReaderIterator);
        return parquetReaderIterator;
    }

    @Override
    public Schema getSchema() {
        MessageType messageType = ((ParquetUtils)this.parquetUtils).readSchema(this.conf, this.path);
        StructType structType = new ParquetToSparkSchemaConverter(this.conf).convert(messageType);
        return SparkAdapterSupport$.MODULE$.sparkAdapter().getAvroSchemaConverters().toAvroType((DataType)structType, true, messageType.getName(), "");
    }

    @Override
    public void close() {
        this.readerIterators.forEach(ParquetReaderIterator::close);
    }

    @Override
    public long getTotalRecords() {
        return this.parquetUtils.getRowCount(this.conf, this.path);
    }
}

