/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.function.Function;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.io.storage.HoodieBaseParquetWriter;
import org.apache.hudi.io.storage.HoodieSparkFileWriter;
import org.apache.hudi.io.storage.row.HoodieRowParquetConfig;
import org.apache.hudi.io.storage.row.HoodieRowParquetWriteSupport;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.unsafe.types.UTF8String;

public class HoodieSparkParquetWriter
extends HoodieBaseParquetWriter<InternalRow>
implements HoodieSparkFileWriter {
    private final UTF8String fileName;
    private final UTF8String instantTime;
    private final boolean populateMetaFields;
    private final HoodieRowParquetWriteSupport writeSupport;
    private final Function<Long, String> seqIdGenerator;

    public HoodieSparkParquetWriter(Path file, HoodieRowParquetConfig parquetConfig, String instantTime, TaskContextSupplier taskContextSupplier, boolean populateMetaFields) throws IOException {
        super(file, parquetConfig);
        this.writeSupport = (HoodieRowParquetWriteSupport)((Object)parquetConfig.getWriteSupport());
        this.fileName = UTF8String.fromString((String)file.getName());
        this.instantTime = UTF8String.fromString((String)instantTime);
        this.populateMetaFields = populateMetaFields;
        this.seqIdGenerator = recordIndex -> {
            Integer partitionId = taskContextSupplier.getPartitionIdSupplier().get();
            return HoodieRecord.generateSequenceId(instantTime, partitionId, recordIndex);
        };
    }

    @Override
    public void writeRowWithMetadata(HoodieKey key, InternalRow row2) throws IOException {
        if (this.populateMetaFields) {
            UTF8String recordKey = UTF8String.fromString((String)key.getRecordKey());
            this.updateRecordMetadata(row2, recordKey, key.getPartitionPath(), this.getWrittenRecordCount());
            super.write(row2);
            this.writeSupport.add(recordKey);
        } else {
            super.write(row2);
        }
    }

    @Override
    public void writeRow(String recordKey, InternalRow row2) throws IOException {
        super.write(row2);
        if (this.populateMetaFields) {
            this.writeSupport.add(UTF8String.fromString((String)recordKey));
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    protected void updateRecordMetadata(InternalRow row2, UTF8String recordKey, String partitionPath, long recordCount) {
        row2.update(HoodieRecord.HoodieMetadataField.COMMIT_TIME_METADATA_FIELD.ordinal(), (Object)this.instantTime);
        row2.update(HoodieRecord.HoodieMetadataField.COMMIT_SEQNO_METADATA_FIELD.ordinal(), (Object)UTF8String.fromString((String)this.seqIdGenerator.apply(recordCount)));
        row2.update(HoodieRecord.HoodieMetadataField.RECORD_KEY_METADATA_FIELD.ordinal(), (Object)recordKey);
        row2.update(HoodieRecord.HoodieMetadataField.PARTITION_PATH_METADATA_FIELD.ordinal(), (Object)UTF8String.fromString((String)partitionPath));
        row2.update(HoodieRecord.HoodieMetadataField.FILENAME_METADATA_FIELD.ordinal(), (Object)this.fileName);
    }
}

