/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.client.Consistency;
import org.apache.hudi.org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.client.Query;
import org.apache.hudi.org.apache.hadoop.hbase.client.Row;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class Get
extends Query
implements Row {
    private static final Logger LOG = LoggerFactory.getLogger(Get.class);
    private byte[] row = null;
    private int maxVersions = 1;
    private boolean cacheBlocks = true;
    private int storeLimit = -1;
    private int storeOffset = 0;
    private TimeRange tr = TimeRange.allTime();
    private boolean checkExistenceOnly = false;
    private boolean closestRowBefore = false;
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);

    public Get(byte[] row2) {
        Mutation.checkRow(row2);
        this.row = row2;
    }

    public Get(Get get2) {
        this(get2.getRow());
        this.setFilter(get2.getFilter());
        this.setReplicaId(get2.getReplicaId());
        this.setConsistency(get2.getConsistency());
        this.cacheBlocks = get2.getCacheBlocks();
        this.maxVersions = get2.getMaxVersions();
        this.storeLimit = get2.getMaxResultsPerColumnFamily();
        this.storeOffset = get2.getRowOffsetPerColumnFamily();
        this.tr = get2.getTimeRange();
        this.checkExistenceOnly = get2.isCheckExistenceOnly();
        this.loadColumnFamiliesOnDemand = get2.getLoadColumnFamiliesOnDemandValue();
        Map<byte[], NavigableSet<byte[]>> fams = get2.getFamilyMap();
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : fams.entrySet()) {
            byte[] fam = entry.getKey();
            NavigableSet<byte[]> cols = entry.getValue();
            if (cols != null && cols.size() > 0) {
                for (byte[] col : cols) {
                    this.addColumn(fam, col);
                }
                continue;
            }
            this.addFamily(fam);
        }
        for (Map.Entry<Object, Object> entry : get2.getAttributesMap().entrySet()) {
            this.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : get2.getColumnFamilyTimeRange().entrySet()) {
            TimeRange tr = (TimeRange)entry.getValue();
            this.setColumnFamilyTimeRange((byte[])entry.getKey(), tr.getMin(), tr.getMax());
        }
        super.setPriority(get2.getPriority());
    }

    public Get(byte[] row2, int rowOffset, int rowLength) {
        Mutation.checkRow(row2, rowOffset, rowLength);
        this.row = Bytes.copy(row2, rowOffset, rowLength);
    }

    public Get(ByteBuffer row2) {
        Mutation.checkRow(row2);
        this.row = new byte[row2.remaining()];
        row2.get(this.row);
    }

    public boolean isCheckExistenceOnly() {
        return this.checkExistenceOnly;
    }

    public Get setCheckExistenceOnly(boolean checkExistenceOnly) {
        this.checkExistenceOnly = checkExistenceOnly;
        return this;
    }

    @Deprecated
    public boolean isClosestRowBefore() {
        return this.closestRowBefore;
    }

    @Deprecated
    public Get setClosestRowBefore(boolean closestRowBefore) {
        return this;
    }

    public Get addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public Get addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            this.familyMap.put(family, set);
        }
        if (qualifier == null) {
            qualifier = HConstants.EMPTY_BYTE_ARRAY;
        }
        set.add(qualifier);
        return this;
    }

    public Get setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    @Deprecated
    public Get setTimeStamp(long timestamp) throws IOException {
        return this.setTimestamp(timestamp);
    }

    public Get setTimestamp(long timestamp) {
        try {
            this.tr = new TimeRange(timestamp, timestamp + 1L);
        }
        catch (Exception e) {
            LOG.error("TimeRange failed, likely caused by integer overflow. ", (Throwable)e);
            throw e;
        }
        return this;
    }

    @Override
    public Get setColumnFamilyTimeRange(byte[] cf, long minStamp, long maxStamp) {
        return (Get)super.setColumnFamilyTimeRange(cf, minStamp, maxStamp);
    }

    @Deprecated
    public Get setMaxVersions() {
        return this.readAllVersions();
    }

    @Deprecated
    public Get setMaxVersions(int maxVersions) throws IOException {
        return this.readVersions(maxVersions);
    }

    public Get readAllVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public Get readVersions(int versions) throws IOException {
        if (versions <= 0) {
            throw new IOException("versions must be positive");
        }
        this.maxVersions = versions;
        return this;
    }

    @Override
    public Get setLoadColumnFamiliesOnDemand(boolean value) {
        return (Get)super.setLoadColumnFamiliesOnDemand(value);
    }

    public Get setMaxResultsPerColumnFamily(int limit) {
        this.storeLimit = limit;
        return this;
    }

    public Get setRowOffsetPerColumnFamily(int offset) {
        this.storeOffset = offset;
        return this;
    }

    @Override
    public Get setFilter(Filter filter) {
        super.setFilter(filter);
        return this;
    }

    public Get setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
        return this;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public int getMaxResultsPerColumnFamily() {
        return this.storeLimit;
    }

    public int getRowOffsetPerColumnFamily() {
        return this.storeOffset;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public Set<byte[]> familySet() {
        return this.familyMap.keySet();
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>(this.familyMap.entrySet().size());
        map.put("families", families);
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary(entry.getKey()));
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        HashMap columns = new HashMap();
        map.put("families", columns);
        map.put("row", Bytes.toStringBinary(this.row));
        map.put("maxVersions", this.maxVersions);
        map.put("cacheBlocks", this.cacheBlocks);
        ArrayList<Long> timeRange = new ArrayList<Long>(2);
        timeRange.add(this.tr.getMin());
        timeRange.add(this.tr.getMax());
        map.put("timeRange", timeRange);
        int colCount = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            ArrayList<String> familyList = new ArrayList<String>();
            columns.put(Bytes.toStringBinary(entry.getKey()), familyList);
            if (entry.getValue() == null) {
                ++colCount;
                --maxCols;
                familyList.add("ALL");
                continue;
            }
            colCount += entry.getValue().size();
            if (maxCols <= 0) continue;
            for (byte[] column : entry.getValue()) {
                if (--maxCols <= 0) continue;
                familyList.add(Bytes.toStringBinary(column));
            }
        }
        map.put("totalColumns", colCount);
        if (this.filter != null) {
            map.put("filter", this.filter.toString());
        }
        if (this.getId() != null) {
            map.put("id", this.getId());
        }
        return map;
    }

    @Override
    public int compareTo(Row other) {
        return Bytes.compareTo(this.getRow(), other.getRow());
    }

    public int hashCode() {
        return Bytes.hashCode(this.getRow());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public Get setAttribute(String name, byte[] value) {
        return (Get)super.setAttribute(name, value);
    }

    @Override
    public Get setId(String id) {
        return (Get)super.setId(id);
    }

    @Override
    public Get setAuthorizations(Authorizations authorizations) {
        return (Get)super.setAuthorizations(authorizations);
    }

    @Override
    public Get setACL(Map<String, Permission> perms) {
        return (Get)super.setACL(perms);
    }

    @Override
    public Get setACL(String user, Permission perms) {
        return (Get)super.setACL(user, perms);
    }

    @Override
    public Get setConsistency(Consistency consistency) {
        return (Get)super.setConsistency(consistency);
    }

    @Override
    public Get setReplicaId(int Id2) {
        return (Get)super.setReplicaId(Id2);
    }

    @Override
    public Get setIsolationLevel(IsolationLevel level) {
        return (Get)super.setIsolationLevel(level);
    }

    @Override
    public Get setPriority(int priority) {
        return (Get)super.setPriority(priority);
    }
}

