/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface RegionLocator
extends Closeable {
    public static final String LOCATOR_META_REPLICAS_MODE = "hbase.locator.meta.replicas.mode";
    public static final String LOCATOR_META_REPLICAS_MODE_LOADBALANCE_SELECTOR = "hbase.locator.meta.replicas.mode.loadbalance.selector";

    default public HRegionLocation getRegionLocation(byte[] row2) throws IOException {
        return this.getRegionLocation(row2, false);
    }

    default public HRegionLocation getRegionLocation(byte[] row2, boolean reload) throws IOException {
        return this.getRegionLocation(row2, 0, reload);
    }

    default public HRegionLocation getRegionLocation(byte[] row2, int replicaId) throws IOException {
        return this.getRegionLocation(row2, replicaId, false);
    }

    public HRegionLocation getRegionLocation(byte[] var1, int var2, boolean var3) throws IOException;

    default public List<HRegionLocation> getRegionLocations(byte[] row2) throws IOException {
        return this.getRegionLocations(row2, false);
    }

    public List<HRegionLocation> getRegionLocations(byte[] var1, boolean var2) throws IOException;

    public void clearRegionLocationCache();

    public List<HRegionLocation> getAllRegionLocations() throws IOException;

    default public byte[][] getStartKeys() throws IOException {
        return this.getStartEndKeys().getFirst();
    }

    default public byte[][] getEndKeys() throws IOException {
        return this.getStartEndKeys().getSecond();
    }

    default public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        List regions = this.getAllRegionLocations().stream().filter(loc -> RegionReplicaUtil.isDefaultReplica(loc.getRegion())).collect(Collectors.toList());
        byte[][] startKeys = new byte[regions.size()][];
        byte[][] endKeys = new byte[regions.size()][];
        int n = regions.size();
        for (int i = 0; i < n; ++i) {
            RegionInfo region = ((HRegionLocation)regions.get(i)).getRegion();
            startKeys[i] = region.getStartKey();
            endKeys[i] = region.getEndKey();
        }
        return Pair.newPair(startKeys, endKeys);
    }

    public TableName getName();
}

