/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.constraint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hudi.org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.client.Durability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Put;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.constraint.Constraint;
import org.apache.hudi.org.apache.hadoop.hbase.constraint.Constraints;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hudi.org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ConstraintProcessor
implements RegionCoprocessor,
RegionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(ConstraintProcessor.class);
    private final ClassLoader classloader;
    private List<? extends Constraint> constraints = new ArrayList<Constraint>();

    @Override
    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public ConstraintProcessor() {
        this.classloader = this.getClass().getClassLoader();
    }

    @Override
    public void start(CoprocessorEnvironment environment) {
        if (!(environment instanceof RegionCoprocessorEnvironment)) {
            throw new IllegalArgumentException("Constraints only act on regions - started in an environment that was not a region");
        }
        RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)environment;
        TableDescriptor desc = env.getRegion().getTableDescriptor();
        try {
            this.constraints = Constraints.getConstraints(desc, this.classloader);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Finished loading " + this.constraints.size() + " user Constraints on table: " + desc.getTableName());
        }
    }

    @Override
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put2, WALEdit edit, Durability durability) throws IOException {
        for (Constraint constraint : this.constraints) {
            constraint.check(put2);
        }
    }
}

