/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.filter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hudi.org.apache.hadoop.hbase.CompareOperator;
import org.apache.hudi.org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hudi.org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hudi.org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hudi.org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.Filter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hudi.org.apache.hadoop.hbase.filter.ParseConstants;
import org.apache.hudi.org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hudi.org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hudi.org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hudi.org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class ParseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ParseFilter.class);
    private static HashMap<ByteBuffer, Integer> operatorPrecedenceHashMap;
    private static HashMap<String, String> filterHashMap;

    public Filter parseFilterString(String filterString) throws CharacterCodingException {
        return this.parseFilterString(Bytes.toBytes(filterString));
    }

    public Filter parseFilterString(byte[] filterStringAsByteArray) throws CharacterCodingException {
        Stack<ByteBuffer> operatorStack = new Stack<ByteBuffer>();
        Stack<Filter> filterStack = new Stack<Filter>();
        Filter filter = null;
        for (int i = 0; i < filterStringAsByteArray.length; ++i) {
            if (filterStringAsByteArray[i] == 40) {
                operatorStack.push(ParseConstants.LPAREN_BUFFER);
                continue;
            }
            if (filterStringAsByteArray[i] == 32 || filterStringAsByteArray[i] == 9) continue;
            if (ParseFilter.checkForOr(filterStringAsByteArray, i)) {
                i += ParseConstants.OR_ARRAY.length - 1;
                this.reduce(operatorStack, filterStack, ParseConstants.OR_BUFFER);
                operatorStack.push(ParseConstants.OR_BUFFER);
                continue;
            }
            if (ParseFilter.checkForAnd(filterStringAsByteArray, i)) {
                i += ParseConstants.AND_ARRAY.length - 1;
                this.reduce(operatorStack, filterStack, ParseConstants.AND_BUFFER);
                operatorStack.push(ParseConstants.AND_BUFFER);
                continue;
            }
            if (ParseFilter.checkForSkip(filterStringAsByteArray, i)) {
                i += ParseConstants.SKIP_ARRAY.length - 1;
                this.reduce(operatorStack, filterStack, ParseConstants.SKIP_BUFFER);
                operatorStack.push(ParseConstants.SKIP_BUFFER);
                continue;
            }
            if (ParseFilter.checkForWhile(filterStringAsByteArray, i)) {
                i += ParseConstants.WHILE_ARRAY.length - 1;
                this.reduce(operatorStack, filterStack, ParseConstants.WHILE_BUFFER);
                operatorStack.push(ParseConstants.WHILE_BUFFER);
                continue;
            }
            if (filterStringAsByteArray[i] == 41) {
                if (operatorStack.empty()) {
                    throw new IllegalArgumentException("Mismatched parenthesis");
                }
                ByteBuffer argumentOnTopOfStack = operatorStack.peek();
                if (argumentOnTopOfStack.equals(ParseConstants.LPAREN_BUFFER)) {
                    operatorStack.pop();
                    continue;
                }
                while (!argumentOnTopOfStack.equals(ParseConstants.LPAREN_BUFFER)) {
                    filterStack.push(ParseFilter.popArguments(operatorStack, filterStack));
                    if (operatorStack.empty()) {
                        throw new IllegalArgumentException("Mismatched parenthesis");
                    }
                    argumentOnTopOfStack = operatorStack.pop();
                }
                continue;
            }
            byte[] filterSimpleExpression = this.extractFilterSimpleExpression(filterStringAsByteArray, i);
            i += filterSimpleExpression.length - 1;
            filter = this.parseSimpleFilterExpression(filterSimpleExpression);
            filterStack.push(filter);
        }
        while (!operatorStack.empty()) {
            filterStack.push(ParseFilter.popArguments(operatorStack, filterStack));
        }
        if (filterStack.empty()) {
            throw new IllegalArgumentException("Incorrect Filter String");
        }
        filter = filterStack.pop();
        if (!filterStack.empty()) {
            throw new IllegalArgumentException("Incorrect Filter String");
        }
        return filter;
    }

    public byte[] extractFilterSimpleExpression(byte[] filterStringAsByteArray, int filterExpressionStartOffset) throws CharacterCodingException {
        int quoteCount = 0;
        for (int i = filterExpressionStartOffset; i < filterStringAsByteArray.length; ++i) {
            if (filterStringAsByteArray[i] == 39) {
                if (ParseFilter.isQuoteUnescaped(filterStringAsByteArray, i)) {
                    ++quoteCount;
                } else {
                    ++i;
                }
            }
            if (filterStringAsByteArray[i] != 41 || quoteCount % 2 != 0) continue;
            byte[] filterSimpleExpression = new byte[i - filterExpressionStartOffset + 1];
            Bytes.putBytes(filterSimpleExpression, 0, filterStringAsByteArray, filterExpressionStartOffset, i - filterExpressionStartOffset + 1);
            return filterSimpleExpression;
        }
        throw new IllegalArgumentException("Incorrect Filter String");
    }

    public Filter parseSimpleFilterExpression(byte[] filterStringAsByteArray) throws CharacterCodingException {
        String filterName = Bytes.toString(ParseFilter.getFilterName(filterStringAsByteArray));
        ArrayList<byte[]> filterArguments = ParseFilter.getFilterArguments(filterStringAsByteArray);
        if (!filterHashMap.containsKey(filterName)) {
            throw new IllegalArgumentException("Filter Name " + filterName + " not supported");
        }
        try {
            filterName = filterHashMap.get(filterName);
            Class<?> c = Class.forName(filterName);
            Class[] argTypes = new Class[]{ArrayList.class};
            Method m = c.getDeclaredMethod("createFilterFromArguments", argTypes);
            return (Filter)m.invoke(null, filterArguments);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        throw new IllegalArgumentException("Incorrect filter string " + new String(filterStringAsByteArray, StandardCharsets.UTF_8));
    }

    public static byte[] getFilterName(byte[] filterStringAsByteArray) {
        int filterNameStartIndex = 0;
        int filterNameEndIndex = 0;
        for (int i = filterNameStartIndex; i < filterStringAsByteArray.length; ++i) {
            if (filterStringAsByteArray[i] != 40 && filterStringAsByteArray[i] != 32) continue;
            filterNameEndIndex = i;
            break;
        }
        if (filterNameEndIndex == 0) {
            throw new IllegalArgumentException("Incorrect Filter Name");
        }
        byte[] filterName = new byte[filterNameEndIndex - filterNameStartIndex];
        Bytes.putBytes(filterName, 0, filterStringAsByteArray, 0, filterNameEndIndex - filterNameStartIndex);
        return filterName;
    }

    public static ArrayList<byte[]> getFilterArguments(byte[] filterStringAsByteArray) {
        int argumentListStartIndex = Bytes.searchDelimiterIndex(filterStringAsByteArray, 0, filterStringAsByteArray.length, 40);
        if (argumentListStartIndex == -1) {
            throw new IllegalArgumentException("Incorrect argument list");
        }
        int argumentStartIndex = 0;
        int argumentEndIndex = 0;
        ArrayList<byte[]> filterArguments = new ArrayList<byte[]>();
        block0: for (int i = argumentListStartIndex + 1; i < filterStringAsByteArray.length; ++i) {
            byte[] filterArgument;
            int j;
            if (filterStringAsByteArray[i] == 32 || filterStringAsByteArray[i] == 44 || filterStringAsByteArray[i] == 41) continue;
            if (filterStringAsByteArray[i] == 39) {
                argumentStartIndex = i;
                for (j = argumentStartIndex + 1; j < filterStringAsByteArray.length; ++j) {
                    if (filterStringAsByteArray[j] == 39) {
                        if (ParseFilter.isQuoteUnescaped(filterStringAsByteArray, j)) {
                            argumentEndIndex = j;
                            i = j + 1;
                            filterArgument = ParseFilter.createUnescapdArgument(filterStringAsByteArray, argumentStartIndex, argumentEndIndex);
                            filterArguments.add(filterArgument);
                            continue block0;
                        }
                        ++j;
                        continue;
                    }
                    if (j != filterStringAsByteArray.length - 1) continue;
                    throw new IllegalArgumentException("Incorrect argument list");
                }
                continue;
            }
            for (j = argumentStartIndex = i; j < filterStringAsByteArray.length; ++j) {
                if (filterStringAsByteArray[j] == 32 || filterStringAsByteArray[j] == 44 || filterStringAsByteArray[j] == 41) {
                    argumentEndIndex = j - 1;
                    i = j;
                    filterArgument = new byte[argumentEndIndex - argumentStartIndex + 1];
                    Bytes.putBytes(filterArgument, 0, filterStringAsByteArray, argumentStartIndex, argumentEndIndex - argumentStartIndex + 1);
                    filterArguments.add(filterArgument);
                    continue block0;
                }
                if (j != filterStringAsByteArray.length - 1) continue;
                throw new IllegalArgumentException("Incorrect argument list");
            }
        }
        return filterArguments;
    }

    public void reduce(Stack<ByteBuffer> operatorStack, Stack<Filter> filterStack, ByteBuffer operator) {
        while (!operatorStack.empty() && !ParseConstants.LPAREN_BUFFER.equals(operatorStack.peek()) && this.hasHigherPriority(operatorStack.peek(), operator)) {
            filterStack.push(ParseFilter.popArguments(operatorStack, filterStack));
        }
    }

    public static Filter popArguments(Stack<ByteBuffer> operatorStack, Stack<Filter> filterStack) {
        ByteBuffer argumentOnTopOfStack = operatorStack.peek();
        if (argumentOnTopOfStack.equals(ParseConstants.OR_BUFFER)) {
            try {
                Filter filter;
                ArrayList<Filter> listOfFilters = new ArrayList<Filter>();
                while (!operatorStack.empty() && operatorStack.peek().equals(ParseConstants.OR_BUFFER)) {
                    filter = filterStack.pop();
                    listOfFilters.add(0, filter);
                    operatorStack.pop();
                }
                filter = filterStack.pop();
                listOfFilters.add(0, filter);
                FilterList orFilter = new FilterList(FilterList.Operator.MUST_PASS_ONE, listOfFilters);
                return orFilter;
            }
            catch (EmptyStackException e) {
                throw new IllegalArgumentException("Incorrect input string - an OR needs two filters");
            }
        }
        if (argumentOnTopOfStack.equals(ParseConstants.AND_BUFFER)) {
            try {
                Filter filter;
                ArrayList<Filter> listOfFilters = new ArrayList<Filter>();
                while (!operatorStack.empty() && operatorStack.peek().equals(ParseConstants.AND_BUFFER)) {
                    filter = filterStack.pop();
                    listOfFilters.add(0, filter);
                    operatorStack.pop();
                }
                filter = filterStack.pop();
                listOfFilters.add(0, filter);
                FilterList andFilter = new FilterList(FilterList.Operator.MUST_PASS_ALL, listOfFilters);
                return andFilter;
            }
            catch (EmptyStackException e) {
                throw new IllegalArgumentException("Incorrect input string - an AND needs two filters");
            }
        }
        if (argumentOnTopOfStack.equals(ParseConstants.SKIP_BUFFER)) {
            try {
                Filter wrappedFilter = filterStack.pop();
                SkipFilter skipFilter = new SkipFilter(wrappedFilter);
                operatorStack.pop();
                return skipFilter;
            }
            catch (EmptyStackException e) {
                throw new IllegalArgumentException("Incorrect input string - a SKIP wraps a filter");
            }
        }
        if (argumentOnTopOfStack.equals(ParseConstants.WHILE_BUFFER)) {
            try {
                Filter wrappedFilter = filterStack.pop();
                WhileMatchFilter whileMatchFilter = new WhileMatchFilter(wrappedFilter);
                operatorStack.pop();
                return whileMatchFilter;
            }
            catch (EmptyStackException e) {
                throw new IllegalArgumentException("Incorrect input string - a WHILE wraps a filter");
            }
        }
        if (argumentOnTopOfStack.equals(ParseConstants.LPAREN_BUFFER)) {
            try {
                Filter filter = filterStack.pop();
                operatorStack.pop();
                return filter;
            }
            catch (EmptyStackException e) {
                throw new IllegalArgumentException("Incorrect Filter String");
            }
        }
        throw new IllegalArgumentException("Incorrect arguments on operatorStack");
    }

    public boolean hasHigherPriority(ByteBuffer a, ByteBuffer b) {
        return operatorPrecedenceHashMap.get(a) - operatorPrecedenceHashMap.get(b) < 0;
    }

    public static byte[] createUnescapdArgument(byte[] filterStringAsByteArray, int argumentStartIndex, int argumentEndIndex) {
        int unescapedArgumentLength = 2;
        for (int i = argumentStartIndex + 1; i <= argumentEndIndex - 1; ++i) {
            ++unescapedArgumentLength;
            if (filterStringAsByteArray[i] != 39 || i == argumentEndIndex - 1 || filterStringAsByteArray[i + 1] != 39) continue;
            ++i;
        }
        byte[] unescapedArgument = new byte[unescapedArgumentLength];
        int count2 = 1;
        unescapedArgument[0] = 39;
        for (int i = argumentStartIndex + 1; i <= argumentEndIndex - 1; ++i) {
            if (filterStringAsByteArray[i] == 39 && i != argumentEndIndex - 1 && filterStringAsByteArray[i + 1] == 39) {
                unescapedArgument[count2++] = filterStringAsByteArray[i + 1];
                ++i;
                continue;
            }
            unescapedArgument[count2++] = filterStringAsByteArray[i];
        }
        unescapedArgument[unescapedArgumentLength - 1] = 39;
        return unescapedArgument;
    }

    public static boolean checkForOr(byte[] filterStringAsByteArray, int indexOfOr) throws CharacterCodingException, ArrayIndexOutOfBoundsException {
        try {
            return !(filterStringAsByteArray[indexOfOr] != 79 || filterStringAsByteArray[indexOfOr + 1] != 82 || filterStringAsByteArray[indexOfOr - 1] != 32 && filterStringAsByteArray[indexOfOr - 1] != 41 || filterStringAsByteArray[indexOfOr + 2] != 32 && filterStringAsByteArray[indexOfOr + 2] != 40);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean checkForAnd(byte[] filterStringAsByteArray, int indexOfAnd) throws CharacterCodingException {
        try {
            return !(filterStringAsByteArray[indexOfAnd] != 65 || filterStringAsByteArray[indexOfAnd + 1] != 78 || filterStringAsByteArray[indexOfAnd + 2] != 68 || filterStringAsByteArray[indexOfAnd - 1] != 32 && filterStringAsByteArray[indexOfAnd - 1] != 41 || filterStringAsByteArray[indexOfAnd + 3] != 32 && filterStringAsByteArray[indexOfAnd + 3] != 40);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean checkForSkip(byte[] filterStringAsByteArray, int indexOfSkip) throws CharacterCodingException {
        try {
            return !(filterStringAsByteArray[indexOfSkip] != 83 || filterStringAsByteArray[indexOfSkip + 1] != 75 || filterStringAsByteArray[indexOfSkip + 2] != 73 || filterStringAsByteArray[indexOfSkip + 3] != 80 || indexOfSkip != 0 && filterStringAsByteArray[indexOfSkip - 1] != 32 && filterStringAsByteArray[indexOfSkip - 1] != 41 && filterStringAsByteArray[indexOfSkip - 1] != 40 || filterStringAsByteArray[indexOfSkip + 4] != 32 && filterStringAsByteArray[indexOfSkip + 4] != 40);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean checkForWhile(byte[] filterStringAsByteArray, int indexOfWhile) throws CharacterCodingException {
        try {
            return !(filterStringAsByteArray[indexOfWhile] != 87 || filterStringAsByteArray[indexOfWhile + 1] != 72 || filterStringAsByteArray[indexOfWhile + 2] != 73 || filterStringAsByteArray[indexOfWhile + 3] != 76 || filterStringAsByteArray[indexOfWhile + 4] != 69 || indexOfWhile != 0 && filterStringAsByteArray[indexOfWhile - 1] != 32 && filterStringAsByteArray[indexOfWhile - 1] != 41 && filterStringAsByteArray[indexOfWhile - 1] != 40 || filterStringAsByteArray[indexOfWhile + 5] != 32 && filterStringAsByteArray[indexOfWhile + 5] != 40);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean isQuoteUnescaped(byte[] array2, int quoteIndex) {
        if (array2 == null) {
            throw new IllegalArgumentException("isQuoteUnescaped called with a null array");
        }
        return quoteIndex == array2.length - 1 || array2[quoteIndex + 1] != 39;
    }

    public static byte[] removeQuotesFromByteArray(byte[] quotedByteArray) {
        if (quotedByteArray == null || quotedByteArray.length < 2 || quotedByteArray[0] != 39 || quotedByteArray[quotedByteArray.length - 1] != 39) {
            throw new IllegalArgumentException("removeQuotesFromByteArray needs a quoted byte array");
        }
        byte[] targetString = new byte[quotedByteArray.length - 2];
        Bytes.putBytes(targetString, 0, quotedByteArray, 1, quotedByteArray.length - 2);
        return targetString;
    }

    public static int convertByteArrayToInt(byte[] numberAsByteArray) {
        long tempResult = ParseFilter.convertByteArrayToLong(numberAsByteArray);
        if (tempResult > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer Argument too large");
        }
        if (tempResult < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Integer Argument too small");
        }
        int result = (int)tempResult;
        return result;
    }

    public static long convertByteArrayToLong(byte[] numberAsByteArray) {
        if (numberAsByteArray == null) {
            throw new IllegalArgumentException("convertByteArrayToLong called with a null array");
        }
        int i = 0;
        long result = 0L;
        boolean isNegative = false;
        if (numberAsByteArray[i] == 45) {
            ++i;
            isNegative = true;
        }
        while (i != numberAsByteArray.length) {
            if (numberAsByteArray[i] < 48 || numberAsByteArray[i] > 57) {
                throw new IllegalArgumentException("Byte Array should only contain digits");
            }
            if ((result = result * 10L + (long)(numberAsByteArray[i] - 48)) < 0L) {
                throw new IllegalArgumentException("Long Argument too large");
            }
            ++i;
        }
        if (isNegative) {
            return -result;
        }
        return result;
    }

    public static boolean convertByteArrayToBoolean(byte[] booleanAsByteArray) {
        if (booleanAsByteArray == null) {
            throw new IllegalArgumentException("convertByteArrayToBoolean called with a null array");
        }
        if (!(booleanAsByteArray.length != 4 || booleanAsByteArray[0] != 116 && booleanAsByteArray[0] != 84 || booleanAsByteArray[1] != 114 && booleanAsByteArray[1] != 82 || booleanAsByteArray[2] != 117 && booleanAsByteArray[2] != 85 || booleanAsByteArray[3] != 101 && booleanAsByteArray[3] != 69)) {
            return true;
        }
        if (!(booleanAsByteArray.length != 5 || booleanAsByteArray[0] != 102 && booleanAsByteArray[0] != 70 || booleanAsByteArray[1] != 97 && booleanAsByteArray[1] != 65 || booleanAsByteArray[2] != 108 && booleanAsByteArray[2] != 76 || booleanAsByteArray[3] != 115 && booleanAsByteArray[3] != 83 || booleanAsByteArray[4] != 101 && booleanAsByteArray[4] != 69)) {
            return false;
        }
        throw new IllegalArgumentException("Incorrect Boolean Expression");
    }

    public static CompareOperator createCompareOperator(byte[] compareOpAsByteArray) {
        ByteBuffer compareOp = ByteBuffer.wrap(compareOpAsByteArray);
        if (compareOp.equals(ParseConstants.LESS_THAN_BUFFER)) {
            return CompareOperator.LESS;
        }
        if (compareOp.equals(ParseConstants.LESS_THAN_OR_EQUAL_TO_BUFFER)) {
            return CompareOperator.LESS_OR_EQUAL;
        }
        if (compareOp.equals(ParseConstants.GREATER_THAN_BUFFER)) {
            return CompareOperator.GREATER;
        }
        if (compareOp.equals(ParseConstants.GREATER_THAN_OR_EQUAL_TO_BUFFER)) {
            return CompareOperator.GREATER_OR_EQUAL;
        }
        if (compareOp.equals(ParseConstants.NOT_EQUAL_TO_BUFFER)) {
            return CompareOperator.NOT_EQUAL;
        }
        if (compareOp.equals(ParseConstants.EQUAL_TO_BUFFER)) {
            return CompareOperator.EQUAL;
        }
        throw new IllegalArgumentException("Invalid compare operator");
    }

    @Deprecated
    public static CompareFilter.CompareOp createCompareOp(byte[] compareOpAsByteArray) {
        ByteBuffer compareOp = ByteBuffer.wrap(compareOpAsByteArray);
        if (compareOp.equals(ParseConstants.LESS_THAN_BUFFER)) {
            return CompareFilter.CompareOp.LESS;
        }
        if (compareOp.equals(ParseConstants.LESS_THAN_OR_EQUAL_TO_BUFFER)) {
            return CompareFilter.CompareOp.LESS_OR_EQUAL;
        }
        if (compareOp.equals(ParseConstants.GREATER_THAN_BUFFER)) {
            return CompareFilter.CompareOp.GREATER;
        }
        if (compareOp.equals(ParseConstants.GREATER_THAN_OR_EQUAL_TO_BUFFER)) {
            return CompareFilter.CompareOp.GREATER_OR_EQUAL;
        }
        if (compareOp.equals(ParseConstants.NOT_EQUAL_TO_BUFFER)) {
            return CompareFilter.CompareOp.NOT_EQUAL;
        }
        if (compareOp.equals(ParseConstants.EQUAL_TO_BUFFER)) {
            return CompareFilter.CompareOp.EQUAL;
        }
        throw new IllegalArgumentException("Invalid compare operator");
    }

    public static ByteArrayComparable createComparator(byte[] comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Incorrect Comparator");
        }
        byte[][] parsedComparator = ParseFilter.parseComparator(comparator);
        byte[] comparatorType = parsedComparator[0];
        byte[] comparatorValue = parsedComparator[1];
        if (Bytes.equals(comparatorType, ParseConstants.binaryType)) {
            return new BinaryComparator(comparatorValue);
        }
        if (Bytes.equals(comparatorType, ParseConstants.binaryPrefixType)) {
            return new BinaryPrefixComparator(comparatorValue);
        }
        if (Bytes.equals(comparatorType, ParseConstants.regexStringType)) {
            return new RegexStringComparator(new String(comparatorValue, StandardCharsets.UTF_8));
        }
        if (Bytes.equals(comparatorType, ParseConstants.substringType)) {
            return new SubstringComparator(new String(comparatorValue, StandardCharsets.UTF_8));
        }
        throw new IllegalArgumentException("Incorrect comparatorType");
    }

    public static byte[][] parseComparator(byte[] comparator) {
        int index = Bytes.searchDelimiterIndex(comparator, 0, comparator.length, 58);
        if (index == -1) {
            throw new IllegalArgumentException("Incorrect comparator");
        }
        byte[][] result = new byte[2][0];
        result[0] = new byte[index];
        System.arraycopy(comparator, 0, result[0], 0, index);
        int len = comparator.length - (index + 1);
        result[1] = new byte[len];
        System.arraycopy(comparator, index + 1, result[1], 0, len);
        return result;
    }

    public Set<String> getSupportedFilters() {
        return filterHashMap.keySet();
    }

    public static Map<String, String> getAllFilters() {
        return Collections.unmodifiableMap(filterHashMap);
    }

    public static void registerFilter(String name, String filterClass) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Registering new filter " + name);
        }
        filterHashMap.put(name, filterClass);
    }

    static {
        filterHashMap = new HashMap();
        filterHashMap.put("KeyOnlyFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.KeyOnlyFilter");
        filterHashMap.put("FirstKeyOnlyFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter");
        filterHashMap.put("PrefixFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.PrefixFilter");
        filterHashMap.put("ColumnPrefixFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.ColumnPrefixFilter");
        filterHashMap.put("MultipleColumnPrefixFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter");
        filterHashMap.put("ColumnCountGetFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.ColumnCountGetFilter");
        filterHashMap.put("PageFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.PageFilter");
        filterHashMap.put("ColumnPaginationFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.ColumnPaginationFilter");
        filterHashMap.put("InclusiveStopFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.InclusiveStopFilter");
        filterHashMap.put("TimestampsFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.TimestampsFilter");
        filterHashMap.put("RowFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.RowFilter");
        filterHashMap.put("FamilyFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.FamilyFilter");
        filterHashMap.put("QualifierFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.QualifierFilter");
        filterHashMap.put("ValueFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.ValueFilter");
        filterHashMap.put("ColumnRangeFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.ColumnRangeFilter");
        filterHashMap.put("SingleColumnValueFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.SingleColumnValueFilter");
        filterHashMap.put("SingleColumnValueExcludeFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter");
        filterHashMap.put("DependentColumnFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.DependentColumnFilter");
        filterHashMap.put("ColumnValueFilter", "org.apache.hudi.org.apache.hadoop.hbase.filter.ColumnValueFilter");
        operatorPrecedenceHashMap = new HashMap();
        operatorPrecedenceHashMap.put(ParseConstants.SKIP_BUFFER, 1);
        operatorPrecedenceHashMap.put(ParseConstants.WHILE_BUFFER, 1);
        operatorPrecedenceHashMap.put(ParseConstants.AND_BUFFER, 2);
        operatorPrecedenceHashMap.put(ParseConstants.OR_BUFFER, 3);
    }
}

