/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.Call;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.CallEvent;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelDuplexHandler;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelPromise;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class BufferCallBeforeInitHandler
extends ChannelDuplexHandler {
    private static final BufferCallEvent SUCCESS_EVENT = new BufferCallEvent(BufferCallAction.FLUSH, null);
    private final Map<Integer, Call> id2Call = new HashMap<Integer, Call>();

    BufferCallBeforeInitHandler() {
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof Call) {
            Call call2 = (Call)msg;
            this.id2Call.put(call2.id, call2);
            promise.trySuccess();
        } else {
            ctx.write(msg, promise);
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof BufferCallEvent) {
            BufferCallEvent bcEvt = (BufferCallEvent)evt;
            switch (bcEvt.action) {
                case FLUSH: {
                    for (Call call2 : this.id2Call.values()) {
                        ctx.write(call2);
                    }
                    break;
                }
                case FAIL: {
                    for (Call call3 : this.id2Call.values()) {
                        call3.setException(bcEvt.error);
                    }
                    break;
                }
            }
            ctx.flush();
            ctx.pipeline().remove(this);
        } else if (evt instanceof CallEvent) {
            this.id2Call.remove(((CallEvent)evt).call.id);
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    public static final class BufferCallEvent {
        public final BufferCallAction action;
        public final IOException error;

        private BufferCallEvent(BufferCallAction action, IOException error) {
            this.action = action;
            this.error = error;
        }

        public static BufferCallEvent success() {
            return SUCCESS_EVENT;
        }

        public static BufferCallEvent fail(IOException error) {
            return new BufferCallEvent(BufferCallAction.FAIL, error);
        }
    }

    private static enum BufferCallAction {
        FLUSH,
        FAIL;

    }
}

