/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hudi.org.apache.hadoop.hbase.util.RowBloomContext;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RowPrefixFixedLengthBloomContext
extends RowBloomContext {
    private final int prefixLength;

    public RowPrefixFixedLengthBloomContext(BloomFilterWriter bloomFilterWriter, CellComparator comparator, int prefixLength) {
        super(bloomFilterWriter, comparator);
        this.prefixLength = prefixLength;
    }

    @Override
    public void writeBloom(Cell cell) throws IOException {
        super.writeBloom(this.getRowPrefixCell(cell));
    }

    private Cell getRowPrefixCell(Cell cell) {
        byte[] row2 = CellUtil.copyRow(cell);
        return ExtendedCellBuilderFactory.create(CellBuilderType.DEEP_COPY).setRow(row2, 0, Math.min(this.prefixLength, row2.length)).setType(Cell.Type.Put).build();
    }
}

