/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sort;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hudi.common.util.BinaryUtil;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.optimize.HilbertCurveUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.hudi.execution.ByteArraySorting;
import org.apache.spark.sql.hudi.execution.RangeSampleSort$;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType;
import org.davidmoten.hilbert.HilbertCurve;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.mutable.WrappedArray;

public class SpaceCurveSortingHelper {
    private static final Logger LOG = LogManager.getLogger(SpaceCurveSortingHelper.class);

    public static Dataset<Row> orderDataFrameByMappingValues(Dataset<Row> df, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy, List<String> orderByCols, int targetPartitionCount) {
        JavaRDD<Row> sortedRDD;
        Map columnsMap = Arrays.stream(df.schema().fields()).collect(Collectors.toMap(StructField::name, java.util.function.Function.identity()));
        List checkCols = orderByCols.stream().filter(columnsMap::containsKey).collect(Collectors.toList());
        if (orderByCols.size() != checkCols.size()) {
            LOG.error((Object)String.format("Trying to ordering over a column(s) not present in the schema (%s); skipping", CollectionUtils.diff(orderByCols, checkCols)));
            return df;
        }
        if (orderByCols.size() == 1) {
            String orderByColName = orderByCols.get(0);
            LOG.debug((Object)String.format("Single column to order by (%s), skipping space-curve ordering", orderByColName));
            return df.repartitionByRange(targetPartitionCount, new Column[]{new Column(orderByColName)});
        }
        int fieldNum = df.schema().fields().length;
        Map<Integer, StructField> fieldMap = orderByCols.stream().collect(Collectors.toMap(e -> Arrays.asList(df.schema().fields()).indexOf(columnsMap.get(e)), columnsMap::get));
        switch (layoutOptStrategy) {
            case ZORDER: {
                sortedRDD = SpaceCurveSortingHelper.createZCurveSortedRDD((JavaRDD<Row>)df.toJavaRDD(), fieldMap, fieldNum, targetPartitionCount);
                break;
            }
            case HILBERT: {
                sortedRDD = SpaceCurveSortingHelper.createHilbertSortedRDD((JavaRDD<Row>)df.toJavaRDD(), fieldMap, fieldNum, targetPartitionCount);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Not supported layout-optimization strategy (%s)", new Object[]{layoutOptStrategy}));
            }
        }
        StructType newStructType = SpaceCurveSortingHelper.composeOrderedRDDStructType(df.schema());
        return df.sparkSession().createDataFrame(sortedRDD, newStructType).drop("Index");
    }

    private static StructType composeOrderedRDDStructType(StructType schema2) {
        return StructType$.MODULE$.apply(CollectionUtils.combine(Arrays.asList(schema2.fields()), Arrays.asList(new StructField("Index", (DataType)BinaryType$.MODULE$, true, Metadata.empty()))));
    }

    private static JavaRDD<Row> createZCurveSortedRDD(JavaRDD<Row> originRDD, Map<Integer, StructField> fieldMap, int fieldNum, int fileNum) {
        return originRDD.map((Function & Serializable)row2 -> {
            byte[][] zBytes = (byte[][])fieldMap.entrySet().stream().map(entry -> {
                int index = (Integer)entry.getKey();
                StructField field = (StructField)entry.getValue();
                return SpaceCurveSortingHelper.mapColumnValueTo8Bytes(row2, index, field.dataType());
            }).toArray(x$0 -> new byte[x$0][]);
            byte[] zOrdinalBytes = BinaryUtil.interleaving(zBytes, 8);
            return SpaceCurveSortingHelper.appendToRow(row2, zOrdinalBytes);
        }).sortBy((Function & Serializable)f -> new ByteArraySorting((byte[])f.get(fieldNum)), true, fileNum);
    }

    private static JavaRDD<Row> createHilbertSortedRDD(JavaRDD<Row> originRDD, final Map<Integer, StructField> fieldMap, int fieldNum, int fileNum) {
        return originRDD.mapPartitions((FlatMapFunction & Serializable)rows -> {
            final HilbertCurve hilbertCurve = HilbertCurve.bits(63).dimensions(fieldMap.size());
            return new Iterator<Row>(){

                @Override
                public boolean hasNext() {
                    return rows.hasNext();
                }

                @Override
                public Row next() {
                    Row row2 = (Row)rows.next();
                    long[] longs = fieldMap.entrySet().stream().mapToLong(entry -> {
                        int index = (Integer)entry.getKey();
                        StructField field = (StructField)entry.getValue();
                        return SpaceCurveSortingHelper.mapColumnValueToLong(row2, index, field.dataType());
                    }).toArray();
                    byte[] hilbertCurvePosBytes = HilbertCurveUtils.indexBytes(hilbertCurve, longs, 63);
                    return SpaceCurveSortingHelper.appendToRow(row2, hilbertCurvePosBytes);
                }
            };
        }).sortBy((Function & Serializable)f -> new ByteArraySorting((byte[])f.get(fieldNum)), true, fileNum);
    }

    private static Row appendToRow(Row row2, Object value) {
        Object[] currentValues = (Object[])((WrappedArray)row2.toSeq()).array();
        return RowFactory.create((Object[])CollectionUtils.append(currentValues, value));
    }

    @Nonnull
    private static byte[] mapColumnValueTo8Bytes(Row row2, int index, DataType dataType) {
        if (dataType instanceof LongType) {
            return BinaryUtil.longTo8Byte(row2.isNullAt(index) ? Long.MAX_VALUE : row2.getLong(index));
        }
        if (dataType instanceof DoubleType) {
            return BinaryUtil.doubleTo8Byte(row2.isNullAt(index) ? Double.MAX_VALUE : row2.getDouble(index));
        }
        if (dataType instanceof IntegerType) {
            return BinaryUtil.intTo8Byte(row2.isNullAt(index) ? Integer.MAX_VALUE : row2.getInt(index));
        }
        if (dataType instanceof FloatType) {
            return BinaryUtil.doubleTo8Byte(row2.isNullAt(index) ? 3.4028234663852886E38 : (double)row2.getFloat(index));
        }
        if (dataType instanceof StringType) {
            return BinaryUtil.utf8To8Byte(row2.isNullAt(index) ? "" : row2.getString(index));
        }
        if (dataType instanceof DateType) {
            return BinaryUtil.longTo8Byte(row2.isNullAt(index) ? Long.MAX_VALUE : row2.getDate(index).getTime());
        }
        if (dataType instanceof TimestampType) {
            return BinaryUtil.longTo8Byte(row2.isNullAt(index) ? Long.MAX_VALUE : row2.getTimestamp(index).getTime());
        }
        if (dataType instanceof ByteType) {
            return BinaryUtil.byteTo8Byte(row2.isNullAt(index) ? (byte)127 : row2.getByte(index));
        }
        if (dataType instanceof ShortType) {
            return BinaryUtil.intTo8Byte(row2.isNullAt(index) ? Short.MAX_VALUE : (int)row2.getShort(index));
        }
        if (dataType instanceof DecimalType) {
            return BinaryUtil.longTo8Byte(row2.isNullAt(index) ? Long.MAX_VALUE : row2.getDecimal(index).longValue());
        }
        if (dataType instanceof BooleanType) {
            boolean value = row2.isNullAt(index) ? false : row2.getBoolean(index);
            return BinaryUtil.intTo8Byte(value ? 1 : 0);
        }
        if (dataType instanceof BinaryType) {
            byte[] byArray;
            if (row2.isNullAt(index)) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 0;
            } else {
                byArray = (byte[])row2.get(index);
            }
            return BinaryUtil.paddingTo8Byte(byArray);
        }
        throw new UnsupportedOperationException(String.format("Unsupported data-type (%s)", dataType.typeName()));
    }

    private static long mapColumnValueToLong(Row row2, int index, DataType dataType) {
        if (dataType instanceof LongType) {
            return row2.isNullAt(index) ? Long.MAX_VALUE : row2.getLong(index);
        }
        if (dataType instanceof DoubleType) {
            return row2.isNullAt(index) ? Long.MAX_VALUE : Double.doubleToLongBits(row2.getDouble(index));
        }
        if (dataType instanceof IntegerType) {
            return row2.isNullAt(index) ? Long.MAX_VALUE : (long)row2.getInt(index);
        }
        if (dataType instanceof FloatType) {
            return row2.isNullAt(index) ? Long.MAX_VALUE : Double.doubleToLongBits(row2.getFloat(index));
        }
        if (dataType instanceof StringType) {
            return row2.isNullAt(index) ? Long.MAX_VALUE : BinaryUtil.convertStringToLong(row2.getString(index));
        }
        if (dataType instanceof DateType) {
            return row2.isNullAt(index) ? Long.MAX_VALUE : row2.getDate(index).getTime();
        }
        if (dataType instanceof TimestampType) {
            return row2.isNullAt(index) ? Long.MAX_VALUE : row2.getTimestamp(index).getTime();
        }
        if (dataType instanceof ByteType) {
            return row2.isNullAt(index) ? Long.MAX_VALUE : BinaryUtil.convertBytesToLong(new byte[]{row2.getByte(index)});
        }
        if (dataType instanceof ShortType) {
            return row2.isNullAt(index) ? Long.MAX_VALUE : (long)row2.getShort(index);
        }
        if (dataType instanceof DecimalType) {
            return row2.isNullAt(index) ? Long.MAX_VALUE : row2.getDecimal(index).longValue();
        }
        if (dataType instanceof BooleanType) {
            boolean value = row2.isNullAt(index) ? false : row2.getBoolean(index);
            return value ? Long.MAX_VALUE : 0L;
        }
        if (dataType instanceof BinaryType) {
            return row2.isNullAt(index) ? Long.MAX_VALUE : BinaryUtil.convertBytesToLong((byte[])row2.get(index));
        }
        throw new UnsupportedOperationException(String.format("Unsupported data-type (%s)", dataType.typeName()));
    }

    public static Dataset<Row> orderDataFrameBySamplingValues(Dataset<Row> df, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy, List<String> orderByCols, int targetPartitionCount) {
        return RangeSampleSort$.MODULE$.sortDataFrameBySample(df, layoutOptStrategy, (Seq<String>)JavaConversions.asScalaBuffer(orderByCols), targetPartitionCount);
    }
}

