/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.bootstrap;

import java.io.IOException;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.client.bootstrap.BootstrapRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.queue.BoundedInMemoryExecutor;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.HoodieBootstrapHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.keygen.KeyGeneratorInterface;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.bootstrap.BaseBootstrapMetadataHandler;
import org.apache.hudi.table.action.bootstrap.BootstrapRecordConsumer;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.HoodieInternalRowUtils$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

class ParquetBootstrapMetadataHandler
extends BaseBootstrapMetadataHandler {
    public ParquetBootstrapMetadataHandler(HoodieWriteConfig config, HoodieTable table, HoodieFileStatus srcFileStatus) {
        super(config, table, srcFileStatus);
    }

    @Override
    Schema getAvroSchema(Path sourceFilePath) throws IOException {
        ParquetMetadata readFooter = ParquetFileReader.readFooter((Configuration)this.table.getHadoopConf(), (Path)sourceFilePath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType parquetSchema = readFooter.getFileMetaData().getSchema();
        return new AvroSchemaConverter().convert(parquetSchema);
    }

    @Override
    protected void executeBootstrap(HoodieBootstrapHandle<?, ?, ?, ?> bootstrapHandle, Path sourceFilePath, KeyGeneratorInterface keyGenerator, String partitionPath, Schema schema2) throws Exception {
        BoundedInMemoryExecutor<HoodieRecord, HoodieRecord, Void> wrapper = null;
        HoodieRecordMerger recordMerger = this.table.getConfig().getRecordMerger();
        HoodieFileReader reader = HoodieFileReaderFactory.getReaderFactory(recordMerger.getRecordType()).getFileReader(this.table.getHadoopConf(), sourceFilePath);
        try {
            Function<HoodieRecord, HoodieRecord> transformer = record -> {
                String recordKey = record.getRecordKey(schema2, Option.of(keyGenerator));
                return this.createNewMetadataBootstrapRecord(recordKey, partitionPath, recordMerger.getRecordType()).copy();
            };
            wrapper = new BoundedInMemoryExecutor<HoodieRecord, HoodieRecord, Void>(this.config.getWriteBufferLimitBytes(), reader.getRecordIterator(schema2), new BootstrapRecordConsumer(bootstrapHandle), transformer, this.table.getPreExecuteRunnable());
            wrapper.execute();
        }
        catch (Exception e) {
            throw new HoodieException(e);
        }
        finally {
            reader.close();
            if (null != wrapper) {
                wrapper.shutdownNow();
                wrapper.awaitTermination();
            }
            bootstrapHandle.close();
        }
    }

    private HoodieRecord createNewMetadataBootstrapRecord(String recordKey, String partitionPath, HoodieRecord.HoodieRecordType recordType) {
        HoodieKey hoodieKey = new HoodieKey(recordKey, partitionPath);
        switch (recordType) {
            case AVRO: {
                GenericData.Record avroRecord = new GenericData.Record(HoodieBootstrapHandle.METADATA_BOOTSTRAP_RECORD_SCHEMA);
                avroRecord.put(HoodieRecord.RECORD_KEY_METADATA_FIELD, (Object)recordKey);
                BootstrapRecordPayload payload = new BootstrapRecordPayload((GenericRecord)avroRecord);
                return new HoodieAvroRecord<BootstrapRecordPayload>(hoodieKey, payload);
            }
            case SPARK: {
                StructType schema2 = HoodieInternalRowUtils$.MODULE$.getCachedSchema(HoodieBootstrapHandle.METADATA_BOOTSTRAP_RECORD_SCHEMA);
                UnsafeProjection unsafeProjection = HoodieInternalRowUtils$.MODULE$.getCachedUnsafeProjection(schema2, schema2);
                GenericInternalRow row2 = new GenericInternalRow(HoodieBootstrapHandle.METADATA_BOOTSTRAP_RECORD_SCHEMA.getFields().size());
                row2.update(HoodieRecord.RECORD_KEY_META_FIELD_ORD, (Object)UTF8String.fromString((String)recordKey));
                UnsafeRow unsafeRow = unsafeProjection.apply((InternalRow)row2);
                return new HoodieSparkRecord(hoodieKey, unsafeRow, false);
            }
        }
        throw new UnsupportedOperationException(String.format("Record type %s is not supported yet!", new Object[]{recordType}));
    }
}

