/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.apache.hudi.client.HoodieInternalWriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.row.HoodieRowCreateHandle;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class BulkInsertDataInternalWriterHelper {
    private static final Logger LOG = LogManager.getLogger(BulkInsertDataInternalWriterHelper.class);
    private final String instantTime;
    private final int taskPartitionId;
    private final long taskId;
    private final long taskEpochId;
    private final HoodieTable hoodieTable;
    private final HoodieWriteConfig writeConfig;
    private final StructType structType;
    private final Boolean arePartitionRecordsSorted;
    private final List<HoodieInternalWriteStatus> writeStatusList = new ArrayList<HoodieInternalWriteStatus>();
    private final String fileIdPrefix;
    private final Map<String, HoodieRowCreateHandle> handles = new HashMap<String, HoodieRowCreateHandle>();
    private final boolean populateMetaFields;
    private final boolean shouldPreserveHoodieMetadata;
    private final Option<BuiltinKeyGenerator> keyGeneratorOpt;
    private final boolean simpleKeyGen;
    private final int simplePartitionFieldIndex;
    private final DataType simplePartitionFieldDataType;
    private UTF8String lastKnownPartitionPath = null;
    private HoodieRowCreateHandle handle;
    private int numFilesWritten = 0;

    public BulkInsertDataInternalWriterHelper(HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType, boolean populateMetaFields, boolean arePartitionRecordsSorted) {
        this(hoodieTable, writeConfig, instantTime, taskPartitionId, taskId, taskEpochId, structType, populateMetaFields, arePartitionRecordsSorted, false);
    }

    public BulkInsertDataInternalWriterHelper(HoodieTable hoodieTable, HoodieWriteConfig writeConfig, String instantTime, int taskPartitionId, long taskId, long taskEpochId, StructType structType, boolean populateMetaFields, boolean arePartitionRecordsSorted, boolean shouldPreserveHoodieMetadata) {
        this.hoodieTable = hoodieTable;
        this.writeConfig = writeConfig;
        this.instantTime = instantTime;
        this.taskPartitionId = taskPartitionId;
        this.taskId = taskId;
        this.taskEpochId = taskEpochId;
        this.structType = structType;
        this.populateMetaFields = populateMetaFields;
        this.shouldPreserveHoodieMetadata = shouldPreserveHoodieMetadata;
        this.arePartitionRecordsSorted = arePartitionRecordsSorted;
        this.fileIdPrefix = UUID.randomUUID().toString();
        this.keyGeneratorOpt = !populateMetaFields ? this.getKeyGenerator(writeConfig.getProps()) : Option.empty();
        if (this.keyGeneratorOpt.isPresent() && this.keyGeneratorOpt.get() instanceof SimpleKeyGenerator) {
            this.simpleKeyGen = true;
            this.simplePartitionFieldIndex = (Integer)structType.getFieldIndex(this.keyGeneratorOpt.get().getPartitionPathFields().get(0)).get();
            this.simplePartitionFieldDataType = structType.fields()[this.simplePartitionFieldIndex].dataType();
        } else {
            this.simpleKeyGen = false;
            this.simplePartitionFieldIndex = -1;
            this.simplePartitionFieldDataType = null;
        }
    }

    private Option<BuiltinKeyGenerator> getKeyGenerator(Properties properties) {
        TypedProperties typedProperties = new TypedProperties();
        typedProperties.putAll((Map<?, ?>)properties);
        if (Option.ofNullable(properties.get(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key())).map(v -> v.equals(NonpartitionedKeyGenerator.class.getName())).orElse(false).booleanValue()) {
            return Option.empty();
        }
        try {
            return Option.of((BuiltinKeyGenerator)HoodieSparkKeyGeneratorFactory.createKeyGenerator(typedProperties));
        }
        catch (ClassCastException cce) {
            throw new HoodieIOException("Only those key generators implementing BuiltInKeyGenerator interface is supported with virtual keys");
        }
        catch (IOException e) {
            throw new HoodieIOException("Key generator instantiation failed ", e);
        }
    }

    public void write(InternalRow row2) throws IOException {
        try {
            UTF8String partitionPath = this.extractPartitionPath(row2);
            if (this.lastKnownPartitionPath == null || !Objects.equals(this.lastKnownPartitionPath, partitionPath) || !this.handle.canWrite()) {
                LOG.info((Object)("Creating new file for partition path " + partitionPath));
                this.handle = this.getRowCreateHandle(partitionPath.toString());
                this.lastKnownPartitionPath = partitionPath.clone();
            }
            this.handle.write(row2);
        }
        catch (Throwable t) {
            LOG.error((Object)"Global error thrown while trying to write records in HoodieRowCreateHandle ", t);
            throw t;
        }
    }

    public List<HoodieInternalWriteStatus> getWriteStatuses() throws IOException {
        this.close();
        return this.writeStatusList;
    }

    public void abort() {
    }

    public void close() throws IOException {
        for (HoodieRowCreateHandle rowCreateHandle : this.handles.values()) {
            this.writeStatusList.add(rowCreateHandle.close());
        }
        this.handles.clear();
        this.handle = null;
    }

    private UTF8String extractPartitionPath(InternalRow row2) {
        if (this.populateMetaFields) {
            return row2.getUTF8String(HoodieRecord.PARTITION_PATH_META_FIELD_ORD);
        }
        if (this.keyGeneratorOpt.isPresent()) {
            return this.keyGeneratorOpt.get().getPartitionPath(row2, this.structType);
        }
        return UTF8String.EMPTY_UTF8;
    }

    private HoodieRowCreateHandle getRowCreateHandle(String partitionPath) throws IOException {
        if (!this.handles.containsKey(partitionPath)) {
            if (this.arePartitionRecordsSorted.booleanValue()) {
                this.close();
            }
            HoodieRowCreateHandle rowCreateHandle = this.createHandle(partitionPath);
            this.handles.put(partitionPath, rowCreateHandle);
        } else if (!this.handles.get(partitionPath).canWrite()) {
            this.writeStatusList.add(this.handles.remove(partitionPath).close());
            HoodieRowCreateHandle rowCreateHandle = this.createHandle(partitionPath);
            this.handles.put(partitionPath, rowCreateHandle);
        }
        return this.handles.get(partitionPath);
    }

    private HoodieRowCreateHandle createHandle(String partitionPath) {
        return new HoodieRowCreateHandle(this.hoodieTable, this.writeConfig, partitionPath, this.getNextFileId(), this.instantTime, this.taskPartitionId, this.taskId, this.taskEpochId, this.structType, this.shouldPreserveHoodieMetadata);
    }

    private String getNextFileId() {
        return String.format("%s-%d", this.fileIdPrefix, this.numFilesWritten++);
    }
}

