/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BaseWriteHelper;

public class HoodieWriteHelper<T, R>
extends BaseWriteHelper<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>, R> {
    private HoodieWriteHelper() {
        super(HoodieData::getNumPartitions);
    }

    public static HoodieWriteHelper newInstance() {
        return WriteHelperHolder.HOODIE_WRITE_HELPER;
    }

    @Override
    protected HoodieData<HoodieRecord<T>> tag(HoodieData<HoodieRecord<T>> dedupedRecords, HoodieEngineContext context, HoodieTable<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> table) {
        return table.getIndex().tagLocation(dedupedRecords, context, table);
    }

    @Override
    protected HoodieData<HoodieRecord<T>> doDeduplicateRecords(HoodieData<HoodieRecord<T>> records, HoodieIndex<?, ?> index, int parallelism, String schemaStr, TypedProperties props, HoodieRecordMerger merger) {
        boolean isIndexingGlobal = index.isGlobal();
        SerializableSchema schema2 = new SerializableSchema(schemaStr);
        int reduceParallelism = Math.max(1, Math.min(records.getNumPartitions(), parallelism));
        return records.mapToPair(record -> {
            HoodieKey hoodieKey = record.getKey();
            Object key = isIndexingGlobal ? hoodieKey.getRecordKey() : hoodieKey;
            return Pair.of(key, record.copy());
        }).reduceByKey((rec1, rec2) -> {
            HoodieRecord reducedRecord;
            try {
                reducedRecord = merger.merge((HoodieRecord)rec1, schema2.get(), (HoodieRecord)rec2, schema2.get(), props).get().getLeft();
            }
            catch (IOException e) {
                throw new HoodieException(String.format("Error to merge two records, %s, %s", rec1, rec2), e);
            }
            HoodieKey reducedKey = rec1.getData().equals(reducedRecord.getData()) ? rec1.getKey() : rec2.getKey();
            return reducedRecord.newInstance(reducedKey);
        }, reduceParallelism).map(Pair::getRight);
    }

    private static class WriteHelperHolder {
        private static final HoodieWriteHelper HOODIE_WRITE_HELPER = new HoodieWriteHelper();

        private WriteHelperHolder() {
        }
    }
}

