/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCompactionException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.table.action.compact.plan.generators.BaseHoodieCompactionPlanGenerator;
import org.apache.hudi.table.action.compact.plan.generators.HoodieCompactionPlanGenerator;
import org.apache.hudi.table.action.compact.plan.generators.HoodieLogCompactionPlanGenerator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ScheduleCompactionActionExecutor<T, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieCompactionPlan>> {
    private static final Logger LOG = LogManager.getLogger(ScheduleCompactionActionExecutor.class);
    private WriteOperationType operationType;
    private final Option<Map<String, String>> extraMetadata;
    private BaseHoodieCompactionPlanGenerator planGenerator;

    public ScheduleCompactionActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, Option<Map<String, String>> extraMetadata, WriteOperationType operationType) {
        super(context, config, table, instantTime);
        this.extraMetadata = extraMetadata;
        this.operationType = operationType;
        ValidationUtils.checkArgument(operationType == WriteOperationType.COMPACT || operationType == WriteOperationType.LOG_COMPACT, "Only COMPACT and LOG_COMPACT is supported");
        this.initPlanGenerator(context, config, table);
    }

    private void initPlanGenerator(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table) {
        this.planGenerator = WriteOperationType.COMPACT.equals((Object)this.operationType) ? new HoodieCompactionPlanGenerator(table, context, config) : new HoodieLogCompactionPlanGenerator(table, context, config);
    }

    @Override
    public Option<HoodieCompactionPlan> execute() {
        ValidationUtils.checkArgument(this.table.getMetaClient().getTableType() == HoodieTableType.MERGE_ON_READ, "Can only compact table of type " + (Object)((Object)HoodieTableType.MERGE_ON_READ) + " and not " + this.table.getMetaClient().getTableType().name());
        if (!this.config.getWriteConcurrencyMode().supportsOptimisticConcurrencyControl() && !this.config.getFailedWritesCleanPolicy().isLazy()) {
            if (this.config.getEngineType() == EngineType.SPARK) {
                this.table.getActiveTimeline().getCommitsTimeline().filterPendingExcludingMajorAndMinorCompaction().firstInstant().ifPresent(earliestInflight -> ValidationUtils.checkArgument(HoodieTimeline.compareTimestamps(earliestInflight.getTimestamp(), HoodieTimeline.GREATER_THAN, this.instantTime), "Earliest write inflight instant time must be later than compaction time. Earliest :" + earliestInflight + ", Compaction scheduled at " + this.instantTime));
            }
            List conflictingInstants = this.table.getActiveTimeline().getWriteTimeline().filterCompletedAndCompactionInstants().getInstantsAsStream().filter(instant -> HoodieTimeline.compareTimestamps(instant.getTimestamp(), HoodieTimeline.GREATER_THAN_OR_EQUALS, this.instantTime)).collect(Collectors.toList());
            ValidationUtils.checkArgument(conflictingInstants.isEmpty(), "Following instants have timestamps >= compactionInstant (" + this.instantTime + ") Instants :" + conflictingInstants);
        }
        HoodieCompactionPlan plan = this.scheduleCompaction();
        Option<HoodieCompactionPlan> option2 = Option.empty();
        if (plan != null && CollectionUtils.nonEmpty(plan.getOperations())) {
            this.extraMetadata.ifPresent(plan::setExtraMetadata);
            try {
                if (this.operationType.equals((Object)WriteOperationType.COMPACT)) {
                    HoodieInstant compactionInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", this.instantTime);
                    this.table.getActiveTimeline().saveToCompactionRequested(compactionInstant, TimelineMetadataUtils.serializeCompactionPlan(plan));
                } else {
                    HoodieInstant logCompactionInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "logcompaction", this.instantTime);
                    this.table.getActiveTimeline().saveToLogCompactionRequested(logCompactionInstant, TimelineMetadataUtils.serializeCompactionPlan(plan));
                }
            }
            catch (IOException ioe) {
                throw new HoodieIOException("Exception scheduling compaction", ioe);
            }
            option2 = Option.of(plan);
        }
        return option2;
    }

    @Nullable
    private HoodieCompactionPlan scheduleCompaction() {
        LOG.info((Object)("Checking if compaction needs to be run on " + this.config.getBasePath()));
        boolean compactable = this.needCompact(this.config.getInlineCompactTriggerStrategy());
        if (compactable) {
            LOG.info((Object)("Generating compaction plan for merge on read table " + this.config.getBasePath()));
            try {
                this.context.setJobStatus(this.getClass().getSimpleName(), "Compaction: generating compaction plan");
                return this.planGenerator.generateCompactionPlan();
            }
            catch (IOException e) {
                throw new HoodieCompactionException("Could not schedule compaction " + this.config.getBasePath(), e);
            }
        }
        return new HoodieCompactionPlan();
    }

    private Option<Pair<Integer, String>> getLatestDeltaCommitInfo() {
        Option<Pair<HoodieTimeline, HoodieInstant>> deltaCommitsInfo = CompactionUtils.getDeltaCommitsSinceLatestCompaction(this.table.getActiveTimeline());
        if (deltaCommitsInfo.isPresent()) {
            return Option.of(Pair.of(deltaCommitsInfo.get().getLeft().countInstants(), deltaCommitsInfo.get().getRight().getTimestamp()));
        }
        return Option.empty();
    }

    private Option<Pair<Integer, String>> getLatestDeltaCommitInfoSinceLastCompactionRequest() {
        Option<Pair<HoodieTimeline, HoodieInstant>> deltaCommitsInfo = CompactionUtils.getDeltaCommitsSinceLatestCompactionRequest(this.table.getActiveTimeline());
        if (deltaCommitsInfo.isPresent()) {
            return Option.of(Pair.of(deltaCommitsInfo.get().getLeft().countInstants(), deltaCommitsInfo.get().getRight().getTimestamp()));
        }
        return Option.empty();
    }

    private boolean needCompact(CompactionTriggerStrategy compactionTriggerStrategy) {
        boolean compactable;
        Option<Pair<Integer, String>> latestDeltaCommitInfoOption = this.getLatestDeltaCommitInfo();
        if (!latestDeltaCommitInfoOption.isPresent()) {
            return false;
        }
        Pair<Integer, String> latestDeltaCommitInfo = latestDeltaCommitInfoOption.get();
        if (WriteOperationType.LOG_COMPACT.equals((Object)this.operationType)) {
            return true;
        }
        int inlineCompactDeltaCommitMax = this.config.getInlineCompactDeltaCommitMax();
        int inlineCompactDeltaSecondsMax = this.config.getInlineCompactDeltaSecondsMax();
        switch (compactionTriggerStrategy) {
            case NUM_COMMITS: {
                boolean bl = compactable = inlineCompactDeltaCommitMax <= latestDeltaCommitInfo.getLeft();
                if (!compactable) break;
                LOG.info((Object)String.format("The delta commits >= %s, trigger compaction scheduler.", inlineCompactDeltaCommitMax));
                break;
            }
            case NUM_COMMITS_AFTER_LAST_REQUEST: {
                latestDeltaCommitInfoOption = this.getLatestDeltaCommitInfoSinceLastCompactionRequest();
                if (!latestDeltaCommitInfoOption.isPresent()) {
                    return false;
                }
                latestDeltaCommitInfo = latestDeltaCommitInfoOption.get();
                boolean bl = compactable = inlineCompactDeltaCommitMax <= latestDeltaCommitInfo.getLeft();
                if (!compactable) break;
                LOG.info((Object)String.format("The delta commits >= %s since the last compaction request, trigger compaction scheduler.", inlineCompactDeltaCommitMax));
                break;
            }
            case TIME_ELAPSED: {
                boolean bl = compactable = (long)inlineCompactDeltaSecondsMax <= this.parsedToSeconds(this.instantTime) - this.parsedToSeconds(latestDeltaCommitInfo.getRight());
                if (!compactable) break;
                LOG.info((Object)String.format("The elapsed time >=%ss, trigger compaction scheduler.", inlineCompactDeltaSecondsMax));
                break;
            }
            case NUM_OR_TIME: {
                boolean bl = compactable = inlineCompactDeltaCommitMax <= latestDeltaCommitInfo.getLeft() || (long)inlineCompactDeltaSecondsMax <= this.parsedToSeconds(this.instantTime) - this.parsedToSeconds(latestDeltaCommitInfo.getRight());
                if (!compactable) break;
                LOG.info((Object)String.format("The delta commits >= %s or elapsed_time >=%ss, trigger compaction scheduler.", inlineCompactDeltaCommitMax, inlineCompactDeltaSecondsMax));
                break;
            }
            case NUM_AND_TIME: {
                boolean bl = compactable = inlineCompactDeltaCommitMax <= latestDeltaCommitInfo.getLeft() && (long)inlineCompactDeltaSecondsMax <= this.parsedToSeconds(this.instantTime) - this.parsedToSeconds(latestDeltaCommitInfo.getRight());
                if (!compactable) break;
                LOG.info((Object)String.format("The delta commits >= %s and elapsed_time >=%ss, trigger compaction scheduler.", inlineCompactDeltaCommitMax, inlineCompactDeltaSecondsMax));
                break;
            }
            default: {
                throw new HoodieCompactionException("Unsupported compaction trigger strategy: " + (Object)((Object)this.config.getInlineCompactTriggerStrategy()));
            }
        }
        return compactable;
    }

    private Long parsedToSeconds(String time) {
        long timestamp;
        try {
            timestamp = HoodieActiveTimeline.parseDateFromInstantTime(time).getTime() / 1000L;
        }
        catch (ParseException e) {
            throw new HoodieCompactionException(e.getMessage(), e);
        }
        return timestamp;
    }
}

